c
c
      subroutine elips3 (isend, n, ngraf,
     +                   alpha, r,
     +                   xbar, xgraf, xsig,
     +                   ybar, ygraf, ysig,
     +                   abort)
c
c action: return ellipse coordinates
c author: w.g.bardsley, University of manchester, U.K., 02/05/2005
c         16/11/2005 replaced NAG by NAGSUB routines  
c         23/03/2007 added intents
c
c         isend: (input/unchanged) isend = 1: confidence region
c                                  isend = 2: confidence envelope
c             n: (input/unchanged) dimension of original data (n > 2)
c         ngraf: (input/unchanged) dimension of graph coordinates (ngraf > 3)
c         alpha: (input/unchanged) significance level (0 < alpha < 1)
c             r: (input/unchanged) correlation coefficent for original x,y-data
c                                  (0 < r < 1)
c          xbar: (input/unchanged) mean of original x-data
c         xgraf: (output) ellipse coordinates
c          xsig: (input/unchanged) sample sigma for original x-data
c          ybar: (input/unchanged) mean of original y-data
c         ygraf: (output) ellipse coordinates
c          ysig: (input/unchanged) sample sigma for original y-data
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,          intent (in)  :: isend, n, ngraf
      double precision, intent (in)  :: alpha, r,
     +                                  xbar, xsig,
     +                                  ybar, ysig 
      double precision, intent (out) :: xgraf(ngraf), ygraf(ngraf)
      logical,          intent (out) :: abort
c
c locals
c
      integer    i, ifail
      double precision a, b, delta, dn, d1, d2, epsi, f, p, root2,
     +                 theta, twopi, u, v, x, y
      double precision zero, one, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00)
      double precision x01aafg, x02ajfg, g01fdfg
      external   x01aafg, x02ajfg, g01fdfg
      intrinsic  dble, sqrt, cos, sin
c
c set abort = .true. then check arguments
c
      abort = .true.
      epsi = sqrt(x02ajfg())
      if (isend.lt.1       .or. isend.gt.2          .or.
     +    n.lt.3           .or. ngraf.lt.4          .or.
     +    alpha.lt.epsi    .or. alpha.gt.one - epsi .or.
     +    r.lt. epsi - one .or. r.gt.one - epsi     .or.
     +    xsig.le.zero     .or. ysig.le.zero) then
         return
      endif
c
c get the F-statistic
c
      p = one - alpha
      dn = dble(n)
      d1 = two
      d2 = dn - two
      ifail = 0
      f = g01fdfg(p, d1, d2, ifail)
      if (ifail.ne.0) return
c
c calculate a and b for the ellipse in standard form
c
      if (isend.eq.1) then
         d1 = two*(dn - one)
      else
         d1 = two*(dn*dn - one)
      endif
      d2 = dn*(dn - two)
      f = d1*f/d2
      a = sqrt(f*(one - r))
      b = sqrt(f*(one + r))
c
c calculate the other ellipse parameters
c
      root2 = sqrt(two)
      theta = one
      twopi = two*x01aafg(theta)
      delta = twopi/dble(ngraf - 2)
      theta = zero
c
c calculate the ngraf points
c
      do i = 1, ngraf - 1
         u = a*cos(theta)
         v = b*sin(theta)
         theta = theta + delta
         x = (u + v)/root2
         y = (v - u)/root2
         xgraf(i) = xsig*x + xbar
         ygraf(i) = ysig*y + ybar
      enddo
      xgraf(ngraf) = xgraf(1)
      ygraf(ngraf) = ygraf(1)
c
c calculation seems ok so set abort = .false.
c
      abort = .false.
      end
c
c
