c
c
      subroutine ellips$(n,
     +                   size1, x, x1, x2, y, y1, y2,
     +                   abort)
c
c action: coordinates for an ellipse
c author: w.g.bardsley, university of manchester, u.k., 20/08/2008
c        
c The ellipse will have its extreme points at x1,y1 and x2,y2 and
c the parameter size1 will dictate the eccentricity except that
c size1 is clipped so that the distance between the extremes defines
c the major axis.
c
      implicit none
c
c arguments
c            
      integer,          intent (in)  :: n
      double precision, intent (in)  :: size1, x1, x2, y1, y2
      double precision, intent (out) :: x(n), y(n) 
      logical,          intent (out) :: abort
c
c locals
c      
      integer    i
      double precision a, b, delta, theta, xx1, xx2, yy1, yy2
      double precision cos_t, sin_t, xi, yi
      double precision size2, x0, y0
      double precision zero, two, twopi
      parameter (zero = 0.0d+00, two = 2.0d+00, twopi = 6.2831853d+00)
      double precision epsi, s_big, s_small
      parameter (epsi = 1.0d-100, s_big = 1.0d+00, s_small = 0.005d+00)
      intrinsic  abs, dble, sqrt, sin, cos, atan
c
c check
c        
      abort = .true.
      if (n.lt.3 .or. size1.le.zero) return
      a = sqrt((x1 - x2)**2 + (y1 - y2)**2)/two
      if (a.le.zero) return
      abort = .false.  
c
c initialise for a centralised ellipse  
c        
      size2 = size1/two
      if (size2.lt.s_small) then
         size2 = s_small
      elseif (size2.gt.s_big) then
         size2 = s_big
      endif         
      delta = twopi/dble(n - 1)  
      b = a*size2
      x(1) = a
      y(1) = zero
      theta = zero
      do i = 2, n - 1
         theta = theta + delta
         x(i) = a*cos(theta)
         y(i) = b*sin(theta)
      enddo
      x(n) = a
      y(n) = zero
c
c swap coordinates if required so that xx2 >= xx1
c      
      if (x2.ge.x1) then
         xx1 = x1
         xx2 = x2
         yy1 = y1
         yy2 = y2
      else
         xx1 = x2
         xx2 = x1
         yy1 = y2
         yy2 = y1
      endif
c
c check for singularities
c      
      if (abs(xx2 - xx1).le.epsi) then
         xx1 = xx1 - epsi
         xx2 = xx2 + epsi
      endif 
      if (abs(yy2 - yy1).le.epsi) then
         if (yy2.ge.yy1) then
            yy2 = yy2 + epsi
            yy1 = yy1 - epsi
         else
            yy2 = yy2 - epsi
            yy1 = yy1 + epsi
         endif
      endif            
c
c rotate to line up with the given extreme points
c           
      theta = atan((yy2 - yy1)/(xx2 - xx1))
      cos_t = cos(theta)
      sin_t = sin(theta)
      do i = 1, n
         xi = x(i)
         yi = y(i)
         x(i) = xi*cos_t - yi*sin_t
         y(i) = xi*sin_t + yi*cos_t
      enddo 
c
c translate centre of the rotated ellipse to the new origin
c      
      
      x0 = xx1 + (xx2 - xx1)/two
      y0 = yy1 + (yy2 - yy1)/two
      do i = 1, n
         x(i) = x(i) + x0
         y(i) = y(i) + y0 
      enddo          
      end
c
c      
          