C
C
      SUBROUTINE FRAMES$(ICOLOR, KCOLOR, NKCOL, NPLOTS,
     +                   XA, XB, XCLIP, XCOORD, XEND, XMAX, XMIN,
     +                   XSTART, XTIC,
     +                   YA, YB, YCLIP, YCOORD, YEND, YMAX, YMIN,
     +                   YSTART, YTIC,
     +                   ZCOORD, ZMAX, ZMIN,
     +                   BAR_CHART, BOXIT, FRAME, MONO, NORMAL, OFFSET,
     +                   PIE_CHART, PS, SHOW_XAXIS, SHOW_YAXIS,
     +                   SHOW_ZAXIS, SWAP_YZ, TWO_PLOTS)
C
C ACTION : Draw frames and axes for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          13/09/1996 Added NORMAL to allow for sliding of axes
C          06/11/1996 added XCLIP, YCLIP
C          14/07/1997 win32 version
C          18/10/2000 added code for clipping
C          20/07/2001 added SHOW_XAXIS 
C          20/05/2007 added INTENTS
C          22/08/2014 added callS to PSJOIN$ and MITER_POLYLINE to swap polyline joins between miter/round
C
      IMPLICIT  NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NKCOL, KCOLOR(NKCOL), NPLOTS 
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: XA, XB, XCLIP(2), XCOORD,
     +                                    XMAX, XMIN, XEND, XSTART,
     +                                    XTIC, YA, YB, YCLIP(2),
     +                                    YCOORD, YMAX, YMIN, YEND,
     +                                    YSTART, YTIC, ZCOORD, ZMAX,
     +                                    ZMIN
      LOGICAL,          INTENT (IN)    :: BAR_CHART, BOXIT, FRAME, MONO,
     +                                    OFFSET, PIE_CHART, PS,
     +                                    SHOW_XAXIS, SHOW_YAXIS, 
     +                                    SHOW_ZAXIS, SWAP_YZ, TWO_PLOTS  
      LOGICAL,          INTENT (INOUT) :: NORMAL
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 7)
      DOUBLE PRECISION XDIFF, YDIFF
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION XFRAME(N6), YFRAME(N6)
      DOUBLE PRECISION ZERO, ONE, FOUR, PCENT1, PCENT5
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00,
     +           FOUR = 4.0D+00, PCENT1 = 0.01D+00, PCENT5 = 0.05D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (BOT = 0.05D+00, TOP = 0.95D+00)
C
C Externals
C
      EXTERNAL  PSPOLY$, SOLID_LINE$, FILL_POLYGON$, PSJOIN$, POLYLINE$,
     +          MITER_POLYLINE$             
      INTRINSIC ABS
      XDIFF = ZMAX - ZMIN!to silence ftn95
C
C Define ICOLOR then NORMAL
C
      IF (.NOT.MONO) ICOLOR = KCOLOR(2)
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      IF (OFFSET .OR. BOXIT) THEN
         NORMAL = .TRUE.
      ELSE
         IF (TWO_PLOTS) THEN
            IF (ABS(XCOORD - XMIN).LT.PCENT1*XDIFF .AND.
     +         ABS(YCOORD - YMIN).LT.PCENT1*YDIFF .AND.
     +         ABS(ZCOORD - XMAX).LT.PCENT1*XDIFF) THEN
               NORMAL = .TRUE.
            ELSE
               NORMAL = .FALSE.
            ENDIF
         ELSE
            IF (ABS(XCOORD - XMIN).LT.PCENT1*XDIFF .AND.
     +         ABS(YCOORD - YMIN).LT.PCENT1*YDIFF) THEN
               NORMAL = .TRUE.
            ELSE
               NORMAL = .FALSE.
            ENDIF
         ENDIF
      ENDIF
C
C Start of code for everything except pie charts .......................
C
      IF (NPLOTS.GT.0 .AND. .NOT.PIE_CHART) THEN
         IF (BOXIT) THEN
C
C Code if BOXIT .......................................................
C This complicated code is not required in the version where
C XSTART = XA, XEND = XB, YSTART = YA, YEND = YB
C
            IF (OFFSET) THEN
               X1 = XSTART
               X2 = XEND
               Y1 = YSTART
               Y2 = YEND
            ELSE
               X1 = XA
               X2 = XB
               Y1 = YA
               Y2 = YB
            ENDIF
            IF (PS) THEN
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               CALL PSPOLY$(ICOLOR, N4, XFRAME, YFRAME, 'pc')
            ELSE
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               XFRAME(5) = X1
               XFRAME(6) = X1 + PCENT5*(X2 - X1)!to finish the final corner
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               YFRAME(5) = Y1
               YFRAME(6) = Y1
               CALL MITER_POLYLINE$(N6, XFRAME, YFRAME, ICOLOR)                            
            ENDIF
         ELSE
C
C Code if .NOT.BOXIT ..................................................
C
            IF (PS .AND. NORMAL .AND. .NOT.OFFSET) THEN
C
C PostScript and NORMAL and .NOT.OFFSET ...............................
C
               IF (TWO_PLOTS) THEN
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS .AND. SHOW_ZAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XB
                     XFRAME(3) = XA
                     XFRAME(4) = XA
                     YFRAME(1) = YB
                     YFRAME(2) = YA
                     YFRAME(3) = YA
                     YFRAME(4) = YB
                     CALL PSJOIN$(N0)
                     CALL PSPOLY$(ICOLOR, N4, XFRAME, YFRAME, 'pl')
                     CALL PSJOIN$(N1)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XA
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                     IF (SHOW_ZAXIS) THEN
                        XFRAME(1) = XB
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                  ENDIF
               ELSEIF (SWAP_YZ) THEN
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XB
                     XFRAME(3) = XA
                     YFRAME(1) = YB
                     YFRAME(2) = YA
                     YFRAME(3) = YA
                     CALL PSJOIN$(N0)
                     CALL PSPOLY$(ICOLOR, N3, XFRAME, YFRAME, 'pl')
                     CALL PSJOIN$(N1)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XB
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                  ENDIF
               ELSE
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XA
                     XFRAME(3) = XA
                     YFRAME(1) = YA
                     YFRAME(2) = YA
                     YFRAME(3) = YB
                     CALL PSJOIN$(N0)
                     CALL PSPOLY$(ICOLOR, N3, XFRAME, YFRAME, 'pl')
                     CALL PSJOIN$(N1)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XA
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL PSPOLY$(ICOLOR, N2, XFRAME, YFRAME, 'pl')
                     ENDIF
                  ENDIF
               ENDIF
            ELSEIF (NORMAL .AND. .NOT.OFFSET) THEN
C
C NORMAL and .NOT.OFFSET ...............................
C
               IF (TWO_PLOTS) THEN
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS .AND. SHOW_ZAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XB
                     XFRAME(3) = XA
                     XFRAME(4) = XA
                     YFRAME(1) = YB
                     YFRAME(2) = YA
                     YFRAME(3) = YA
                     YFRAME(4) = YB
                     CALL MITER_POLYLINE$(N4, XFRAME, YFRAME, ICOLOR)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XA
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                     IF (SHOW_ZAXIS) THEN
                        XFRAME(1) = XB
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                  ENDIF
               ELSEIF (SWAP_YZ) THEN
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XB
                     XFRAME(3) = XA
                     YFRAME(1) = YB
                     YFRAME(2) = YA
                     YFRAME(3) = YA
                     CALL MITER_POLYLINE$(N3, XFRAME, YFRAME, ICOLOR)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XB
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                  ENDIF
               ELSE
                  IF (SHOW_XAXIS .AND. SHOW_YAXIS) THEN
                     XFRAME(1) = XB
                     XFRAME(2) = XA
                     XFRAME(3) = XA
                     YFRAME(1) = YA
                     YFRAME(2) = YA
                     YFRAME(3) = YB
                     CALL MITER_POLYLINE$(N3, XFRAME, YFRAME, ICOLOR)
                  ELSE
                     IF (SHOW_XAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XB
                        YFRAME(1) = YA
                        YFRAME(2) = YA
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                     IF (SHOW_YAXIS) THEN
                        XFRAME(1) = XA
                        XFRAME(2) = XA
                        YFRAME(1) = YA
                        YFRAME(2) = YB
                        CALL POLYLINE$(N2, XFRAME, YFRAME, ICOLOR)
                     ENDIF
                  ENDIF
               ENDIF   
            ELSE
               IF (SHOW_XAXIS .AND. .NOT.BAR_CHART) THEN
C
C Draw the X-axis allowing for YCOORD if required......................
C
                  IF (OFFSET) THEN
                     CALL SOLID_LINE$(XA, YSTART, XB, YSTART, ICOLOR)
                  ELSEIF (NORMAL) THEN
                     CALL SOLID_LINE$(XA, YA, XB, YA, ICOLOR)
                  ELSE
                     X1 = XA
                     X2 = XB
                     Y1 = YA + (YCOORD - YMIN)*(YB - YA)/YDIFF
                     Y2 = Y1
                     CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
                  ENDIF
               ENDIF
C
C Draw the Y-axis allowing for XCOORD if required.......................
C
               IF (SHOW_YAXIS .AND. SWAP_YZ) THEN
                  IF (OFFSET) THEN
                     CALL SOLID_LINE$(XEND, YA, XEND, YB, ICOLOR)
                  ELSEIF (NORMAL) THEN
                     CALL SOLID_LINE$(XB, YA, XB, YB, ICOLOR)
                  ELSEIF (SHOW_YAXIS) THEN
                     X1 = XA + (XCOORD - XMIN)*(XB - XA)/XDIFF
                     X2 = X1
                     Y1 = YA
                     Y2 = YB
                     CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
                  ENDIF
               ELSEIF (SHOW_YAXIS) THEN
                  IF (OFFSET) THEN
                     CALL SOLID_LINE$(XSTART, YA, XSTART, YB, ICOLOR)
                  ELSEIF (NORMAL) THEN
                     CALL SOLID_LINE$(XA, YA, XA, YB, ICOLOR)
                  ELSEIF (SHOW_YAXIS) THEN
                     X1 = XA + (XCOORD - XMIN)*(XB - XA)/XDIFF
                     X2 = X1
                     Y1 = YA
                     Y2 = YB
                     CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
                  ENDIF
               ENDIF
               IF (SHOW_ZAXIS .AND. TWO_PLOTS) THEN
                  IF (OFFSET) THEN
                       CALL SOLID_LINE$(XEND, YA, XEND, YB, ICOLOR)
                  ELSEIF (NORMAL) THEN
                     CALL SOLID_LINE$(XB, YA, XB, YB, ICOLOR)
                  ELSEIF (SHOW_ZAXIS) THEN
C
C Draw the Z-axis allowing for ZCOORD..................................
C
                     X1 = XA + (ZCOORD - XMIN)*(XB - XA)/XDIFF
                     X2 = X1
                     Y1 = YA
                     Y2 = YB
                     CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
      ENDIF
C
C Start of code to draw a frame round the graph
C
      IF (FRAME) THEN
         X1 = XCLIP(1) + YTIC/FOUR
         X2 = XCLIP(2) - YTIC/FOUR
         Y1 = YCLIP(1) + XTIC/FOUR
         Y2 = YCLIP(2) - XTIC/FOUR
         IF (PS) THEN
            XFRAME(1) = X1
            XFRAME(2) = X2
            XFRAME(3) = X2
            XFRAME(4) = X1
            YFRAME(1) = Y1
            YFRAME(2) = Y1
            YFRAME(3) = Y2
            YFRAME(4) = Y2
            CALL PSJOIN$(N0)
            CALL PSPOLY$(ICOLOR, N4, XFRAME, YFRAME, 'pc')
            CALL PSJOIN$(N1)
         ELSE
            XFRAME(1) = X1
            XFRAME(2) = X2
            XFRAME(3) = X2
            XFRAME(4) = X1
            XFRAME(5) = X1
            XFRAME(6) = X1 + PCENT5*(X2 - X1)
            YFRAME(1) = Y1
            YFRAME(2) = Y1
            YFRAME(3) = Y2
            YFRAME(4) = Y2           
            YFRAME(5) = Y1
            YFRAME(6) = Y1
            CALL MITER_POLYLINE$(N6, XFRAME, YFRAME, ICOLOR)
         ENDIF
      ENDIF
C
C Action if plot has been clipped
C
      IF (.NOT.PS) THEN
         IF (XCLIP(1).GT.BOT .OR. XCLIP(2).LT.TOP .OR.
     +       YCLIP(1).GT.BOT .OR. YCLIP(2).LT.TOP) THEN
            IF (XCLIP(1).GT.BOT) THEN
               X1 = ZERO
               X2 = XCLIP(1) - YTIC/FOUR
               Y1 = ZERO
               Y2 = ONE
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               XFRAME(5) = X1
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               YFRAME(5) = Y1
               CALL FILL_POLYGON$(N5, XFRAME, YFRAME, JCOLOR)
            ENDIF
            IF (XCLIP(2).LT.TOP) THEN
               X1 = XCLIP(2) + YTIC/FOUR
               X2 = ONE
               Y1 = ZERO
               Y2 = ONE
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               XFRAME(5) = X1
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               YFRAME(5) = Y1
               CALL FILL_POLYGON$(N5, XFRAME, YFRAME, JCOLOR)
            ENDIF
            IF (YCLIP(1).GT.BOT) THEN
               X1 = ZERO
               X2 = ONE
               Y1 = ZERO
               Y2 = YCLIP(1) - XTIC/FOUR
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               XFRAME(5) = X1
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               YFRAME(5) = Y1
               CALL FILL_POLYGON$(N5, XFRAME, YFRAME, JCOLOR)
            ENDIF
            IF (YCLIP(2).LT.TOP) THEN
               X1 = ZERO
               X2 = ONE
               Y1 = YCLIP(2) + XTIC/FOUR
               Y2 = ONE
               XFRAME(1) = X1
               XFRAME(2) = X2
               XFRAME(3) = X2
               XFRAME(4) = X1
               XFRAME(5) = X1
               YFRAME(1) = Y1
               YFRAME(2) = Y1
               YFRAME(3) = Y2
               YFRAME(4) = Y2
               YFRAME(5) = Y1
               CALL FILL_POLYGON$(N5, XFRAME, YFRAME, JCOLOR)
            ENDIF
         ENDIF
      ENDIF
      END
C
C
