c
c
      subroutine fsize1$ (itype, tsize,
     +                    title)
c
c action: return adjusted value for font size after calling tsizes$
c author: w.g.bardsley, university of manchester, u.k., 20/04/2011
c
c         itype: type of font required as follows:
c                itype =  1: title (main)
c                itype =  2: x-legend
c                itype =  3: y-legend
c                itype =  4: z-legend
c                itype =  5: x-text-labels
c                itype =  6: y-text-labels 
c                itype =  7: z-text-labels
c                itype =  8: bar chart labels
c                itype =  9: pie chart labels
c                itype = 10: panel labels
c                itype = 11: data point labels
c                itype = 12: title (extra)
c                itype = 13: x_numbers
c                itype = 14: y-numbers
c                itype = 15: z-numbers
c         tsize: value returned by tsizes$
c         title: character string for title or legends
c
c Note: the behaviour can be altered by re-defining nstep and scalar
c




      implicit none
c
c arguments
c      
      integer,             intent (in)    :: itype 
      double precision,    intent (inout) :: tsize
      character (len = *), intent (in)    :: title 
c
c locals
c      
      integer    i, k, len200, nstep(7)
      double precision value
      parameter (value = 0.9d+00)
      double precision scalar(7)
      character (len = 1) letter
      external   len200
      data scalar / 0.90d+00, 0.85d+00, 0.8d+00, 0.75d+00, 0.7d+00,
     +              0.65d+00, 0.6d+00 /
c
c return if user has already adjusted tsize
c      
      if (tsize.le.value) return
c
c work out if it is the title or one of the legends
c
      if (itype.eq.1 .or. itype.eq.2 .or. itype.eq.12) then
         letter = 'T'
      elseif (itype.eq.3 .or. itype.eq.4) then
         letter = 'Y'
      else
         return
      endif                 
      if (letter.eq.'T') then
c
c treat the X-axis legend and title the same: nstep = 40, 45, 50, 55, 60, 65, 70
c
         nstep(1) = 40
         do i = 2, 7
            nstep(i) = nstep(i - 1) + 5
         enddo  
      elseif (letter.eq.'Y') then  
c
c treat the Y and Z axes the same: nstep = 25, 30, 35, 40, 45, 50, 55
c         
         nstep(1) = 25
         do i = 2, 7
            nstep(i) = nstep(i - 1) + 5
         enddo 
      else
c
c not title, X, Y, or Z so return
c        
         return
      endif 
c
c new size if title is long
c      
      k = len200 (title)
      if (k.le.nstep(1)) then
         return
      elseif (k.gt.nstep(7)) then
         tsize = scalar(7)
      elseif (k.gt.nstep(6)) then
         tsize = scalar(6)
      elseif (k.gt.nstep(5)) then
         tsize = scalar(5)
      elseif (k.gt.nstep(4)) then
         tsize = scalar(4)   
      elseif (k.gt.nstep(3)) then
         tsize = scalar(3)
      elseif (k.gt.nstep(2)) then
         tsize = scalar(2)
      else
         tsize = scalar(1)
      endif             
      end
c
c      
     