c
c
      subroutine fsizes (itype,
     +                   fsize,
     +                   store)
c
c action: store or retrieve font size correction factors
c author: w.g.bardsley, university of manchester, u.k., 
c         20/01/2011 calls fsizes$ as follows:
c                    jtype = abs(itype) then
c                    store = .true. itype > 0: invokes a request to change font size jtype
c                                   itype < 0: store value supplied for font size jtype
c                    store = .false. just return the stored value for jtype
c 
c         itype: (input/unchanged)
c                fsizes$ first sets jtype = abs(itype) then
c         jtype: type of font required as follows:
c                jtype =  1: title (main)
c                jtype =  2: x-legend
c                jtype =  3: y-legend
c                jtype =  4: z-legend
c                jtype =  5: x-text-labels
c                jtype =  6: y-text-labels
c                jtype =  7: z-text-labels
c                jtype =  8: bar chart labels
c                jtype =  9: pie chart labels
c                jtype = 10: panel labels
c                jtype = 11: data point labels
c                jtype = 12: title (extra)
c                jtype = 13: x-numbers
c                jtype = 14: y-numbers
c                itype = 15: z-numbers
c         fsize: (input/output) as follows:
c                store = .true. then change fsize and store a copy as follows
c                         itype > 0: interactive query
c                         itype < 0: store without a query       
c                store = .false. then just return the stored value
c         store: (input/unchanged) type of action required as above
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: itype
      double precision, intent (inout) :: fsize
      logical,          intent (in)    :: store
c
c locals
c
      external   fsizes$
      call fsizes$(itype,
     +             fsize,
     +             store)  
      end
c
c
