C
C ----------------
C FILE: G_OBJECTS1
C ----------------
C
C PLTOBJ$: main graphical-object plotting routine
C LOOPD4$: Copy of LOOP04$
C LOOPD5$: Copy of LOOP05$
C LOOPD6$: Copy of LOOP06$
C
C 28/08/2011 This version of g_objects1 contains that code required to plot graphical
C            objects but which is not required in response to the call back functions
C            called from w_button.for within w_clearwin.dll.
C            It is consistent with the code in g_objects2 inside w_clearwin.dll which
C            actually is required by the call back functions in the file w_button.for. 
C            The current g_objects1 and g_objects2 allow w_clearwin to control the
C            nature of graphical objects to be plotted without needing reverse        
C            communication from w_clearwin.dll to w_graphics.dll.
C
C            Note: this version of g_objects1 is not consistent with any previous
C                  versions of g_objects1 and g_objects2 and many subroutines required
C                  by g_objects2 have been moved from w_graphics.dll into w_clearwin.dll
C                  leaving only simple stubs behind. 
C

C  
C-----------------------------------------------------------------------
C
       SUBROUTINE PLTOBJ$(ISEND, NPRESS)
C
C ACTION : Edit or plot the objects depending on ISEND and NPRESS
C
C          ISEND = 0: set SWITCH_ON = .TRUE. then RETURN
C          ISEND = 1: call OBJPLT$ to initialise or re-initialise
C          ISEND = 2: call OBJPLT$ to edit
C          ISEND = 3: call OBJPLT$ to save coordinates
C          ISEND = 4: plot existing objects as foreground
C          ISEND = 5: plot existing objects as background if SWITCH_ON = .TRUE.
C          ISEND = 6: set SWITCH_ON = .FALSE. then RETURN
C          ISEND = 7: plot existing objects between data and axes if SWITCH_ON = .TRUE.
C
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 16/12/97
C          30/10/1998 Changed global save for specified save
C          22/10/2000 Extensive editing to call revised MENUD6$
C          28/10/2000 No longer saves locally but calls the SAV???$ routines
C          15/08/2001 added call to WGBCFG$ to initialise font 
C          12/05/2007 added INTENTS
C          17/06/2007 removed defngks.ins, added GETDEF$ and increased dimensions to 200 for CONFYG$ 
C          20/10/2008 added ISEND_ARR, ISEND_OBJ, I_COPY, M_COPY, and SWITCH_ON option for ISEND = 5
C          31/10/2008 added ISEND = 0 and 6 and suppressed background unless SWITCH_ON = .TRUE.
C          04/11/2008 changed default colours for arrows and objects
C          17/06/2011 added the option ISEND = 7 for objects between axes and data
C          28/08/2011 split editing function off into OBJPLT$ 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)    :: ISEND
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Parameters
C
      INTEGER    N_ARROW, N_CHAR, N_OBJ, N_TEXT
      PARAMETER (N_ARROW = 200, N_CHAR = 80, N_OBJ = 200, N_TEXT = 200)
      INTEGER    K0, K1
      PARAMETER (K0 = 0, K1 = 1)
      INTEGER    BLACK, BRIGHT_WHITE
      PARAMETER (BLACK = 1, BRIGHT_WHITE = 16)
      LOGICAL    MONO, BAR_CHART, VIDEO
      PARAMETER (MONO = .FALSE., BAR_CHART = .FALSE., VIDEO = .FALSE.)
C
C Arrows
C
      INTEGER    IARROW(N_ARROW), IKOLOR(N_ARROW)
      INTEGER    I_COPY(N_ARROW), ISEND_ARR(N_ARROW)
      DOUBLE PRECISION HEAD(N_ARROW), X1(N_ARROW), X2(N_ARROW),
     +                 Y1(N_ARROW), Y2(N_ARROW)
C
C Objects
C
      INTEGER    ICOLOR, JCOLOR_OBJ(N_OBJ), LCTEMP, M_OBJ(N_OBJ)
      INTEGER    ISEND_OBJ(N_OBJ), M_COPY(N_OBJ)
      DOUBLE PRECISION SIZE_OBJ(N_OBJ), WIDE_OBJ(N_OBJ), X_OBJ(N_OBJ),
     +                 Y_OBJ(N_OBJ)
C
C Text
C
      INTEGER   JKOLOR(N_TEXT), ISTRNG(N_TEXT)
      DOUBLE PRECISION HSTRNG(N_TEXT), SPS(N_TEXT), XPS(N_TEXT),
     +                 XSTRNG(N_TEXT), YSTRNG(N_TEXT)
      CHARACTER   FONT(N_TEXT)*(N_CHAR), STRNG(N_TEXT)*(N_CHAR),
     +            SYMBOL(N_TEXT)*(N_CHAR), TYPE1(N_TEXT)*(N_CHAR)
C
C Locals
C
      INTEGER    I 
      LOGICAL    FIRST, STORE, SWITCH_ON  
C
C Arguments for GETDFE$
C                       
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE, ZSCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
C
C Externals
C
      EXTERNAL  PUTFAT$, LOOPD4$, LOOPD5$, LOOPD6$, SAVELC$, SAVARR$, 
     +          SAVOBJ$, SAVTXT$ 
      EXTERNAL  GETDEF$, DEFGKS$ 
      EXTERNAL  OBJPLT$, SAVSWI$, ARROBJ$ 
C
C Locals
C
       SAVE I
       SAVE FIRST, STORE
       SAVE ISEND_ARR, ISEND_OBJ
       SAVE SWITCH_ON
C
C Data
C
      DATA FIRST / .TRUE. / 
      DATA SWITCH_ON / .FALSE. / 
      DATA ISEND_ARR, ISEND_OBJ / N_ARROW*4, N_OBJ*4 /
C
C Is it safe ?
C
      IF (ISEND.LT.0 .OR. ISEND.GT.7) THEN
          CALL PUTFAT$('Illegal value for ISEND in PLTOBJ$')
          RETURN
      ENDIF
C
C Initialise first time round
C      
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL DEFGKS$
         CALL OBJPLT$(K1, K0)
      ENDIF    
C
C ISEND = 0 and 6: Special cases called from GKSGRF$ to set SWITCH_ON = .TRUE. or .FALSE.
C       
      IF (ISEND.EQ.0) THEN
         SWITCH_ON = .TRUE.
         STORE = .TRUE.
         CALL SAVSWI$(SWITCH_ON, STORE)
         RETURN
      ELSEIF (ISEND.EQ.6) THEN
         SWITCH_ON = .FALSE.
         STORE = .TRUE.
         CALL SAVSWI$(SWITCH_ON, STORE)
         RETURN   
      ENDIF
C
C Get current graphics parameters
C      
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
      ZSCALE = Y_SCALE
      
      IF (ISEND.EQ.1 .OR. ISEND.EQ.2 .OR. ISEND.EQ.3) THEN
C
C ISEND = 1, 2, OR 3 
C
         CALL OBJPLT$(ISEND, NPRESS)
         RETURN
      ENDIF
C
C Retrieve ISEND_ARR and ISEND_OBJ
C      
      STORE = .FALSE.
      CALL ARROBJ$(ISEND_ARR, ISEND_OBJ, N_ARROW, N_OBJ,
     +             STORE)      
      
      IF (ISEND.EQ.4) THEN
C
C ISEND = 4: plot foreground objects
C
      
C
C Retrieve LCTEMP
C
         STORE = .FALSE.
         CALL SAVELC$(LCTEMP,
     +                STORE)
C
C Draw arrows on plot if required ........................................
C
         STORE = .FALSE.
         CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +                HEAD, X1, X2, Y1, Y2,
     +                STORE)
         IF (SWITCH_ON) THEN
            DO I = 1, N_ARROW
               IF (ISEND_ARR(I).EQ.ISEND) THEN
C
C Only plot this if SWITCH_ON = .TRUE. and ISEND = 4, 5, or 7 
C                 
                  I_COPY(I) = IARROW(I)
               ELSE
                  I_COPY(I) = 0
               ENDIF
            ENDDO
         ELSE
C
C Standard foreground plotting
C           
            DO I = 1, N_ARROW
               I_COPY(I) = IARROW(I)
            ENDDO
         ENDIF                  
         CALL LOOPD4$(I_COPY, IKOLOR, N_ARROW, LCTEMP, K0,
     +                HEAD, X1, X2, Y1, Y2,
     +                MONO, VIDEO,
     +                BLACK, BRIGHT_WHITE)
C
C Objects................................................................
C
         STORE = .FALSE.
         CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                STORE)
         IF (SWITCH_ON) THEN
            DO I = 1, N_OBJ
               IF (ISEND_OBJ(I).EQ.ISEND) THEN
C
C Only plot this if SWITCH_ON = .TRUE. and ISEND = 4, 5, or 7
C                 
                  M_COPY(I) = M_OBJ(I)
               ELSE
                  M_COPY(I) = 0
               ENDIF      
            ENDDO  
         ELSE
C
C Standard foreground plotting
C           
            DO I = 1, N_OBJ
               M_COPY(I) = M_OBJ(I)
            ENDDO   
         ENDIF    
         CALL LOOPD5$(ICOLOR, JCOLOR_OBJ, LCTEMP, M_COPY, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ, ZSCALE,
     +                BAR_CHART, MONO, PS, VIDEO)
C
C Draw any text strings required to label the plot .......................
C
         STORE = .FALSE.
         CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT,
     +                HSTRNG, SPS, XPS, XSTRNG, YSTRNG, 
     +                FONT, STRNG, SYMBOL, TYPE1,
     +                STORE)
         CALL LOOPD6$(JKOLOR, N_TEXT, ISTRNG, K0, NOUT_PS,
     +                SPS, XPS, XSTRNG, YSTRNG, Y_SCALE,
     +                FONT, STRNG, SYMBOL, TYPE1,
     +                HARD_COPY, HPGL, MONO, PS, VIDEO,
     +                BLACK, BRIGHT_WHITE)
       ELSEIF (ISEND.EQ.5 .AND. SWITCH_ON) THEN
C
C ISEND = 5: plot backgound objects only if SWITCH_ON = .TRUE. and ISEND = 5
C
       
C
C Retrieve LCTEMP
C
         STORE = .FALSE.
         CALL SAVELC$(LCTEMP,
     +                STORE)
C
C Draw arrows on plot if required ........................................
C
         STORE = .FALSE.
         CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +                HEAD, X1, X2, Y1, Y2,
     +                STORE)
         DO I = 1, N_ARROW
            IF (ISEND_ARR(I).EQ.ISEND) THEN
               I_COPY(I) = IARROW(I)
            ELSE
               I_COPY(I) = 0
            ENDIF
         ENDDO         
         CALL LOOPD4$(I_COPY, IKOLOR, N_ARROW, LCTEMP, K0,
     +                HEAD, X1, X2, Y1, Y2,
     +                MONO, VIDEO,
     +                BLACK, BRIGHT_WHITE)     
C
C Objects................................................................
C
         STORE = .FALSE.
         CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                STORE)
         DO I = 1, N_OBJ
            IF (ISEND_OBJ(I).EQ.ISEND) THEN
               M_COPY(I) = M_OBJ(I)
            ELSE
               M_COPY(I) = 0
            ENDIF      
         ENDDO  
         CALL LOOPD5$(ICOLOR, JCOLOR_OBJ, LCTEMP, M_COPY, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ, ZSCALE,
     +                BAR_CHART, MONO, PS, VIDEO)
       ELSEIF (ISEND.EQ.7 .AND. SWITCH_ON) THEN
C
C ISEND = 7: plot intermediate objects between axes and data only if SWITCH_ON = .TRUE. and ISEND = 7
C
       
C
C Retrieve LCTEMP
C
         STORE = .FALSE.
         CALL SAVELC$(LCTEMP,
     +                STORE)
C
C Draw arrows on plot if required ........................................
C
         STORE = .FALSE.
         CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +                HEAD, X1, X2, Y1, Y2,
     +                STORE)
         DO I = 1, N_ARROW
            IF (ISEND_ARR(I).EQ.ISEND) THEN
               I_COPY(I) = IARROW(I)
            ELSE
               I_COPY(I) = 0
            ENDIF
         ENDDO         
         CALL LOOPD4$(I_COPY, IKOLOR, N_ARROW, LCTEMP, K0,
     +                HEAD, X1, X2, Y1, Y2,
     +                MONO, VIDEO,
     +                BLACK, BRIGHT_WHITE)     
C
C Objects................................................................
C
         STORE = .FALSE.
         CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                STORE)
         DO I = 1, N_OBJ
            IF (ISEND_OBJ(I).EQ.ISEND) THEN
               M_COPY(I) = M_OBJ(I)
            ELSE
               M_COPY(I) = 0
            ENDIF      
         ENDDO  
         CALL LOOPD5$(ICOLOR, JCOLOR_OBJ, LCTEMP, M_COPY, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ, ZSCALE,
     +                BAR_CHART, MONO, PS, VIDEO)
      ENDIF
      END
C 
C---------------------------------------------------------------
C
      SUBROUTINE LOOPD4$(IARROW, IKOLOR, JARROW, LCOLOR, NGKS,
     +                   HEAD, X1, X2, Y1, Y2,
     +                   MONO, VIDEO,
     +                   BLACK, BRIGHT_WHITE)
C
C 14/0719/97 win32 version
C 12/05/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C             
      INTEGER,          INTENT (IN) :: JARROW
      INTEGER,          INTENT (IN) :: IARROW(JARROW), IKOLOR(JARROW),
     +                                 LCOLOR, NGKS  
      INTEGER,          INTENT (IN) :: BLACK, BRIGHT_WHITE
      DOUBLE PRECISION, INTENT (IN) :: HEAD(JARROW), 
     +                                 X1(JARROW), X2(JARROW),
     +                                 Y1(JARROW), Y2(JARROW)
      LOGICAL,          INTENT (IN) :: MONO, VIDEO
C
C Locals
C      
    
      INTEGER    K1
      PARAMETER (K1 = 1)
      INTEGER    I, ICOLOR
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$, WGB_ARROW$
      CALL GSELNT$(NGKS)
      CALL GSLN$(K1)
      CALL GSLWSC$(ONE)
      DO I = 1, JARROW
         IF (MONO) THEN
            IF (VIDEO) THEN
               ICOLOR = BLACK - 1
            ELSE
               ICOLOR = BRIGHT_WHITE - 1
            ENDIF
         ELSE
            ICOLOR = IKOLOR(I)
         ENDIF
         CALL WGB_ARROW$(IARROW(I), ICOLOR, LCOLOR, 
     +                   HEAD(I), X1(I), X2(I), Y1(I), Y2(I))
      ENDDO
      END
C 
C----------------------------------------------------------------------
C
      SUBROUTINE LOOPD5$(ICOLOR, JCOLOR, LCTEMP, M, N,
     +                   SIZES, WIDE, X, Y, ZSCALE,
     +                   BAR_CHART, MONO, PS, VIDEO)
C
C ACTION : Symbols for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/12/97
C          Derived from LOOP02$       
C          12/05/2007 added INTENTS
C
      IMPLICIT    NONE
C
C Argument list
C
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (IN)    :: JCOLOR(N), LCTEMP, M(N) 
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: SIZES(N), WIDE(N), X(N), Y(N),
     +                                    ZSCALE
      LOGICAL,          INTENT (IN)    :: BAR_CHART, MONO, PS, VIDEO
C
C Locals
C
      INTEGER    K0, NHATCH, NT
      PARAMETER (K0 = 0, NHATCH = 140, NT = 1)
      INTEGER    I, IFILL1
      INTEGER    IXRES, IYRES
      DOUBLE PRECISION X_SVG, Y_SVG, YTOX
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      PARAMETER (XMAX = 1.0D+00, XMIN = 0.0D+00, YMAX = 1.0D+00,
     +           YMIN = 0.0D+00)
      DOUBLE PRECISION A, C, FACTOR, PNT25
      PARAMETER (A = 1.0D+00, FACTOR = 0.75D+00,
     +           PNT25 = 0.25D+00)
      DOUBLE PRECISION SIZNUM, XT(NT), YT(NT)
      DOUBLE PRECISION WIDE1
      PARAMETER (WIDE1 = 1.0D+00)
      LOGICAL    ACTIVE_SVG, STORE
      PARAMETER (STORE = .FALSE.)
      LOGICAL    BARCAP, SIDE1
      PARAMETER (BARCAP = .FALSE., SIDE1 = .TRUE.)
      EXTERNAL   GKSHOL$, PLTBAR$
      EXTERNAL   SAVRES$, SVGPAR
      IF (BAR_CHART) I = 1!to silence ftn95
C
C Define YTOX and C
C  
      CALL SAVRES$(IXRES, IYRES,
     +             STORE)
      YTOX = DBLE(IYRES)/DBLE(IXRES) 
      CALL SVGPAR (K0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG)
      IF (ACTIVE_SVG) YTOX = Y_SVG*YTOX/X_SVG  
      C = YTOX  
            
      DO I = 1, N
         IF (M(I).NE.0) THEN
            XT(1) = X(I)
            YT(1) = Y(I)
            IF (MONO) THEN
               IF (VIDEO) THEN
                  ICOLOR = 0
               ELSE
                  ICOLOR = 15
               ENDIF
            ELSE
               ICOLOR = JCOLOR(I)
            ENDIF
            IF (M(I).EQ.1) THEN
               SIZNUM = FACTOR*PNT25*SIZES(I)*ZSCALE
            ELSE
               SIZNUM = FACTOR*SIZES(I)*ZSCALE
            ENDIF
            IF (M(I).GE.20 .AND. M(I).LE.29) THEN
               IFILL1 = M(I) - 19
               CALL PLTBAR$(ICOLOR, IFILL1, K0, LCTEMP, NHATCH, NT,
     +                      SIZNUM, WIDE(I), WIDE1, XT, XMAX, XMIN, YT,
     +                      YMAX, YMIN,
     +                      BARCAP, PS, SIDE1)
            ELSE
               CALL GKSHOL$(ICOLOR, K0, LCTEMP, M(I), NT,
     +                      A, C, SIZNUM, WIDE(I),
     +                      XT, XMAX, XMIN, YT, YMAX, YMIN)
            ENDIF
         ENDIF
      ENDDO
      END
C  
C----------------------------------------------------------------------
C
      SUBROUTINE LOOPD6$(JCOLOR, JSTRNG, NFONT, NGKS, NOUT_PS,
     +                   ANGLE, SIZES, XSTRNG, YSTRNG, Y_SCALE,
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   HARD_COPY, HPGL, MONO, PS, VIDEO,
     +                   BLACK, BRIGHT_WHITE)
C
C Derived from previous LOOP04$, 10/9/96
C 14/07/1997 win32 version
C 27/10/2000 changed font scheme
C            102 = Helvetica (slant = 0 or 20)
C            106 = Times-Roman (slant = 0)
C            107 = Times-Italic (slant = 0)
C            102 = Courier (temporary) (slant = 0 or 20)  
C 12/05/2007 added INTENTS
C
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: BLACK, BRIGHT_WHITE
      INTEGER,             INTENT (IN) :: JSTRNG
      INTEGER,             INTENT (IN) :: JCOLOR(JSTRNG), NFONT(JSTRNG),
     +                                    NGKS, NOUT_PS 
      DOUBLE PRECISION,    INTENT (IN) :: ANGLE(JSTRNG), SIZES(JSTRNG),
     +                                    XSTRNG(JSTRNG),
     +                                    YSTRNG(JSTRNG), Y_SCALE  
      CHARACTER (LEN = *), INTENT (IN) :: FONT(JSTRNG), STRNG(JSTRNG),
     +                                    SYMBOL(JSTRNG), TYPE1(JSTRNG)
      LOGICAL,             INTENT (IN) :: HARD_COPY, HPGL, MONO, PS,
     +                                    VIDEO
C
C Locals
C      
      INTEGER    I, ICOLOR, IFONT(14)
      DOUBLE PRECISION X, Y
      DOUBLE PRECISION SLANT(14)
      DOUBLE PRECISION ZERO, TWENTY
      PARAMETER (ZERO = 0.0D+00, TWENTY = 20.0D+00)
      EXTERNAL   PLTSTR$
      DATA IFONT / 106, 106, 107, 107, 102, 102, 102, 102, 102, 102,
     +             102, 102, 102, 102 /
      DATA SLANT / ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, TWENTY, TWENTY,
     +             ZERO, ZERO, TWENTY, TWENTY, ZERO, ZERO /
      DO I = 1, JSTRNG
         IF (STRNG(I).NE.' ') THEN
            IF (MONO) THEN
               IF (VIDEO) THEN
                  ICOLOR = BLACK - 1
               ELSE
                  ICOLOR = BRIGHT_WHITE - 1
               ENDIF
            ELSE
               ICOLOR = JCOLOR(I)
            ENDIF
            X = XSTRNG(I)
            Y = YSTRNG(I) 
            CALL PLTSTR$(ICOLOR, IFONT(NFONT(I)), NFONT(I), NGKS,
     +                   NOUT_PS,
     +                   ANGLE(I), SIZES(I), SLANT(NFONT(I)),
     +                   X, Y, Y_SCALE,
     +                   FONT(I), STRNG(I), SYMBOL(I), TYPE1(I),
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO
      END
C 
C----------------------------------------------------------------------
C
 