
C
C SERVICES
C ========
C
C ATTRIB$
C GETCHR$
C GETIGE$
C GETI01$
C GETIL1$
C GETIM1$
C GETJ01$
C GETJGE$
C GETJL1$
C GETJM1$
C GETKEY$
C GETRGE$
C GETR01$
C GETRG2$
C GETRL1$
C GETRM1$
C GETD01$
C GETDG2$
C GETDL1$
C GETDM1$
C GETSTR$
C GETTXT$
C GETYES$
C MAXMIN$
C NX2FIL$
C NX4FIL$
C NXXFIL$
C NXSORT$
C OFILES$
C PUTADV$
C PUTBEL$
C PUTCAU$ 
C PUTFAT$
C PUTIOS$
C PUTMES$
C PUTWAR$
C REJECT$
C X02AME$
C
C The routines do exactly the same thing as the routines in the
C menus dll but they have a $ in the name, e.g. putfat$ instead of putfat.
C I recommend that these routines be replaced by independent code, as
C I have done for some of them already, e.g. MAXMIN, NX2FIL, etc.
C
C The idea behind this is to make the graphics code potentially
C independent of the menus code, which has been necessary on some
C platforms. For instance, it is advisable to make a version of these
C routines that does not call the menus routines because, e.g. if putfat$
C is called before a window is completed, the Salford debugger does not
C work properly, and the developer does not get the required warning
C message. In Windows the MessageBox can be used, for instance, as in
C the calls to PUTALL.
C
C......................................................................
C
      SUBROUTINE ATTRIB$(FNAME,
     +                   EXIST, READ_ONLY)
      IMPLICIT  NONE
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,             INTENT (OUT) :: EXIST, READ_ONLY 
      EXTERNAL  ATTRIB
      CALL ATTRIB (FNAME,
     +             EXIST, READ_ONLY)
      END
C
C......................................................................
C
      SUBROUTINE GETCHR$(CHRKEY)
C
      IMPLICIT   NONE
      CHARACTER (LEN = 1), INTENT (OUT) :: CHRKEY
      EXTERNAL   GETCHR
      CALL GETCHR (CHRKEY)
      END
C
C......................................................................
C
      SUBROUTINE GETIGE$(I, LIMIT, 
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I >= LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      INTEGER,             INTENT (IN)  :: LIMIT
      INTEGER,             INTENT (OUT) :: I 
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
      EXTERNAL   GETIGE
      CALL GETIGE (I, LIMIT,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETI01$(I,
     +                   TEXT)
C
C ACTION : Ask for input then get an unlimited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      INTEGER,             INTENT (OUT) :: I
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL   GETI01
      CALL GETI01 (I, TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETIL1$(IBOT, IMID, ITOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          Tested ... Date of this version 28/9/93
C          DBOS version 30/3/94
C
      IMPLICIT   NONE   
      INTEGER, INTENT (OUT) :: IMID
      INTEGER, INTENT (IN)  :: IBOT, ITOP 
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
      EXTERNAL   GETIL1
      CALL GETIL1 (IBOT, IMID, ITOP, 
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETIM1$(NBOT, NMID, NTOP,
     +           TEXT)
C
C ACTION : USE GETIL1 TO GET NMID
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          DBOS version ... 18/2/94
C
      IMPLICIT  NONE
      INTEGER,             INTENT (OUT) :: NMID
      INTEGER,             INTENT (IN)  :: NBOT, NTOP
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL GETIM1
      CALL GETIM1 (NBOT, NMID, NTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETJGE$(I, LIMIT,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I >= LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE  
      INTEGER,             INTENT (INOUT) :: I
      INTEGER,             INTENT (IN)    :: LIMIT
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
      EXTERNAL   GETJGE
      CALL GETJGE (I, LIMIT,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETJ01$(I,
     +                   TEXT)
C
C ACTION : Ask for input then get an unlimited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      INTEGER,             INTENT (INOUT) :: I
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
      EXTERNAL   GETJ01
      CALL GETJ01 (I,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETJM1$(NBOT, NMID, NTOP,
     +                   TEXT)
C
C ACTION : USE GETJM1 TO GET NMID
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          DBOS version ... 18/2/94
C
      IMPLICIT  NONE    
      INTEGER,             INTENT (INOUT) :: NMID
      INTEGER,             INTENT (IN)    :: NBOT, NTOP
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
      EXTERNAL GETJM1
      CALL GETJM1 (NBOT, NMID, NTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETKEY$(KEYSCN,
     +                   CHRKEY)
C
      IMPLICIT   NONE
      INTEGER,             INTENT (OUT) :: KEYSCN
      CHARACTER (LEN = 1), INTENT (OUT) :: CHRKEY
      EXTERNAL GETKEY
      CALL GETKEY (KEYSCN,
     +             CHRKEY)
      END
C
C......................................................................
C
      SUBROUTINE GETRGE$(X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X >= XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE  
      DOUBLE PRECISION,    INTENT (OUT) :: X
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL   GETRGE
      CALL GETRGE (X, XLIM,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETR01$(X, 
     +                   TEXT)
C
C ACTION : Ask for input then get one real unlimited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL   GETR01
      CALL GETR01 (X,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETRG2$(X, Y,
     +                   TEXT)
C
C ACTION : Ask for input then get two real numbers from keyboard
C          Reject unless Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          Tested ... Date of this version 28/9/93
C          DBOS version 30/3/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL  GETRG2
      CALL GETRG2 (X, Y,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETRL1$(XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a real limited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION,    INTENT (OUT) :: XMID 
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL   GETRL1
      CALL GETRL1 (XBOT, XMID, XTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETRM1$(XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : USE GETRL1 TO GET XMID
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION,    INTENT (OUT) :: XMID 
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
      EXTERNAL   GETRM1
      CALL GETRM1 (XBOT, XMID, XTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETDGE$(X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X >= XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION,    INTENT (INOUT) :: X  
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
      EXTERNAL   GETDGE
      CALL GETDGE (X, XLIM,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETD01$(X,
     +                   TEXT)
C
C ACTION : Ask for input then get one real unlimited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
      EXTERNAL   GETD01
      CALL GETD01 (X,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETDG2$(X, Y,
     +                   TEXT)
C
C ACTION : Ask for input then get two real numbers from keyboard
C          Reject unless Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          Tested ... Date of this version 28/9/93
C          DBOS version 30/3/94
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (INOUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
      EXTERNAL  GETDG2
      CALL GETDG2 (X, Y,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETDL1$(XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a real limited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE  
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID 
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT, XTOP
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
      EXTERNAL   GETDL1
      CALL GETDL1 (XBOT, XMID, XTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETDM1$(XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : USE GETDM1 TO GET XMID
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          DBOS version ... 18/2/94
C
      IMPLICIT   NONE 
      DOUBLE PRECISION, INTENT (INOUT) :: XMID 
      DOUBLE PRECISION, INTENT (IN)    :: XBOT, XTOP
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
      EXTERNAL   GETDM1
      CALL GETDM1 (XBOT, XMID, XTOP,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETSTR$(QUERY, TEXT)
C
C ACTION : Return TEXT in response to QUERY
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 25/12/92
C          18/02/1994 DBOS version
C          23/10/1995 differs from GETTXT in that it displays TEXT not ?
C                     so TEXT must be initialised before this can be used
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT 
      CHARACTER (LEN = *), INTENT (IN)    :: QUERY
C
C Locals
C      
      EXTERNAL   GETSTR
      CALL GETSTR (QUERY, TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETTXT$(QUERY, TEXT)
C
C ACTION : Return TEXT in response to QUERY
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 25/12/92
C          Tested ... Date of this version 28/9/93
C          Replace by call to DBOS_GETTXT 26/3/94
C
      IMPLICIT  NONE   
      CHARACTER (LEN = *), INTENT (OUT) :: TEXT 
      CHARACTER (LEN = *), INTENT (IN)  :: QUERY
      EXTERNAL  GETTXT
      CALL GETTXT (QUERY, TEXT)
      END
C
C......................................................................
C
      SUBROUTINE GETYES$(YES)
C
      IMPLICIT  NONE
      LOGICAL, INTENT (INOUT) :: YES
      EXTERNAL  GETYES
      CALL GETYES (YES)
      END
C
C......................................................................
C
      SUBROUTINE MAXMIN$(ISEND, N,
     +                   X, XMAX, XMIN)
C
C ACTION : ISEND = 0 : Return XMAX and XMIN from an array X(N)
C          ISEND = 1 : Overwrite XMAX and XMIN supplied if justified
C ADVICE : ISEND, N and X are unchanged
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 30/1/92
C          Date of this version 23/2/97
C
      IMPLICIT   NONE
      INTEGER,          INTENT (IN)    :: ISEND, N
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), XMAX, XMIN
      INTEGER    I
      INTEGER    N0, N2
      PARAMETER (N0 = 0, N2 = 2)
      DOUBLE PRECISION TMAX, TMIN
      TMAX = X(1)
      TMIN = X(1)
      DO I = N2, N
         IF (X(I).GT.TMAX) TMAX = X(I)
         IF (X(I).LT.TMIN) TMIN = X(I)
      ENDDO
      IF (ISEND.EQ.N0) THEN
         XMAX = TMAX
         XMIN = TMIN
      ELSE
         IF (TMAX.GT.XMAX) XMAX = TMAX
         IF (TMIN.LT.XMIN) XMIN = TMIN
      ENDIF
      END
C
C......................................................................
C
      SUBROUTINE NX2FIL$(N,
     +                   X1, X2)
C
C ACTION : Write a set of 2 X coordinates to a file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/90
C          27/12/1992 Added commas as separators and other changes
C                     Derived from NX4FIL
C          30/03/1994 DBOS version 
C          12/02/1996 Added J and cleaned up clashes with INTEGER*2/*4
C          30/06/1999 Added call to GETNOU
C          11/03/2001 Added call to PFILE2
C          28/06/2006 Added call to I1FILE and I2FILE
C          10/03/2021 Added call to nxxfil$ 
C          09/09/2023 Added call to e_formats, etc.
C
C      N: (input/unchanged) no. of points
C X1, X2: (input/unchanged) vectors 
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N 
      DOUBLE PRECISION, INTENT (IN) :: X1(N), X2(N)
C
C Locals
C      
      INTEGER    NOUT
      INTEGER    NBIG, NLINES, NSMALL
      PARAMETER (NBIG = 50, NSMALL = 1)
      INTEGER    I, J
      INTEGER    ITYPE, N1, N2
      PARAMETER (ITYPE = 4, N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      CHARACTER  FNAME*1024, TITLE*80
      character (len = 13) d13(2), showrj 
      character (len = 2 ) blank2
      parameter (blank2 = '  ')
      logical    e_formats, e_numbers
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      LOGICAL    ABORT, ASKIF
      PARAMETER (ASKIF = .TRUE.)
      external   e_formats, showrj
      EXTERNAL   OFILES$, GETTXT$, GETJM1$
      EXTERNAL   YESNO2, GETNOU, PFILE2, I1FILE, I2FILE
      EXTERNAL   NXXFIL$
      e_numbers = e_formats()
C
C Check N the attempt to open a file
C      
      ABORT = .TRUE.
      CALL NXXFIL$(ABORT, STORE) 
      IF (N.LT.N1) RETURN
      CALL GETNOU (NOUT)
      I = N1
      CALL OFILES$(I, NOUT, 
     +             FNAME, 
     +             ABORT)
      CALL NXXFIL$(ABORT, STORE)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN    
      ENDIF      
C
C Write the output file
C      
      CALL GETTXT$('Title of data', TITLE)
      WRITE (NOUT,'(A)')  TITLE  
      CALL I2FILE (NOUT, N, N2)
      if (e_numbers) then
         WRITE (NOUT,'(1P,2E13.5)') (X1(I), X2(I), I = N1, N)
      else 
         do i = n1, n
           d13(1) = showrj(x1(i))
           d13(2) = showrj(x2(i))
           write (nout,'(a2,a13,a2,a13)') blank2, d13(1), blank2, d13(2)
         enddo
      endif        
C
C Extra trailing lines of text if required
C      
      CALL YESNO2 (ICOLOR, IX, IY, 
     +             'Add extra details ?', 
     +             ABORT)
      IF (ABORT) THEN
         NLINES = N1
         CALL GETJM1$(NSMALL, NLINES, NBIG,
     +'No. of extra lines required')
         CALL I1FILE (NOUT, NLINES)
         J = NLINES
         DO I = N1, J
            CALL GETTXT$('Next line', TITLE)
            WRITE (NOUT,'(A)') TITLE
         ENDDO
      ELSE  
         CALL I1FILE (NOUT, N1)
         WRITE (NOUT,'(A)') 'Line 1'
      ENDIF     
C
C Close NOUT then add to project archive if required
C      
      CLOSE (UNIT = NOUT)
      CALL PFILE2 (ITYPE, 
     +             FNAME, 
     +             ASKIF)
      END
C
C......................................................................
C
      SUBROUTINE NX4FIL$(N,
     +                   X1, X2, X3, X4)
C
C ACTION : Write a set of 4 X coordinates to a file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/90
C          27/12/1992 Added commas as separators and other changes
C          30/09/1993 Tested
C          30/03/1994 DBOS version
C          12/02/1996 Added J and cleaned up clashes with INTEGER*2/*4
C          30/06/1999 added call to GETNOU
C          11/03/2001 added call to PFILE1 and PFILE2
C          09/09/2023 Added call to e_formats, etc.
C
C              N: (input/unchanged) dimension
C X1, X2, X3, X4: (input/unchanged) vectors 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N 
      DOUBLE PRECISION, INTENT (IN) :: X1(N), X2(N), X3(N), X4(N)
C
C Locals
C      
      INTEGER    NBIG, NLINES, NSMALL
      PARAMETER (NBIG = 50, NSMALL = 1)
      INTEGER    ITYPE, N1, N4
      PARAMETER (ITYPE = 4, N1 = 1, N4 = 4)
      INTEGER    I, J, NOUT
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      CHARACTER  FNAME*1024, TITLE*80
      character (len = 13) d13(4), showrj
      character (len = 2 ) blank2
      parameter (blank2 = '  ') 
      logical    e_formats, e_numbers
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      LOGICAL    ABORT, ASKIF
      PARAMETER (ASKIF = .TRUE.)
      external   e_formats, showrj
      EXTERNAL   YESNO2, GETNOU, PFILE2, I1FILE, I2FILE
      EXTERNAL   OFILES$, GETJM1$, GETTXT$ 
      EXTERNAL   NXXFIL$
      e_numbers = e_formats()
C
C Check N then attempt to open a file
C      
      ABORT = .TRUE.
      CALL NXXFIL$ (ABORT, STORE)
      IF (N.LT.N1) RETURN
      CALL GETNOU (NOUT)
      I = N1
      CALL OFILES$(I, NOUT, 
     +             FNAME,
     +             ABORT)
      CALL NXXFIL$(ABORT, STORE)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN     
      ENDIF
C
C Write data to the file
C         
      CALL GETTXT$('Title of data', TITLE)
      WRITE (NOUT,'(A)') TITLE
      CALL I2FILE (NOUT, N, N4)
      if (e_numbers) then
         WRITE (NOUT,'(1P,4E13.5)') (X1(I), X2(I), X3(I), X4(I), 
     +                               I = N1, N)
      else
         do i = 1, n
            d13(1) = showrj(x1(i))
            d13(2) = showrj(x2(i))
            d13(3) = showrj(x3(i))
            d13(4) = showrj(x4(i))
            write (nout,'(a2,a13,a2,a13,a2,a13, a2,a13)')
     +             blank2, d13(1), blank2, d13(2),
     +             blank2, d13(3), blank2, d13(4)    
         enddo
      endif      
C
C Add extra details if required 
C
      CALL YESNO2 (ICOLOR, IX, IY,
     +             'Add extra details ?',
     +             ABORT)
      IF (ABORT) THEN
         NLINES = N1
         CALL GETJM1$(NSMALL, NLINES, NBIG,
     +'No. of extra lines required')
         CALL I1FILE (NOUT, NLINES)
         J = NLINES
         DO I = N1, J
            CALL GETTXT$('Next line', TITLE)
            WRITE (NOUT,'(A)') TITLE
         ENDDO
      ELSE                  
         CALL I1FILE (NOUT, N1)
         WRITE (NOUT,'(A)') 'Line 1'
      ENDIF  
C
C Close NOUT the add to project archive if required
C      
      CLOSE (UNIT = NOUT)
      CALL PFILE2 (ITYPE, FNAME, ASKIF)
      END
c
c subroutine nxxfil$ 10/03/2021 
c
      subroutine nxxfil$ (abort, store)
      logical, intent (inout) :: abort
      logical, intent (in)    :: store
      logical abort_sav
      save abort_sav
      data abort_sav / .true. /
      if (store) then
c
c store the value supplied
c        
         abort_sav = abort
      else
c
c retrieve the last value stored
c        
         abort = abort_sav
      endif
      end              
C
C......................................................................
C
      SUBROUTINE NXSORT$(N,
     +                   X)
C
C ACTION : Sort array X into increasing order using HEAPSORT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          13/05/2007 added INTENTS
C
      IMPLICIT NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N  
      DOUBLE PRECISION, INTENT (INOUT) :: X(N) 
C
C Locals
C      
      INTEGER  I, J, K, L
      DOUBLE PRECISION XTEMP
      IF (N.LT.2) RETURN
      L = N/2 + 1
      K = N
   20 CONTINUE
         IF (L.GT.1) THEN
            L = L - 1
            XTEMP = X(L)
         ELSE
            XTEMP = X(K)
            X(K) = X(1)
            K = K - 1
            IF (K.EQ.1) THEN
               X(1) = XTEMP
               GOTO 60
            ENDIF
         ENDIF
         I = L
         J = L + L
   40    IF (J.LE.K) THEN
            IF (J.LT.K) THEN
               IF (X(J).LT.X(J + 1)) J = J + 1
            ENDIF
            IF (XTEMP.LT.X(J)) THEN
               X(I) = X(J)
               I = J
               J = J + J
            ELSE
               J = K + 1
            ENDIF
            GOTO 40
         ENDIF
         X(I) = XTEMP
         GOTO 20
   60 CONTINUE
      END
C
C......................................................................
C
      SUBROUTINE OFILES$(ISEND, NOUT,
     +                   FNAME,
     +                   ABORT)
      IMPLICIT  NONE
      INTEGER,             INTENT (IN)    :: ISEND, NOUT
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (OUT)   :: ABORT
      EXTERNAL  OFILES
      CALL OFILES (ISEND, NOUT,
     +             FNAME,
     +             ABORT)
      END
C
C......................................................................
C
      SUBROUTINE PUTADV$(TEXT)
C
C ACTION : Declare ... ADVICE: TEXT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          DBOS version ... 18/2/94
C          15/11/2004 ftn95 version
C          TEXT: (input/unchanged)
C
      IMPLICIT   NONE
C
C Argument
C
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      EXTERNAL   PUTALL$
      CALL PUTALL$(ISEND,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE PUTBEL$
C
C ACTION : Sound bell
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26,11,92
C          Date of this version 30/3/94
C
      IMPLICIT NONE
      EXTERNAL PUTBEL
      CALL PUTBEL
      END
C
C......................................................................
C
      SUBROUTINE PUTCAU$(TEXT)
C
C ACTION : Declare  CAUTION: TEXT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          DBOS version ... 18/2/94
C          15/11/2004 ftn95 version
C          TEXT: (input/unchanged)
C
      IMPLICIT   NONE
C
C Argument
C
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      EXTERNAL   PUTALL$
      CALL PUTALL$(ISEND,
     +             TEXT)
      END
C         
C......................................................................
C
      SUBROUTINE PUTFAT$(TEXT)
C
C ACTION : Declare ... FATAL: TEXT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          DBOS version ... 18/2/94
C          15/11/2004 ftn95 version
C          TEXT: (input/unchanged)
C
      IMPLICIT   NONE
C
C Argument
C
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 4)
      EXTERNAL   PUTALL$
      CALL PUTALL$(ISEND, TEXT)
      END
C
C......................................................................
C
      SUBROUTINE PUTIOS$(IOS,
     +                   SRNAME)
C
C ACTION : Declare *IOSTAT : ... SRNAME
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/12/92
C          Tested ... Date of this version 28/9/93
C          Replaced by call to DBOS_PUTFAT 26/3/94
C          15/11/2004 ftn95 version
C
C          IOS: (input/unchanged)
C       SRNAME: (input/unchanged)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: IOS
      CHARACTER (LEN = *), INTENT (IN) :: SRNAME
C
C Locals
C
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT$
      WRITE (LINE,100) IOS, SRNAME
      CALL PUTFAT$ (LINE)
  100 FORMAT ('IOSTAT =',I4,' from ',A)
      END
C
C......................................................................
C
      SUBROUTINE PUTMES$(N, 
     +                   TEXT)
C
C ACTION : show a message
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 9/12/98
C
      IMPLICIT  NONE
      INTEGER,             INTENT (IN) :: N
      CHARACTER (LEN = *), INTENT (IN) :: TEXT(N)
      EXTERNAL  PUTMES
      CALL PUTMES (N,
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE PUTWAR$(TEXT)
C
C ACTION : Declare ... WARNING: TEXT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          DBOS version ... 18/2/94
C          15/11/2004 ftn95 version
C          TEXT: (input/unchanged)
C
      IMPLICIT   NONE
C
C Argument
C
      CHARACTER (LEN = *), INTENT (IN) :: TEXT
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 3)
      EXTERNAL   PUTALL$
      CALL PUTALL$(ISEND, 
     +             TEXT)
      END
C
C......................................................................
C
      SUBROUTINE REJECT$
C
C ACTION : Display reject message
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 19/11/92
C          Date of this version 30/3/94
C
      IMPLICIT NONE
      EXTERNAL PUTFAT$
      CALL PUTFAT$('Input rejected ... Try again')
      END
C
C......................................................................
C
      FUNCTION X02AME$()
      IMPLICIT NONE
      DOUBLE PRECISION X02AME$, RTOL
      PARAMETER (RTOL = 1.0D-300)
      X02AME$ = RTOL
      END
C
C
