C
C GSYMBOLS
C ========
C
C BLOCK
C WGB_ARROW
C WGB_CROSS
C WGB_MINUS
C WGB_PLUS
C WGB_DFILL
C WGB_EFILL
C WGB_SFILL
C WGB_TFILL
C WGB_UFILL
C
C These graph plotting symbols are corrected for aspect ratios, i.e.
C they are shape invariant under GKS type projective transformations.
C They communicate using the COMMON blocks in defngks.ins but do not
C themselves call any graphics primitives. Everything is in double
C precision and standard integers and there are no Salford calls.
C
C ACTION : Plotting symbols for SIMFIT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K. 21/11/94
C
C Version of COVERWGB for FTN77 GKS look alike
C Subroutines for plotting arrows and symbols by W. G. BARDSLEY, 23/4/93
C 29/11/1992 Added RECTANGLE, TRIANGLE and WEDGE
C 01/12/1992 Added PLUS_SIGN, CROSS_SIGN and ELLIPSE
C 16/12/1992 Added ARROW
C 23/04/1993 Added WGB_?FILL routines to fill symbols with background colour
C 03/11/1993 More _FILL routines, L = background colour, removed uneccessary code
C 03/10/1995 Added minus sign
C 23/02/1997 Win32 version  
C 24/07/1997 Added SHORT = for long/short colours
C 12/12/1997 added new arrow type for vector lines
C 08/02/1999 removed call to fill_rectangle
C 13/01/2003 added horizontal boxes to arrows
C 22/08/2006 added extra arrow type
C 20/04/2007 added INTENTS 
C 15/06/2007 removed defngks.ins and introduced GETGKS_LGL, etc.
C 27/12/2007 added script arrows
C 16/08/2008 extra options for outline plot symbols
C 18/06/2011 added WGB_UFILL for upside down triangle
C 23/08/2014 added calls to MITER_POLYLINE$ 
C            Note: PS symbols are now plotted from PSSYMB$ 
C 11/07/2019 added correction to YTOX for when stretching has been done 
C                       
C-----------------------------------------------------------------------
C
      SUBROUTINE BLOCK$(X1, Y1, X2, Y2, COLOUR_INDEX)
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN) :: X1, Y1, X2, Y2
C
C Locals
C        
      INTEGER    COLOUR
      INTEGER    N5
      PARAMETER (N5 = 5)
      DOUBLE PRECISION XTEMP(N5), YTEMP(N5)
      EXTERNAL   FILL_POLYGON$
      COLOUR = COLOUR_INDEX
      XTEMP(1) = X1
      XTEMP(2) = X1
      XTEMP(3) = X2
      XTEMP(4) = X2
      XTEMP(5) = XTEMP(1)
      YTEMP(1) = Y1
      YTEMP(2) = Y2
      YTEMP(3) = Y2
      YTEMP(4) = Y1
      YTEMP(5) = YTEMP(1)
      CALL FILL_POLYGON$(N5, XTEMP, YTEMP, COLOUR)
      END
C   
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_ARROW$(ISEND, COLOUR_INDEX, L,
     +                      HEAD, X1, X2, Y1, Y2)
C
C     Draws an arrow with head = (X1,Y1), tail = (X2,Y2), arrow length HEAD
C     ISEND = 1 (line)
C     ISEND = 2 (hollow)
C     ISEND = 3 (solid)
C     ISEND = 4 (LINETYPE = 1: solid line)
C     ISEND = 5 (LINETYPE = 2: dashed line)
C     ISEND = 6 (LINETYPE = 3: dotted line)
C     ISEND = 7 (LINETYPE = 4: dashed dotted line)
C     ISEND = 8 (transparent box) sloping
C     ISEND = 9 (opaque box) sloping
C     ISEND = 10 (solid box) sloping
C     ISEND = 11 (as 1 with no shaft for vector lines)
C     ISEND = 12 (connecting bridge)
C     ISEND = 13 (transparent box) horizontal
C     ISEND = 14 (opaque box) horizontal
C     ISEND = 15 (solid box) horizontal
C     ISEND = 16 dashed arrow 
C     ISEND = 17 (plus)
C     ISEND = 18 (cross)
C     ISEND = 19 (asterisk)  
C     ISEND = 20 (script-solid)
C     ISEND = 21 (script-dashed)  
C     ISEND = 22 (outline ellipse)
C     ISEND = 23 (filled ellipse)    
C
C     FACTOR ADJUSTS THICKNESS OF ARROW SHAFT
C     IT IS PRESUMED THAT THE COORDINATES ARE FULL SCREEN i.e. GSELNT(0)
C     L = BACKGROUND COLOUR
C     07/03/1998 Draw a cross if X1 = X2 and Y1 = Y2
C     18/09/1999 Added conecting bridges
C     22/08/2006 Added dashed arrow type and revised test for UP or DOWN 
C     21/06/2007 Added plus, cross, and astersisk
C     27/12/2007 Added script arows
C     20/08/2008 Added ellipses
C     23/08/2014 Added call MITER_POLYLINE$ for arrow head
C     11/07/2019 Added new definition of YTOX to allow for stretching
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ISEND, COLOUR_INDEX, L  
      DOUBLE PRECISION, INTENT (IN) :: HEAD, X1, X2, Y1, Y2
C
C Locals
C               
      INTEGER    IXRES, IYRES
      INTEGER    COLOUR 
      INTEGER    I, LFIX, NOUT_PS 
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N13, N14, N15, N16, N17, N19, N20, N21, N22, N23, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N13 = 13, N14 = 14, N15 = 15, N16 = 16, N17 = 17,
     +           N19 = 19, N20 = 20, N21 = 21, N22 = 22, N23 = 23,
     +           N100 = 100)
      DOUBLE PRECISION DMIN, EPSI, FACTOR, SIZE_1, SMALL, YTOX
      PARAMETER (DMIN = 0.01D+00, EPSI = 1.0D-38, FACTOR = 0.2D+00,
     +           SIZE_1 = 0.015D+00, SMALL = 1.0D-10)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, EIGHT, NINE, TEN,
     +                 ELEVEN      
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, EIGHT = 8.0D+00,
     +           NINE = 9.0D+00, TEN = 10.0D+00, ELEVEN = 11.0D+00) 
      DOUBLE PRECISION PI
      PARAMETER (PI = 3.14592654D+00)
      DOUBLE PRECISION X_SVG, Y_SVG
      DOUBLE PRECISION XPLUS, YPLUS
      DOUBLE PRECISION CONST, SLOPE, X(N100), Y(N100)
      DOUBLE PRECISION THETA, XDIFF, XTEMP, YDIFF, YTEMP
      LOGICAL    ACTIVE_SVG
      LOGICAL    ABORT, DOWN, UP
      LOGICAL    PS, STORE, STORE1
      PARAMETER (STORE = .TRUE., STORE1 = .FALSE.)
      EXTERNAL   SAVRES$, SVGPAR
      EXTERNAL   GSLN$, LINE$, FILL_POLYGON$, POLYLINE$, GSLWSC$,
     +           WGB_CROSS$, WGB_PLUS$, ELLIPS$, MITER_POLYLINE$,
     +           SET_END_CAP, PSLCAP$
      EXTERNAL   GETGKS_EPS
      INTRINSIC  ABS, ATAN, COS, SIN, SQRT
C
C Return if ISEND not in range 1 to 23
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N23) RETURN 
C
C Define YTOX
C  
      CALL SAVRES$(IXRES, IYRES,
     +             STORE1)
      YTOX = DBLE(IYRES)/DBLE(IXRES) 
      CALL SVGPAR (N0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG)
      IF (ACTIVE_SVG) YTOX = Y_SVG*YTOX/X_SVG   
C
C Copy colours
C     
      COLOUR = COLOUR_INDEX
      LFIX = L 
C
C Set line thickness globally
C
      IF (ISEND.GE.N1 .AND. ISEND.LE.N3 .OR. ISEND.GE.N16) THEN
         CALL GSLWSC$(ONE)
      ELSEIF (ISEND.GE.N4 .AND. ISEND.LE.N7) THEN
         CALL GSLWSC$(HEAD/SIZE_1)
      ENDIF
C
C Set line type globally
C
      IF (ISEND.EQ.N5) THEN
         CALL GSLN$(N2)
      ELSEIF (ISEND.EQ.N6) THEN
         CALL GSLN$(N3)
      ELSEIF (ISEND.EQ.N7) THEN
         CALL GSLN$(N4)
      ELSE
         CALL GSLN$(N1)
      ENDIF
C
C Check for the singular case
C
      IF (ABS(X2 - X1).LE.EPSI .AND. ABS(Y2 - Y1).LE.EPSI) THEN
         XPLUS = YTOX*HEAD
         YPLUS = HEAD
         CALL WGB_CROSS$(X1, XPLUS, Y1, YPLUS, COLOUR)
         RETURN
      ENDIF  
C
C Deal with plus, cross, asterisk
C                                 
      IF (ISEND.GT.N16 .AND. ISEND.LE.N19) THEN 
         XPLUS = YTOX*HEAD
         YPLUS = HEAD  
         IF (ISEND.EQ.N17 .OR. ISEND.EQ.N19) THEN         
           CALL WGB_PLUS$(X1, XPLUS, Y1, YPLUS, COLOUR)
         ENDIF
         IF (ISEND.GT.N17) THEN    
           CALL WGB_CROSS$(X1, XPLUS, Y1, YPLUS, COLOUR) 
         ENDIF  
         RETURN
      ENDIF
C
C Check if a PS file is being created
C      
      CALL GETGKS_EPS (NOUT_PS,
     +                    PS)        
C
C Decide if arrow is up, down, define THETA or return if YDIFF too small
C
      XDIFF = X2 - X1
      YDIFF = Y2 - Y1
      DOWN = .FALSE.
      UP = .FALSE.
      IF (ISEND.EQ.N1 .OR. ISEND.EQ.N11 .OR. 
     +    ISEND.GE.N16 .AND. ISEND.LE.N21) THEN
C
C Test for ordinary and vector lines is quite strict to keep arrows on curves
C
         CONST = EPSI       
      ELSEIF (ISEND.GE.N2 .AND. ISEND.LE.N7) THEN 
C
C Test for other arrow types is still quite strict
C      
         CONST = SMALL   
      ELSE
C
C Test for boxes and bridges is not so strict to help lining up parallel to the axes
C
         CONST = DMIN
      ENDIF
      IF (ABS(XDIFF).LE.CONST) THEN
         IF (YDIFF.GT.ZERO) THEN
            THETA = PI/TWO
            DOWN = .TRUE.
         ELSE
            THETA = - PI/TWO
            UP = .TRUE.
         ENDIF
      ELSEIF (XDIFF.GT.ZERO) THEN
         THETA = ATAN(YTOX*YDIFF/XDIFF)
      ELSE
         THETA = PI + ATAN(YTOX*YDIFF/XDIFF)
      ENDIF
      IF (ISEND.EQ.N1 .OR. (ISEND.GE.N4 .AND. ISEND.LE.N7) .OR.
     +    ISEND.EQ.N11 .OR. ISEND.EQ.N16) THEN
C
C Draw a line type arrow. Draw shaft of arrow (line arrow)
C
         IF (ISEND.NE.N11) THEN 
            IF (ISEND.EQ.N16) THEN
               CALL GSLN$(N2)
               CALL LINE$(X1, Y1, X2, Y2, COLOUR) 
               CALL GSLN$(N1)
            ELSE
               CALL LINE$(X1, Y1, X2, Y2, COLOUR)
            ENDIF   
         ENDIF   
         IF (ISEND.GT.N3 .AND. ISEND.LE.N7) RETURN
C
C Draw upper (i.e. anticlockwise) arrow head (line arrow)
C
         XTEMP = X1 + HEAD*COS(THETA + PI/FOUR)
         YTEMP = Y1 + HEAD*SIN(THETA + PI/FOUR)/YTOX
         X(1) = XTEMP
         Y(1) = YTEMP
         X(2) = X1
         Y(2) = Y1  
C
C Draw lower (i.e. clockwise) arrow head (line arrow)
C
         XTEMP = X1 + HEAD*COS(THETA - PI/FOUR)
         YTEMP = Y1 + HEAD*SIN(THETA - PI/FOUR)/YTOX
         X(3) = XTEMP
         Y(3) = YTEMP
         IF (PS) THEN
            CALL PSLCAP$(N2)
         ELSE
            I = N2
            CALL SET_END_CAP (I,
     +                        STORE)
         ENDIF           
         CALL MITER_POLYLINE$(N3, X, Y, COLOUR)
         IF (PS) THEN
            CALL PSLCAP$(N0)
         ELSE
            I = N0
            CALL SET_END_CAP (I,
     +                        STORE)
         ENDIF 
      ELSEIF (ISEND.EQ.N2 .OR. ISEND.EQ.N3) THEN
C
C Draw an outline type of arrow to be hollow or filled subsequently
C
         IF (DOWN .OR. UP) THEN
C
C Draw an up or down type outline arrow based on X2 = X1
C
            IF (DOWN) THEN
               X(1) = X1 - FACTOR*HEAD
               X(6) = X1 + FACTOR*HEAD
               Y(2) = Y1 + HEAD/(SQRT(TWO)*YTOX)
            ELSE
               X(1) = X1 + FACTOR*HEAD
               X(6) = X1 - FACTOR*HEAD
               Y(2) = Y1 - HEAD/(SQRT(TWO)*YTOX)
            ENDIF
            X(2) = X(1)
            X(3) = X1 + HEAD*COS(THETA + PI/FOUR)
            X(4) = X1
            X(5) = X1 + HEAD*COS(THETA - PI/FOUR)
            X(7) = X(6)
            Y(1) = Y2
            Y(3) = Y(2)
            Y(4) = Y1
            Y(5) = Y(2)
            Y(6) = Y(2)
            Y(7) = Y2
         ELSE
C
C Draw a non-vertical outline arrow
C
            IF (ABS(YDIFF).LE.DMIN) THEN
C
C X(1), X(7), Y(1), Y(7) for horizontal outline arrow based on Y2 = Y1
C
               X(1) = X2
               X(7) = X2
               IF (X2.GT.X1) THEN
                  Y(1) = Y1 + FACTOR*HEAD/YTOX
                  Y(7) = Y1 - FACTOR*HEAD/YTOX
               ELSE
                  Y(1) = Y1 - FACTOR*HEAD/YTOX
                  Y(7) = Y1 + FACTOR*HEAD/YTOX
               ENDIF
            ELSE
C
C X(1), X(7), Y(1), Y(7) for non-horizontal outline arrow
C
               SLOPE = YTOX*YDIFF/XDIFF
               CONST = YTOX*Y2 + X2/SLOPE
               IF (YDIFF.GT.EPSI) THEN
                  X(1) = X2 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
                  X(7) = X2 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               ELSE
                  X(1) = X2 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
                  X(7) = X2 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               ENDIF
               Y(1) = (- X(1)/SLOPE + CONST)/YTOX
               Y(7) = (- X(7)/SLOPE + CONST)/YTOX
            ENDIF
C
C Define remaining coordinates for outline arrow
C
            X(3) = X1 + HEAD*COS(THETA + PI/FOUR)
            Y(3) = Y1 + HEAD*SIN(THETA + PI/FOUR)/YTOX
            X(4) = X1
            Y(4) = Y1
            X(5) = X1 + HEAD*COS(THETA - PI/FOUR)
            Y(5) = Y1 + HEAD*SIN(THETA - PI/FOUR)/YTOX
            X(2) = X(3) + (ONE - SQRT(TWO)*FACTOR)*(X(5) - X(3))/TWO
            Y(2) = Y(3) + (ONE - SQRT(TWO)*FACTOR)*(Y(5) - Y(3))/TWO
            X(6) = X(3) + (ONE + SQRT(TWO)*FACTOR)*(X(5) - X(3))/TWO
            Y(6) = Y(3) + (ONE + SQRT(TWO)*FACTOR)*(Y(5) - Y(3))/TWO
         ENDIF
C
C Either hollow or filled arrow depending on ISEND
C
         X(8) = X(1)
         Y(8) = Y(1)
         IF (PS) THEN
            CALL PSLCAP$(N2)
         ELSE
            I = N2
            CALL SET_END_CAP (I,
     +                        STORE)
         ENDIF    
         IF (ISEND.EQ.N2) THEN
            CALL FILL_POLYGON$(N8, X, Y, LFIX)
            CALL MITER_POLYLINE$(N8, X, Y, COLOUR)
         ELSEIF (ISEND.EQ.N3) THEN
            CALL FILL_POLYGON$(N8, X, Y, COLOUR)
            CALL MITER_POLYLINE$(N8, X, Y, COLOUR)
         ENDIF
         IF (PS) THEN
            CALL PSLCAP$(N0)
         ELSE
            I = N0
            CALL SET_END_CAP (I,
     +                        STORE)            
         ENDIF
      ELSEIF (ISEND.GE.N8 .AND. ISEND.LE.N10 .OR. ISEND.EQ.N12) THEN
C
C Draw an outline type of box to be hollow or filled subsequently
C
         IF (DOWN .OR. UP) THEN
C
C Draw an up or down type outline box based on X2 = X1
C
            IF (DOWN) THEN
               X(1) = X1 - FACTOR*HEAD
               X(3) = X1 + FACTOR*HEAD
            ELSE
               X(1) = X1 + FACTOR*HEAD
               X(3) = X1 - FACTOR*HEAD
            ENDIF
            Y(1) = Y2
            Y(2) = Y1
            X(2) = X(1)
            X(4) = X(3)
            Y(3) = Y(2)
            Y(4) = Y(1)
         ELSEIF (ABS(YDIFF).LE.DMIN) THEN
C
C Draw a horizontal outline box based on Y2 = Y1
C
            IF (X2.GT.X1) THEN
               Y(1) = Y1 + FACTOR*HEAD/YTOX
               Y(3) = Y1 - FACTOR*HEAD/YTOX
            ELSE
               Y(1) = Y1 - FACTOR*HEAD/YTOX
               Y(3) = Y1 + FACTOR*HEAD/YTOX
            ENDIF
            X(1) = X2
            X(2) = X1
            X(3) = X(2)
            X(4) = X(1)
            Y(2) = Y(1)
            Y(4) = Y(3)
         ELSE
C
C X(1), X(4), Y(1), Y(4) for non-horizontal outline arrow
C
            SLOPE = YTOX*YDIFF/XDIFF
            CONST = YTOX*Y2 + X2/SLOPE
            IF (YDIFF.GT.EPSI) THEN
               X(1) = X2 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               X(4) = X2 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
            ELSE
               X(1) = X2 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               X(4) = X2 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
            ENDIF
            Y(1) = (- X(1)/SLOPE + CONST)/YTOX
            Y(4) = (- X(4)/SLOPE + CONST)/YTOX
C
C X(2), X(3), Y(2), Y(3) for non-horizontal outline arrow
C
            CONST = YTOX*Y1 + X1/SLOPE
            IF (YDIFF.GT.EPSI) THEN
               X(2) = X1 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               X(3) = X1 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
            ELSE
               X(2) = X1 + FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
               X(3) = X1 - FACTOR*HEAD*SQRT(SLOPE**2/(ONE+SLOPE**2))
            ENDIF
            Y(2) = (- X(2)/SLOPE + CONST)/YTOX
            Y(3) = (- X(3)/SLOPE + CONST)/YTOX
         ENDIF
      ELSEIF (ISEND.GE.N8 .AND. ISEND.LE.N15) THEN
         X(1) = X1
         X(2) = X2
         X(3) = X2
         X(4) = X1
         Y(1) = Y1
         Y(2) = Y1
         Y(3) = Y2
         Y(4) = Y2
      ELSEIF (ISEND.EQ.N20 .OR. ISEND.EQ.N21) THEN
C
C Draw a script line type arrow. Draw shaft of arrow (line arrow)
C
         XTEMP = X1 + HEAD*COS(THETA)
         YTEMP = Y1 + HEAD*SIN(THETA)/YTOX
         IF (ISEND.EQ.N20) THEN
            CALL LINE$(XTEMP, YTEMP, X2, Y2, COLOUR)
         ELSEIF (ISEND.EQ.N21) THEN
            CALL GSLN$(N2)
            CALL LINE$(XTEMP, YTEMP, X2, Y2, COLOUR) 
            CALL GSLN$(N1)
         ENDIF   
C
C Draw upper (i.e. anticlockwise) arrow head (line arrow)
C  
         XTEMP = X1 + TWO*HEAD*COS(THETA + PI/EIGHT)
         YTEMP = Y1 + TWO*HEAD*SIN(THETA + PI/EIGHT)/YTOX
         X(1) = XTEMP
         Y(1) = YTEMP
         XTEMP = X1 + (THREE/TWO)*HEAD*COS(THETA + PI/NINE)
         YTEMP = Y1 + (THREE/TWO)*HEAD*SIN(THETA + PI/NINE)/YTOX
         X(2) = XTEMP
         Y(2) = YTEMP
         XTEMP = X1 + HEAD*COS(THETA + PI/TEN)
         YTEMP = Y1 + HEAD*SIN(THETA + PI/TEN)/YTOX
         X(3) = XTEMP
         Y(3) = YTEMP
         XTEMP = X1 + (HEAD/TWO)*COS(THETA + PI/ELEVEN)
         YTEMP = Y1 + (HEAD/TWO)*SIN(THETA + PI/ELEVEN)/YTOX
         X(4) = XTEMP
         Y(4) = YTEMP
         X(5) = X1
         Y(5) = Y1
C
C Draw lower (i.e. clockwise) arrow head (line arrow)
C
         XTEMP = X1 + (HEAD/TWO)*COS(THETA - PI/ELEVEN)
         YTEMP = Y1 + (HEAD/TWO)*SIN(THETA - PI/ELEVEN)/YTOX
         X(6) = XTEMP
         Y(6) = YTEMP
         XTEMP = X1 + HEAD*COS(THETA - PI/TEN)
         YTEMP = Y1 + HEAD*SIN(THETA - PI/TEN)/YTOX
         X(7) = XTEMP
         Y(7) = YTEMP
         XTEMP = X1 + (THREE/TWO)*HEAD*COS(THETA - PI/NINE)
         YTEMP = Y1 + (THREE/TWO)*HEAD*SIN(THETA - PI/NINE)/YTOX
         X(8) = XTEMP
         Y(8) = YTEMP
         XTEMP = X1 + TWO*HEAD*COS(THETA - PI/EIGHT)
         YTEMP = Y1 + TWO*HEAD*SIN(THETA - PI/EIGHT)/YTOX
         X(9) = XTEMP
         Y(9) = YTEMP
         XTEMP = X1 + HEAD*COS(THETA)
         YTEMP = Y1 + HEAD*SIN(THETA)/YTOX
         X(10) = XTEMP
         Y(10) = YTEMP
         X(11) = X(1)
         Y(11) = Y(1)
         CALL FILL_POLYGON$(N11, X, Y, COLOUR)
      ELSEIF (ISEND.GE.N22 .AND. ISEND.LE.N23) THEN   
C
C Ellipses
C      
         CALL ELLIPS$(N100,
     +                HEAD, X, X1, X2, Y, Y1, Y2,
     +                ABORT)
         IF (.NOT.ABORT) THEN
            IF (ISEND.EQ.N23) CALL FILL_POLYGON$(N100, X, Y, COLOUR)
            CALL POLYLINE$(N100, X, Y, COLOUR)         
         ENDIF   
      ENDIF
      
      IF ((ISEND.GE.N8 .AND. ISEND.LE.N10) .OR.
     +    ISEND.EQ.N12 .OR.
     +    (ISEND.GE.N12 .AND. ISEND.LE.N15)) THEN
C
C Either hollow or filled box depending on ISEND
C
         X(5) = X(1)
         X(6) = X(2)
         Y(5) = Y(1)
         Y(6) = Y(2)
         IF (ISEND.EQ.N8 .OR. ISEND.EQ.N13) THEN
            CALL MITER_POLYLINE$(N6, X, Y, COLOUR)
         ELSEIF (ISEND.EQ.N9 .OR. ISEND.EQ.N14) THEN
            CALL FILL_POLYGON$(N5, X, Y, L)
            CALL MITER_POLYLINE$(N6, X, Y, COLOUR)
         ELSEIF (ISEND.EQ.N10 .OR. ISEND.EQ.N15) THEN
            CALL FILL_POLYGON$(N5, X, Y, COLOUR)
            CALL MITER_POLYLINE$(N6, X, Y, COLOUR)
         ELSEIF (ISEND.EQ.N12) THEN
C
C Start at [X(2),Y(2)} thus leaving out the long side connecting
C [X(1),Y(1)] to [X(2),Y(2)]
C
            CALL MITER_POLYLINE$(N4, X(2), Y(2), COLOUR)
         ENDIF
      ENDIF
      END
C  
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_CROSS$(X, XPLUS, Y, YPLUS, COLOUR_INDEX)
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN) :: X, XPLUS, Y, YPLUS
C
C Locals
C         
      INTEGER    COLOUR 
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION XADD, XSUB, YADD, YSUB
      EXTERNAL   GSLN$, LINE$   
      XADD = X + XPLUS
      XSUB = X - XPLUS
      YADD = Y + YPLUS
      YSUB = Y - YPLUS
      COLOUR = COLOUR_INDEX
      CALL GSLN$(N1)
      CALL LINE$(XSUB, YSUB, XADD, YADD, COLOUR)
      CALL LINE$(XADD, YSUB, XSUB, YADD, COLOUR)
      END
C  
C-----------------------------------------------------------------------
C
      SUBROUTINE WGB_MINUS$(X, XPLUS, Y, COLOUR_INDEX)
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN) :: X, XPLUS, Y
C
C Locals
C                   
      INTEGER    COLOUR
      INTEGER    I, N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION XADD, XSUB, YFIX
      EXTERNAL   GSLN$, LINE$ 
      COLOUR = COLOUR_INDEX   
      XADD = X + XPLUS
      XSUB = X - XPLUS
      YFIX = Y
      I = N1
      CALL GSLN$(I)
      CALL LINE$(XSUB, YFIX, XADD, YFIX, COLOUR)
      END
C 
C-----------------------------------------------------------------------
C
      SUBROUTINE WGB_PLUS$(X, XPLUS, Y, YPLUS, COLOUR_INDEX)
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION X, XPLUS, Y, YPLUS
C
C Locals
C                    
      INTEGER    COLOUR
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION XADD, XFIX, XSUB, YADD, YFIX, YSUB
      EXTERNAL   GSLN$, LINE$
      COLOUR = COLOUR_INDEX 
      XADD = X + XPLUS 
      XFIX = X
      XSUB = X - XPLUS
      YADD = Y + YPLUS
      YFIX = Y
      YSUB = Y - YPLUS
      CALL GSLN$(N1)
      CALL LINE$(XFIX, YSUB, XFIX, YADD, COLOUR)
      CALL LINE$(XSUB, YFIX, XADD, YFIX, COLOUR)
      END
C 
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_DFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X, XTEMP,
     +                      Y, YTEMP, COLOUR_INDEX)
C
C Fill in diamond (stretched by FACTOR) with colours then re-draw
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, L, NPTS, COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN)    :: HEIGHT, RADIUS, X, Y
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), YTEMP(NPTS)
C
C Locals
C     
      INTEGER    COLOUR 
      INTEGER    I, LFIX 
      INTEGER    N0, N1, N2, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N5 = 5, N6 = 6)
      DOUBLE PRECISION FACTOR
      PARAMETER (FACTOR = 1.2D+00) 
      LOGICAL    PS
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      EXTERNAL   PSPOLY$, GSLN$, FILL_POLYGON$, MITER_POLYLINE$
      EXTERNAL   GETGKS_LGL, SET_END_CAP
      COLOUR = COLOUR_INDEX  
      LFIX = L
      CALL GSLN$(N1)
      XTEMP(1) = X
      XTEMP(2) = X + FACTOR*RADIUS
      XTEMP(3) = XTEMP(1)
      XTEMP(4) = X - FACTOR*RADIUS
      XTEMP(5) = XTEMP(1)
      YTEMP(1) = Y - FACTOR*HEIGHT
      YTEMP(2) = Y
      YTEMP(3) = Y + FACTOR*HEIGHT
      YTEMP(4) = YTEMP(2)
      YTEMP(5) = YTEMP(1)
      IF (ISEND.EQ.1) THEN
         CALL FILL_POLYGON$(N5, XTEMP, YTEMP, LFIX)
      ELSEIF (ISEND.EQ.2) THEN
         XTEMP(4) = XTEMP(1)
         YTEMP(4) = YTEMP(1)
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, COLOUR)
         XTEMP(4) = X - FACTOR*RADIUS
         YTEMP(4) = YTEMP(2)
         XTEMP(2) = XTEMP(1)
         YTEMP(2) = YTEMP(1)
         CALL FILL_POLYGON$(N4, XTEMP(2), YTEMP(2), LFIX)
         XTEMP(2) = X + FACTOR*RADIUS
         YTEMP(2) = Y
      ELSEIF (ISEND.EQ.3) THEN
         CALL FILL_POLYGON$(N4, XTEMP(2), YTEMP(2), COLOUR)
      ENDIF         
      CALL GETGKS_LGL (N6,
     +                 PS)      
      IF (PS) THEN
         CALL PSPOLY$(COLOUR_INDEX, N4, XTEMP, YTEMP, 'pc')
      ELSE
         I = N2
         CALL SET_END_CAP (I,
     +                     STORE)                 
         CALL MITER_POLYLINE$(N5, XTEMP, YTEMP, COLOUR)
         I = N0
         CALL SET_END_CAP (I,
     +                     STORE)   
      ENDIF
      END
C 
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_EFILL$(ISEND, L, NPTS, A, B, X, XTEMP, Y, YTEMP,
     +                      COLOUR_INDEX)
C
C Fill in ellipse with colours then re-draw
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, L, NPTS, COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN)    :: A, B, X, Y 
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), YTEMP(NPTS)
C
C Locals
C                   
      INTEGER    I, COLOUR, LFIX, N, NTEMP
      INTEGER    N1, N6
      PARAMETER (N1 = 1, N6 = 6)
      DOUBLE PRECISION THETA 
      DOUBLE PRECISION PI
      PARAMETER (PI = 3.14592654D+00)
      LOGICAL    PS
      EXTERNAL   PSPOLY$, GSLN$, FILL_POLYGON$, POLYLINE$
      EXTERNAL   GETGKS_LGL
      INTRINSIC  COS, SIN, DBLE, MOD
C
C Make sure N is odd so that NTEMP = N/2 + 1 does not lead to overflow
C      
      IF (MOD(NPTS,2).EQ.0) THEN
         N = NPTS - 1
      ELSE
         N = NPTS   
      ENDIF   
      CALL GSLN$(N1)   
      COLOUR = COLOUR_INDEX
      LFIX = L
      THETA = - 0.5D+00*PI
      DO I =  1, N - 1
         XTEMP(I) = X + A*COS(THETA)
         YTEMP(I) = Y + B*SIN(THETA)
         THETA = THETA + 2.0D+00*PI/(DBLE(N) - 2.0D+00)
      ENDDO
      XTEMP(N) = XTEMP(2)
      YTEMP(N) = YTEMP(2)  
      CALL GETGKS_LGL (N6,
     +                 PS)       
      IF (PS) THEN
         IF (ISEND.EQ.1) THEN 
            NTEMP = N - 1
            CALL PSPOLY$(LFIX, NTEMP, XTEMP, YTEMP, 'pe')
         ELSEIF (ISEND.EQ.2) THEN   
            NTEMP = N/2 + 1
            CALL PSPOLY$(LFIX, NTEMP, XTEMP, YTEMP, 'pf')
            CALL PSPOLY$(LFIX, NTEMP, XTEMP(NTEMP), YTEMP(NTEMP), 'pe')
         ELSEIF (ISEND.EQ.3) THEN 
            NTEMP = N - 1 
            CALL PSPOLY$(LFIX, NTEMP, XTEMP, YTEMP, 'pf')
         ENDIF  
         NTEMP = N - 1
         CALL PSPOLY$(LFIX, NTEMP, XTEMP, YTEMP, 'pc')
      ELSE
         IF (ISEND.EQ.1) THEN  
            NTEMP = N
            CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, LFIX)
         ELSEIF (ISEND.EQ.2) THEN   
            NTEMP = N/2 + 1
            CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, COLOUR)
            CALL FILL_POLYGON$(NTEMP, XTEMP(NTEMP), YTEMP(NTEMP), LFIX)
         ELSEIF (ISEND.EQ.3) THEN                 
            NTEMP = N
            CALL FILL_POLYGON$(NTEMP, XTEMP, YTEMP, COLOUR)
         ENDIF 
         NTEMP = N
         CALL POLYLINE$(NTEMP, XTEMP, YTEMP, COLOUR)
      ENDIF
      END
C 
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_SFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X, XTEMP,
     +                      Y, YTEMP, COLOUR_INDEX)
C
C Fill square with colours then re-draw
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, L, NPTS, COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN)    :: HEIGHT, RADIUS, X, Y
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), YTEMP(NPTS)
C
C Locals
C        
      INTEGER    COLOUR 
      INTEGER    I, LFIX 
      INTEGER    N1, N2, N4, N5, N6
      PARAMETER (N1 = 1, N2 = 2, N4 = 4, N5 = 5, N6 = 6)
      LOGICAL    PS
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)      
      EXTERNAL   PSPOLY$, GSLN$, FILL_POLYGON$, MITER_POLYLINE$
      EXTERNAL   GETGKS_LGL, SET_END_CAP
      IF (NPTS.LT.N5) RETURN
      CALL GSLN$(N1)  
      COLOUR = COLOUR_INDEX
      LFIX = L
      XTEMP(1) = X - RADIUS
      XTEMP(2) = XTEMP(1)
      XTEMP(3) = X + RADIUS
      XTEMP(4) = XTEMP(3)
      XTEMP(5) = XTEMP(1)
      YTEMP(1) = Y - HEIGHT
      YTEMP(2) = Y + HEIGHT
      YTEMP(3) = YTEMP(2)
      YTEMP(4) = YTEMP(1)
      YTEMP(5) = YTEMP(1)
      IF (ISEND.EQ.1) THEN
         CALL FILL_POLYGON$(N5, XTEMP, YTEMP, LFIX)
      ELSEIF (ISEND.EQ.2) THEN
         XTEMP(1) = X
         XTEMP(2) = XTEMP(1)
         XTEMP(5) = XTEMP(1)
         CALL FILL_POLYGON$(N5, XTEMP, YTEMP, COLOUR)
         XTEMP(1) = X - RADIUS
         XTEMP(2) = XTEMP(1)
         XTEMP(5) = XTEMP(1)
         XTEMP(3) = X
         XTEMP(4) = XTEMP(3)
         CALL FILL_POLYGON$(N5, XTEMP, YTEMP, LFIX)
         XTEMP(3) = X + RADIUS
         XTEMP(4) = XTEMP(3)
      ELSEIF (ISEND.EQ.3) THEN
         CALL FILL_POLYGON$(N5, XTEMP, YTEMP, COLOUR)
      ENDIF 
      CALL GETGKS_LGL (N6,
     +                 PS) 
      IF (PS) THEN
         CALL PSPOLY$(COLOUR, N4, XTEMP, YTEMP, 'pc')
      ELSE
         I = N2
         CALL SET_END_CAP (I,
     +                     STORE) 
         CALL MITER_POLYLINE$(N5, XTEMP, YTEMP, COLOUR)
         I = N1
         CALL SET_END_CAP (I,
     +                     STORE)            
      ENDIF
      END
C 
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_TFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                      X, XTEMP, Y, YTEMP, COLOUR_INDEX)
C
C Fill triangle with colours then re-draw
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, L, NPTS, COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN)    :: HEIGHT, RADIUS, TRIANG, X, Y
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), YTEMP(NPTS)
C
C Locals
C     
      INTEGER    COLOUR 
      INTEGER    LFIX 
      INTEGER    N1, N3, N4, N5, N6
      PARAMETER (N1 = 1, N3 = 3, N4 = 4, N5 = 5, N6 = 6)
      LOGICAL    PS
      EXTERNAL   PSPOLY$, GSLN$, FILL_POLYGON$, MITER_POLYLINE$  
      EXTERNAL   GETGKS_LGL
      IF (NPTS.LT.N4) RETURN
      CALL GSLN$(N1)         
      COLOUR = COLOUR_INDEX
      LFIX = L
      XTEMP(1) = X + TRIANG*RADIUS
      XTEMP(2) = X
      XTEMP(3) = X - TRIANG*RADIUS
      XTEMP(4) = XTEMP(1)
      YTEMP(1) = Y - HEIGHT
      YTEMP(2) = Y + HEIGHT
      YTEMP(3) = YTEMP(1)
      YTEMP(4) = YTEMP(1)
      IF (ISEND.EQ.1) THEN
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, LFIX)
      ELSEIF (ISEND.EQ.2) THEN
         XTEMP(3) = XTEMP(2)
         XTEMP(4) = XTEMP(1)
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, COLOUR)
         XTEMP(1) = X - TRIANG*RADIUS
         XTEMP(4) = XTEMP(1)
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, LFIX)
         XTEMP(1) = X + TRIANG*RADIUS
         XTEMP(3) = X - TRIANG*RADIUS
         XTEMP(4) = XTEMP(1)
      ELSEIF (ISEND.EQ.3) THEN
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, COLOUR)
      ENDIF 
      CALL GETGKS_LGL (N6,
     +                 PS)  
      IF (PS) THEN
         CALL PSPOLY$(COLOUR, N3, XTEMP, YTEMP, 'pc')
      ELSE
         XTEMP(5) = XTEMP(2)
         YTEMP(5) = YTEMP(2)
         CALL MITER_POLYLINE$(N5, XTEMP, YTEMP, COLOUR)
      ENDIF
      END
C
C
C 
C----------------------------------------------------------------------
C
      SUBROUTINE WGB_UFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                      X, XTEMP, Y, YTEMP, COLOUR_INDEX)
C
C Fill upside down triangle with colours then re-draw
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, L, NPTS, COLOUR_INDEX 
      DOUBLE PRECISION, INTENT (IN)    :: HEIGHT, RADIUS, TRIANG, X, Y
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), YTEMP(NPTS)
C
C Locals
C     
      INTEGER    COLOUR 
      INTEGER    LFIX 
      INTEGER    N1, N3, N4, N5, N6
      PARAMETER (N1 = 1, N3 = 3, N4 = 4, N5 = 5, N6 = 6)
      LOGICAL    PS
      EXTERNAL   PSPOLY$, GSLN$, FILL_POLYGON$, MITER_POLYLINE$  
      EXTERNAL   GETGKS_LGL
      IF (NPTS.LT.N4) RETURN
      CALL GSLN$(N1)         
      COLOUR = COLOUR_INDEX
      LFIX = L
      XTEMP(1) = X 
      XTEMP(2) = X + TRIANG*RADIUS
      XTEMP(3) = X - TRIANG*RADIUS
      XTEMP(4) = XTEMP(1)
      YTEMP(1) = Y - HEIGHT
      YTEMP(2) = Y + HEIGHT
      YTEMP(3) = YTEMP(2)
      YTEMP(4) = YTEMP(1)
      IF (ISEND.EQ.1) THEN
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, LFIX)
      ELSEIF (ISEND.EQ.2) THEN
         XTEMP(3) = XTEMP(1)
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, COLOUR)
         XTEMP(2) = XTEMP(1)
         XTEMP(3) = X - TRIANG*RADIUS
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, LFIX)
         XTEMP(2) = X + TRIANG*RADIUS
      ELSEIF (ISEND.EQ.3) THEN
         CALL FILL_POLYGON$(N4, XTEMP, YTEMP, COLOUR)
      ENDIF 
      CALL GETGKS_LGL (N6,
     +                 PS)  
      IF (PS) THEN
         CALL PSPOLY$(COLOUR, N3, XTEMP, YTEMP, 'pc')
      ELSE
         XTEMP(5) = XTEMP(2)
         YTEMP(5) = YTEMP(2)
         CALL MITER_POLYLINE$(N5, XTEMP, YTEMP, COLOUR)
      ENDIF
      END
C
C
