C
C
      SUBROUTINE GKS001 (L, M, N,
     +                   X, Y, 
     +                   PTITLE, XTITLE, YTITLE)
C
C ACTION: Call GKS004
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 3/1/2000
C         28/06/2006 edited to add checks on input arguments and clarify
C         13/04/2007 added INTENTS (arguments are not changed by GKS004)
C
C Note: this subroutine merely generates dummy arguments for variables
C       2, 3, and 4 then passes the arguments on to GKS004, the main
C       Simfit simple plotting routine
C
      IMPLICIT   NONE    
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: L, M, N 
      DOUBLE PRECISION,    INTENT (IN) :: X(N), Y(N)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
C
C Locals
C      
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      DOUBLE PRECISION X2(1), X3(1), X4(1)
      DOUBLE PRECISION Y2(1), Y3(1), Y4(1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   GKS004
C
C Check
C  
      IF (N.LT.N1) RETURN
      IF (L.LE.N0 .AND. M.LE.N0) RETURN    
C
C Initialise the dummy variables
C
      X2(1) = ZERO
      X3(1) = ZERO
      X4(1) = ZERO
      Y2(1) = ZERO
      Y3(1) = ZERO
      Y4(1) = ZERO
C
C Call GKS004 to plot X,Y  (N0 suppresses all except the first arguments)
C
      CALL GKS004 (L, N0, N0, N0,
     +             M, N0, N0, N0,
     +             N, N1, N1, N1,
     +             X, X2, X3, X4, 
     +             Y, Y2, Y3, Y4,
     +             PTITLE, XTITLE, YTITLE,
     +             AXES, GSAVE)
      END
C
C
