C
C GKS004
C ======
C
C This is the main plotting program from the original SIMFIT implementation
C of GKS. It is a very simple plotter for up to 4 data sets and has a number
C of historic features and things to bear in mind when editing it. In this
C version all the reals are in double precision and all integers are long.
C However, GKSD2S, which used to map doubles into reals, has been kept to
C copy the input arguments, which has many advantages, principally that the
C exact values are returned, which is very important when called repeatedly
C from a transforming program which takes logs, inverses, etc. The trimming
C of text to centralise is necessary if Hershey is called, but is irrelevent
C if TrueType or PS is intended. MONO and VIDEO should be left as initialised
C in defngks, or white on black may be created, as in the DOS version. Note
C how ASCII files can be output or simple editing by GKSMNU implemented. So,
C by replacing GKSMNU, more extensive editing can be allowed. The main graphics
C window with titles and legends, etc. is set up by GKSBOX. So, by editing
C GKSBOX, more extensive window functionality would be permitted. Note that
C titles, legends, labels, etc. are applied in the default (0,1) GKS frame,
C but GKSMRK$ and GKSHOL$ do clipping to the projected physical space. So
C be very careful if you decide to alter GKSBOX as it will effect all the
C GKS projections in the simple plotting programs. You have been warned!
C
C Note : concerning AXES and GSAVE
C ================================
C AXES and GSAVE now have different meanings from the original ones. If
C AXES = .TRUE. (axes have been transformed) and
C GSAVE = .FALSE. (do not save coordinates or call SIMPLOT)
C it will be presumed that GKS004 has been called from GKST04 and users
C will be warned about saving ASCII or transferring to SIMPLOT.
C
      SUBROUTINE GKS004 ( L1,  L2,  L3,  L4,
     +                    M1,  M2,  M3,  M4,
     +                   N1D, N2D, N3D, N4D,
     +                   X1D, X2D, X3D, X4D,
     +                   Y1D, Y2D, Y3D, Y4D,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
C
C ADVICE : Non of the input arguments are changed in this version
C ACTION : Call GKS as follows :-
C           L =   0 :- no line
C           L > = 1 :- solid line
C           M =   1 :- dot
C           M =   2 :- plus
C           M =   3 :- cross
C           M =   4 :- asterisk
C           M =   5 :- circle etc. ... 16 :- diamond
C
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          11/10/1993 added call to GKSD2S for double to single precision
C          28/11/1993 dimension of NMAX changed to 2000
C          31/01/1994 added calls to DBOS_MENUS
C          05/04/1994 added menu to choose ASCII files
C          23/02/1997 Win32 version
C          15/12/1997 changed dimensions to (*) so N1D, N2D, etc. can be used
C                     for present/absent as well as L1, L2, M1, M2, etc.
C          09/03/1998 revised call to GKSMNU and creation of ascii files
C          20/11/1998 added call to DEFGKS$ to make sure graphics parameters
C                     in DEFNGKS.INS are initialised
C          12/09/1999 introduced GRAVE1 and TBOX01
C          22/09/1999 changed definition of PTEXT into PTEXT = PTITLE, etc.
C          06/12/2000 replaced TBOX01 by LVIEW2
C          12/03/2001 introduced SMPLOT and TITLES
C          24/08/2001 introduced call to GSCALE$
C          23/10/2004 added XHAIRS and XGRID to call to GKSMNU and GKSBOX
C          23/01/2006 made arrays allocatable, extensive editing, and added
C                     calls I1FILE and I2FILE 
C          14/06/2007 removed defngks.ins and introduced GETGKS_LGL
C          29/07/2009 added calls to GKSTIC$ and GKSLGL$  
C          04/08/2009 added call to GKSCOL$ 
C          13/08/2009 replaced GSCALE$ by DOAXIS$ and added SIGGKS$
C          08/01/2016 added ICOUNT to prevent crash when calling DOAXIS$
C          10/03/2021 added call to NXXFIL$
C          13/03/2021 added MSYMBL$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: L1, L2, L3, L4,
     +                                    M1, M2, M3, M4,
     +                                    N1D, N2D, N3D, N4D
      DOUBLE PRECISION,    INTENT (IN) :: X1D(*), X2D(*),
     +                                    X3D(*), X4D(*),
     +                                    Y1D(*), Y2D(*),
     +                                    Y3D(*), Y4D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL,             INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: X1(:), X2(:), X3(:), X4(:),
     +                                 Y1(:), Y2(:), Y3(:), Y4(:)
C
C Locals
C
      INTEGER    ISEND, JSEND, NJCOL, NKCOL, NLGL
      PARAMETER (ISEND = 1, JSEND = 3, NJCOL = 5, NKCOL = 4, NLGL = 7)
      INTEGER    KPLOTS, KXM, KYM
      PARAMETER (KPLOTS = 4, KXM = 4, KYM = 4)
      INTEGER    KLOOP, KDEC, KTEMP
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K15
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K15 = 15)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    ICOL(K4), LN(K4), MK(K4), NUMBER(K4)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      INTEGER    KTIC, KTYPE, MXTIC, MYTIC, NPLOTS, LCTEMP
      INTEGER    N1, N2, N3, N4
      INTEGER    LN1, LN2, LN3, LN4, MK1, MK2, MK3, MK4, NOUT
      INTEGER    I, IERR, IFAIL, J, JFILES(K4), LFILES(K4), MFILES(K4),
     +           NFILES
      INTEGER    ICOUNT
      INTEGER    NLDGX, NLDGY, NXSIG, NYSIG
      DOUBLE PRECISION ONE, PNT25, ZERO
      PARAMETER (ONE = 1.0D+00, PNT25 = 0.25D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION A, B, C, D, FACTOR
      DOUBLE PRECISION XMIN, YMIN, XMAX, YMAX
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  CIPHER(8)*15, FRMAT*5, LINES(0:8)*15, SYMBOL(0:19)*15
      CHARACTER  TEXT(30)*100, TITLES(K4)*80
      CHARACTER  BLANK*1, GRAVE1*1, SAVEIT(K4)*20
      PARAMETER (BLANK = ' ', GRAVE1 = '`')
      CHARACTER  ABSENT*80, SAVED*20, SAVEAS*20, TEMP*80
      PARAMETER (ABSENT = 'Data set selected is absent ... Try again',
     +           SAVED = 'Saved*', 
     +           SAVEAS = 'Save As ASCII ?',
     +           TEMP = 'Temporary file' )
      CHARACTER  FILES(K4)*1024
      LOGICAL    VARLGL(NLGL) 
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)   
      LOGICAL    BOXIT, FRAME, MONO, OFFSET, PCX, VIDEO
      LOGICAL    XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT
      LOGICAL    ABORT, ASCII, FIRST, THERE
      LOGICAL    PLOT(K4), TEXTS 
      LOGICAL    HARD_COPY
      LOGICAL    ASKIF, TITLE1
      PARAMETER (ASKIF = .FALSE., TITLE1 = .TRUE.)
      EXTERNAL   GKSD2S$, MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, GKSMRK$,
     +           GKSHOL$, NX2FIL$, PUTFAT$, DEFGKS$, SMPLOT$, PUTWAR$,
     +           DOAXIS$, GKSTIC$, GKSLGL$, GKSCOL$, GKSSIG$
      EXTERNAL   GETGKS_LGL
      EXTERNAL   LVIEW2, TRIMC1, GETTMP, DELEET, GETNOU, I1FILE, I2FILE
      EXTERNAL   NXXFIL$, MSYMBL$
      INTRINSIC  MAX
C
C Data to confer SAVE and avoid UNDEF
C
       SAVE ICOL, LCTEMP
       DATA ICOL / K0, K0, K0, K0 /
       DATA LCTEMP / K15 /
C
C Data for line/symbol type menu for saving ASCII coordinate files
C
      DATA LINES  / 'No line        ', 'Solid line     ',
     +              'Dashed line    ', 'Dotted line    ',
     +              'Dash-Dotted    ', 'Vector >>>>>   ',
     +              'Vector <<<<<   ', 'Step ( cdf )   ',
     +              'Step(survive)  ' /
      DATA SYMBOL / 'No symbol      ', 'Point (.)      ',
     +              'Plus (+)       ', 'Cross (X)      ',
     +              'Asterisk (*)   ', 'Circle         ',
     +              'Half-circle    ', 'Full-circle    ',
     +              'Triangle       ', 'Half-triangle  ',
     +              'Full-triangle  ', 'Square         ',
     +              'Half-square    ', 'Full-square    ',
     +              'Diamond        ', 'Half-diamond   ',
     +              'Full-diamond   ', 'Minus          ',
     +              'Male           ', 'Female         ' /
C
C Initialise DEFGKS.INS
C
      CALL DEFGKS$  
C
C How many plots and find the minimum and maximum of the X and Y values
C Set PLOT and where a plot is possible copy N1D, X1D, Y1D, etc.
C
      N1 = MAX(N1D,K0)
      NUMBER(1) = N1
      N2 = MAX(N2D,K0)
      NUMBER(2) = N2
      N3 = MAX(N3D,K0)
      NUMBER(3) = N3
      N4 = MAX(N4D,K0)
      NUMBER(4) = N4
      IF (N1 + N2 + N3 + N4 .EQ. K0) THEN
         RETURN
      ELSE
         IERR = K0
         IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
         IF (IERR.NE.K0) RETURN
      ENDIF
      KTYPE = K0
      NPLOTS = K0
      PLOT(K1) = .FALSE.
      PLOT(K2) = .FALSE.
      PLOT(K3) = .FALSE.
      PLOT(K4) = .FALSE.
      TITLES(K1) = PTITLE
      TITLES(K2) = XTITLE
      TITLES(K3) = YTITLE
      TITLES(K4) = BLANK
      SAVEIT(K1) = BLANK
      SAVEIT(K2) = BLANK
      SAVEIT(K3) = BLANK
      SAVEIT(K4) = BLANK
      MXTIC = K4
      MYTIC = K4
C
C See if X1, Y1 are to be plotted
C
      ICOUNT = K0
      IF (N1.GT.K0 .AND. (L1.GT.K0 .OR. M1.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X1(N1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y1(N1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         NPLOTS = NPLOTS + K1
         PLOT(K1) = .TRUE.
         SAVEIT(K1) = SAVEAS
         CALL GKSD2S$(N1,
     +                X1D, X1)
         CALL GKSD2S$(N1,
     +                Y1D, Y1)
         CALL MAXMIN$(KTYPE, N1,
     +                X1, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N1,
     +                Y1, YMAX, YMIN)
         KTYPE = K1
      ELSE
         ALLOCATE(X1(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y1(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
      ENDIF
C
C See if X2, Y2 are to be plotted
C
      IF (N2.GT.K0 .AND. (L2.GT.K0 .OR. M2.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X2(N2), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y2(N2), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         NPLOTS = NPLOTS + K1
         PLOT(K2) = .TRUE.
         SAVEIT(K2) = SAVEAS
         CALL GKSD2S$(N2,
     +                X2D, X2)
         CALL GKSD2S$(N2, 
     +                Y2D, Y2)
         CALL MAXMIN$(KTYPE, N2,
     +                X2, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N2,
     +                Y2, YMAX, YMIN)
         KTYPE = K1
      ELSE
         ALLOCATE(X2(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y2(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
      ENDIF
C
C See if X3, Y3 are to be plotted
C
      IF (N3.GT.K0 .AND. (L3.GT.K0 .OR. M3.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X3(N3), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y3(N3), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         NPLOTS = NPLOTS + K1
         PLOT(K3) = .TRUE.
         SAVEIT(K3) = SAVEAS
         CALL GKSD2S$(N3,
     +                X3D, X3)
         CALL GKSD2S$(N3, 
     +                Y3D, Y3)
         CALL MAXMIN$(KTYPE, N3, 
     +                X3, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N3, 
     +                Y3, YMAX, YMIN)
         KTYPE = K1
      ELSE
         ALLOCATE(X3(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y3(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
      ENDIF
C
C See if X4, Y4 are to be plotted
C
      IF (N4.GT.K0 .AND. (L4.GT.K0 .OR. M4.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X4(N4), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y4(N4), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         NPLOTS = NPLOTS + K1
         PLOT(K4) = .TRUE.
         SAVEIT(K4) = SAVEAS
         CALL GKSD2S$(N4, 
     +                X4D, X4)
         CALL GKSD2S$(N4,
     +                Y4D, Y4)
         CALL MAXMIN$(KTYPE, N4,
     +                X4, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N4,
     +                Y4, YMAX, YMIN)
      ELSE
         ALLOCATE(X4(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
         ALLOCATE(Y4(K1), STAT = IERR)
         IF (IERR.NE.K0) GOTO 80
      ENDIF
C
C Find suitable ranges for X and Y axes
C
      IF (ICOUNT.EQ.K0) GOTO 80
      CALL DOAXIS$(MXTIC, NLDGX,
     +             XMAX, XMIN) 
      CALL DOAXIS$(MYTIC, NLDGY,
     +             YMAX, YMIN)           
      CALL GKSTIC$(ISEND, MXTIC, MYTIC)
C
C Set default significance
C      
      NXSIG = K2
      NYSIG = K2
      CALL GKSSIG$(ISEND, NLDGX, NXSIG, NLDGY, NYSIG)           
C
C Initialise GKSDEC and set the arrays LN and MK etc.
C
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      KTIC = K3
      LN(K1) = L1
      LN(K2) = L2
      LN(K3) = L3
      LN(K4) = L4
      MK(K1) = M1
      MK(K2) = M2
      MK(K3) = M3
      MK(K4) = M4
C
C Check if the symbols require adjusting
C      
      CALL MSYMBL$(MK(K1), N1)
      CALL MSYMBL$(MK(K2), N2)
      CALL MSYMBL$(MK(K3), N3)
      CALL MSYMBL$(MK(K4), N4)
C
C Copy titles into text for edititng
C
      PTEXT = PTITLE
      XTEXT = XTITLE
      YTEXT = YTITLE
      CALL TRIMC1 (PTEXT)
      CALL TRIMC1 (XTEXT)
      CALL TRIMC1 (YTEXT)
C
C Initialise plot style parameters
C
      TEXTS = .FALSE.
      XTOINT = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.
      CALL GKSLGL$(JSEND, NLGL,
     +             VARLGL)
      BOXIT = VARLGL (1)
      FRAME = VARLGL(2)
      OFFSET = VARLGL(3)
      XGRID = VARLGL(4)
      YGRID = VARLGL(5)
      XHAIRS = VARLGL(6) 
      IF (VARLGL(7)) THEN
         KTIC = K3
      ELSE
         KTIC = K1
      ENDIF       
C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Edit the plot
C            
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY) 
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, K4, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
      LN1 = LN(K1)
      LN2 = LN(K2)
      LN3 = LN(K3)
      LN4 = LN(K4)
      MK1 = MK(K1)
      MK2 = MK(K2)
      MK3 = MK(K3)
      MK4 = MK(K4)
C
C Call GKSBOX to set up a GKS portrait frame
C
      IF (TEXTS) THEN
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTEXT, XTEXT, YTEXT,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ELSE
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTITLE, XTITLE, YTITLE,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ENDIF
      IF (ABORT) GOTO 80
C
C Set colours then call GKSMRK to draw lines
C
      LCTEMP = K15
      IF (MONO) THEN
         IF (VIDEO) THEN
C
C Black on white
C
            LCTEMP = K15
            DO I = K1, K4
               ICOL(I) = K0
            ENDDO   
         ELSE
C
C White on black
C
            LCTEMP = K0
            DO I = K1, K4
               ICOL(I) = K15
            ENDDO   
         ENDIF
      ELSE
C
C Colour
C
         CALL GKSCOL$(JSEND, JCOL, KCOL, NJCOL, NKCOL)
         LCTEMP = JCOL(5)
         DO I = K1, K4
            ICOL(I) = KCOL(I)
         ENDDO   
      ENDIF
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K1), K1, LN1, MK1, N1,
     +                A, B, C, D, FACTOR, ONE, X1, XMAX, XMIN,
     +                                         Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K2), K1, LN2, MK2, N2,
     +                A, B, C, D, FACTOR, ONE, X2, XMAX, XMIN,
     +                                         Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K3), K1, LN3, MK3, N3,
     +                A, B, C, D, FACTOR, ONE, X3, XMAX, XMIN,
     +                                         Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K4), K1, LN4, MK4, N4,
     +                A, B, C, D, FACTOR, ONE, X4, XMAX, XMIN,
     +                                         Y4, YMAX, YMIN)
      ENDIF
C
C Call GKSHOL to draw symbols
C
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K1), K1, LCTEMP, MK1, N1,
     +                A, C, FACTOR, ONE, X1, XMAX, XMIN,
     +                                   Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K2), K1, LCTEMP, MK2, N2,
     +                A, C, FACTOR, ONE, X2, XMAX, XMIN,
     +                                   Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K3), K1, LCTEMP, MK3, N3,
     +                A, C, FACTOR, ONE, X3, XMAX, XMIN,
     +                                   Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K4), K1, LCTEMP, MK4, N4,
     +                A, C, FACTOR, ONE, X4, XMAX, XMIN,
     +                                   Y4, YMAX, YMIN)
      ENDIF
C
C LABEL 40: Call GKSDEC to decide the next course of action
C =========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      IF (ASCII) THEN
C
C LABEL 60: Create ASCII files to import into program SIMPLOT
C =========
C
         IF (AXES .AND. .NOT.GSAVE) THEN
            CALL PUTWAR$(
     +'Only untransformed x,y data can be saved or exported to SIMPLOT')
            GOTO 40
         ENDIF
   60    CONTINUE
         KDEC = KPLOTS + K1
         TEXT(K1) = 'Options for current data `'//
     +'Data Status `Associated Line Type `Associated Symbol Type'
         KTEMP = K1
         DO KLOOP = K1, KPLOTS
            KTEMP = KTEMP + K1
            WRITE (FRMAT,'(I3,2X)') KLOOP
            IF (PLOT(KLOOP)) THEN
               CIPHER(KLOOP) = 'Plotted'
               TEXT(KTEMP) =  FRMAT//SAVEIT(KLOOP)//GRAVE1//
     +                        CIPHER(KLOOP)//GRAVE1//
     +                        LINES(LN(KLOOP))//GRAVE1//
     +                        SYMBOL(MK(KLOOP))
            ELSE
               CIPHER(KLOOP) = 'No data'
               TEXT(KTEMP) =  FRMAT//GRAVE1//CIPHER(KLOOP)
            ENDIF
         ENDDO
         KTEMP = KTEMP + K1
         TEXT(KTEMP) = 'Advanced editing'
         KTEMP = KTEMP + K1
         TEXT(KTEMP) = 'Return to default graph'
         KTEMP = KTEMP + K1
         TEXT(KTEMP) = 'Cancel'
         KLOOP = KPLOTS + K3
         CALL LVIEW2 (KXM, KYM, KDEC, KLOOP,
     +                TEXT, TITLE1)
         IF (KDEC.EQ.K1) THEN
            IF (PLOT(K1)) THEN
               CALL NX2FIL$(N1,
     +                      X1, Y1)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K1) = SAVEAS
               ELSE   
                  SAVEIT(K1) = SAVED
               ENDIF   
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
            GOTO 60
         ELSEIF (KDEC.EQ.K2) THEN
            IF (PLOT(K2)) THEN
               CALL NX2FIL$(N2, 
     +                      X2, Y2)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K2) = SAVEAS
               ELSE   
                  SAVEIT(K2) = SAVED
               ENDIF   
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
            GOTO 60
         ELSEIF (KDEC.EQ.K3) THEN
            IF (PLOT(K3)) THEN
               CALL NX2FIL$(N3,
     +                      X3, Y3)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K3) = SAVEAS
               ELSE   
                  SAVEIT(K3) = SAVED
               ENDIF   
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
            GOTO 60
         ELSEIF (KDEC.EQ.K4) THEN
            IF (PLOT(K4)) THEN
               CALL NX2FIL$(N4,
     +                      X4, Y4)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K4) = SAVEAS
               ELSE   
                  SAVEIT(K4) = SAVED
               ENDIF  
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
            GOTO 60
         ELSEIF (KDEC.EQ.K5) THEN
            NFILES = K0
            DO I = K1, KPLOTS
               IF (PLOT(I)) THEN
                  NFILES = NFILES + K1
                  JFILES(NFILES) = ICOL(I)
                  LFILES(NFILES) = LN(I)
                  MFILES(NFILES) = MK(I)
                  CALL GETTMP (IFAIL, FILES(NFILES))
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FILES(NFILES))
                  WRITE (NOUT,'(A)') TEMP
                  CALL I2FILE (NOUT, NUMBER(I), K2)
                  DO J = K1, NUMBER(I)
                     IF (I.EQ.K1) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X1(J), Y1(J)
                     ELSEIF (I.EQ.K2) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X2(J), Y2(J)
                     ELSEIF (I.EQ.K3) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X3(J), Y3(J)
                     ELSEIF (I.EQ.K4) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X4(J), Y4(J)
                     ENDIF
                  ENDDO 
                  CALL I1FILE (NOUT, K1)
                  WRITE (NOUT,'(A)') TEMP
                  CLOSE (UNIT = NOUT)
               ENDIF
            ENDDO
            CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES,
     +                   FILES, TITLES)
            DO I = K1, NFILES
               CALL DELEET (FILES(I),
     +                      ASKIF, THERE)
            ENDDO
            GOTO 60
         ELSEIF (KDEC.EQ.K6) THEN
            GOTO 40
         ELSE
            GOTO 80
         ENDIF
      ENDIF
      IF (.NOT.ABORT) GOTO 20
C
C LABEL 80: deallocate workspaces
C =========
C
   80 CONTINUE
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
      END
C
C
c
c     
      subroutine msymbl$ (m, npts)
c
c action: replace plotting symbols (m > 1) by dots (m = 1) if npts > nmax for appropriate programs
c author: w.g.bardsley, university of manchester, u.k., 13/03/2021
c         07/05/2022 increased nmax from (50,250) to (300,900) and also increased nmin to 300 
c
c         Note: nmax(i) can be set in the data statement depending on the program calling graphics
c               nmin sets the global minimum for which action is required and requires nmin =< nmax(i) for i = 1, 24
c
c arguments
c        
      integer, intent (inout) :: m  
      integer, intent (in)    :: npts
c
c locals
c      
      integer    i, ios, l1, l2, nin, nmax(24), nmin
      parameter (nmin = 300)
      character (len = 1024) temp
      character (len = 256 ) dummy, x_aux256, line
      character (len = 10  ) pname, prog(24)
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    back
      parameter (back = .true.)
      external   x_aux256, getnou, lcase1  
      data       prog / 'adderr' , 'average', 'binomial', 'calcurve', 
     +                  'compare', 'deqsol' , 'editfl'  , 'exfit'   ,
     +                  'gcfit'  , 'hlfit'  , 'inrate'  , 'linfit'  ,
     +                  'makdat' , 'mmfit'  , 'normal'  , 'polnom'  ,
     +                  'qnfit'  , 'rffit'  , 'sffit'   , 'simplot' ,
     +                  'simstat', 'spline' , 'ttest'   , 'usermod' /
      data       nmax /  300,  300,  300,  300,
     +                   300,  900,  300,  300,
     +                   300,  300,  300,  300,
     +                   300,  300,  300,  300,
     +                   900,  300,  300,  900,
     +                   300,  300,  300,  300  /   
c
c check if action is required
c     
      if (m.le.1 .or. npts.le.nmin) return
c
c open the temporary file written by simfit programs for identification and read the identifier
c        
      temp = x_aux256('f$simfit.tmp')
      call getnou (nin)    
      open (unit = nin, file = temp, iostat = ios) 
      if (ios.ne.0) then
         close (unit = nin)
         return
      else   
         dummy = blank
         line = blank
         do while (ios.eq.0)
            read (nin,'(a)', iostat=ios) dummy
            if (ios.eq.0) line = dummy
         enddo
      endif
      close (unit = nin) 
      if (line.eq.blank) then
         return
      else   
         l1 = len_trim(line)
         l2 = index(line(1:l1), '\', back)  
         pname = line(l2 + 1:l2 + 10)
         call lcase1 (pname)
c
c check if action is required
c      
          do i = 1, 24
             if (pname.eq.prog(i)) then
               if (npts.gt.nmax(i)) m = 1
               return
            endif  
         enddo
      endif         
      end
c
c
