C
C GKS012
C ======
C
C Read the introduction to gks004
C
      SUBROUTINE GKS012 (
     +L1,  L2,  L3,  L4,  L5,  L6,  L7,  L8,  L9,  L10,  L11,  L12,
     +M1,  M2,  M3,  M4,  M5,  M6,  M7,  M8,  M9,  M10,  M11,  M12,
     +N1D, N2D, N3D, N4D, N5D, N6D, N7D, N8D, N9D, N10D, N11D, N12D,
     +X1D, X2D, X3D, X4D, X5D, X6D, X7D, X8D, X9D, X10D, X11D, X12D,
     +Y1D, Y2D, Y3D, Y4D, Y5D, Y6D, Y7D, Y8D, Y9D, Y10D, Y11D, Y12D,
     +PTITLE, XTITLE, YTITLE, 
     +AXES, GSAVE)
C
C ADVICE : None of the input arguments are changed in this version
C ACTION : Call GKS as follows :-
C           L = 0 :- no line
C           L = 1 :- solid line
C           L = 2 :- dashed line, etc. 
C           M = 1 :- dot
C           M = 2 :- plus
C           M = 3 :- cross
C           M = 4 :- asterisk
C           M = 5 :- circle, etc. ... 16 :- diamond
C
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          11/10/1993 Added call to GKSD2S for double to single precision
C          28/11/1993 Dimension of NMAX changed to 2000
C          31/01/1994 added calls to DBOS_MENUS
C          05/04/1994 added menu to choose ASCII files
C          11/10/1995 Derived from GKS004
C          03/03/1997 Win32 version
C          15/12/1997 Used (*) so N1, N2 can be used for absent/present
C          09/03/1998 Used MXTIC, MYTIc in call to GKSMNU
C          20/11/1998 added call to DEFGKS$ to inialise parameters in
C                     DEFNGKS.INS
C          06/03/1999 altered call to GKSMNU to call with KPLOTS instead of NPLOTS
C          12/09/1999 Added GRAVE1 and call to TBOX01
C          23/09/1999 Changed definition of PTEXT to PTEXT = PTITLE, etc.
C          24/08/2001 introduced call to GSCALE$
C          25/10/2004 added XGRID and XHAIRS in call to GKSMNU and GKSBOX
C          29/06/2006 introduced allocatable workspaces, I1FILE, and I2FILE 
C          14/06/2007 removed defngks.ins and added GETGKS_LGL 
C          24/07/2009 corected error in call to GSCALE$
C          29/07/2009 added calls to GKSTIC$ and GKSLGL$
C          04/08/2009 added calls to GKSCOL$
C          13/08/2009 replaced GSCAlE$ by DOAXIS$ and added SIGGKS$
C          10/01/2016 added ICOUNT to prevent problems wit DOAXIS$
C          10/03/2021 added call to NXXFIL$

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) ::
     +L1,  L2,  L3,  L4,  L5,  L6,  L7,  L8,  L9,  L10,  L11,  L12,
     +M1,  M2,  M3,  M4,  M5,  M6,  M7,  M8,  M9,  M10,  M11,  M12,
     +N1D, N2D, N3D, N4D, N5D, N6D, N7D, N8D, N9D, N10D, N11D, N12D 
      DOUBLE PRECISION, INTENT (IN) ::
     +X1D(*), X2D(*), X3D(*), X4D(*),   X5D(*),  X6D(*),
     +X7D(*), X8D(*), X9D(*), X10D(*), X11D(*), X12D(*)
      DOUBLE PRECISION, INTENT (IN) ::
     +Y1D(*), Y2D(*), Y3D(*), Y4D(*),   Y5D(*),  Y6D(*),
     +Y7D(*), Y8D(*), Y9D(*), Y10D(*), Y11D(*), Y12D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL, INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C    
      DOUBLE PRECISION, ALLOCATABLE ::
     +X1(:), X2(:), X3(:), X4(:),  X5(:),  X6(:),
     +X7(:), X8(:), X9(:), X10(:), X11(:), X12(:)
      DOUBLE PRECISION, ALLOCATABLE ::
     +Y1(:), Y2(:), Y3(:), Y4(:),  Y5(:),  Y6(:),
     +Y7(:), Y8(:), Y9(:), Y10(:), Y11(:), Y12(:)   
C
C Locals
C     
      INTEGER    ISEND, JSEND, NJCOL, NKCOL, NLGL
      PARAMETER (ISEND = 1, JSEND = 3, NJCOL = 5, NKCOL = 12, NLGL = 7)
      INTEGER    KPLOTS, KXM, KYM
      PARAMETER (KPLOTS = 12, KXM = 4, KYM = 4)
      INTEGER    KLOOP, KDEC, KTEMP
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K11, K12,
     +           K15
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K11 = 11, K12 = 12,
     +           K15 = 15)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    ICOL(K12), LN(K12), MK(K12)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      INTEGER    I, IERR, IFAIL, J, JFILES(K12), LFILES(K12),
     +           MFILES(K12), NFILES, NOUT, NUMBER(K12)
      INTEGER    NLDGX, NLDGY, NXSIG, NYSIG
      INTEGER    KTIC, KTYPE, NPLOTS, LCTEMP, MXTIC, MYTIC,
     +N1,  N2,  N3,  N4,  N5,  N6,  N7,  N8,  N9,  N10,  N11,  N12,
     +LN1, LN2, LN3, LN4, LN5, LN6, LN7, LN8, LN9, LN10, LN11, LN12,
     +MK1, MK2, MK3, MK4, MK5, MK6, MK7, MK8, MK9, MK10, MK11, MK12
      INTEGER   ICOUNT
      DOUBLE PRECISION ONE, PNT25, ZERO
      PARAMETER (ONE = 1.0D+00, PNT25 = 0.25D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION A, B, C, D, FACTOR
      DOUBLE PRECISION XMIN, YMIN, XMAX, YMAX
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  CIPHER(K12)*10, FRMAT*5, LINES(0:8)*15,
     +           SYMBOL(0:19)*15
      CHARACTER  TEXT(30)*100, TITLES(4)*80
      CHARACTER  FILES(K12)*1024
      CHARACTER  BLANK*1, GRAVE1*1, SAVEIT(12)*20
      PARAMETER (BLANK = ' ', GRAVE1 = '`') 
      CHARACTER  ABSENT*80, SAVEAS*20, SAVED*20
      PARAMETER (ABSENT = 'Data set selected is absent ... Try again',
     +           SAVEAS = 'Save As ASCII ?',
     +           SAVED = 'Saved*')
      LOGICAL    LGLVAR(NLGL)   
      LOGICAL    BOXIT, FRAME, MONO, OFFSET, PCX, VIDEO
      LOGICAL    XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT
      LOGICAL    ABORT, ASCII, FIRST
      LOGICAL    PLOT(K12), TEXTS
      LOGICAL    HARD_COPY
      LOGICAL    ASKIF, THERE, STORE, TITLE1
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE., TITLE1 = .TRUE.)
      EXTERNAL   GKSD2S$, MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, GKSMRK$,
     +           GKSHOL$, NX2FIL$, PUTFAT$, DEFGKS$, SMPLOT$, PUTWAR$,
     +           DOAXIS$, GKSTIC$, GKSLGL$, GKSCOL$, GKSSIG$
      EXTERNAL   GETGKS_LGL
      EXTERNAL   LVIEW2, TRIMC1, GETTMP, DELEET, GETNOU, I1FILE, I2FILE
      EXTERNAL   NXXFIL$, MSYMBL$
      INTRINSIC  MAX
C
C Data to confer SAVE and avoid UNDEF
C
      SAVE ICOL, LCTEMP
      DATA ICOL / 12*0 /
      DATA LCTEMP / 15 /
C
C Data for line/symbol type menu for saving ASCII coordinate files
C
      DATA LINES  / 'No line        ', 'Solid line     ',
     +              'Dashed line    ', 'Dotted line    ',
     +              'Dash-Dotted    ', 'Vector >>>>>   ',
     +              'Vector <<<<<   ', 'Step ( cdf )   ',
     +              'Step(Survive)  ' /
      DATA SYMBOL / 'No symbol      ', 'Point (.)      ',
     +              'Plus (+)       ', 'Cross (X)      ',
     +              'Asterisk (*)   ', 'Circle         ',
     +              'Half-circle    ', 'Full-circle    ',
     +              'Triangle       ', 'Half-triangle  ',
     +              'Full-triangle  ', 'Square         ',
     +              'Half-square    ', 'Full-square    ',
     +              'Diamond        ', 'Half-diamond   ',
     +              'Full-diamond   ', 'Minus          ',
     +              'Male           ', 'Female         ' /
C
C Initialise DEFGKS.INS
C
      CALL DEFGKS$
C
C How many plots and find the minimum and maximum of the X and Y values
C Set PLOT and where a plot is possible copy N1, X1, Y1, etc.
C
      N1 = MAX(N1D, K0)
      NUMBER(1) = N1
      N2 = MAX(N2D, K0)
      NUMBER(2) = N2
      N3 = MAX(N3D, K0)
      NUMBER(3) = N3
      N4 = MAX(N4D, K0)
      NUMBER(4) = N4
      N5 = MAX(N5D, K0)
      NUMBER(5) = N5
      N6 = MAX(N6D, K0)
      NUMBER(6) = N6
      N7 = MAX(N7D, K0)
      NUMBER(7) = N7
      N8 = MAX(N8D, K0)
      NUMBER(8) = N8
      N9 = MAX(N9D, K0)
      NUMBER(9) = N9
      N10 = MAX(N10D, K0)
      NUMBER(10) = N10
      N11 = MAX(N11D, K0)
      NUMBER(11) = N11
      N12 = MAX(N12D, K0)
      NUMBER(12) = N12
      IF (N1 + N2 + N3 + N4 + N5 + N6 + N7 + N8 + N9 + N10 + N11 + N12
     +.EQ. K0) RETURN
C
C Make sure workspaces are deallocated
C             
      IERR = K0
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X5)) DEALLOCATE(X5, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X6)) DEALLOCATE(X6, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X7)) DEALLOCATE(X7, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X8)) DEALLOCATE(X8, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X9)) DEALLOCATE(X9, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X10)) DEALLOCATE(X10, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X11)) DEALLOCATE(X11, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X12)) DEALLOCATE(X12, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y5)) DEALLOCATE(Y5, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y6)) DEALLOCATE(Y6, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y7)) DEALLOCATE(Y7, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y8)) DEALLOCATE(Y8, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y9)) DEALLOCATE(Y9, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y10)) DEALLOCATE(Y10, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y11)) DEALLOCATE(Y11, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y12)) DEALLOCATE(Y12, STAT = IERR)
      IF (IERR.NE.K0) RETURN
C
C Initialise then deal with each case in turn
C      
      KTYPE = K0
      NPLOTS = K0
      MXTIC = K4
      MYTIC = K4
      TITLES(1) = PTITLE
      TITLES(2) = XTITLE
      TITLES(3) = YTITLE
      TITLES(4) = BLANK
      DO KLOOP = 1, K12
         PLOT(KLOOP) = .FALSE.
         SAVEIT(KLOOP) = BLANK
      ENDDO
      ICOUNT = K0
      IF (N1.GT.K0 .AND. (L1.GT.K0 .OR. M1.GT.K0)) THEN 
         ICOUNT = ICOUNT + K1
         ALLOCATE(X1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(1) = .TRUE.
         SAVEIT(1) = SAVEAS
         CALL GKSD2S$(N1, X1D, X1)
         CALL GKSD2S$(N1, Y1D, Y1)
         CALL MAXMIN$(KTYPE, N1, X1, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N1, Y1, YMAX, YMIN)
         KTYPE = K1
      ELSE
         ALLOCATE(X1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (N2.GT.K0 .AND. (L2.GT.K0 .OR. M2.GT.K0)) THEN 
         ICOUNT = ICOUNT + K1
         ALLOCATE(X2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(2) = .TRUE.
         SAVEIT(2) = SAVEAS
         CALL GKSD2S$(N2, X2D, X2)
         CALL GKSD2S$(N2, Y2D, Y2)
         CALL MAXMIN$(KTYPE, N2, X2, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N2, Y2, YMAX, YMIN)
         KTYPE = K1    
      ELSE
         ALLOCATE(X2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (N3.GT.K0 .AND. (L3.GT.K0 .OR. M3.GT.K0)) THEN 
         ICOUNT = ICOUNT + K1
         ALLOCATE(X3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(3) = .TRUE.
         SAVEIT(3) = SAVEAS
         CALL GKSD2S$(N3, X3D, X3)
         CALL GKSD2S$(N3, Y3D, Y3)
         CALL MAXMIN$(KTYPE, N3, X3, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N3, Y3, YMAX, YMIN)
         KTYPE = K1 
      ELSE
         ALLOCATE(X3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N4.GT.K0 .AND. (L4.GT.K0 .OR. M4.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(4) = .TRUE.
         SAVEIT(4) = SAVEAS
         CALL GKSD2S$(N4, X4D, X4)
         CALL GKSD2S$(N4, Y4D, Y4)
         CALL MAXMIN$(KTYPE, N4, X4, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N4, Y4, YMAX, YMIN)
         KTYPE = K1    
      ELSE
         ALLOCATE(X4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N5.GT.K0 .AND. (L5.GT.K0 .OR. M5.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X5(N5), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y5(N5), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(5) = .TRUE.
         SAVEIT(5) = SAVEAS
         CALL GKSD2S$(N5, X5D, X5)
         CALL GKSD2S$(N5, Y5D, Y5)
         CALL MAXMIN$(KTYPE, N5, X5, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N5, Y5, YMAX, YMIN)
         KTYPE = K1    
      ELSE
         ALLOCATE(X5(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y5(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N6.GT.K0 .AND. (L6.GT.K0 .OR. M6.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X6(N6), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y6(N6), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(6) = .TRUE.
         SAVEIT(6) = SAVEAS
         CALL GKSD2S$(N6, X6D, X6)
         CALL GKSD2S$(N6, Y6D, Y6)
         CALL MAXMIN$(KTYPE, N6, X6, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N6, Y6, YMAX, YMIN)
         KTYPE = K1  
      ELSE
         ALLOCATE(X6(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y6(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N7.GT.K0 .AND. (L7.GT.K0 .OR. M7.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X7(N7), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y7(N7), STAT = IERR)
         IF (IERR.NE.K0) RETURN    
         NPLOTS = NPLOTS + K1
         PLOT(7) = .TRUE.
         SAVEIT(7) = SAVEAS
         CALL GKSD2S$(N7, X7D, X7)
         CALL GKSD2S$(N7, Y7D, Y7)
         CALL MAXMIN$(KTYPE, N7, X7, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N7, Y7, YMAX, YMIN)
         KTYPE = K1    
      ELSE
         ALLOCATE(X7(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y7(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N8.GT.K0 .AND. (L8.GT.K0 .OR. M8.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X8(N8), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y8(N8), STAT = IERR)
         IF (IERR.NE.K0) RETURN    
         NPLOTS = NPLOTS + K1
         PLOT(8) = .TRUE.
         SAVEIT(8) = SAVEAS
         CALL GKSD2S$(N8, X8D, X8)
         CALL GKSD2S$(N8, Y8D, Y8)
         CALL MAXMIN$(KTYPE, N8, X8, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N8, Y8, YMAX, YMIN)
         KTYPE = K1 
      ELSE
         ALLOCATE(X8(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y8(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N9.GT.K0 .AND. (L9.GT.K0 .OR. M9.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X9(N9), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y9(N9), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(9) = .TRUE.
         SAVEIT(9) = SAVEAS
         CALL GKSD2S$(N9, X9D, X9)
         CALL GKSD2S$(N9, Y9D, Y9)
         CALL MAXMIN$(KTYPE, N9, X9, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N9, Y9, YMAX, YMIN)
         KTYPE = K1    
      ELSE
         ALLOCATE(X9(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y9(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN       
      ENDIF
      IF (N10.GT.K0 .AND. (L10.GT.K0 .OR. M10.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X10(N10), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y10(N10), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(10) = .TRUE.
         SAVEIT(10) = SAVEAS
         CALL GKSD2S$(N10, X10D, X10)
         CALL GKSD2S$(N10, Y10D, Y10)
         CALL MAXMIN$(KTYPE, N10, X10, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N10, Y10, YMAX, YMIN)
         KTYPE = K1      
      ELSE
         ALLOCATE(X10(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y10(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N11.GT.K0 .AND. (L11.GT.K0 .OR. M11.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X11(N11), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y11(N11), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT(11) = .TRUE.
         SAVEIT(11) = SAVEAS
         CALL GKSD2S$(N11, X11D, X11)
         CALL GKSD2S$(N11, Y11D, Y11)
         CALL MAXMIN$(KTYPE, N11, X11, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N11, Y11, YMAX, YMIN)
         KTYPE = K1  
      ELSE
         ALLOCATE(X11(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y11(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN       
      ENDIF
      IF (N12.GT.K0 .AND. (L12.GT.K0 .OR. M12.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X12(N12), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y12(N12), STAT = IERR)
         IF (IERR.NE.K0) RETURN    
         NPLOTS = NPLOTS + K1
         PLOT(12) = .TRUE.
         SAVEIT(12) = SAVEAS
         CALL GKSD2S$(N12, X12D, X12)
         CALL GKSD2S$(N12, Y12D, Y12)
         CALL MAXMIN$(KTYPE, N12, X12, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N12, Y12, YMAX, YMIN)
         KTYPE = K1     
      ELSE
         ALLOCATE(X12(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
         ALLOCATE(Y12(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (ICOUNT.EQ.K0) GOTO 80
C
C Find suitable ranges for X and Y axes
C
      CALL DOAXIS$(MXTIC, NLDGX,
     +             XMAX, XMIN) 
      CALL DOAXIS$(MYTIC, NLDGY,
     +             YMAX, YMIN)           
      CALL GKSTIC$(ISEND, MXTIC, MYTIC)
C
C Set default significance
C      
      NXSIG = K2
      NYSIG = K2
      CALL GKSSIG$(ISEND, NLDGX, NXSIG, NLDGY, NYSIG)           
C
C Initialise GKSDEC and set the arrays LN and MK etc.
C
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      KTIC = K3
      LN(1) = L1
      LN(2) = L2
      LN(3) = L3
      LN(4) = L4
      LN(5) = L5
      LN(6) = L6
      LN(7) = L7
      LN(8) = L8
      LN(9) = L9
      LN(10) = L10
      LN(11) = L11
      LN(12) = L12
      MK(1) = M1
      MK(2) = M2
      MK(3) = M3
      MK(4) = M4
      MK(5) = M5
      MK(6) = M6
      MK(7) = M7
      MK(8) = M8
      MK(9) = M9
      MK(10) = M10
      MK(11) = M11
      MK(12) = M12
C
C Check if symbols need adjusting
C      
      CALL MSYMBL$(MK(K1), N1)
      CALL MSYMBL$(MK(K2), N2)
      CALL MSYMBL$(MK(K3), N3)
      CALL MSYMBL$(MK(K4), N4)
      CALL MSYMBL$(MK(K5), N5)
      CALL MSYMBL$(MK(K6), N6)
      CALL MSYMBL$(MK(K7), N7)
      CALL MSYMBL$(MK(K8), N8)
      CALL MSYMBL$(MK(K9), N9)
      CALL MSYMBL$(MK(K10), N10)
      CALL MSYMBL$(MK(K11), N11)
      CALL MSYMBL$(MK(K12), N12)
      PTEXT = PTITLE
      XTEXT = XTITLE
      YTEXT = YTITLE
      CALL TRIMC1 (PTEXT)
      CALL TRIMC1 (XTEXT)
      CALL TRIMC1 (YTEXT)
C
C Initialise plot style parameters
C
      TEXTS = .FALSE.
      XTOINT = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.
      CALL GKSLGL$(JSEND, NLGL,
     +             LGLVAR)
      BOXIT = LGLVAR(1)      
      FRAME = LGLVAR(2)      
      OFFSET = LGLVAR(3)      
      XGRID = LGLVAR(4)      
      YGRID = LGLVAR(5)      
      XHAIRS = LGLVAR(6) 
      IF (LGLVAR(7)) THEN
         KTIC = K3
      ELSE
         KTIC = K1
      ENDIF           
C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Edit the plot
C                    
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY) 
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, KPLOTS, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
      LN1 = LN(1)
      LN2 = LN(2)
      LN3 = LN(3)
      LN4 = LN(4)
      LN5 = LN(5)
      LN6 = LN(6)
      LN7 = LN(7)
      LN8 = LN(8)
      LN9 = LN(9)
      LN10 = LN(10)
      LN11 = LN(11)
      LN12 = LN(12)
      MK1 = MK(1)
      MK2 = MK(2)
      MK3 = MK(3)
      MK4 = MK(4)
      MK5 = MK(5)
      MK6 = MK(6)
      MK7 = MK(7)
      MK8 = MK(8)
      MK9 = MK(9)
      MK10 = MK(10)
      MK11 = MK(11)
      MK12 = MK(12)
C
C Call GKSBOX to set up a GKS portrait frame
C
      IF (TEXTS) THEN
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTEXT, XTEXT, YTEXT,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ELSE
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTITLE, XTITLE, YTITLE,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ENDIF
      IF (ABORT) THEN
         DEALLOCATE(X1, STAT = IERR)
         DEALLOCATE(X2, STAT = IERR)
         DEALLOCATE(X3, STAT = IERR)
         DEALLOCATE(X4, STAT = IERR)
         DEALLOCATE(X5, STAT = IERR)
         DEALLOCATE(X6, STAT = IERR)
         DEALLOCATE(X7, STAT = IERR)
         DEALLOCATE(X8, STAT = IERR)
         DEALLOCATE(X9, STAT = IERR)
         DEALLOCATE(X10, STAT = IERR)
         DEALLOCATE(X11, STAT = IERR)
         DEALLOCATE(X12, STAT = IERR) 
         DEALLOCATE(Y1, STAT = IERR)
         DEALLOCATE(Y2, STAT = IERR)
         DEALLOCATE(Y3, STAT = IERR)
         DEALLOCATE(Y4, STAT = IERR)
         DEALLOCATE(Y5, STAT = IERR)
         DEALLOCATE(Y6, STAT = IERR)
         DEALLOCATE(Y7, STAT = IERR)
         DEALLOCATE(Y8, STAT = IERR)
         DEALLOCATE(Y9, STAT = IERR)
         DEALLOCATE(Y10, STAT = IERR)
         DEALLOCATE(Y11, STAT = IERR)
         DEALLOCATE(Y12, STAT = IERR)
         RETURN
      ENDIF   
C
C Set colours then call GKSMRK to draw lines
C
      LCTEMP = 15
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = K15
            DO KLOOP = K1, K12
               ICOL(KLOOP) = K0
            ENDDO
         ELSE
            LCTEMP = K0
            DO KLOOP = K1, K12
               ICOL(KLOOP) = K15
            ENDDO
         ENDIF
      ELSE
         CALL GKSCOL$(JSEND, JCOL, KCOL, NJCOL, NKCOL)
         LCTEMP = JCOL(5)
         DO KLOOP = K1, K12
            ICOL(KLOOP) = KCOL(KLOOP)
         ENDDO   
      ENDIF
      IF (PLOT(1)) THEN
         IF (MK1.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(1), K1, LN1, MK1, N1, A, B, C, D, FACTOR,
     +                ONE, X1, XMAX, XMIN, Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(2)) THEN
         IF (MK2.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(2), K1, LN2, MK2, N2, A, B, C, D, FACTOR,
     +                ONE, X2, XMAX, XMIN, Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(3)) THEN
         IF (MK3.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(3), K1, LN3, MK3, N3, A, B, C, D, FACTOR,
     +                ONE, X3, XMAX, XMIN, Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(4)) THEN
         IF (MK4.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(4), K1, LN4, MK4, N4, A, B, C, D, FACTOR,
     +                ONE, X4, XMAX, XMIN, Y4, YMAX, YMIN)
      ENDIF
      IF (PLOT(5)) THEN
         IF (MK5.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(5), K1, LN5, MK5, N5, A, B, C, D, FACTOR,
     +                ONE, X5, XMAX, XMIN, Y5, YMAX, YMIN)
      ENDIF
      IF (PLOT(6)) THEN
         IF (MK6.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(6), K1, LN6, MK6, N6, A, B, C, D, FACTOR,
     +                ONE, X6, XMAX, XMIN, Y6, YMAX, YMIN)
      ENDIF
      IF (PLOT(7)) THEN
         IF (MK7.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(7), K1, LN7, MK7, N7, A, B, C, D, FACTOR,
     +                ONE, X7, XMAX, XMIN, Y7, YMAX, YMIN)
      ENDIF
      IF (PLOT(8)) THEN
         IF (MK8.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(8), K1, LN8, MK8, N8, A, B, C, D, FACTOR,
     +                ONE, X8, XMAX, XMIN, Y8, YMAX, YMIN)
      ENDIF
      IF (PLOT(9)) THEN
         IF (MK9.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(9), K1, LN9, MK9, N9, A, B, C, D, FACTOR,
     +                ONE, X9, XMAX, XMIN, Y9, YMAX, YMIN)
      ENDIF
      IF (PLOT(10)) THEN
         IF (MK10.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(10), K1, LN10, MK10, N10, A, B, C, D, FACTOR,
     +                ONE, X10, XMAX, XMIN, Y10, YMAX, YMIN)
      ENDIF
      IF (PLOT(11)) THEN
         IF (MK11.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(11), K1, LN11, MK11, N11, A, B, C, D, FACTOR,
     +                ONE, X11, XMAX, XMIN, Y11, YMAX, YMIN)
      ENDIF
      IF (PLOT(12)) THEN
         IF (MK12.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(12), K1, LN12, MK12, N12, A, B, C, D, FACTOR,
     +                ONE, X12, XMAX, XMIN, Y12, YMAX, YMIN)
      ENDIF
C
C Call GKSHOL to draw symbols
C
      IF (PLOT(1)) THEN
         IF (MK1.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(1), K1, LCTEMP, MK1, N1, A, C, FACTOR,
     +                ONE, X1, XMAX, XMIN, Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(2)) THEN
         IF (MK2.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(2), K1, LCTEMP, MK2, N2, A, C, FACTOR,
     +                ONE, X2, XMAX, XMIN, Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(3)) THEN
         IF (MK3.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(3), K1, LCTEMP, MK3, N3, A, C, FACTOR,
     +                ONE, X3, XMAX, XMIN, Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(4)) THEN
         IF (MK4.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(4), K1, LCTEMP, MK4, N4, A, C, FACTOR,
     +                ONE, X4, XMAX, XMIN, Y4, YMAX, YMIN)
      ENDIF
      IF (PLOT(5)) THEN
         IF (MK5.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(5), K1, LCTEMP, MK5, N5, A, C, FACTOR,
     +                ONE, X5, XMAX, XMIN, Y5, YMAX, YMIN)
      ENDIF
      IF (PLOT(6)) THEN
         IF (MK6.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(6), K1, LCTEMP, MK6, N6, A, C, FACTOR,
     +                ONE, X6, XMAX, XMIN, Y6, YMAX, YMIN)
      ENDIF
      IF (PLOT(7)) THEN
         IF (MK7.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(7), K1, LCTEMP, MK7, N7, A, C, FACTOR,
     +                ONE, X7, XMAX, XMIN, Y7, YMAX, YMIN)
      ENDIF
      IF (PLOT(8)) THEN
         IF (MK8.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(8), K1, LCTEMP, MK8, N8, A, C, FACTOR,
     +                ONE, X8, XMAX, XMIN, Y8, YMAX, YMIN)
      ENDIF
      IF (PLOT(9)) THEN
         IF (MK9.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(9), K1, LCTEMP, MK9, N9, A, C, FACTOR,
     +                ONE, X9, XMAX, XMIN, Y9, YMAX, YMIN)
      ENDIF
      IF (PLOT(10)) THEN
         IF (MK10.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(10), K1, LCTEMP, MK10, N10, A, C, FACTOR,
     +                ONE, X10, XMAX, XMIN, Y10, YMAX, YMIN)
      ENDIF
      IF (PLOT(11)) THEN
         IF (MK11.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(11), K1, LCTEMP, MK11, N11, A, C, FACTOR,
     +                ONE, X11, XMAX, XMIN, Y11, YMAX, YMIN)
      ENDIF
      IF (PLOT(12)) THEN
         IF (MK12.EQ.1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(12), K1, LCTEMP, MK12, N12, A, C, FACTOR,
     +                ONE, X12, XMAX, XMIN, Y12, YMAX, YMIN)
      ENDIF
C
C LABEL 40: Call GKSDEC to decide the next course of action
C =========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      IF (ASCII) THEN
C
C Create ASCII files to import into program SIMPLOT
C
         IF (AXES .AND. .NOT.GSAVE) THEN
            CALL PUTWAR$(
     +'Only untransformed x,y data can be saved or exported to SIMPLOT')
            GOTO 40
         ENDIF
C
C LABEL 60: save ASCII text files
C ========
C
   60    CONTINUE
         KDEC = KPLOTS + 1
         TEXT(1) = 'Options for current data `'//
     +  'Data Status `Associated Line Type `Associated Symbol Type'
         KTEMP = 1
         DO KLOOP = 1, KPLOTS
            KTEMP = KTEMP + 1
            WRITE (FRMAT,'(I3,2X)') KLOOP
            IF (PLOT(KLOOP)) THEN
               CIPHER(KLOOP) = 'Plotted'
               TEXT(KTEMP) = FRMAT//SAVEIT(KLOOP)//GRAVE1//
     +                       CIPHER(KLOOP)//GRAVE1//
     +                       LINES(LN(KLOOP))//GRAVE1//SYMBOL(MK(KLOOP))
            ELSE
               CIPHER(KLOOP) = 'No data'
               TEXT(KTEMP) = FRMAT//GRAVE1//CIPHER(KLOOP)
            ENDIF
         ENDDO
         KTEMP = KTEMP + 1
         TEXT(KTEMP) = 'Advanced editing'
         KTEMP = KTEMP + 1
         TEXT(KTEMP) = 'Return to default graph'
         KTEMP = KTEMP + 1
         TEXT(KTEMP) = 'Cancel'
         KLOOP = KPLOTS + 3
         CALL LVIEW2 (KXM, KYM, KDEC, KLOOP, TEXT, TITLE1)
         IF (KDEC.EQ.1) THEN
            IF (PLOT(1)) THEN
               CALL NX2FIL$(N1, X1, Y1)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K1) = SAVEAS
               ELSE   
                  SAVEIT(K1) = SAVED
               ENDIF 
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.2) THEN
            IF (PLOT(2)) THEN
               CALL NX2FIL$(N2, X2, Y2)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K2) = SAVEAS
               ELSE   
                  SAVEIT(K2) = SAVED
               ENDIF 
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.3) THEN
            IF (PLOT(3)) THEN
               CALL NX2FIL$(N3, X3, Y3)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K3) = SAVEAS
               ELSE   
                  SAVEIT(K3) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.4) THEN
            IF (PLOT(4)) THEN
               CALL NX2FIL$(N4, X4, Y4)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K4) = SAVEAS
               ELSE   
                  SAVEIT(K4) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.5) THEN
            IF (PLOT(5)) THEN
               CALL NX2FIL$(N5, X5, Y5)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K5) = SAVEAS
               ELSE   
                  SAVEIT(K5) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.6) THEN
            IF (PLOT(6)) THEN
               CALL NX2FIL$(N6, X6, Y6)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K6) = SAVEAS
               ELSE   
                  SAVEIT(K6) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.7) THEN
            IF (PLOT(7)) THEN
               CALL NX2FIL$(N7, X7, Y7)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K7) = SAVEAS
               ELSE   
                  SAVEIT(K7) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.8) THEN
            IF (PLOT(8)) THEN
               CALL NX2FIL$(N8, X8, Y8)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K8) = SAVEAS
               ELSE   
                  SAVEIT(K8) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.9) THEN
            IF (PLOT(9)) THEN
               CALL NX2FIL$(N9, X9, Y9)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K9) = SAVEAS
               ELSE   
                  SAVEIT(K9) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.10) THEN
            IF (PLOT(10)) THEN
               CALL NX2FIL$(N10, X10, Y10)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K10) = SAVEAS
               ELSE   
                  SAVEIT(K10) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.11) THEN
            IF (PLOT(11)) THEN
               CALL NX2FIL$(N11, X11, Y11)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K11) = SAVEAS
               ELSE   
                  SAVEIT(K11) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.12) THEN
            IF (PLOT(12)) THEN
               CALL NX2FIL$(N12, X12, Y12)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  SAVEIT(K12) = SAVEAS
               ELSE   
                  SAVEIT(K12) = SAVED
               ENDIF
            ELSE
               CALL PUTFAT$(ABSENT)
            ENDIF
         ELSEIF (KDEC.EQ.13) THEN
            NFILES = 0
            DO I = 1, KPLOTS
               IF (PLOT(I)) THEN
                  NFILES = NFILES + 1
                  JFILES(NFILES) = ICOL(I)
                  LFILES(NFILES) = LN(I)
                  MFILES(NFILES) = MK(I)
                  CALL GETTMP (IFAIL, FILES(NFILES))
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FILES(NFILES))
                  WRITE (NOUT,'(A)') 'Temporary file' 
                  CALL I2FILE (NOUT, NUMBER(I), K2)
                  DO J = 1, NUMBER(I)
                     IF (I.EQ.1) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X1(J), Y1(J)
                     ELSEIF (I.EQ.2) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X2(J), Y2(J)
                     ELSEIF (I.EQ.3) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X3(J), Y3(J)
                     ELSEIF (I.EQ.4) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X4(J), Y4(J)
                     ELSEIF (I.EQ.5) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X5(J), Y5(J)
                     ELSEIF (I.EQ.6) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X6(J), Y6(J)
                     ELSEIF (I.EQ.7) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X7(J), Y7(J)
                     ELSEIF (I.EQ.8) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X8(J), Y8(J)
                     ELSEIF (I.EQ.9) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X9(J), Y9(J)
                     ELSEIF (I.EQ.10) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X10(J), Y10(J)
                     ELSEIF (I.EQ.11) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X11(J), Y11(J)
                     ELSEIF (I.EQ.12) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X12(J), Y12(J)
                     ENDIF
                  ENDDO 
                  CALL I1FILE (NOUT, K1)
                  WRITE (NOUT,'(A)') 'Temporary file'
                  CLOSE (UNIT = NOUT)
               ENDIF
            ENDDO
            CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES, FILES,
     +                   TITLES)
            DO I = 1, NFILES
               CALL DELEET (FILES(I), ASKIF, THERE)
            ENDDO
         ELSEIF (KDEC.EQ.14) THEN
            GOTO 40
         ELSE
            RETURN
         ENDIF
         GOTO 60
      ENDIF
      IF (.NOT.ABORT) GOTO 20    
   80 CONTINUE      
      DEALLOCATE(X1, STAT = IERR)
      DEALLOCATE(X2, STAT = IERR)
      DEALLOCATE(X3, STAT = IERR)
      DEALLOCATE(X4, STAT = IERR)
      DEALLOCATE(X5, STAT = IERR)
      DEALLOCATE(X6, STAT = IERR)
      DEALLOCATE(X7, STAT = IERR)
      DEALLOCATE(X8, STAT = IERR)
      DEALLOCATE(X9, STAT = IERR)
      DEALLOCATE(X10, STAT = IERR)
      DEALLOCATE(X11, STAT = IERR)
      DEALLOCATE(X12, STAT = IERR) 
      DEALLOCATE(Y1, STAT = IERR)
      DEALLOCATE(Y2, STAT = IERR)
      DEALLOCATE(Y3, STAT = IERR)
      DEALLOCATE(Y4, STAT = IERR)
      DEALLOCATE(Y5, STAT = IERR)
      DEALLOCATE(Y6, STAT = IERR)
      DEALLOCATE(Y7, STAT = IERR)
      DEALLOCATE(Y8, STAT = IERR)
      DEALLOCATE(Y9, STAT = IERR)
      DEALLOCATE(Y10, STAT = IERR)
      DEALLOCATE(Y11, STAT = IERR)
      DEALLOCATE(Y12, STAT = IERR)
      END
C
C
