C
C
      SUBROUTINE GKSA2I$(IX, IY, N,
     +                   X, Y)
C
C ACTION : Transform real number pairs into integer pairs for plotting
C          Required for FTN77 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/12/93
C          23/02/1997 double precision to integer
C          13/04/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N 
      INTEGER,          INTENT (OUT) :: IX(N), IY(N)
      DOUBLE PRECISION, INTENT (IN)  :: X(N), Y(N)
C
C Locals
C      
      INTEGER    I
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    IXTEMP, IYTEMP
      DOUBLE PRECISION XTEMP, YTEMP
      EXTERNAL   GKSR2I$ 
      IF (N.LT.N1) RETURN
      DO I = N1, N
         XTEMP = X(I)
         YTEMP = Y(I)
         CALL GKSR2I$(IXTEMP, IYTEMP, 
     +                XTEMP, YTEMP)
         IX(I) = IXTEMP
         IY(I) = IYTEMP
      ENDDO
      END
C
C------------------------------------------------------------------------------
C
      SUBROUTINE GKSA2D$(N,
     +                   DX, DY, X, Y)
C
C ACTION : Transform real number pairs into double precision  pairs for plotting
C          Required for FTN77 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/12/93
C          23/02/1997 double precision to integer
C          13/04/2007 added INTENTS
C          23/11/2013 derived from GKSASI$
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N 
      DOUBLE PRECISION, INTENT (OUT) :: DX(N), DY(N)
      DOUBLE PRECISION, INTENT (IN)  :: X(N), Y(N)
C
C Locals
C      
      INTEGER    I
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION DXTEMP, DYTEMP, XTEMP, YTEMP
      EXTERNAL   GKSR2D$ 
      IF (N.LT.N1) RETURN
      DO I = N1, N
         XTEMP = X(I)
         YTEMP = Y(I)
         CALL GKSR2D$(DXTEMP, DYTEMP, 
     +                XTEMP, YTEMP)
         DX(I) = DXTEMP
         DY(I) = DYTEMP
      ENDDO
      END
C
C