C
C
      SUBROUTINE GKSBAR$(J, K, MTRANS, N,
     +                   A, B, C, D, SIZE, WIDE, X, XH, XL, XMAX, XMIN,
     +                   Y, YH, YL, YMAX, YMIN,
     +                   BARCAP, LOWER, UPPER)
C
C ACTION : Produce error bars using GKS
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.25/6/91
C          07/10/1992 Added code to clip error bars
C          11/10/1992 Two sections for individual error bars
C                     Added K and Y to argument list
C                     Replaced call to LINE by call to GKSPIC
C          12/10/1992 Removed mono
C          09/11/1992 Derived from GKSERB
C          04/12/1992 ADJUST must agree with ADJUST in GKSWGB
C          05/05/1993 Replaced GKSPIC by GKSDRW
C          23/02/1997 Now all integer and double precision
C          22/07/1999 Checked for horizontal/vertical end caps
C          13/04/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: J, K, MTRANS, N 
      DOUBLE PRECISION, INTENT (IN) :: A, B, C, D, SIZE, WIDE,
     +                                 X(N), XH(N), XL(N), XMAX, XMIN,
     +                                 Y(N), YH(N), YL(N), YMAX, YMIN
      LOGICAL,          INTENT (IN) :: BARCAP, LOWER, UPPER
C
C Locals
C      
      INTEGER    L, N0, N1, N2
      PARAMETER (L = 1, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I
      DOUBLE PRECISION ADJUST, FRACN, PNT001, ZERO, ONE, TWO, FOUR
      PARAMETER (ADJUST = 0.012D+00, FRACN = 0.01D+00,
     +           PNT001 = 0.001D+00, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION AA, BB, CC, DD, XNEW, YNEW
      DOUBLE PRECISION ADELTA, DELTAX, DELTAY, XDELTA, YDELTA
      DOUBLE PRECISION BIGRAD, BIGX1, BIGX2, BIGY1, BIGY2
      DOUBLE PRECISION CONST, FACTOR, SLOPE, XDIFF, YDIFF
      DOUBLE PRECISION RADIUS, HEIGHT, XYDIST
      DOUBLE PRECISION X_SVG, Y_SVG
      DOUBLE PRECISION X2(N2), Y2(N2)
      LOGICAL    ACTIVE_SVG
      EXTERNAL   GKSDRW$, SVGPAR
      INTRINSIC  ABS, SQRT 
      IF (N.LT.N1) RETURN
C
C
      XDELTA = XMAX - XMIN
      YDELTA = YMAX - YMIN
      DELTAX = FRACN*XDELTA
      DELTAY = FRACN*YDELTA
      ADELTA = A*DELTAX
      RADIUS = ADJUST*SIZE*XDELTA
      HEIGHT = RADIUS*A/C
      CALL SVGPAR (N0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG) 
      IF (ACTIVE_SVG) THEN
         ADELTA = ADELTA/X_SVG
         DELTAX = DELTAX/X_SVG
         HEIGHT = HEIGHT/X_SVG
         RADIUS = RADIUS/X_SVG
      ENDIF   
      BIGRAD = A*RADIUS
      DO I = N1, N
C
C First check if centre point (X, Y) is in range
C
         IF (X(I).GE.XMIN .AND. X(I).LE.XMAX .AND.
     +       Y(I).GE.YMIN .AND. Y(I).LE.YMAX) THEN
C
C Now check if upper point (XH, YH) is in range
C
            IF (UPPER) THEN
               BIGX1 = A*X(I) + B
               BIGX2 = A*XH(I) + B
               BIGY1 = C*Y(I) + D
               BIGY2 = C*YH(I) + D
               XDIFF = ABS(X(I) - XH(I))/XDELTA
               YDIFF = ABS(Y(I) - YH(I))/YDELTA
               XYDIST = SQRT((BIGX1 - BIGX2)**2 + (BIGY1 - BIGY2)**2)
               IF (XH(I).GE.XMIN .AND. XH(I).LE.XMAX .AND.
     +             YH(I).GE.YMIN .AND. YH(I).LE.YMAX .AND.
     +             XYDIST.GT.BIGRAD) THEN
C
C If so draw error bar cap orthogonal to error bar
C
                  IF (BARCAP) THEN
                     IF (XDIFF.GT.PNT001 .AND. YDIFF.GT.PNT001) THEN
C
C Sloping error bar
C
                        SLOPE = (BIGY2 - BIGY1)/(BIGX2 - BIGX1)
                        CONST = BIGY1 - SLOPE*BIGX1
                        FACTOR = ADELTA*SQRT(SLOPE**2/(ONE + SLOPE**2))
                        X2(1) = (BIGX2 + FACTOR - B)/A
                        X2(2) = (BIGX2 - FACTOR - B)/A
                        FACTOR = FACTOR/SLOPE
                        Y2(1) = (BIGY2 - FACTOR - D)/C
                        Y2(2) = (BIGY2 + FACTOR - D)/C
                     ELSEIF (XDIFF.LE.PNT001) THEN
C
C Vertical error bar (horizontal cap)
C
                        X2(1) = XH(I) - DELTAX
                        X2(2) = XH(I) + DELTAX
                        Y2(1) = YH(I)
                        Y2(2) = YH(I)
                     ELSEIF (YDIFF.LE.PNT001) THEN
C
C Horizontal error bar (vertical cap)
C
                        X2(1) = XH(I)
                        X2(2) = XH(I)
                        Y2(1) = YH(I) - DELTAY
                        Y2(2) = YH(I) + DELTAY
                     ENDIF
                     CALL GKSDRW$(J, K, L, N2, WIDE, X2, Y2)
                  ENDIF
C
C Then draw the upper error bar
C
                  IF (XDIFF.GT.PNT001) THEN
                     SLOPE = (BIGY2 - BIGY1)/(BIGX2 - BIGX1)
                     CONST = BIGY1 - SLOPE*BIGX1
                     AA = ONE + SLOPE**2
                     BB = - TWO*(BIGX1 - CONST*SLOPE + BIGY1*SLOPE)
                     CC = BIGX1**2 + (BIGY1 - CONST)**2 - BIGRAD**2
                     DD = BB**2 - FOUR*AA*CC
                     IF (DD.GT.1.0D-38) THEN
                        DD = SQRT(DD)
                     ELSE
                        DD = ZERO
                     ENDIF
                     XNEW = (- BB + DD)/(TWO*AA)
                     YNEW = SLOPE*XNEW + CONST
                     X2(1) = (XNEW - B)/A
                     Y2(1) = (YNEW - D)/C
                  ELSE
                     X2(1) = X(I)
                     IF (MTRANS.EQ.2 .OR. MTRANS.EQ.4) THEN
                        Y2(1) = Y(I) - HEIGHT
                     ELSE
                        Y2(1) = Y(I) + HEIGHT
                     ENDIF
                  ENDIF
                  X2(2) = XH(I)
                  Y2(2) = YH(I)
                  CALL GKSDRW$(J, K, L, N2, WIDE, X2, Y2)
               ENDIF
            ENDIF
C
C Now check if lower point (XL, YL) is in range
C
            IF (LOWER) THEN
               BIGX1 = A*X(I) + B
               BIGX2 = A*XL(I) + B
               BIGY1 = C*Y(I) + D
               BIGY2 = C*YL(I) + D
               XDIFF = ABS(X(I) - XL(I))/XDELTA
               YDIFF = ABS(Y(I) - YL(I))/YDELTA
               XYDIST = SQRT((BIGX1 - BIGX2)**2 + (BIGY1 - BIGY2)**2)
               IF (XL(I).GE.XMIN .AND. XL(I).LE.XMAX .AND.
     +             YL(I).GE.YMIN .AND. YL(I).LE.YMAX .AND.
     +             XYDIST.GT.BIGRAD) THEN
C
C If so draw error bar cap orthogonal to error bar
C
                  IF (BARCAP) THEN
                     IF (XDIFF.GT.PNT001 .AND. YDIFF.GT.PNT001) THEN
C
C Sloping error bar
C
                        SLOPE = (BIGY2 - BIGY1)/(BIGX2 - BIGX1)
                        CONST = BIGY1 - SLOPE*BIGX1
                        FACTOR = ADELTA*SQRT(SLOPE**2/(ONE + SLOPE**2))
                        X2(1) = (BIGX2 + FACTOR - B)/A
                        X2(2) = (BIGX2 - FACTOR - B)/A
                        FACTOR = FACTOR/SLOPE
                        Y2(1) = (BIGY2 - FACTOR - D)/C
                        Y2(2) = (BIGY2 + FACTOR - D)/C
                     ELSEIF (XDIFF.LE.PNT001) THEN
C
C Vertical error bar (horizontal cap)
C
                        X2(1) = XL(I) - DELTAX
                        X2(2) = XL(I) + DELTAX
                        Y2(1) = YL(I)
                        Y2(2) = YL(I)
                     ELSEIF (YDIFF.LE.PNT001) THEN
C
C Horizontal error bar (vertical cap)
C
                        X2(1) = XL(I)
                        X2(2) = XL(I)
                        Y2(1) = YL(I) - DELTAY
                        Y2(2) = YL(I) + DELTAY
                     ENDIF
                     CALL GKSDRW$(J, K, L, N2, WIDE, X2, Y2)
                  ENDIF
C
C Then draw lower error bar
C
                  IF (XDIFF.GT.PNT001) THEN
                     SLOPE = (BIGY2 - BIGY1)/(BIGX2 - BIGX1)
                     CONST = BIGY1 - SLOPE*BIGX1
                     AA = ONE + SLOPE**2
                     BB = - TWO*(BIGX1 - CONST*SLOPE + BIGY1*SLOPE)
                     CC = BIGX1**2 + (BIGY1 - CONST)**2 - BIGRAD**2
                     DD = BB**2 - FOUR*AA*CC
                     IF (DD.GT.1.0D-38) THEN
                        DD = SQRT(DD)
                     ELSE
                        DD = ZERO
                     ENDIF
                     XNEW = (- BB - DD)/(TWO*AA)
                     YNEW = SLOPE*XNEW + CONST
                     X2(1) = (XNEW - B)/A
                     Y2(1) = (YNEW - D)/C
                  ELSE
                     X2(1) = X(I)
                     IF (MTRANS.EQ.2 .OR. MTRANS.EQ.4) THEN
                        Y2(1) = Y(I) + HEIGHT
                     ELSE
                        Y2(1) = Y(I) - HEIGHT
                     ENDIF
                  ENDIF
                  X2(2) = XL(I)
                  Y2(2) = YL(I)
                  CALL GKSDRW$(J, K, L, N2, WIDE, X2, Y2)
               ENDIF
            ENDIF
         ENDIF
      ENDDO
      END
C
C                        
