C
C GKSBOX$
C =======
C
C Calls INIT$ to initialise plotting. 
C
C This is the main routine to set up a plotting frame for the simple
C graphics routines gks004, gks012, gkseb4, etc. This version can call
C Hershey fonts and for this the Salford routine SET_TEXT_ATTRIBUTE
C requires REAl*4 variables. If Hershey fonts are not required then
C these can be suppressed, as well as all the HPGL stuff.
C It can also call Truetype fonts if required, if TRUE_TYPE = .TRUE.
C However, with the PS flag set it will only generate PostScript.
C Note that this routine has gone through very very many revisions
C for different platforms and is grossly overspecified due to the
C dozens of changes in positional and size information. Sorry.
C
      SUBROUTINE GKSBOX$(KTIC, MKID, MTYPE, MXTIC, MYTIC,
     +                   NCFONT, NTFONT, NXFONT, NYFONT,
     +                   A, B, C, D,
     +                   SPC, SPT, SPX, SPY, XMAX, XMIN,
     +                   XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                   PTITLE, XTITLE, YTITLE,
     +                   ABORT, BOXIT, FRAME, MONO, OFFSET,
     +                   VIDEO, XGRID, XHAIRS, XTOINT, YGRID,
     +                   YTOINT, YVERT)
C
C ACTION : Set up 4 by 3 PC portrait frame with legends etc. for a GKS plot
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 17/01/1992
C          Version for FTN77 GKS look alike
C          28/10/1994 Scaled fonts by X_SCALE and Y_SCALE
C          10/08/1995 Added EXPSET to offset for exponents
C          17/01/1996 Made call to BLOCK$ permanent for PS overlays
C          23/02/1997 Win32 version ... NMAX set to 300
C          01/12/1997 NMAX set to 301 and treatment of exponent label improved
C          25/10/1998 Added SILENT to stop ftn95 complaining about arguments that
C                     are not used in this version but which may be needed again
C          23/09/1999 SAVE GTYPE to stop GTYPE becoming undefined
C                     This must!!! be a compiler error
C          26/12/1999 REMOVED silent but added code to use the extra arguments
C          27/12/1999 also saved TYPE5, TYPE6, TYPE7 and LABELS
C          08/01/2000 added global SAVE
C          22/02/2000 added WGBCFG$ and GSLWSC$
C          28/02/2000 used WGBINI$ to re-set font size to 1 until I can get
C                     round to introducing PLTSTR$ for text plotting. The next
C                     changes made the line thickness in stroke fonts independent
C                     of the line width used for plotting.
C            WGBINI$(3) makes size = 1 (for Hershey)
C            WGBINI$(4) restores size  (for Hershey)
C          28/02/2000 added WGBINI$ to make sure font size = 1
C          20/11/2000 added TRUE_TYPE, WGBFNT$, PLTSTR$, PLNUMB$
C          20/11/2000 introduced TRUE_TYPE to force use of TrueType fonts and
C                     also introduced WGBFNT$, PLTSTR$ and PLNUMB$ and TTYPE
C                     to scale the TrueType size. When TRUE_TYPE = .TRUE. then
C                     all the Hershey code is bypassed.
C          06/12/2000 replaced INTEGER*2 by INTEGER 
C          07/12/2000 removed all INTEGER*2 and REAL*4 and diverted all the
C                     calls to SET_TEXT_ATTRIBUTE$ 
C          25/10/2004 added XHAIRS to plot cross hairs intersecting at (0,0) 
C          20/05/2007 added INTENTS
C          14/06/2007 removed defngks.ins and introduced GETDEF$
C          23/07/2009 added new variables and call to GKSSIG$
C          04/08/2009 added call to GKSCOL$ 
C          26/08/2009 revised scheme for label formats but retained GTYPE for future use  
C          21/10/2009 added labelling improvements sugested by Samad 
C          22/08/2014 added calls to SET_END_CAP and PSLCAP$
C          24/06/2016 added calls to XFRMAT$
C
C
C ADVICE : MKID = WORKSTATION, MTYPE = TYPE
C          KTIC = 1: tick marks point out; = 2: none; = 3: point in
C          M?TIC = no. tic marks on X and Y axes
C          N?FONT = C(haracter), T(itle), X(legend), Y(legend) font nos.
C          A, B, C, D required for error bar caps in Scatchard plot
C          SP? = C, T, X, Y character   spacing factors called by GSCHSP
C          XP? = C, T, X, Y character expansion factors called by GSCHXP
C          NMAX = max. powers of 10 accepted... this sets EPSI
C          YTOX = ratio Y/X of physical lengths of the display
C          EPSI = min. size difference to allow fixed X or fixed Y plots
C          ?HEIGHT = C, E(xponent), T, X, Y character heights
C          TFAC = axes thickness factor
C
C     Factors to correct numbers and text positions for FTN77 GKS look alike
C
C     NPCHAR, NXCHAR, NYCHAR ... No. of characters across PC screen
C     XADD1, YADD1 ... Y-axis numbers
C     XADD2, YADD2 ... Y-axis exponent
C     XADD3, YADD3 ... Y-axis x10
C     XADD4, YADD4 ... X-axis numbers
C     XADD5, YADD5 ... X-axis exponent
C     XADD6, YADD6 ... X-axis x10
C     XMOVE        ... move Y title back a bit
C
C     Factors for HPGL output
C     NHPGL ... Font
C     XHPGL ... Scaling for font size
C     XADD7 ... Add extra to x coordinate for text etc. if in HPGL mode
C     YADD7 ... Add extra to y coordinate for text etc. if in HPGL mode
C
C     Factors for PS output
C     PSADDY ... Move left for exponent show on Y axis
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: KTIC, MKID, MTYPE, MXTIC,
     +                                       MYTIC
      INTEGER,             INTENT (IN)    :: NCFONT, NTFONT, NXFONT,
     +                                       NYFONT 
      DOUBLE PRECISION,    INTENT (INOUT) :: A, B, C, D, XMAX, XMIN,
     +                                       YMAX, YMIN   
      DOUBLE PRECISION,    INTENT (IN)    :: SPC, SPT, SPX, SPY
      DOUBLE PRECISION,    INTENT (IN)    :: XPC, XPT, XPX, XPY
      CHARACTER (LEN = *), INTENT (IN)    :: PTITLE, XTITLE, YTITLE 
      LOGICAL,             INTENT (IN)    :: BOXIT, FRAME, MONO, OFFSET
      LOGICAL,             INTENT (IN)    :: VIDEO, XGRID, XHAIRS,
     +                                       XTOINT, YGRID, YTOINT,
     +                                       YVERT
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Parameter for PS output
C
      DOUBLE PRECISION PSADDY
      PARAMETER (PSADDY = - 0.08D+00)
C
C Parameter for TrueType font size
C
      DOUBLE PRECISION TTYPE
      PARAMETER (TTYPE = 0.833333D+00)
C
C Parameters for HPGL hardcopy
C
      INTEGER    NHPGL
      PARAMETER (NHPGL = 1)
      DOUBLE PRECISION XHPGL
      PARAMETER (XHPGL = 0.625D+00)
      DOUBLE PRECISION XSHIFT, YSHIFT
C
C Parameters for screen characters
C
      INTEGER    ITEMP
      INTEGER    K0, K4
      PARAMETER (K0 = 0, K4 = 4)
      INTEGER    NPCHAR, NXCHAR, NYCHAR
      PARAMETER (NPCHAR = 45, NXCHAR = 50, NYCHAR = 40)
      INTEGER    FONT
      DOUBLE PRECISION SIZE4, ITALIC, ROTATION
      DOUBLE PRECISION XADD0, YADD0
      PARAMETER (XADD0 = 0.0D+00, YADD0 = 0.0D+00)
      DOUBLE PRECISION XADD1, YADD1
      PARAMETER (XADD1 = - 0.115D+00, YADD1 = - 0.010D+00)
      DOUBLE PRECISION XADD2, YADD2
      PARAMETER (XADD2 = - 0.045D+00, YADD2 = 0.005D+00)
      DOUBLE PRECISION XADD3, YADD3
      PARAMETER (XADD3 = - 0.090D+00, YADD3 = 0.000D+00)
      DOUBLE PRECISION XADD4, YADD4
      PARAMETER (XADD4 = - 0.046D+00, YADD4 = 0.005D+00)
      DOUBLE PRECISION XADD5, YADD5
      PARAMETER (XADD5 = - 0.000D+00, YADD5 = 0.005D+00)
      DOUBLE PRECISION XADD6, YADD6
      PARAMETER (XADD6 = - 0.042D+00, YADD6 = 0.000D+00)
      DOUBLE PRECISION XMOVE
      PARAMETER (XMOVE = 0.8D+00)
      DOUBLE PRECISION XADD7, YADD7
      PARAMETER (XADD7 = 0.03D+00, YADD7 = - 0.02D+00)
C
C Integer parameters and scalars
C                      
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      INTEGER    IFIGX, IFIGY, ISIGX, ISIGY
      INTEGER    ISIG, NKCOL, NJCOL
      PARAMETER (ISIG = 3, NJCOL = 5, NKCOL = 1)
      INTEGER    NMAX
      PARAMETER (NMAX = 301)
      INTEGER    N0, N1, N2, N3, N4, N9, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N9 = 9,
     +           N10 = 10)
      INTEGER    I, ICOLOR, ISEND, NFONT, NX, NY, XMAG, YMAG
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
C
C Parameters to scale axes line thickness and fonts
C
      DOUBLE PRECISION FACTOR
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = 3.0D+00/4.0D+00)
      DOUBLE PRECISION CHEIGHT, EHEIGHT, THEIGHT, XHEIGHT, YHEIGHT
      PARAMETER (CHEIGHT = 0.035D+00, EHEIGHT = 0.75D+00*CHEIGHT,
     +           THEIGHT = 0.045D+00, XHEIGHT = 0.04D+00,
     +           YHEIGHT = YTOX*XHEIGHT)
C
C Parameters to set up the default axes
C
      DOUBLE PRECISION XEND, XSTART
      DOUBLE PRECISION XEND1, XSTRT1
C
C Moved right on 22/02/2000
C*****PARAMETER (XEND1 = 0.94D+00, XSTRT1 = 0.18D+00)
C Moved back left on 28/08/2009
C      PARAMETER (XEND1 = 0.96D+00, XSTRT1 = 0.20D+00)
      PARAMETER (XEND1 = 0.94D+00, XSTRT1 = 0.18D+00)
      DOUBLE PRECISION YEND, YSTART
      DOUBLE PRECISION YEND1, YSTRT1
      PARAMETER (YEND1 = 0.87D+00, YSTRT1 = 0.23D+00)
      DOUBLE PRECISION XTIC, YTIC
      PARAMETER (XTIC = 0.01D+00, YTIC = YTOX*XTIC)
      DOUBLE PRECISION ZERO, ONE, TWO, FOUR, FIVE, TEN, NINETY
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00, TEN = 10.0D+00,
     +           NINETY = 90.0D+00)
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = ONE/(TEN**NMAX))
      DOUBLE PRECISION PNT02, PNT05, PNT5
      PARAMETER (PNT02 = 0.02D+00, PNT05 = 0.05D+00, PNT5 = 0.5D+00)
C
C Temporary real variables
C                                      
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      DOUBLE PRECISION XFRAME(4), YFRAME(4)
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION XA, XB, XC, XDIFF, XBEGIN, XTEMP, XMAX1, XMIN1,
     +                 XVAL
      DOUBLE PRECISION YA, YB, YC, YDIFF, YBEGIN, YTEMP, YMAX1, YMIN1,
     +                 YVAL
      DOUBLE PRECISION ANGLE, DELTA, EXTRA1, EXTRA2, EXTRA3, EXTRA4,
     +                 SLANT
      DOUBLE PRECISION XBOX1, XBOX2, YBOX1, YBOX2
      DOUBLE PRECISION SIZE1, SIZE2, WGBCFG$
      DOUBLE PRECISION DI, DMXTIC, DMYTIC
C
C Temporary character variables
C
      CHARACTER  BLANK*1, TIME10*5
      PARAMETER (BLANK = ' ', TIME10 = 'x10  ')
      CHARACTER  EXPONT*4, FRMAT*20, LABEL4*4, WORD1*1
      CHARACTER  TLABEL*10
      CHARACTER  SYMBOL*60
C
C Local logicals
C
      LOGICAL    GTYPE(10)
      LOGICAL    TRUE_TYPE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS 
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      
C
C Externals  and intrinsics
C
      EXTERNAL  TRIML1
      EXTERNAL  INIT$, GSLN$, GSWN$, GSVP$, GSELNT$, BLOCK$, TEXT$,
     +          SOLID_LINE$, DASHED_LINE$, PSTEXT$, PSPOLY$, WGBCFG$
      EXTERNAL  PUTFAT$
      EXTERNAL  PSNUMB$, GSLWSC$, WGBINI$, WGBFNT$, PLTSTR$, PLNUMB$ 
      EXTERNAL  GETDEF$, GKSSIG$, GKSCOL$
      EXTERNAL  SET_TEXT_ATTRIBUTE$
      EXTERNAL  SET_END_CAP, PSLCAP$
      EXTERNAL  XFRMAT$
      INTRINSIC ABS, LEN, MAX, NINT, DBLE, MIN
C
C Check if default colour scheme is in operation
C  
      IF (.NOT.MONO) THEN
         ISEND = 3
         CALL GKSCOL$(ISEND, JCOL, KCOL, NJCOL, NKCOL)
      ENDIF   
      
C
C Next code to silence ftn95 ... variables not used in this version
C Note that setting TRUE_TYPE = .TRUE. replaces all Hershey code by
C TrueType code. This could be done interactively.
C
      IF (YVERT) THEN!code to stop ftn95 complaining and define TRUE_TYPE
         XTEMP = SPC
         YTEMP = SPT
         ITEMP = MTYPE
         TRUE_TYPE = .TRUE.
      ELSE
         XTEMP = SPX
         YTEMP = SPY
         ITEMP = MKID
         TRUE_TYPE = .TRUE.
      ENDIF
C
C Check if plot is possible ............................................
C
      ABORT = .TRUE. 
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS) 
      IF (HPGL) THEN
         XSHIFT = XADD7
         YSHIFT = YADD7
      ELSE
         XSHIFT = XADD0
         YSHIFT = YADD0
      ENDIF
C
C Find magnitude of numbers on X-Axis. Return if too small or large.
C Store the result in XMAG
C
      XTEMP = MAX(ABS(XMAX), ABS(XMIN))
      YTEMP = LOG10(XTEMP)
      XMAG = INT(YTEMP)
      YTEMP = XTEMP/TEN**XMAG
C
C Make sure numbers will be of the form (1.234...)*10**XMAG
C
      IF (YTEMP.LT.ONE) THEN
         XMAG = XMAG - N1
      ELSEIF (YTEMP.GT.TEN) THEN
         XMAG = XMAG + N1
      ENDIF   
      IF (XMAG.GT.NMAX .OR. XMAG.LT.-NMAX) GOTO 20
C
C Find magnitude of numbers on Y-Axis. Return if too small or large.
C Store the result in YMAG
C
      XTEMP = MAX(ABS(YMAX), ABS(YMIN))
      YTEMP = LOG10(XTEMP)
      YMAG = INT(YTEMP)
      YTEMP = XTEMP/TEN**YMAG
C
C Make sure numbers will be of the form (1.234...)*10**XMAG
C
      IF (YTEMP.LT.ONE) THEN
         YMAG = YMAG - N1
      ELSEIF (YTEMP.GT.TEN) THEN
         YMAG = YMAG + N1
      ENDIF   
      IF (YMAG.GT.NMAX .OR. YMAG.LT.-NMAX) GOTO 20
C
C Data seems to be OK so set up a plotting frame
C      
      XSTART = XSTRT1 
      XEND = XEND1 
      YSTART = YSTRT1
      YEND = YEND1
C
C Adjust if extra space is needed for exponent in X-axis title
C
      EXTRA1 = EHEIGHT + EHEIGHT/TEN
      EXTRA2 = EHEIGHT - EHEIGHT/FIVE
      IF (XMAG.GE. - N2 .AND. XMAG.LE.N3) THEN
         YSTART = YSTART - EXTRA1 - EXTRA2
         EXTRA1 = ZERO
         EXTRA2 = ZERO
      ENDIF
C
C Adjust if extra space is needed for exponent in Y-axis title
C
      EXTRA3 = EHEIGHT + EHEIGHT/TEN
      EXTRA4 = EHEIGHT - EHEIGHT/FIVE
C
C Expand plotting space if tick marks do not point outwards
C
      IF (KTIC.GT.1) THEN
         XSTART = XSTART - YTIC
         XEND = XEND + YTIC
         YSTART = YSTART - XTIC
         YEND = YEND + XTIC
      ENDIF
C
C Check that XMAX, XMIN, YMAX, YMIN are satisfactory then
C define XMAX1 etc. to expand the limits and free the origin
C EPSI is required to allow clustering of values at fixed X or Y
C
      IF (XMIN.GT.XMAX) THEN
         XTEMP = XMIN
         XMIN = XMAX
         XMAX = XTEMP
      ENDIF
      IF (YMIN.GT.YMAX) THEN
         YTEMP = YMIN
         YMIN = YMAX
         YMAX = YTEMP
      ENDIF
      IF ((XMAX - XMIN).LE.EPSI) THEN
         XMAX = XMAX + PNT02*ABS(XMAX) + EPSI
         XMIN = XMIN - PNT02*ABS(XMIN) - EPSI
      ENDIF
      IF ((YMAX - YMIN).LE.EPSI) THEN
         YMAX = YMAX + PNT02*ABS(YMAX) + EPSI
         YMIN = YMIN - PNT02*ABS(YMIN) - EPSI
      ENDIF
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
C
C Calculate XA, XB, XC etc. to define plotting space
C
      IF (OFFSET) THEN
         XMAX1 = XMAX + PNT05*XDIFF
         XMIN1 = XMIN - PNT05*XDIFF
         XTEMP = (XEND - XSTART)/(XMAX1 - XMIN1)
         XA = XSTART + XTEMP*(XMIN - XMIN1)
         XB = XSTART + XTEMP*(XMAX - XMIN1)
         XC = XSTART
         YMAX1 = YMAX + PNT05*YDIFF
         YMIN1 = YMIN - PNT05*YDIFF
         YTEMP = (YEND - YSTART)/(YMAX1 - YMIN1)
         YA = YSTART + YTEMP*(YMIN - YMIN1)
         YB = YSTART + YTEMP*(YMAX - YMIN1)
         YC = YSTART
      ELSE
         XMAX1 = XMAX + PNT05*XDIFF
         XMIN1 = XMIN - PNT05*XDIFF
         XTEMP = (XEND - XSTART)/(XMAX1 - XMIN)
         XA = XSTART
         XB = XSTART + (XMAX - XMIN)*XTEMP
         XC = XSTART - (XMIN - XMIN1)*XTEMP
         YMAX1 = YMAX + PNT05*YDIFF
         YMIN1 = YMIN - PNT05*YDIFF
         YTEMP = (YEND - YSTART)/(YMAX1 - YMIN)
         YA = YSTART
         YB = YSTART + (YMAX - YMIN)*YTEMP
         YC = YSTART - (YMIN - YMIN1)*YTEMP
      ENDIF
C
C Now define A, B, C, D for Scatchard plot error bar caps etc.
C
      A = (XB - XA)/(XMAX - XMIN)
      B = (XA*XMAX - XB*XMIN)/(XMAX - XMIN)
      C = YTOX*(YB - YA)/(YMAX - YMIN)
      D = YTOX*(YA*YMAX - YB*YMIN)/(YMAX - YMIN)
C
C Initialise GKS by call to INIT .......................................
C
      ISEND = N0
      CALL INIT$(ISEND)
      IF (ISEND .NE. 0) RETURN
C
C Call WGBINI$ temporarily in this version to re-set font size = 1
C (For future developments) set the font size and line width for
C use with Hershey fonts to make the font and line width independent
C
      IF (.NOT.TRUE_TYPE) THEN
         CALL WGBINI$(N3)
         SIZE1 = WGBCFG$(K0)
         SIZE1 = WGBCFG$(K4)
      ENDIF
C
C Line width
C
      CALL GSLWSC$(ONE)
C
C Define the font scaling parameter by C_SCALE as set in INIT$..........
C
      FACTOR = C_SCALE
      ABORT = .FALSE.
C
C Set up GKS windows, viewports and normalising transformations
C
      CALL GSLN$(N1)
      CALL GSWN$(N1,
     +           XMIN1, XMAX1, YMIN1, YMAX1)
      CALL GSVP$(N1,
     +           XC, XEND, YC, YEND)
      CALL GSWN$(N2,
     +           ZERO, ONE, ZERO, ONE)
      CALL GSVP$(N2,
     +           ZERO, ONE, ZERO, ONE)
C
C Call GKS transformation N2 for axes etc.
C
      CALL GSELNT$(N2)
      X1 = ZERO
      X2 = ONE
      Y1 = ZERO
      Y2 = ONE
      IF (PS) THEN
C
C Always colour the PS background to obliterate in overlays
C
         IF (MONO .AND. .NOT.VIDEO) THEN
            ICOLOR = 15
            ITEMP = 0
         ELSE
            ICOLOR = 0
            ITEMP = 15
            IF (.NOT.MONO) ITEMP = JCOL(5)
         ENDIF
         CALL BLOCK$(X1, Y1, X2, Y2, ITEMP)
      ELSEIF (MONO) THEN
         IF (VIDEO) THEN
C
C The default ... no background
C
            ICOLOR = 0
         ELSE
C
C The special case ... white on black
C
            ICOLOR = 15
            ITEMP = 0
            CALL BLOCK$(X1, Y1, X2, Y2, ITEMP)
         ENDIF
      ELSE
C
C User supplied defaults
C        
         ITEMP = JCOL(5)   
         CALL BLOCK$(X1, Y1, X2, Y2, ITEMP)
      ENDIF
C
C Set Postscript linecaps for tick marks .......................PS only
C
      IF (PS) THEN 
         CALL PSLCAP$(N2)
      ELSE
         I = N2
         CALL SET_END_CAP (I,
     +                     STORE)
      ENDIF             
C
C Initialise SYMBOL then call WGBFNT$ to initialise TrueType fonts
C
      DO I = 1, 60
         SYMBOL(I:I) = '0'
      ENDDO
      ANGLE = ZERO
      CALL WGBFNT$(I, NFONT,
     +             SLANT)
C
C Draw the Plot Title ..................................................
C
      IF (PTITLE .NE. BLANK) THEN
         IF (.NOT.MONO) ICOLOR = JCOL(1)
         IF (PS) THEN
            XBEGIN = PNT5
            YBEGIN = ONE - TWO*THEIGHT
            CALL PSTEXT$(ICOLOR, 
     +                   XBEGIN, YBEGIN,
     +                   PTITLE, 'ti')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = PNT5
            YBEGIN = ONE - TWO*THEIGHT
            IF (NFONT.EQ.1 .OR. NFONT.EQ.3 .OR. NFONT.EQ. 5 .OR.
     +          NFONT.EQ.7 .OR. NFONT.EQ.9 .OR. NFONT.EQ.11) THEN
               I = NFONT + 1
            ELSE
               I = NFONT
            ENDIF
            SIZE2 = TTYPE*XPT
            CALL PLTSTR$(ICOLOR, NTFONT, I, N2, NOUT_PS,
     +                   ANGLE, SIZE2, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                   '\Helvetica', PTITLE, SYMBOL, 'ti',
     +                   HARD_COPY, HPGL, PS)
         ELSE
            XBEGIN = PNT5*DBLE(NPCHAR - LEN(PTITLE))/DBLE(NPCHAR)
            IF (XBEGIN.LT.ZERO) XBEGIN = ZERO
            YBEGIN = ONE - TWO*THEIGHT
            IF (OFFSET .AND. BOXIT) YBEGIN = YBEGIN + THEIGHT/FOUR
            IF (KTIC.GT.1) YBEGIN = YBEGIN - XTIC
            FONT = NTFONT
            SIZE4 = XPT*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            ROTATION = ZERO
            ITALIC = ZERO
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN, YBEGIN, PTITLE, ICOLOR)
         ENDIF
      ENDIF
C
C Draw the X-axis legend
C
      IF (XTITLE .NE. BLANK) THEN
         IF (.NOT.MONO) ICOLOR = JCOL(2)
         IF (PS) THEN
            XBEGIN = PNT5
C
C Moved down 22/02/2000
C***********YBEGIN = XHEIGHT + XHEIGHT/TWO
C
            YBEGIN = XHEIGHT - XHEIGHT/FOUR
            CALL PSTEXT$(ICOLOR,
     +                   XBEGIN, YBEGIN,
     +                   XTITLE, 'xl')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = PNT5
            YBEGIN = XHEIGHT - XHEIGHT/FOUR
            SIZE2 = TTYPE*XPX
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, N2, NOUT_PS,
     +                   ANGLE, SIZE2, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                   '\Helvetica', XTITLE, SYMBOL, 'xl',
     +                   HARD_COPY, HPGL, PS)
         ELSE
            XBEGIN = PNT5*DBLE(NXCHAR - LEN(XTITLE))/DBLE(NXCHAR)
            IF (XBEGIN.LT.ZERO) XBEGIN = ZERO
C Moved down 22/02/2000
C***********YBEGIN = XHEIGHT + XHEIGHT/TWO
C
            YBEGIN = XHEIGHT - XHEIGHT/FOUR
            IF (KTIC.GT.1) YBEGIN = YBEGIN + XTIC
            FONT = NXFONT
            SIZE4 = XPX*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            ROTATION = ZERO
            ITALIC = ZERO
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN, YBEGIN + YSHIFT, XTITLE, ICOLOR)
         ENDIF
      ENDIF
C
C Draw the Y-axis legend
C
      IF (YTITLE .NE. BLANK) THEN
         IF (.NOT.MONO) ICOLOR = JCOL(2)
         IF (PS) THEN
C
C Moved left 22/02/2000
C***********XBEGIN = TWO*YHEIGHT
C
            XBEGIN = TWO*YHEIGHT - YTIC
            YBEGIN = PNT5
            CALL PSTEXT$(ICOLOR, XBEGIN, YBEGIN, YTITLE, 'yl')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = TWO*YHEIGHT - YTIC
            YBEGIN = PNT5
            SIZE2 = TTYPE*XPY
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, N2, NOUT_PS,
     +                   ANGLE, SIZE2, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                   '\Helvetica', YTITLE, SYMBOL, 'yl',
     +                   HARD_COPY, HPGL, PS)
         ELSE
C
C Moved left 22/02/2000
C***********XBEGIN = XMOVE*(TWO*YHEIGHT)
C
            XBEGIN = XMOVE*(TWO*YHEIGHT) - YTIC
            IF (KTIC.GT.1) XBEGIN = XBEGIN + YTIC
            YBEGIN = PNT5*DBLE(NYCHAR - LEN(YTITLE))/DBLE(NYCHAR)
            IF (YBEGIN.LT.ZERO) YBEGIN = ZERO
            FONT = NYFONT
            SIZE4 = XPY*SIZE1
            IF (HARD_COPY) SIZE4 = X_SCALE*SIZE4
            ROTATION = NINETY
            ITALIC = ZERO
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN, YBEGIN, YTITLE, ICOLOR)
         ENDIF
      ENDIF
C
C Draw X-Axis, Y-Axis, Box and Frame if required .......................
C
      IF (.NOT.MONO) ICOLOR = JCOL(4)
      IF (BOXIT) THEN
         IF (OFFSET) THEN
            X1 = XSTART
            X2 = XEND
            Y1 = YSTART
            Y2 = YEND
         ELSE
            X1 = XA
            X2 = XB
            Y1 = YA
            Y2 = YB
         ENDIF
         IF (PS) THEN
            XFRAME(1) = X1
            XFRAME(2) = X2
            XFRAME(3) = X2
            XFRAME(4) = X1
            YFRAME(1) = Y1
            YFRAME(2) = Y1
            YFRAME(3) = Y2
            YFRAME(4) = Y2
            CALL PSPOLY$(ICOLOR, N4,
     +                   XFRAME, YFRAME,
     +                   'pc')
         ELSE
            CALL SOLID_LINE$(X1, Y1, X2, Y1, ICOLOR)
            CALL SOLID_LINE$(X2, Y1, X2, Y2, ICOLOR)
            CALL SOLID_LINE$(X2, Y2, X1, Y2, ICOLOR)
            CALL SOLID_LINE$(X1, Y2, X1, Y1, ICOLOR)
         ENDIF
      ELSE
         IF (PS .AND. .NOT.OFFSET) THEN
            XFRAME(1) = XB
            XFRAME(2) = XA
            XFRAME(3) = XA
            YFRAME(1) = YA
            YFRAME(2) = YA
            YFRAME(3) = YB
            CALL PSPOLY$(ICOLOR, N3,
     +                   XFRAME, YFRAME,
     +                   'pl')
         ELSE
            CALL SOLID_LINE$(XA, YSTART, XB, YSTART, ICOLOR)
            CALL SOLID_LINE$(XSTART, YA, XSTART, YB, ICOLOR)
         ENDIF
      ENDIF
C
C Plot cross hairs
C
      IF (XHAIRS .AND.
     +    XMIN.LT.ZERO .AND. XMAX.GT.ZERO .AND.
     +    YMIN.LT.ZERO .AND. YMAX.GT.ZERO) THEN
         IF (OFFSET) THEN
            X1 = XA - XMIN*(XB - XA)/XDIFF
            X2 = X1
            Y1 = YSTART
            Y2 = YEND
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
            X1 = XSTART
            X2 = XEND
            Y1 = YA - YMIN*(YB - YA)/YDIFF
            Y2 = Y1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
         ELSE
            X1 = XA - XMIN*(XB - XA)/XDIFF
            X2 = X1
            Y1 = YA
            Y2 = YB
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
            X1 = XA
            X2 = XB
            Y1 = YA - YMIN*(YB - YA)/YDIFF
            Y2 = Y1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
         ENDIF
      ENDIF
      IF (FRAME) THEN
         X1 = ZERO + YTIC
         X2 = ONE - YTIC
         Y1 = ZERO + XTIC
         Y2 = ONE - XTIC
         IF (PS) THEN
            XFRAME(1) = X1
            XFRAME(2) = X2
            XFRAME(3) = X2
            XFRAME(4) = X1
            YFRAME(1) = Y1
            YFRAME(2) = Y1
            YFRAME(3) = Y2
            YFRAME(4) = Y2
            CALL PSPOLY$(ICOLOR, N4,
     +                   XFRAME, YFRAME,
     +                   'pc')
         ELSE
            CALL SOLID_LINE$(X1, Y1, X2, Y1, ICOLOR)
            CALL SOLID_LINE$(X2, Y1, X2, Y2, ICOLOR)
            CALL SOLID_LINE$(X2, Y2, X1, Y2, ICOLOR)
            CALL SOLID_LINE$(X1, Y2, X1, Y1, ICOLOR)
         ENDIF
      ENDIF
C
C Retrieve the plotting precision
C      
      CALL GKSSIG$(ISIG, IFIGX, ISIGX, IFIGY, ISIGY)      
C
C Work out labelling scheme for X-Axis .................................
C
      DO I = 1, 10
         GTYPE(I) = .FALSE.
      ENDDO

      IF (ISIGX.EQ.1) THEN
C
C Low precision
C        
         IF (XMAG .LT. - N9) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F5.1)'
            GTYPE(1) = .TRUE.
         ELSEIF (XMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F5.1)'
            GTYPE(2) = .TRUE.
         ELSEIF (XMAG .EQ. - N2) THEN
            FRMAT = '(F10.3)'
            GTYPE(3) = .TRUE.
         ELSEIF (XMAG .EQ. - N1) THEN
            FRMAT = '(F10.2)'
            GTYPE(4) = .TRUE.
         ELSEIF (XMAG .EQ. N0) THEN
            FRMAT = '(F10.1)'
            GTYPE(5) = .TRUE.
         ELSEIF (XMAG .EQ. N1) THEN
            FRMAT = '(F10.1)'
            GTYPE(6) = .TRUE.
         ELSEIF (XMAG .EQ. N2) THEN
            GTYPE(7) = .TRUE.
         ELSEIF (XMAG .EQ. N3) THEN
            GTYPE(8) = .TRUE.
         ELSEIF (XMAG .LT. N10)  THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F5.1)'
            GTYPE(9) = .TRUE.
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F5.1)'
            GTYPE(10) = .TRUE.
         ENDIF      
      ELSEIF (ISIGX.EQ.2) THEN
C
C Automatic precision
C
         IFIGX = MAX(N1,IFIGX)

         IF (XMAG.EQ.-N2 .OR.
     +      (XMAG.EQ.-N1 .AND. IFIGX.EQ.N1) .OR.
     +      (XMAG.GE.N0  .AND. XMAG.LE.N3)) THEN
            IFIGX =  IFIGX - XMAG
            XMAG = N0
         ENDIF                        

         IFIGX = MAX(N1,IFIGX)
                  
         WRITE (WORD1,'(I1)') IFIGX
                
         IF (XMAG.GE.-N2 .AND. XMAG.LE.N3) THEN
            FRMAT = '(F10.'//WORD1//')'
         ELSE   
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F10.'//WORD1//')'
         ENDIF
            
         IF (XMAG .LT. - N9) THEN
            GTYPE(1) = .TRUE.
         ELSEIF (XMAG .LT. - N2) THEN
            GTYPE(2) = .TRUE.
         ELSEIF (XMAG .EQ. - N2) THEN
            GTYPE(3) = .TRUE.
         ELSEIF (XMAG .EQ. - N1) THEN
            GTYPE(4) = .TRUE.
         ELSEIF (XMAG.EQ. N0) THEN
            GTYPE(5) = .TRUE.
         ELSEIF (XMAG .EQ. N1) THEN
            GTYPE(6) = .TRUE.
         ELSEIF (XMAG .EQ. N2) THEN
            GTYPE(7) = .TRUE.
         ELSEIF (XMAG .EQ. N3) THEN
            GTYPE(8) = .TRUE.
         ELSEIF (XMAG .LT. N10)  THEN
            GTYPE(9) = .TRUE.
         ELSE
            GTYPE(10) = .TRUE.
         ENDIF
      ELSEIF (ISIGX.EQ.3) THEN
C
C High precision
C      
         IF (XMAG .LT. - N9) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F8.4)'
            GTYPE(1) = .TRUE.
         ELSEIF (XMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F8.4)'
            GTYPE(2) = .TRUE.
         ELSEIF (XMAG .EQ. - N2) THEN
            FRMAT = '(F10.6)'
            GTYPE(3) = .TRUE.
         ELSEIF (XMAG .EQ. - N1) THEN
            FRMAT = '(F10.5)'
            GTYPE(4) = .TRUE.
         ELSEIF (XMAG.EQ. N0) THEN
            FRMAT = '(F10.4)'
            GTYPE(5) = .TRUE.
         ELSEIF (XMAG .EQ. N1) THEN
            FRMAT = '(F10.3)'
            GTYPE(6) = .TRUE.
         ELSEIF (XMAG .EQ. N2) THEN
            GTYPE(6) = .TRUE.
            FRMAT = '(F10.2)'
         ELSEIF (XMAG .EQ. N3) THEN
            GTYPE(6) = .TRUE.
            FRMAT = '(F10.1)'
         ELSEIF (XMAG .LT. N10)  THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F8.4)'
            GTYPE(9) = .TRUE.
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-XMAG,'P,F8.4)'
            GTYPE(10) = .TRUE.
         ENDIF
      ENDIF    
C
C Set up fonts for labels on X-axis
C
      IF (.NOT.TRUE_TYPE) THEN
         FONT = NCFONT
         SIZE4 = XPC*SIZE1
         IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
         ROTATION = ZERO
         ITALIC = ZERO
         IF (HPGL) THEN
            SIZE4 = XHPGL*SIZE4
            CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                ROTATION, ITALIC)
         ELSE
            SIZE4 = FACTOR*SIZE4
            CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                ROTATION, ITALIC)
         ENDIF
      ENDIF
C
C Set up coordinates for labels and tick marks
C
      IF (OFFSET) THEN
         YBOX1 = YEND
      ELSE
         YBOX1 = YB
      ENDIF
C
C Moved down 22/02/2000
C*****YBEGIN = YSTART - CHEIGHT - CHEIGHT/FIVE
C
      YBEGIN = YSTART - CHEIGHT - CHEIGHT/TWO - TWO*XTIC
      IF (KTIC.EQ.1) THEN
         YBEGIN = YBEGIN - XTIC
         YTEMP = YSTART - XTIC
         YBOX2 = YBOX1 + XTIC
      ELSEIF (KTIC.EQ.2) THEN
         YTEMP = YSTART
         YBOX2 = YBOX1
      ELSE
         YTEMP = YSTART + XTIC
         YBOX2 = YBOX1 - XTIC
      ENDIF
C
C Draw tick marks and labels on X-axis
C
      DMXTIC = DBLE(MXTIC)
      DO I = 0, MXTIC
         DI = DBLE(I)
         XTEMP = DI*(XB - XA)/DMXTIC + XA
         IF (.NOT.MONO) ICOLOR = JCOL(4)
         CALL SOLID_LINE$(XTEMP, YSTART, XTEMP, YTEMP, ICOLOR)
         IF (BOXIT) CALL SOLID_LINE$(XTEMP, YBOX1, XTEMP, YBOX2, ICOLOR)
         IF (XGRID) THEN
            CALL GSLN$(N2)
            CALL DASHED_LINE$(XTEMP, YSTART, XTEMP, YBOX1, ICOLOR)
         ENDIF
         XVAL = DI*(XMAX - XMIN)/DMXTIC + XMIN
         IF (XTOINT.AND.GTYPE(5) .OR. XTOINT.AND.GTYPE(6) .OR.
     +       GTYPE(7) .OR. GTYPE(8)) THEN
            NX = NINT(XVAL)
            WRITE (TLABEL,'(I10)') NX
            CALL TRIML1 (TLABEL)
         ELSE
            WRITE (TLABEL,FRMAT) XVAL
            CALL TRIML1 (TLABEL)
            IF (ISIGX.EQ.2) CALL XFRMAT$ (ISIGX,
     +                                    XVAL,
     +                                    TLABEL, FRMAT)               
         ENDIF
         XBEGIN = XTEMP
         IF (.NOT.MONO) ICOLOR = JCOL(3)
         IF (PS) THEN
            CALL PSTEXT$(ICOLOR, XBEGIN, YBEGIN, TLABEL, 'tc')
         ELSEIF (TRUE_TYPE) THEN
            SIZE2 = TTYPE*XPC
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, N2, NOUT_PS,
     +                   ANGLE, SIZE2, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                   '\Helvetica', TLABEL, SYMBOL, 'tc',
     +                   HARD_COPY, HPGL, PS)
         ELSE
            CALL TEXT$(XBEGIN + XADD4, YBEGIN + YADD4 + YSHIFT,
     +                 TLABEL, ICOLOR)           
         ENDIF
      ENDDO
C
C Draw exponential if required. Use DELTA to move exponent over if req.
C
      DELTA = ZERO
      IF (GTYPE(1)) THEN
         WRITE (EXPONT, FMT = '(I4)') XMAG
      ELSEIF (GTYPE(2)) THEN
         WRITE (EXPONT, FMT = '(I4)') XMAG
      ELSEIF (GTYPE(9)) THEN
         WRITE (EXPONT, FMT = '(I4)') XMAG
         DELTA = EHEIGHT/FOUR
      ELSEIF (GTYPE(10)) THEN
         WRITE (EXPONT, FMT = '(I4)') XMAG
         DELTA = EHEIGHT/FOUR
      ELSE
          EXPONT = ' '
      ENDIF
      IF (EXPONT .NE. ' ' .AND. MXTIC.GT.0) THEN
         CALL TRIML1 (EXPONT)
         IF (XMAG.GT.ZERO) THEN
            LABEL4 = EXPONT
            EXPONT = BLANK//LABEL4(1:3)
         ENDIF
         IF (.NOT.MONO) ICOLOR = JCOL(3)
         IF (PS) THEN
            XBEGIN = XB + XADD6
            YBEGIN = YBEGIN - EXTRA1 - EXTRA2 + YADD6 + YSHIFT
            CALL TRIML1 (EXPONT)
            CALL PSNUMB$(ICOLOR,
     +                   XBEGIN, YBEGIN,
     +                   'E'//EXPONT, 'tl')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = XB + XADD6
            YBEGIN = YBEGIN - EXTRA1 - EXTRA2 + YADD6 + YSHIFT
            CALL TRIML1 (EXPONT)
            SIZE2 = TTYPE*XPC
            CALL PLNUMB$(ICOLOR, I, N2, 
     +                   SIZE2, XBEGIN, YBEGIN, Y_SCALE,
     +                   'tl', 'E'//EXPONT, 
     +                   HARD_COPY, HPGL)
         ELSE
            XBEGIN = XB - DELTA
            YBEGIN = YBEGIN - EXTRA1
            SIZE4 = 0.75D+00*XPC*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN + XADD5, YBEGIN + YADD5 + YSHIFT, EXPONT,
     +                 ICOLOR)
            XBEGIN = XB
            YBEGIN = YBEGIN - EXTRA2
            SIZE4 = XPC*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN + XADD6, YBEGIN + YADD6 + YSHIFT, TIME10,
     +                 ICOLOR)
         ENDIF
      ENDIF
C
C Now work out labelling scheme for Y-Axis .............................
C
      GTYPE(1) = .FALSE.
      IF (ISIGY.EQ.1) THEN
C
C Low significance
C        
         IF (YMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-YMAG,'P,F6.1)'
         ELSEIF (YMAG .EQ. - N2) THEN
            FRMAT = '(F10.3)'
         ELSEIF (YMAG .EQ. - N1) THEN
            FRMAT = '(F10.2)'
         ELSEIF (YMAG.EQ. N0) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.1)'
            ENDIF
         ELSEIF (YMAG .EQ. N1) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.1)'
            ENDIF
         ELSEIF (YMAG .EQ. N2 .OR.YMAG .EQ. N3) THEN
            GTYPE(1) = .TRUE.
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-YMAG,'P,F6.1)'
         ENDIF      
      ELSEIF (ISIGY.EQ.2) THEN
C
C Automatic significance
C

         IFIGY = MAX(N1,IFIGY)
         
         IF (YMAG.EQ.-N2 .OR.
     +      (YMAG.EQ.-N1 .AND. IFIGY.EQ.N1) .OR.
     +      (YMAG.GE.N0  .AND. YMAG.LE.N3)) THEN
            IFIGY =  IFIGY - YMAG
            YMAG = N0
         ENDIF                        

         IFIGY = MAX(N1,IFIGY)
                  
         WRITE (WORD1,'(I1)') IFIGY
                
         IF (YMAG.GE.-N2 .AND. YMAG.LE.N3) THEN
            FRMAT = '(F10.'//WORD1//')'
         ELSE   
            WRITE (FRMAT, '(A,I4,A)') '(',-YMAG,'P,F10.'//WORD1//')'
         ENDIF
         
         IF (YMAG.EQ. N0 .AND. YTOINT) THEN
            GTYPE(1) = .TRUE.
         ELSEIF (YMAG .EQ. N1 .AND. YTOINT) THEN
            GTYPE(1) = .TRUE.
         ELSEIF (YMAG .EQ. N2 .OR.YMAG .EQ. N3) THEN
            GTYPE(1) = .TRUE.
         ENDIF
      ELSEIF (ISIGY.EQ.3) THEN
C
C High significance
C      
         IF (YMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-YMAG,'P,F8.4)'
         ELSEIF (YMAG .EQ. - N2) THEN
            FRMAT = '(F10.6)'
         ELSEIF (YMAG .EQ. - N1) THEN
            FRMAT = '(F10.5)'
         ELSEIF (YMAG.EQ. N0) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.4)'
            ENDIF
         ELSEIF (YMAG .EQ. N1) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.3)'
            ENDIF
         ELSEIF (YMAG .EQ. N2) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.2)' 
            ENDIF 
         ELSEIF (YMAG .EQ. N3) THEN
            IF (YTOINT) THEN
               GTYPE(1) = .TRUE.
            ELSE
               FRMAT = '(F10.1)' 
            ENDIF            
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-YMAG,'P,F8.4)'
         ENDIF   
      ENDIF   
C
C Set up fonts for Y-axis labels
C
      IF (.NOT.TRUE_TYPE) THEN
         FONT = NCFONT
         SIZE4 = XPC*SIZE1
         IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
         ROTATION = ZERO
         ITALIC = ZERO
         IF (HPGL) THEN
            SIZE4 = XHPGL*SIZE4
            CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                ROTATION, ITALIC)
         ELSE
            SIZE4 = FACTOR*SIZE4
            CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                ROTATION, ITALIC)
         ENDIF
      ENDIF
C
C Calculate parameters for tick marks on Y-axis
C
      IF (OFFSET) THEN
         XBOX1 = XEND
      ELSE
         XBOX1 = XB
      ENDIF
      XBEGIN = XSTART - CHEIGHT/TEN
      IF (KTIC.EQ.1) THEN
         XBEGIN = XBEGIN - YTIC
         XTEMP = XSTART - YTIC
         XBOX2 = XBOX1 + YTIC
      ELSEIF (KTIC.EQ.2) THEN
         XTEMP = XSTART
         XBOX2 = XBOX1
      ELSE
         XTEMP = XSTART + YTIC
         XBOX2 = XBOX1 - YTIC
      ENDIF
C
C Set the line thickness for tick marks then draw and label
C
      DMYTIC = DBLE(MYTIC)
      DO I = 0, MYTIC
         DI = DBLE(I)
         YTEMP = DI*(YB - YA)/DMYTIC + YA
         IF (.NOT.MONO) ICOLOR = JCOL(4)
         CALL SOLID_LINE$(XSTART, YTEMP, XTEMP, YTEMP, ICOLOR)
         IF (BOXIT) CALL SOLID_LINE$(XBOX1, YTEMP, XBOX2, YTEMP, ICOLOR)
         IF (YGRID) THEN
            CALL GSLN$(N2)
            CALL DASHED_LINE$(XSTART, YTEMP, XBOX1, YTEMP, ICOLOR)
         ENDIF
         YVAL = DI*(YMAX - YMIN)/DMYTIC + YMIN
         IF (GTYPE(1)) THEN
            NY = NINT(YVAL)
            WRITE (TLABEL,'(I10)') NY
            CALL TRIML1 (TLABEL)
         ELSE
            WRITE (TLABEL,FRMAT) YVAL
            CALL TRIML1 (TLABEL)
            IF (ISIGY.EQ.2) CALL XFRMAT$ (ISIGY,
     +                                    YVAL,
     +                                    TLABEL, FRMAT)             
         ENDIF
         IF (.NOT.MONO) ICOLOR = JCOL(3)
         IF (PS) THEN
            CALL PSTEXT$(ICOLOR, MIN(XTEMP,XSTART) - YTIC,
     +                   YTEMP, TLABEL, 'ty')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = MIN(XTEMP,XSTART) - YTIC
            YBEGIN = YTEMP
            SIZE2 = TTYPE*XPC
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, N2, NOUT_PS,
     +                   ANGLE, SIZE2, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                   '\Helvetica', TLABEL, SYMBOL, 'ty',
     +                   HARD_COPY, HPGL, PS)
         ELSE
            CALL TEXT$(XBEGIN + XADD1 + XSHIFT, YTEMP + YADD1, TLABEL,
     +                 ICOLOR)
         ENDIF
      ENDDO
C
C Draw Y-Axis exponential if required. Use DELTA to space exponent if req.
C
      DELTA = ZERO
      IF (YMAG .LT. - N9) THEN
         WRITE (EXPONT, FMT = '(I4)') YMAG
      ELSEIF (YMAG .LT. - N2) THEN
         WRITE (EXPONT, FMT = '(I4)') YMAG
      ELSEIF (YMAG .GT. N9) THEN
         WRITE (EXPONT, FMT = '(I4)') YMAG
         DELTA = EHEIGHT/FOUR
      ELSEIF (YMAG .GT. N3) THEN
         WRITE (EXPONT, FMT = '(I4)') YMAG
         DELTA = EHEIGHT/FOUR
      ELSE
         EXPONT = ' '
      ENDIF
      IF (EXPONT .NE. ' ' .AND. MYTIC.GT.0) THEN
         CALL TRIML1 (EXPONT)
         IF (YMAG.GT.ZERO) THEN
            LABEL4 = EXPONT
            EXPONT = BLANK//LABEL4(1:3)
         ENDIF
         IF (.NOT.MONO) ICOLOR = JCOL(3)
         IF (PS) THEN
            XBEGIN = XBEGIN + PSADDY
            YBEGIN = YB - CHEIGHT/TWO - EXTRA3 - EXTRA4
            CALL TRIML1 (EXPONT)
            CALL PSNUMB$(ICOLOR, 
     +                   XBEGIN, YBEGIN,
     +                   'E'//EXPONT, 'tl')
         ELSEIF (TRUE_TYPE) THEN
            XBEGIN = XBEGIN + PSADDY
            YBEGIN = YB - CHEIGHT/TWO - EXTRA3 - EXTRA4
            CALL TRIML1 (EXPONT)
            SIZE2 = TTYPE*XPC
            CALL PLNUMB$(ICOLOR, I, N2,
     +                   SIZE2, XBEGIN, YBEGIN, Y_SCALE,
     +                   'tl', 'E'//EXPONT,
     +                   HARD_COPY, HPGL)
         ELSE
            XTEMP = XBEGIN
            XBEGIN = XTEMP - DELTA
            YBEGIN = YB - CHEIGHT/TWO - EXTRA3 + YADD3
            SIZE4 = 0.75D+00*XPC*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
               SIZE4 = FACTOR*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                   ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN + XADD2 + XSHIFT, YBEGIN + YADD2, EXPONT,
     +                 ICOLOR)
            XBEGIN = XTEMP
            YBEGIN = YBEGIN - EXTRA4
            SIZE4 = XPC*SIZE1
            IF (HARD_COPY) SIZE4 = Y_SCALE*SIZE4
            IF (HPGL) THEN
               SIZE4 = XHPGL*SIZE4
               CALL SET_TEXT_ATTRIBUTE$ (NHPGL, SIZE4,
     +                                   ROTATION, ITALIC)
            ELSE
                SIZE4 = FACTOR*SIZE4
                CALL SET_TEXT_ATTRIBUTE$ (FONT, SIZE4,
     +                                    ROTATION, ITALIC)
            ENDIF
            CALL TEXT$(XBEGIN + XADD3 + XSHIFT, YBEGIN + YADD3,TIME10,
     +                 ICOLOR)
         ENDIF
      ENDIF
C
C Set Postscript linecaps for tick marks .......................PS only
C
      IF (PS) THEN 
         CALL PSLCAP$(N0)
      ELSE
         I = N0
         CALL SET_END_CAP (I,
     +                     STORE)
      ENDIF            
C
C Restore size then return.............................................
C
      IF (.NOT.TRUE_TYPE) CALL WGBINI$(N4)
      ABORT = .FALSE.
      RETURN
C
C Error: Here if numbers are too large/small to plot ........................
C
   20 CONTINUE
      ABORT = .TRUE.
      CALL PUTFAT$('Numbers too large/small for accurate display')
      END
C
C
