C
C

      SUBROUTINE GKSD2D$(X, X1, Y, Y1)
C
C ACTION : Transform a real number pair into a number pair for plotting
C          in the default (0,1) space
C          Required for FTN77 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/12/97
C          Derived from GKSR2I$    
C          13/04/2007 added INTENTS 
C          15/06/2007 removed defngks.ins and added GETGKS_OT0, GETGKS_OT1, and GETGKS_FF1 
C
      IMPLICIT   NONE
C
C Arguments
C      
       DOUBLE PRECISION, INTENT (IN)  :: X, Y 
       DOUBLE PRECISION, INTENT (OUT) :: X1, Y1
C
C Locals
C               
      INTEGER    IXBOT0, IXDIF0, IXTOP0, IYBOT0, IYDIF0, IYTOP0 
      INTEGER    IXBOT1, IXDIF1, IXTOP1, IYBOT1, IYDIF1, IYTOP1
      INTEGER    IX, IY        
      DOUBLE PRECISION XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00) 
      EXTERNAL   GETGKS_FF1, GETGKS_OT0, GETGKS_OT1
      INTRINSIC  DBLE, NINT            
      CALL GETGKS_FF1 (XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01)
      CALL GETGKS_OT0 (IXBOT0, IXDIF0, IXTOP0, IYBOT0, IYDIF0, IYTOP0)
      CALL GETGKS_OT1 (IXBOT1, IXDIF1, IXTOP1, IYBOT1, IYDIF1, IYTOP1)
      IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
      IY = NINT(DBLE(IYBOT0) - DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
      X1 = DBLE(IX)/DBLE(IXTOP1 - IXBOT1)
      Y1 = ONE + DBLE(IY)/DBLE(IYTOP1 - IYBOT1)
      END
C
C  