C
C GKSDEC$:
C ========
C Controls the graphics window created by the simple graphics
C interface as in gks004, gks012, gkseb4, etc. The plot is
C initiated using init$ then closed using finish_1$.
C Note that PCX is used to control termination which avoids
C calling the editor GKSMNU$ except when actually requested.
C windows.ins is only required to call CLOSE_PRINTER@ and can
C be deleted if Salford @ routines are not used.
C defngks.ins is required for the COMMON block variables
C
      SUBROUTINE GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
C
C ACTION : Decide options after displaying a GKS plot
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,26/1/92 
C          15/12/1993 Added call to PCX
C          01/02/1994 Added calls to DBOS menu type routines
C          23/06/1994 Masked off lower RHS legend
C          28/10/1994 Extensively rewritten
C          20/11/1994 PS added
C          04/11/1996 Added XCLIP, YCLIP
C          21/02/1997 Win32 version
C          03/11/2000 removed .bmp option, and extensive revision,
C                     including use of PCX to control editor
C          19/03/2007 introduced CLOSE_PRINTER and added INTENTS 
C          14/06/2007 removed defngks.ins and added GETGKS and PUTGKS routines 
C          04/08/2009 added call to GKSCOL$
C
C          ABORT: Informs calling program whether to draw or stop
C          ASCII: If .TRUE. create ASCII text coordinate files for SIMPLOT
C          FIRST: Must be called first time to initialise
C
C          The next logicals must be set but they do not have any use in this
C          version. They must be retained to maintain calling sequences and
C          allow for future possible re-use.
C
C          GSAVE: Not used in this version. Used to allow display with no save
C           MONO: Not used now. Used to be used in DOS to suppress colour.
C            PCX: Not used for PCX now but used as an extra logical control
C                 variable. Used to be used in DOS to create PCX files.
C          VIDEO: Not used in this version. Used to be used in DOS to create
C                 reverse video
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      LOGICAL, INTENT (IN)    :: FIRST, GSAVE   
      LOGICAL, INTENT (INOUT) :: ABORT, ASCII, MONO, PCX, VIDEO 
C
C Locals
C                        
      INTEGER    I, ISEND
      INTEGER    NJCOL, NKCOL
      PARAMETER (NJCOL = 8, NKCOL = 12)
      INTEGER    N1, N2, N5, N6 
      PARAMETER (N1 = 1, N2 = 2, N5 = 5, N6 = 6)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      INTEGER    IFAIL, NPRESS, CLOSE_PRINTER
      INTEGER    HANDL1, NOUT_PS
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XCLIP(2), YCLIP(2)
      CHARACTER  FNAME*1024 
      LOGICAL    DOTMAT, HARD_COPY, PCL, PS
      LOGICAL    YES
      EXTERNAL   PUTADV$, WGB2PS$, FINISH_1$, PUTFAT$
      EXTERNAL   DEFGKS$, GETGKS_EPS, GETGKS_LGL, PUTGKS_LGL,
     +           GETGKS_HND, GKSCOL$ 
      EXTERNAL   CLOSE_PRINTER  
      SAVE       FNAME
      IF (GSAVE) IFAIL = 1!to silence ftn95
      IF (FIRST) THEN
C
C First time set up defaults
C
         ASCII = .FALSE.
         MONO = .TRUE.
         ISEND = 3
         CALL GKSCOL$(ISEND, JCOL, KCOL, NJCOL, NKCOL)
         DO I = 1, NJCOL
            IF (I.EQ.5) THEN
               IF (JCOL(I).NE.15) MONO = .FALSE.
            ELSE
               IF (JCOL(I).NE.0) MONO = .FALSE.
            ENDIF
            IF (.NOT.MONO) EXIT
         ENDDO    
         IF (MONO) THEN
            DO I = 1, NKCOL
               IF (KCOL(I).NE.0) THEN
                  MONO = .FALSE.
                  EXIT
               ENDIF   
            ENDDO  
         ENDIF             
         PCX = .FALSE.
         VIDEO = .TRUE. 
         CALL DEFGKS$
         RETURN
      ENDIF
C
C Define XCLIP, YCLIP every time for simple graphics to cancel clipping
C
      XCLIP(1) = ZERO
      XCLIP(2) = ONE
      YCLIP(1) = ZERO
      YCLIP(2) = ONE
C
C Check for ASCII, PCX etc.
C                       
      CALL GETGKS_EPS (NOUT_PS,
     +                 PS)  
      CALL GETGKS_LGL (N1,
     +                 DOTMAT)  
      CALL GETGKS_LGL (N2,
     +                 HARD_COPY) 
      CALL GETGKS_LGL (N5,
     +                 PCL)   
      IF (ASCII) THEN
C
C Close down after ASCII option has been used
C
         ASCII = .FALSE.
         ABORT = .FALSE.
         PCX = .TRUE.
         RETURN
      ELSEIF (PS) THEN
C
C Close down after PS option has been used
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP,
     +               'CLOSE', FNAME)
         ABORT = .FALSE.
         HARD_COPY = .FALSE.
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)         
         PCX = .TRUE.
         PS = .FALSE. 
         CALL PUTGKS_LGL (N6,
     +                    PS)         
         RETURN
      ELSEIF (PCL) THEN
C
C Close down after PCL output to printer has finished
C             
         CALL GETGKS_HND (N1,
     +                    HANDL1)         
         IFAIL = CLOSE_PRINTER (HANDL1)
         IF (IFAIL.EQ.1) THEN
            CALL PUTADV$(
     +'The plot has been copied to the printer (or file)')            
         ELSE
            CALL PUTFAT$('The printer cannot be closed ... Investigate')
         ENDIF
         ABORT = .FALSE.
         HARD_COPY = .FALSE. 
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)         
         PCX = .TRUE.
         PCL = .FALSE.
         CALL PUTGKS_LGL (N5,
     +                    PCL)         
         RETURN
      ELSEIF (DOTMAT) THEN
C
C This option should never be used as .bmp output has been suppressed
C
         DOTMAT = .FALSE.
         CALL PUTGKS_LGL (N1,
     +                    DOTMAT)          
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Call FINISH_1$ to determine next action required
C
      ABORT = .TRUE.
      ASCII = .FALSE.
      PCX = .FALSE.
      DOTMAT = .FALSE.
      DO I = 1, 6    
         ISEND = I
         CALL PUTGKS_LGL (ISEND,
     +                    DOTMAT)
      ENDDO
              
      CALL FINISH_1$(NPRESS,
     +               YES)

      IF (NPRESS.EQ.0 .OR. .NOT.YES) THEN
C
C Cancel
C
         ABORT = .TRUE.
         ASCII = .FALSE.
      ELSEIF (NPRESS.EQ.1) THEN
C
C Edit
C
         ABORT = .FALSE.
         HARD_COPY = .FALSE. 
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)         
         PCX = .FALSE.
      ELSEIF (NPRESS.EQ.21) THEN
C
C ASCII
C
         ABORT = .TRUE.
         HARD_COPY = .FALSE. 
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)        
         ASCII = .TRUE.
      ELSEIF (NPRESS.EQ.22) THEN
C
C PostScript
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP,
     +               'OPEN', FNAME)
         ABORT = .FALSE.
         IF (IFAIL.EQ.0) THEN
            HARD_COPY = .TRUE.
            PS = .TRUE.
         ELSE
            HARD_COPY = .FALSE.
            PCX = .TRUE.
            PS = .FALSE.
         ENDIF
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)
         CALL PUTGKS_LGL (N6,
     +                    PS)                   
      ELSEIF (NPRESS.EQ.23) THEN
C
C PCL, Fonts or line width
C
         ABORT = .FALSE.
         IF (HARD_COPY .AND. PCL) THEN
            PCX = .FALSE.
         ELSE
            ASCII = .FALSE.
            PCX = .TRUE.
            PS = .FALSE.     
            CALL PUTGKS_LGL (N6,
     +                       PS)             
         ENDIF
      ELSE
C
C Just in case
C
         ABORT = .TRUE.
         ASCII = .FALSE.
      ENDIF
      END
C
C
