C
C GKSDEK$
C =======
C
C Control the SIMPLOT surface type window and plot objects
C
C INIT2$ has been called to create the window then FINISH_4$ is
C called to close it down as appropriate. This is actually a
C version of GKSDEC for a SIMPLOT surface graphical window. 
C
      SUBROUTINE GKSDEK$(NPRESS,
     +                   XCLIP, YCLIP, 
     +                   ABORT, FIRST, GSAVE)
C
C ACTION : Decide options after displaying a GKS plot
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,26/1/92
C          15/12/1993 Added call to PCX
C          01/02/1994 Added calls to DBOS menu type routines
C          23/06/1994 Masked off lower RHS legend
C          28/10/1994 Extensively rewritten
C          20/11/1994 PS added
C          30/11/1994 Added PCX to SAVE since removed from argument list
C          26/01/1995 Removed MONO and VIDEO
C          04/11/1996 Added XCLIP, YCLIP
C          21/05/1997 Extensive revision for win32 version
C          18/12/1997 added NPRESS and FINISH_4$
C          03/11/2000 removed .bmp file and extensive revision
C          13/11/2000 NPRESS = 22 invokes PS directly while NPRESS = 23 now
C                     prints directly
C          19/03/2007 introduced CLOSE_PRINTER and added INTENTS 
c          14/06/2007 removed defngks.ins and added DEFGKS$, etc.
C
      IMPLICIT   NONE
C                                                                       
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: NPRESS
      DOUBLE PRECISION, INTENT (INOUT) :: XCLIP(2), YCLIP(2)
      LOGICAL,          INTENT (IN)    :: FIRST, GSAVE  
      LOGICAL,          INTENT (INOUT) :: ABORT
C
C Locals
C      
      INTEGER    HANDL1, NOUT_PS
      INTEGER    N0, N1, N2, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N5 = 5, N6 = 6)
      INTEGER    I, IFAIL, CLOSE_PRINTER
      CHARACTER  FNAME*1024
      LOGICAL    YES     
      LOGICAL    DOTMAT, HARD_COPY, META, PCL, PS
      EXTERNAL   FINISH_4$, PLTOBJ$, WGB2PS$, PUTADV$
      EXTERNAL   DEFGKS$, GETGKS_EPS, GETGKS_LGL, PUTGKS_LGL,
     +           GETGKS_HND  
      EXTERNAL   CLOSE_PRINTER
      SAVE       FNAME
      IF (GSAVE) I = 1!to silence ftn95
      IF (FIRST) THEN
C
C First time set up defaults then RETURN
C               
         CALL DEFGKS$
         RETURN
      ENDIF
C
C Otherwise plot the extra graphical objects
C
      I = N0
      CALL PLTOBJ$(N4, I)   
      CALL GETGKS_EPS (NOUT_PS,
     +                 PS) 
      CALL GETGKS_LGL (N1,
     +                 DOTMAT)  
      CALL GETGKS_LGL (N2,
     +                 HARD_COPY)           
      CALL GETGKS_LGL (N5,
     +                 PCL)      
      IF (PS) THEN
C
C Close down after PostScript output
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP,
     +               'CLOSE', FNAME)
         ABORT = .FALSE.
         DOTMAT = .FALSE.
         CALL PUTGKS_LGL (N1,
     +                    DOTMAT)         
         HARD_COPY = .FALSE.
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)         
         PCL = .FALSE. 
         CALL PUTGKS_LGL (N5,
     +                    PCL)          
         PS = .FALSE.
         CALL PUTGKS_LGL (N6,
     +                    PS)          
         NPRESS = N0
         RETURN
      ELSEIF (PCL) THEN
C
C Close down after PCL output
C                          
         CALL GETGKS_HND (N1,
     +                    HANDL1)         
         IFAIL = CLOSE_PRINTER (HANDL1)
         IF (IFAIL.EQ.1) THEN
            CALL PUTADV$(
     +'The plot has been copied to the printer (or file)')                  
         ELSE
            CALL PUTADV$('The printer cannot be closed ... Investigate')
         ENDIF
         ABORT = .FALSE.
         DOTMAT = .FALSE.
         CALL PUTGKS_LGL (N1,
     +                    DOTMAT)          
         HARD_COPY = .FALSE.    
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)         
         PCL = .FALSE. 
         CALL PUTGKS_LGL (N5,
     +                    PCL)         
         PS = .FALSE. 
         CALL PUTGKS_LGL (N6,
     +                    PS)         
         NPRESS = N0
         RETURN
      ELSEIF (DOTMAT) THEN
C
C This should not now be required but is retained for possible future use
C
         ABORT = .FALSE.
         DOTMAT = .FALSE.
         CALL PUTGKS_LGL (N1,
     +                    DOTMAT)         
         HARD_COPY = .FALSE.
         CALL PUTGKS_LGL (N2,
     +                    HARD_COPY)          
         PCL = .FALSE.
         CALL PUTGKS_LGL (N5,
     +                    PCL)         
         PS = .FALSE.  
         CALL PUTGKS_LGL (N6,
     +                    PS)          
         NPRESS = N0
         RETURN
      ENDIF
C
C Close the graphics window and find out which button has been pressed
C
      DOTMAT = .FALSE.
      CALL PUTGKS_LGL (N1,
     +                 DOTMAT)      
      HARD_COPY = .FALSE.    
      CALL PUTGKS_LGL (N2,
     +                 HARD_COPY)      
      META = .FALSE.
      CALL PUTGKS_LGL (N4,
     +                 META)      
      PCL = .FALSE.  
      CALL PUTGKS_LGL (N5,
     +                 PCL)       
      PS = .FALSE.  
      CALL PUTGKS_LGL (N6,
     +                 PS)     
      
      CALL FINISH_4$(NPRESS,
     +               YES)
     
      IF (NPRESS.EQ.22) THEN
C
C PostScript
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP,
     +               'OPEN', FNAME)
         IF (IFAIL.EQ.N0) THEN
            HARD_COPY = .TRUE.     
            CALL PUTGKS_LGL (N2,
     +                       HARD_COPY)             
            PS = .TRUE.
            CALL PUTGKS_LGL (N6,
     +                       PS)             
            ABORT = .FALSE.
            NPRESS = 21
         ELSE
            HARD_COPY = .FALSE. 
            CALL PUTGKS_LGL (N2,
     +                       HARD_COPY)            
            PS = .FALSE. 
            CALL PUTGKS_LGL (N6,
     +                       PS)            
            NPRESS = 0
         ENDIF
      ELSEIF (NPRESS.EQ.23) THEN
C
C PCL printer
C
         IF (.NOT.HARD_COPY .AND. .NOT.PCL) NPRESS = 20
      ENDIF
      END
C
C
