C
C GKSEB4
C ======
C
C Read the introduction to gks004
C
      SUBROUTINE GKSEB4 (L1, L2, L3, L4, M1, M2, M3, M4,
     +                   N1D, N2D, N3D, N4D,
     +                   X1D, X2D, X3D, X4D,
     +                   YH1D, YH3D, YL1D, YL3D, Y1D, Y2D, Y3D, Y4D,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   AXES, GSAVE)
C
C ACTION  : Call GKS as follows :-
C           L = 0 :- no line, etc.
C           M = 0 :- no symbol, etc.
C
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K.
C           MODIFICATION OF GKSEB3 TO DRAW ERROR BARS
C           DISPLAYS :- 2 SETS OF MEANS+/-ERRORS AND 2 BEST-FIT CURVES
C           07/10/1992 CHANGED ARGUMENT LIST TO GKSERB/ALTERED GKSPIC TO GKSTRY
C           12/10/1992 ADDED ICOLOR AND VIDEO AND REMOVED MONO FROM GKSTRY/ERB
C           03/02/1993 simplified and added SAVEIT
C           11/04/1993 Altered to resemble GKS004 and GKST04
C           15/06/1993 Replaced GKSTRY/GKSERB by GKSMRK, GKSBAR AND GKSHOL
C           12/10/1993 DOUBLE PRECISION and replaced GKSPOR by GKSBOX
C           03/03/1997 Win32 version
C           15/12/1997 Altered dimensions to (*)
C           20/11/1998 added call to DEFGKS$ to initialise parameters in
C                      DEFNGKS.INS
C           23/09/1999 Changed definition of PTEXT into PTEXT = PTILE, etc.
C           12/03/2001 introduced SMPLOT$
C           24/08/2001 introduced call to GSCALE$
C           25/10/2004 added XGRID and XHAIRS in call to GKSMNU and GKSBOX
C           21/12/2004 corrected error N1 not N3 in call to GKSBAR with X3,Y3
C           28/06/2006 introduced allocatable arrays 
C           13/04/2007 added INTENTS 
C           14/06/2007 removed defbgks.ins and added DEFGKS$, etc.
C           29/07/2009 added calls to GKSTIC$ and GKSLGL$ 
C           04/08/2009 added calls to GKSCOL$
C           13/08/2009 replaced GSCALE$ by DOAXIS$ and added SIGGKS$
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: L1, L2, L3, L4,
     +                                    M1, M2, M3, M4, 
     +                                    N1D, N2D, N3D, N4D
      DOUBLE PRECISION,    INTENT (IN) :: X1D(*), X2D(*), 
     +                                    X3D(*), X4D(*),
     +                                    YH1D(*), YH3D(*), 
     +                                    YL1D(*), YL3D(*),
     +                                    Y1D(*), Y2D(*),
     +                                    Y3D(*), Y4D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL,             INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C                           
      DOUBLE PRECISION, ALLOCATABLE :: X1(:), X2(:), X3(:), X4(:),
     +                                 Y1(:), Y2(:), Y3(:), Y4(:),
     +                                 YH1(:), YH3(:), YL1(:), YL3(:)
C
C Locals
C    
      INTEGER    ISEND, JSEND, NJCOL, NKCOL, NLGL
      PARAMETER (ISEND = 1, JSEND = 3, NJCOL = 5, NKCOL = 4, NLGL = 7)
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K10, K15
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K10 = 10, K15 = 15)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    KTIC, KTYPE, LCTEMP, NPLOTS, MXTIC, MYTIC
      INTEGER    N1, N2, N3, N4
      INTEGER    ICOL(K4), LN(K4), MK(K4)
      INTEGER    I, IERR, IFAIL, J, JFILES(K4), LFILES(K4), MFILES(K4),
     +           NOUT, NUMBER(K4), NFILES
      INTEGER    NLDGX, NLDGY, NXSIG, NYSIG
      INTEGER    LN1, LN2, LN3, LN4, MK1, MK2, MK3, MK4
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 7)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      DOUBLE PRECISION ONE, PNT25, ZERO
      PARAMETER (ONE = 1.0D+00, PNT25 = 0.25D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION A, B, C, D, FACTOR
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  CIPHER(K4)*40, FILES(K4)*1024, TEXT(10)*100,
     +           TITLES(K4)*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ') 
      LOGICAL    LGLVAR(NLGL)
      LOGICAL    HARD_COPY
      LOGICAL    BARCAP, LOWER, UPPER
      PARAMETER (BARCAP = .TRUE., LOWER = .TRUE., UPPER = .TRUE.)
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      LOGICAL    ABORT, ASCII, FIRST, MONO, PCX, VIDEO
      LOGICAL    BOXIT, FRAME, OFFSET, TEXTS, XGRID, XHAIRS, YGRID
      LOGICAL    XTOINT, YTOINT, YVERT
      LOGICAL    PLOT(K4)
      EXTERNAL   GKSD2S$, MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, GKSMRK$,
     +           GKSBAR$, GKSHOL$, NX2FIL$, NX4FIL$, DEFGKS$, PUTFAT$,
     +           SMPLOT$, DOAXIS$, GKSTIC$, GKSLGL$, GKSCOL$, GKSSIG$
      EXTERNAL   GETGKS_LGL
      EXTERNAL   TRIMC1, LBOX02, GETNOU, DELEET, GETTMP, I1FILE, I2FILE
      INTRINSIC  MAX
C
C Data to confer SAVE and avoid UNDEF
C
      SAVE ICOL, LCTEMP
      DATA ICOL / K0, K0, K0, K0 /
      DATA LCTEMP / K15 /
      DATA NUMPOS / NUMOPT*1 /
C
C Initialise DEFNGKS.INS
C
      CALL DEFGKS$
C
C How many plots and find the minimum and maximum of the X and Y values
C
      KTYPE = K0
      NPLOTS = K0
      PLOT(K1) = .FALSE.
      PLOT(K2) = .FALSE.
      PLOT(K3) = .FALSE.
      PLOT(K4) = .FALSE.
      MXTIC = K4
      MYTIC = K4
      N1 = MAX(N1D, K0)
      NUMBER(K1) = N1
      N2 = MAX(N2D, K0)
      NUMBER(K2) = N2
      N3 = MAX(N3D, K0)
      NUMBER(K3) = N3
      N4 = MAX(N4D, K0)
      NUMBER(K4) = N4
      IF (N1 + N2 + N3 + N4 .EQ. K0) RETURN 
                                              
C
C Allocate workspaces
C     
      IERR = K0  
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YH3)) DEALLOCATE(YH3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YL1)) DEALLOCATE(YL1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YL3)) DEALLOCATE(YL3, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      TITLES(K1) = PTITLE
      TITLES(K2) = XTITLE
      TITLES(K3) = YTITLE
      TITLES(K4) = BLANK
      DO I = K1, K4
         CIPHER(I) = 'Missing'
      ENDDO
      IF (N1.GT.K0 .AND. (L1.GT.K0 .OR. M1.GT.K0)) THEN
         ALLOCATE(X1(N1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y1(N1), STAT = IERR)
         IF (IERR.NE.0) RETURN        
         ALLOCATE(YH1(N1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YL1(N1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K1) = .TRUE.
         CIPHER(K1) = 'Error bars (Save x,y as ASCII ?)'
         CALL GKSD2S$(N1, X1D, X1)
         CALL GKSD2S$(N1, Y1D, Y1)
         CALL GKSD2S$(N1, YH1D, YH1)
         CALL GKSD2S$(N1, YL1D, YL1)
         CALL MAXMIN$(KTYPE, N1, X1, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N1, Y1, YMAX, YMIN)
         KTYPE = K1
         CALL MAXMIN$(K1, N1, YH1, YMAX, YMIN)
         CALL MAXMIN$(K1, N1, YL1, YMAX, YMIN)
      ELSE 
         ALLOCATE(X1(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y1(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN        
         ALLOCATE(YH1(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YL1(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
      ENDIF
      IF (N2.GT.K0 .AND. (L2.GT.K0 .OR. M2.GT.K0)) THEN
         ALLOCATE(X2(N2), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y2(N2), STAT = IERR)
         IF (IERR.NE.0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K2) = .TRUE.
         CIPHER(K2) = 'Line (Save x,y as ASCII ?)'
         CALL GKSD2S$(N2, X2D, X2)
         CALL GKSD2S$(N2, Y2D, Y2)
         CALL MAXMIN$(KTYPE, N2, X2, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N2, Y2, YMAX, YMIN)
         KTYPE = K1  
      ELSE
         ALLOCATE(X2(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y2(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN   
      ENDIF
      IF (N3.GT.K0 .AND. (L3.GT.K0 .OR. M3.GT.K0)) THEN
         ALLOCATE(X3(N3), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y3(N3), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YH3(N3), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YL3(N3), STAT = IERR)
         IF (IERR.NE.0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K3) = .TRUE.
         CIPHER(K3) = 'Error bars (Save x,y as ASCII ?)'
         CALL GKSD2S$(N3, X3D, X3)
         CALL GKSD2S$(N3, Y3D, Y3)
         CALL GKSD2S$(N3, YH3D, YH3)
         CALL GKSD2S$(N3, YL3D, YL3)
         CALL MAXMIN$(KTYPE, N3, X3, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N3, Y3, YMAX, YMIN)
         KTYPE = K1
         CALL MAXMIN$(K1, N3, YH3, YMAX, YMIN)
         CALL MAXMIN$(K1, N3, YL3, YMAX, YMIN)
      ELSE
         ALLOCATE(X3(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y3(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YH3(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(YL3(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN   
      ENDIF
      IF (N4.GT.K0 .AND. (L4.GT.K0 .OR. M4.GT.K0)) THEN
         ALLOCATE(X4(N4), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y4(N4), STAT = IERR)
         IF (IERR.NE.0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K4) = .TRUE.
         CIPHER(K4) = 'Line (Save x,y as ASCII ?)'
         CALL GKSD2S$(N4, X4D, X4)
         CALL GKSD2S$(N4, Y4D, Y4)
         CALL MAXMIN$(KTYPE, N4, X4, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N4, Y4, YMAX, YMIN) 
      ELSE
         ALLOCATE(X4(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(Y4(K1), STAT = IERR)
         IF (IERR.NE.0) RETURN   
      ENDIF
      IF (NPLOTS.EQ.K0) GOTO 80
C
C Find suitable ranges for X and Y axes
C
      CALL DOAXIS$(MXTIC, NLDGX,
     +             XMAX, XMIN) 
      CALL DOAXIS$(MYTIC, NLDGY,
     +             YMAX, YMIN)           
      CALL GKSTIC$(ISEND, MXTIC, MYTIC)
C
C Set default significance
C      
      NXSIG = K2
      NYSIG = K2
      CALL GKSSIG$(ISEND, NLDGX, NXSIG, NLDGY, NYSIG)    
C
C Initialise GKSDEC
C
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      KTIC = K3
      LN(K1) = L1
      LN(K2) = L2
      LN(K3) = L3
      LN(K4) = L4
      MK(K1) = M1
      MK(K2) = M2
      MK(K3) = M3
      MK(K4) = M4
C
C Copy TITLES into TEXT to allow editing
C
      PTEXT = PTITLE
      XTEXT = XTITLE
      YTEXT = YTITLE
      CALL TRIMC1 (PTEXT)
      CALL TRIMC1 (XTEXT)
      CALL TRIMC1 (YTEXT)
C
C Initialise plot style parameters
C
      TEXTS = .FALSE.
      XTOINT = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.
      CALL GKSLGL$(JSEND, NLGL,
     +             LGLVAR)
      BOXIT = LGLVAR(1)      
      FRAME = LGLVAR(2)      
      OFFSET = LGLVAR(3)      
      XGRID = LGLVAR(4)      
      YGRID = LGLVAR(5)      
      XHAIRS = LGLVAR(6) 
      IF (LGLVAR(7)) THEN
         KTIC = K3
      ELSE
         KTIC = K1
      ENDIF           
C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Enquire if default axes are satisfactory
C                                             
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY)      
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, K4, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
      LN1 = LN(K1)
      LN2 = LN(K2)
      LN3 = LN(K3)
      LN4 = LN(K4)
      MK1 = MK(K1)
      MK2 = MK(K2)
      MK3 = MK(K3)
      MK4 = MK(K4)
C
C Call GKSBOX to set up a GKS portrait frame
C
      IF (TEXTS) THEN
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTEXT, XTEXT, YTEXT,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ELSE
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTITLE, XTITLE, YTITLE,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ENDIF
      IF (ABORT) RETURN
C
C Set colours then call GKSMRK to draw lines
C
      LCTEMP = K15
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = K15
            ICOL(1) = K0
            ICOL(2) = K0
            ICOL(3) = K0
            ICOL(4) = K0
         ELSE
            LCTEMP = K0
            ICOL(1) = K15
            ICOL(2) = K15
            ICOL(3) = K15
            ICOL(4) = K15
         ENDIF
      ELSE
         CALL GKSCOL$(JSEND, JCOL, KCOL, NJCOL, NKCOL)
         LCTEMP = JCOL(5)
         ICOL(1) = KCOL(1)
         ICOL(2) = KCOL(2)
         ICOL(3) = KCOL(3)
         ICOL(4) = KCOL(4)
      ENDIF
C
C Call GKSMRK/GKSBAR to draw lines and/or markers and error bars
C
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K1), K1, LN1, MK1, N1,
     +                A, B, C, D, FACTOR, ONE, X1, XMAX, XMIN, Y1, YMAX,
     +                YMIN)
         CALL GKSBAR$(ICOL(K1), K1, K10, N1, 
     +                A, B, C, D, FACTOR, ONE, X1, X1, X1, XMAX, XMIN,
     +                Y1, YH1, YL1, YMAX, YMIN, 
     +                BARCAP, LOWER, UPPER)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K2), K1, LN2, MK2, N2, 
     +                A, B, C, D, FACTOR, ONE, X2, XMAX, XMIN, Y2, YMAX,
     +                YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K3), K1, LN3, MK3, N3, 
     +                A, B, C, D, FACTOR, ONE, X3, XMAX, XMIN, Y3, YMAX,
     +                YMIN)
         CALL GKSBAR$(ICOL(K3), K1, K10, N3, 
     +                A, B, C, D, FACTOR, ONE, X3, X3, X3, XMAX, XMIN,
     +                Y3, YH3, YL3, YMAX, YMIN,
     +                BARCAP, LOWER, UPPER)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K4), K1, LN4, MK4, N4, 
     +                A, B, C, D, FACTOR, ONE, X4, XMAX, XMIN, Y4, YMAX, 
     +                YMIN)
      ENDIF
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K1), K1, LCTEMP, MK1, N1, 
     +                A, C, FACTOR, ONE, X1, XMAX, XMIN, Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K2), K1, LCTEMP, MK2, N2,
     +                A, C, FACTOR, ONE, X2, XMAX, XMIN, Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K3), K1, LCTEMP, MK3, N3,
     +                A, C, FACTOR, ONE, X3, XMAX, XMIN, Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K4), K1, LCTEMP, MK4, N4, 
     +                A, C, FACTOR, ONE, X4, XMAX, XMIN, Y4, YMAX, YMIN)
      ENDIF
C
C LABEL 40
C ========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      IF (ASCII) THEN
C
C LABEL 60
C ========
C
   60    CONTINUE
         WRITE (TEXT,100) (CIPHER(I), I = K1, K4)
         NUMDEC = NUMOPT - K2
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.K1) THEN
            IF (PLOT(K1)) THEN
               CALL NX4FIL$(N1, X1, YL1, Y1, YH1)
               CIPHER(K1) = 'Error bars (Saved *)'
            ELSE
               CALL PUTFAT$('Data set 1 is missing')
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K2) THEN
            IF (PLOT(K2)) THEN
               CALL NX2FIL$(N2, X2, Y2)
               CIPHER(K2) = 'Line (Saved *)'
            ELSE
               CALL PUTFAT$('Data set 2 is missing')
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K3) THEN
            IF (PLOT(K3)) THEN
               CALL NX4FIL$(N3, X3, YL3, Y3, YH3)
               CIPHER(K3) = 'Error bars (Saved *)'
            ELSE
               CALL PUTFAT$('Data set 3 is missing')
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K4) THEN
            IF (PLOT(K4)) THEN
               CALL NX2FIL$(N4, X4, Y4)
               CIPHER(K4) = 'Line (Saved *)'
            ELSE
               CALL PUTFAT$('Data set 4 is missing')
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K5) THEN
            NFILES = K0
            DO I = K1, K4
               IF (PLOT(I)) THEN
                  NFILES = NFILES + K1
                  JFILES(NFILES) = ICOL(I)
                  LFILES(NFILES) = LN(I)
                  MFILES(NFILES) = MK(I)
                  CALL GETTMP (IFAIL, FILES(NFILES))
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FILES(NFILES))
                  WRITE (NOUT,'(A)') 'Temporary file'
                  IF (I.EQ.K1 .OR. I.EQ.K3) THEN
                     CALL I2FILE (NOUT, NUMBER(I), K4)
                  ELSE
                     CALL I2FILE (NOUT, NUMBER(I), K2)
                  ENDIF
                  DO J = K1, NUMBER(I)
                     IF (I.EQ.K1) THEN
                        WRITE (NOUT,'(1P,4E13.5)') X1(J), YL1(J), Y1(J),
     +                                             YH1(J)
                     ELSEIF (I.EQ.K2) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X2(J), Y2(J)
                     ELSEIF (I.EQ.K3) THEN
                        WRITE (NOUT,'(1P,4E13.5)') X3(J), YL3(J), Y3(J),
     +                                             YH3(J)
                     ELSEIF (I.EQ.K4) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X4(J), Y4(J)
                     ENDIF
                  ENDDO 
                  CALL I1FILE (NOUT, K1)
                  WRITE (NOUT,'(A)') 'Temporary file'
                  CLOSE (UNIT = NOUT)
               ENDIF
            ENDDO
            CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES, FILES,
     +                   TITLES)
            DO I = K1, NFILES
               CALL DELEET (FILES(I), ASKIF, THERE)
            ENDDO
            GOTO 60
         ELSEIF (NUMDEC.EQ.K6) THEN
            ASCII = .TRUE.
            GOTO 40
         ELSE
            RETURN
         ENDIF
      ENDIF
      IF (.NOT.ABORT) GOTO 20       
C
C Deallocate
C      
   80 CONTINUE
      DEALLOCATE (X1, STAT = IERR)    
      DEALLOCATE (X2, STAT = IERR)
      DEALLOCATE (X3, STAT = IERR)
      DEALLOCATE (X4, STAT = IERR)
      DEALLOCATE (Y1, STAT = IERR)
      DEALLOCATE (Y2, STAT = IERR)
      DEALLOCATE (Y3, STAT = IERR)
      DEALLOCATE (Y4, STAT = IERR)
      DEALLOCATE (YH1, STAT = IERR)
      DEALLOCATE (YH3, STAT = IERR)
      DEALLOCATE (YL1, STAT = IERR)
      DEALLOCATE (YL3, STAT = IERR)
C
C Format statement
C      
  100 FORMAT (
     + 'Data 1: ',A
     +/'Data 2: ',A
     +/'Data 3: ',A
     +/'Data 4: ',A
     +/'Advanced editing'
     +/'Return to default graph'
     +/'Cancel')
      END
C
C

