C
C
       SUBROUTINE GKSF2B$(NGROUP, NIN,
     +                    FNAME,
     +                    ABORT, SUPPLY_XY)
C
C ACTION : Transform a matrix file into a barchart file
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 7/12/98
C          09/04/1999 Changed mechanism for adding error bars so errors
C                     can be stored in a separate file
C          25/06/2000 closed down FNAME while reading in errors
C          29/05/2001 edited to allow A(i,j) < 0
C          01/06/2001 added SUPPLY_XY
C          18/12/2001 checked for box and whisker plot
C          14/10/2004 extensive revision
C          19/04/2007 added INTENTS and GETWRD
C          01/12/2010 added PANELS to argument list to LABELS
C          23/04/2011 increased dimension to 20
C          06/07/2011 added WORDX and VECTORS in call to LABELS   
C
C          NGROUP: (output) no. of bars per group
C             NIN: (input/unchanged) unconnected unit for data input
C           FNAME: (input/output) returned as the file with data for plotting
C           ABORT: (output) set .true. on error o/w .false.
C       SUPPLY_XY: (input/unchanged) value as supplied to GKSGRF$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN 
      INTEGER,             INTENT (OUT)   :: NGROUP
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (IN)    :: SUPPLY_XY 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    I, ICOUNT, IOS, J, JCOUNT, NCOLS, NIN1, NOUT1, NROWS
      INTEGER    IFILL, IHUE
      INTEGER    NCMAX, NRMAX, N0, N1, N2, N9, N10, N20, N21, N60, 
     +           N71
      PARAMETER (NCMAX = 20, NRMAX = 500, N0 = 0, N1 = 1, N2 = 2,
     +           N9 = 9, N10 = 10, N20 = 20, N21 = 21, N60 = 60,
     +           N71 = 71)
      INTEGER    JCOLOR(N20), JFILL(N20)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0, NSTART = 18,
     +           NUMOPT = 4, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    NTYPE, NUMDEC, NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NRMAX), E(NRMAX,NCMAX), ERROR
      DOUBLE PRECISION X, XTEMP, Y1, Y2, Y3, Y4, Y5, F, W, C
      DOUBLE PRECISION ZERO, ONE, TWO, TEN, F71
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00, F71 = 71.0D+00)
      CHARACTER  FNAME1*1024, LINE*100, TITLE1*100, TNAME*1024
      CHARACTER  TEXT1(NTEXT)*80, TEXT(N20)*40, PANELS(N20)*40,
     +           WORDX(N20)*40, VECTORS(N60)*40 
      CHARACTER  WORDS(NRMAX)*40
      CHARACTER  STAR*11
      PARAMETER (STAR = '*bars/group')
      LOGICAL    OK, THERE
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .TRUE., FIXROW = .TRUE., LABEL = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT$, PUTADV$
      EXTERNAL   GETNOU, GETTMP, LABELS, LBOX01, MATTIN, GETWRD
      INTRINSIC  SQRT, DBLE, ABS, NINT, INDEX
      DATA       NUMPOS / NUMOPT*0 /
      DATA       NUMBLD / NTEXT*0 /   
C
C Initialise, open files then check the matrix file supplied
C
      ABORT = .TRUE. 
      NGROUP = N0
      CLOSE (UNIT = NIN)
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (.NOT.THERE) RETURN
      OPEN (UNIT = NIN, FILE = FNAME)
      CALL GETTMP (I,
     +             TNAME)
      CALL GETNOU (NOUT1)
      OPEN (UNIT = NOUT1, FILE = TNAME)
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 20
      ICOUNT = ICOUNT + N1
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.N0) GOTO 20
      IF (I.LT.N1) THEN
         CALL PUTFAT$('No. of groups requested < 1')
         GOTO 20
      ELSEIF (I.GT.NRMAX) THEN
         CALL PUTFAT$('No. of bars requested > 500')
         GOTO 20
      ENDIF
      IF (J.LT.N1) THEN
         CALL PUTFAT$('Group size requested < 1')
         GOTO 20
      ELSEIF (J.GT.NCMAX) THEN
         CALL PUTFAT$('Group size requested > 20')
         GOTO 20
      ENDIF
C
C So far so good ... define NCOLS, NROWS then check the data
C
      NROWS = I
      NCOLS = J
      DO I = N1, NROWS
         ICOUNT = ICOUNT + N1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) (A(I,J), J = N1, NCOLS)
         IF (IOS.NE.0) GOTO 20
      ENDDO
C
C Close down main file now to check or while errors are read in
C
      CLOSE (UNIT = NIN)
C
C Is it a proper bar chart file ?
C
      IF (NCOLS.EQ.N9) THEN
         XTEMP = A(1,1)
         OK = .TRUE.
         I = N0
         DO WHILE (OK .AND. I.LT.NROWS)
            I = I + N1
            X = A(I,1)
            Y1 = A(I,2)
            Y2 = A(I,3)
            Y3 = A(I,4)
            Y4 = A(I,5)
            Y5 = A(I,6)
            F = A(I,7)
            W = A(I,8)
            C = A(I,9)
            IF (X.LT.XTEMP) THEN
               OK = .FALSE.
            ELSEIF (Y1.GT.Y2) THEN
               OK = .FALSE.
            ELSEIF (Y2.GT.Y3) THEN
               OK = .FALSE.
            ELSEIF (Y3.GT.Y4) THEN
               OK = .FALSE.
            ELSEIF (Y4.GT.Y5) THEN
               OK = .FALSE.
            ELSEIF (F.LT.ZERO .OR. F.GT.TEN) THEN
               OK = .FALSE.
            ELSEIF (W.LT.ZERO .OR. W.GT.ONE) THEN
               OK = .FALSE.
            ELSEIF (C.LT.ZERO .OR. C.GT.F71) THEN
               OK = .FALSE.
            ENDIF
            XTEMP = X
         ENDDO
         IF (OK) THEN
C
C File seems to be OK so write the data to the temporary file
C
            NGROUP = N1
            ABORT = .FALSE.
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)') LINE
            WRITE (NOUT1,'(A)') LINE
            READ (NIN,*) NROWS, NCOLS
            WRITE (NOUT1,'(2I6)') NROWS, NCOLS
            DO I = N1, NROWS
               READ (NIN,*) (A(I,J), J = 1, 9)
               WRITE (NOUT1,200) (A(I,J), J = 1, 6),
     +                            NINT(A(I,7)), A(I,8), NINT(A(I,9))
            ENDDO
C
C See if the file has labels appended
C             
            CLOSE (UNIT = NIN)
            CALL GETWRD (N1, NCOLS, NIN, NROWS, NRMAX,
     +                   FNAME, WORDS) 
            CLOSE (UNIT = NIN) 
            WRITE (NOUT1,'(I6)') NROWS 
            DO I = N1, NROWS  
               WRITE (NOUT1,'(A)') WORDS(I)
            ENDDO  
            CLOSE (UNIT = NOUT1)   
C
C Check if last label defines no. of bars per group
C                 
            LINE = WORDS(NROWS) 
            I = INDEX(LINE, STAR)
            IF (I.GT.N1) THEN
               READ (LINE(1:I - 1),*,IOSTAT=IOS) J
               IF (IOS.EQ.N0) THEN
                  IF (J.GE.N1 .AND. J.LE.NROWS) NGROUP = J
               ENDIF
            ENDIF
C
C Set FNAME = TNAME, then return
C
            FNAME = TNAME
            RETURN
         ENDIF
      ENDIF
C
C The file is not a consistent 9 column barchart file so set NGROUP = NCOLS
C
      NGROUP = NCOLS
C
C The matrix is consistent so ask about error bars
C
      IF (SUPPLY_XY) THEN
         NTYPE = N1
      ELSE
         WRITE (TEXT1,100)
         NUMBLD(1) = N1
         NUMDEC = N1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT1,
     +                BORDER, FLASH, HIGH)
         NTYPE = NUMDEC
      ENDIF
      IF (NTYPE.EQ.4) THEN
         CALL GETNOU (NIN1)
         CLOSE (UNIT = NIN1)
         CALL PUTADV$('Now input the matrix of errors')
         CALL MATTIN (ISEND, NCMAX, NCOLS, NIN1, NRMAX, NROWS,
     +                E, B,
     +                FNAME1, TITLE1,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN1)
         IF (ABORT) THEN
            CALL PUTFAT$('No error bars will be created')
            DO J = N1, NCOLS
               DO I = N1, NROWS
                  E(I,J) = ZERO
               ENDDO
            ENDDO
         ELSE
            ICOUNT = N2
            DO I = N1, NROWS
               ICOUNT = ICOUNT + N1
               DO J = N1, NCOLS
                  IF (E(I,J).LT.ZERO) THEN
                     CALL PUTFAT$('Negative value encountered')
                     GOTO 20
                  ENDIF
               ENDDO
            ENDDO
         ENDIF
      ENDIF
C
C The matrix is consistent so get the defaults then write to the new file
C
      CALL LABELS (N1, JCOLOR, JFILL,
     +             TEXT, PANELS, WORDX, VECTORS) 
      WRITE (NOUT1,'(A)') LINE
      WRITE (NOUT1,'(2I6)') NROWS*NCOLS, N9
      JCOUNT = N0
      DO I = N1, NROWS
         DO J = N1, NCOLS
            JCOUNT = JCOUNT + N1
            IF (J.LE.N20) THEN
               IFILL = JFILL(J)
               IHUE = JCOLOR(J)
            ELSEIF (J.EQ.N21) THEN
               IFILL = N1
               IHUE = N0
            ELSE
               IFILL = IFILL + N1
               IF (IFILL.GT.N10) IFILL = N1
               IHUE = IHUE + N1
               IF (IHUE.GT.N71) IHUE = N0
            ENDIF
            IF (NTYPE.EQ.1) THEN
               ERROR = ZERO
            ELSEIF (NTYPE.EQ.2) THEN
               ERROR = SQRT(ABS(A(I,J)))
            ELSEIF (NTYPE.EQ.3) THEN
               ERROR = TWO*SQRT(ABS(A(I,J)))
            ELSEIF (NTYPE.EQ.4) THEN
               ERROR = E(I,J)
            ENDIF
            IF (A(I,J).GE.ZERO) THEN
               WRITE (NOUT1,200) DBLE(JCOUNT), ZERO, ZERO, ZERO,
     +                           A(I,J),
     +                           A(I,J) + ERROR, IFILL, ONE, IHUE
            ELSE
               WRITE (NOUT1,200) DBLE(JCOUNT), A(I,J) - ERROR,
     +                           A(I,J),
     +                           ZERO, ZERO, ZERO, IFILL, ONE, IHUE
            ENDIF
         ENDDO
         JCOUNT = JCOUNT + N1
      ENDDO
C
C Now re-open the main file to read the labels
C                       
                 
      CLOSE (UNIT = NIN)
      CALL GETWRD (N1, NCOLS, NIN, NROWS, NRMAX,
     +             FNAME, WORDS) 
      CLOSE (UNIT = NIN) 
C
C Append the labels
C      
      WRITE (NOUT1,'(I6)') NROWS*NCOLS 
      DO I = N1, NROWS  
         WRITE (NOUT1,'(A)') WORDS(I)
      ENDDO  
      DO I = NROWS + N1, NROWS*NCOLS
         WRITE (NOUT1,300) NGROUP
      ENDDO
      CLOSE (UNIT = NOUT1)
      FNAME = TNAME
      ABORT = .FALSE.
      FNAME = TNAME
      IF (.NOT.SUPPLY_XY) CALL PUTADV$(
     +'A temporary barchart type file has been created')
      NGROUP = NCOLS
      ABORT = .FALSE.
      RETURN
C
C LABEL 20: Here only if a crash has occurred
c =========
C
   20 CONTINUE
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT1)
      WRITE (LINE,400) ICOUNT
      CALL PUTFAT$(LINE)
      ABORT = .TRUE.          
C
C Format statements
C      
  100 FORMAT (
     + 'Methods for adding error bars to the barchart'
     +/
     +/'If you select no error bars you can still edit your data to'
     +/'add individual error bars from the [Data] option if required'
     +/
     +/'If the data are Poisson counts you can add 1 or 2 square roots'
     +/'of the values to generate error bars. Adding 2*sqrt(X) to X'
     +/'gives an approx. 95% conf. limit for many counting processes,'
     +/'e.g. if X is the no. of cells in apoptosis in a section.'
     +/
     +/'You can also use the values estimated by SIMFIT. For example,'
     +/'if you have means and variance estimates, you can put mean'
     +/'values in a first matrix and error bar estimates (such as a'
     +/'t-percent(nu)*standard-error-of-mean, for instance) in a second'
     +/'matrix, so that error bars can be created by adding elements'
     +/'of the second matrix to elements of the first matrix.'
     +/
     +/'No error bars to be plotted'
     +/'Use 1*sqrt(X) for error bars'
     +/'Use 2*sqrt(X) for error bars'
     +/'Use errors from a matrix file')
  200 FORMAT (1P,6E11.3,I6,E11.3,I6)
C
C Note to editors/programmers/translators
C The I2,'* part of this next format must not be changed
C
  300 FORMAT (I2,'*bars/group')
  400 FORMAT ('Check file at line',I6)
      END
C
C
