
C
C GKSGRF : The main plotting subroutine
C
      
      SUBROUTINE GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M,
     +                   NFILE1, NGRAFS, NIN, NMAX, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE,
     +                   FSAV, FSAV1, LABELS, LABVEC, PLINE,
     +                   PSYMB, TSAV, TITLES, WORDX, WORDY,
     +                   BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +                   PIE_CHART, PLOTX, PLOTY, PLOTZ,
     +                   PSHOW, SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +                   VECTOR_FIELD, YAXIS)
      
      USE MODULE_SAVEGKS, ONLY : NMAX1,
     +                           X, XH, XHT, XL, XLT, XT,
     +                           Y, YH, YHT, YL, YLT, YT

C
C ACTION : Call GKS to make a plot
C
C ADVICE : This version is protected against clipping if calculation
C          pushes XPANEL or YPANEL outside the range XMIN, XMAX, YMIN, YMAX
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Added code for lower information panel 6/12/93
C          25/01/1994 Saved everything except big arrays to allow recall
C          04/08/1995 Added TWO_PLOTS
C          03/10/1995 Added ROTATE
C          30/07/1996 Added ISHAPE
C          08/08/1996 Added LIB_FILE
C          11/09/1996 Added new arguments for rotating text etc.
C          20/09/1996 Extensively edited for clarity and versatility
C                     and to ensure all arrays are dimensioned externally
C          30/09/1996 Added PLOT_TITLE
C          03/10/1996 Aded CENTRE
C          04/11/1996 Added XCLIP, YCLIP
C          11/12/1996 Changed dimensions of ARRAYT etc.
C          20/02/1997 Added BARCAP_1
C          14/07/1997 win32 version ... colours are defined as parameters
C          28/11/1997 Revised to allow movement by mouse
C          12/12/1997 added objects for GKSOBJ$
C          04/02/1998 Altered logic so call to LIBFIL first. If failed then
C                     carry on to PFILES with NFILES = 0 but with filename
C                     retained.
C          10/09/1998 added FSAV1
C          06/10/1998 made sure NIN closed after reading in files
C          11/10/1998 added TYPE_IN
C          09/12/1998 Added NGROUP
C          22/07/1999 re-dimensioned XTITLE, etc. for extended transformation
C          08/01/2000 added NFILE1 to argument list
C          01/02/2000 changed NATLOG to an array to control log axes
C          19/02/2000 added DRAGTI, DRAGXL, DRAGYL, DRAGZL, PCENTX, PCENTY,
C                     PCENTZ
C          23/02/2000 added PHIGHX, PHIGHY, PHIGHZ
C          25/10/2000 added QTITLE
C          28/10/2000 extensive revision
C          05/03/2001 added SUPPLY_XY and SUPPXY for calls from SMPLOT$
C          12/03/2001 added TITLES
C          28/05/2001 added SUPPLY_XY to PIEFIL$ for calls from PCPLOT$
C          01/06/2001 added SUPPLY_XY for BAR_CHART = .TRUE.
C          20/07/2001 added DENDRO_GRAM and SHOW_XAXIS
C          10/08/2001 added BRAY_CURTIS and PLOT_LABELS
C          15/08/2001 added MXDROP and YDROP
C          08/09/2001 added FACTOR to call to GKSPLT and THREE_D
C          07/01/2003 redimensioned WIDE(5*NGRAFS) as follows:-
C                     WIDE(I) = line width
C                     WIDE(NGRAFS + I) = error bar line width
C                     WIDE(2*NGRAFS + I) = symbol/marker line width
C          16/01/2003 removed the call to LOOP02$ and other editing
C          25/01/2003 restored the call to LOOP02$
C          17/11/2003 added call to ISOLAT$
C          03/12/2003 set NCT = NCX = NCY = NCZ = 80
C          09/05/2004 added call to PLOTYN$
C          15/10/2004 added call to SYMBOL on exit to store plot parameters
C          21/10/2004 added SHOW_BACKGROUND and SHOW_QUADRANTS
C          12/11/2004 set NKCOL = 12 and deleted call to SYMBOL
C          11/07/2005 made sure maximum no. labels from f$labels.tmp =< NWORDS
C                     and used LABEL/LABVEC instead of WORDX/WORDY for plotting c
C          19/08/2005 added EXTEND_LINES
C          12/09/2006 added call to GKSVF5 for vector_field and bi_plot
C          09/05/2007 added INTENTS 
C          05/06/2007 added LABFIL, VFFILE, and SIM256
C          20/12/2007 added XLABEL to control MXTIC = -1 and suppress X-label editing
C          24/12/2007 added ADJLAB$ to adjust plot labels and added %no_labels% 
C          11/01/2008 added JKOLOR for label colours and NXTRA/NXTRA1 for biplots
C          28/01/2008 transferred X, ..., YT to MODULE_SAVEGKS and introduced GKSSAV$ 
C          20/10/2008 added extra calls to PLTOBJ$ for background objects
C          31/10/2008 moved call to PLTOBJ$ for background objects to plot before axes, title, etc.
C          03/10/2010 added SUPPYZ$ to deal with data supplied in TWO_PLOT format 
C          02/12/2010 replaced SAVGKS$ by SAVLGL$ and increased NKCOL to 15
C          21/12/2010 added call to ISOLAT$ for ZTITLE
C          28/12/2010 added calls to SAVCHR$ for character vectors
C          07/02/2011 added initialisation of PANEL_1 and SIDE_1 after call to GKSSTY$
C          11/02/2011 added PANEL_LINES and PANEL_SYMBOLS 
C          24/04/2011 increased NKCOL to 20
C          17/06/2011 calls PLTOBJ$ with ISEND = 7 for intermediate layering of arrows/symbols
C          27/05/2013 added code to check for begin{vfield} ... end{vfield} when VECTOR_FIELD = .TRUE.
C          25/08/2016 added code to read an extra file when BAR_CHART = .TRUE. and NFILE1 = 2 
C
      IMPLICIT   NONE 
C
C Integers in argument list.............................................
C                                                        
      INTEGER, INTENT (IN)    :: KPANEL, NGRAFS, NIN, NWORDS, NXTRA 
      INTEGER, INTENT (INOUT) :: NMAX
      INTEGER, INTENT (INOUT) :: NFILE1, IFILL(NXTRA), IHUE(NXTRA),
     +                           JCOLOR(NGRAFS), L(NGRAFS), M(NGRAFS),
     +                           NSAV(NGRAFS)
C
C Double precisions in argument list...................................
C
      DOUBLE PRECISION, INTENT (INOUT) :: FACTOR(NXTRA), SIZE(NGRAFS),
     +                                    WIDE(5*NGRAFS)
C
C Characters in argument list..........................................
C
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NGRAFS), 
     +                                       FSAV1(NGRAFS),
     +                                       LABELS(NWORDS),
     +                                       LABVEC(NWORDS),
     +                                       PLINE(KPANEL), 
     +                                       PSYMB(KPANEL),
     +                                       TSAV(NGRAFS),
     +                                       TITLES(4),
     +                                       WORDX(NWORDS),
     +                                       WORDY(NWORDS) 
C
C Logicals in argument list............................................
C
      LOGICAL, INTENT (INOUT) :: BAR_CHART, PIE_CHART, SUPPLY_XY,
     +                           TYPE_IN, VECTOR_FIELD 
      LOGICAL, INTENT (INOUT) :: BARCAP(NGRAFS), BARCAP_1, LIB_FILE,
     +                           LOWER(NGRAFS), PLOTX(NWORDS),
     +                           PLOTY(NWORDS), PLOTZ(NWORDS),
     +                           PSHOW(KPANEL), TWO_PLOTS, 
     +                           UPPER(NGRAFS), YAXIS(NGRAFS)                   
C
C Parameters from DLL in common block in DEFNGKS.INS...................
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
C
C Integer parameters and local arrays and scalars.......................
C
      INTEGER    NPIE
      PARAMETER (NPIE = 100)
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K9, K11, K15, K71
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K9 = 9, K11 = 11, K15 = 15, K71 = 71)
      INTEGER    NCT, NCX, NCY, NCZ
C*****Increased size of title and legends 25/11/2000
C*****PARAMETER (NCT = 50, NCX = 55, NCY = 41, NCZ = 41)
C*****PARAMETER (NCT = 80, NCX = 70, NCY = 55, NCZ = 55)
C*****Increased size of title and legends 03/12/2003
      PARAMETER (NCT = 80, NCX = 80, NCY = 80, NCZ = 80)
      INTEGER    NCLIP, NKCOL, NLOG
      PARAMETER (NCLIP = 2, NKCOL = 20, NLOG = 12)
      INTEGER    MODE2, NWMAX
      PARAMETER (MODE2 = 2, NWMAX = 2000)
      INTEGER    JKOLOR(NWMAX), KCOLOR(NKCOL)
      INTEGER    ICOLOR, LCOLOR, LCTEMP, MCOLOR
      INTEGER    KANGLE, KTIC, MXDROP, MXTIC, MYTIC, MZTIC
      INTEGER    IFONT, NCFONT, NFONT_PS, NTFONT, NXFONT, NYFONT
      INTEGER    MTRANS, NBARS, NFILES, NGROUP, NPTS, NPTSAV, NT, NTYPE
      INTEGER    MTSAV, NFSAV, NPLOTS
      INTEGER    IPANEL, NPANEL
      INTEGER    ISHAPE, NPRESS
      INTEGER    I, IOS, ISEND, J, K, NCOL, NROW, NTYPE1, NTYPE2,
     +           NTYPE3, NY, NZ
      INTEGER    NBAR_1, NGROUP_1, NPTS_1
C
C Double precision parameters and local arrays and scalars..............
C
      DOUBLE PRECISION ZERO, ONE, TWO, PNT5, PNT85, XBIG
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           PNT5 = 0.5D+00, PNT85 = 0.85D+00, XBIG = 1.0D+300)
      DOUBLE PRECISION HSIZE
      PARAMETER (HSIZE = 0.005D+00)
      DOUBLE PRECISION ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL
      DOUBLE PRECISION A, B, C, CZ, D, DZ, PSCALE, THICK, ZSCALE
      DOUBLE PRECISION SPC, SPT, SPX, SPY, XMAX, XMIN
      DOUBLE PRECISION XPC, XPMAX, XPMIN, XPT, XPX, XPY, YMAX, YMIN,
     +                 YSCALE
      DOUBLE PRECISION YMAX1, YMAX3, YMAX4, YMIN1, YMIN3, YMIN4, ZMAX,
     +                 ZMAX1, ZMIN, ZMIN1
      DOUBLE PRECISION XPANEL(2), XPDRAG, YPANEL(2), YPDRAG
      DOUBLE PRECISION XSTART
      DOUBLE PRECISION XDIFF
      DOUBLE PRECISION YDELTA, YDIFF, YPDIFF
      DOUBLE PRECISION YPCHT, YPMAX, YPMIN, YPXTRA
      DOUBLE PRECISION XCOORD, YCOORD, YDROP, ZCOORD
      DOUBLE PRECISION SLANT, XTEMP, YTEMP
      DOUBLE PRECISION XCLIP(NCLIP), YCLIP(NCLIP)
      DOUBLE PRECISION BARVAL(9)
      DOUBLE PRECISION RADIUS
      DOUBLE PRECISION X_SVG, Y_SVG
C
C Local characters.....................................................
C
      CHARACTER  PTITLE(0:15)*(NCT), QTITLE*(NCT), XTITLE(0:15)*(NCX),
     +           YTITLE(0:15)*(NCY), ZTITLE(0:15)*(NCZ),
     +           ZTITLE_1*(NCZ)
      CHARACTER  ARRAYQ*(NCT), ARRAYT(0:15)*(NCT), ARRAYX(0:15)*(NCX),
     +           ARRAYY(0:15)*(NCY), ARRAYZ(0:15)*(NCZ),
     +           ARRAYZ_1*(NCZ)
      CHARACTER  LABSAV*40, LINE*80, FNAME*1024, TITLE*80  
      CHARACTER  ADJLAB*1024, LABFIL*1024, SIM256*1024, VFFILE*1024
      CHARACTER  BLANK, NO_LABELS*11
      PARAMETER (BLANK = ' ', NO_LABELS = '%no_labels%')
      CHARACTER  CHOP80*80
C
C Local logicals........................................................
C
      LOGICAL    ACTIVE_SVG, OFFSET_SVG
      LOGICAL    ABORT, BORDER, BOXIT, FIRST, FRAME, GRATICULE, MONO,
     +           OFFSET, ROTATE
      LOGICAL    PANEL, SIDE, SWAP_YZ, VIDEO, XTOINT, YTOINT, ZTOINT
      LOGICAL    NATLOG(NLOG), POWERX, POWERY, POWERZ, XGRID, YGRID,
     +           YVERT
      LOGICAL    DOUGH_NUT, POWERX_1, POWERY_1, POWERZ_1
      LOGICAL    BRAY_CURTIS, DENDRO_GRAM, EXTEND_LINES, PLOT_LABELS,
     +           SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +           SHOW_YAXIS, SHOW_ZAXIS, THREE_D
      LOGICAL    MONO_SAV, VIDEO_SAV, YES
      LOGICAL    BI_PLOT, CENTRE, NUMBRX, PLOT_TITLE, STORE, THERE,
     +           VEC_FIELD
      LOGICAL    XLABEL
      LOGICAL    PCENTX, PCENTY, PCENTZ
      LOGICAL    PHIGHX, PHIGHY, PHIGHZ
      LOGICAL    IWARNU
      LOGICAL    ASKIF, GSAVE, MONO_CHROME
      PARAMETER (ASKIF = .FALSE., GSAVE = .TRUE., MONO_CHROME = .FALSE.)
      LOGICAL    DFOLT_1, BAR_1, PANEL_1, PANEL_LINES, PANEL_SYMBOLS,
     +           PIE_1, SIDE_1, WIDE_PANEL  
C
C Externals............................................................
C
      EXTERNAL   GSLN$, GSLWSC$, PUTFAT$, INIT_1$, SAVEMN$, SAVEXY$,
     +           SAVEIT$, SAVEOB$, PUTADV$, GKSSTY$, GKSPLT$, DECGKS$,
     +           GKSFIL$, WGBFNT$, LOOP01$, LOOP02$, LOOP03$, GETDEF$,
     +           DEFOLT$, PFILES$, PANELS$, BCKEYS$, PLTOBJ$, LIBFIL$,
     +           PIEFIL$, PCKEYS$, TYPEIN$, TYPEPC$, TYPEPF$, SAVE11$,
     +           SUPPXY$, GKSF2B$, PLTLAB$, ISOLAT$, PLOTYN$, SAVLGL$,
     +           GKSSAV$, SUPPYZ$, SAVCHR$, SAVINT$, SAVEDN$
      EXTERNAL   COPYFL, CHOP80, GKSVF5, GETWRD, ISITMF, SIM256, DELEET
      EXTERNAL   CLOSE_GR_WINDOWS
      EXTERNAL   SVGPAR
C
C Intrinsics...........................................................
C
      INTRINSIC  MIN, MAX, NINT, DBLE
C
C Integers that must be saved between calls.............................
C
      SAVE       ICOLOR, IPANEL, ISHAPE, KANGLE, KCOLOR, KTIC, LCOLOR,
     +           LCTEMP, MTRANS, MTSAV, MXTIC, MYTIC, MZTIC, NBARS,
     +           NCFONT, NFILES, NFSAV, NGROUP, NPANEL, NPTS, NT,
     +           NTFONT, NTYPE, NXFONT, NYFONT
C
C Reals that must be saved between calls...............................
C
      SAVE       ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +           A, B, C, CZ, D, DZ, OFFSET_SVG, PSCALE, THICK, ZSCALE,
     +           SPC, SPT, SPX, SPY, XCLIP, XMAX, XMIN,
     +           XPC, XPMAX, XPMIN, XPT, XPX, XPY, YCLIP, YMAX, YMIN,
     +           YSCALE, YMAX1, YMAX3, YMAX4, YMIN1, YMIN3, YMIN4,
     +           XPANEL, XPDRAG, YPANEL, YPDRAG,
     +           XSTART, XDIFF,
     +           YDELTA, YDIFF, YPDIFF,
     +           YPCHT, YPMAX, YPMIN, YPXTRA,
     +           ZMAX, ZMIN
C
C Characters that must be saved between calls...........................
C
      SAVE       PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +           ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ
C
C Logicals that must be saved between calls............................
C
      SAVE       ABORT, BORDER, BOXIT, FIRST, FRAME, GRATICULE, MONO,
     +           OFFSET, PANEL, SIDE, SWAP_YZ, VIDEO, XTOINT, YTOINT,
     +           ZTOINT, NATLOG, XGRID, YGRID, YVERT, PLOT_TITLE,
     +           CENTRE, MONO_SAV, NUMBRX, POWERX, POWERY, POWERZ,
     +           VIDEO_SAV, YES, ROTATE, PCENTX, PCENTY, PCENTZ,
     +           PHIGHX, PHIGHY, PHIGHZ 
      DATA       FIRST / .TRUE. /
C
C Define VIDEO/MONO
C
      DATA MONO, VIDEO / .FALSE., .FALSE. /
      DATA MONO_SAV, VIDEO_SAV / .FALSE., .FALSE. /  
C
C Call CLOSE_GR_WINDOWS 
C      
      CALL CLOSE_GR_WINDOWS
C      
C Allocate workspace in MODULE_SAVEGKS and define parameters in MODULE_CLEARWIN 
C      
      CALL GKSSAV$(K1, K1,
     +             ABORT)
      IF (ABORT) RETURN
      IF (PIE_CHART) THEN
         PIE_1 = .TRUE.
         IF (NMAX.LT.NPIE) NMAX = NPIE
         STORE = .FALSE.
         CALL SAVEDN$(RADIUS,
     +                DOUGH_NUT, STORE)
         DOUGH_NUT = .FALSE.
         STORE = .TRUE. 
         CALL SAVEDN$(RADIUS,
     +                DOUGH_NUT, STORE)         
      ELSE
         PIE_1 = .FALSE.
      ENDIF        
      CALL GKSSAV$(K2, NMAX,
     +             ABORT)  
      IF (ABORT) RETURN 
      STORE = .TRUE.  
      CALL SAVLGL$(K3, PIE_1,    
     +             STORE) 
      IF (BAR_CHART) THEN
         BAR_1 = .TRUE.
      ELSE
         BAR_1 = .FALSE.
      ENDIF 
      CALL SAVLGL$(K4, BAR_1,    
     +             STORE)      
C
C Define the labels files and default label colors
C                   
      IF (VECTOR_FIELD) THEN
         LABSAV = LABELS(1)
      ELSE
         LABSAV = BLANK
      ENDIF      
      ADJLAB = SIM256('f$rotate.tmp')
      LABFIL = SIM256('f$labels.tmp')             
      VFFILE = SIM256('f$vfield.tmp')
      IF (JCOLOR(1).LT.K0 .OR. JCOLOR(1).GT.K71) THEN 
         JCOLOR(1) = K0
         DFOLT_1 = .TRUE.
      ELSE
         DFOLT_1 = .FALSE.
      ENDIF  
      STORE = .TRUE.
      CALL SAVLGL$(K11,
     +             DFOLT_1, STORE)      
C
C Retrieve XLABEL 
C      
      STORE = .FALSE.
      CALL SAVLGL$(K2, 
     +             XLABEL, STORE)    
C
C Inintialise NBARS, NGROUP, BI_PLOT, and VEC_FIELD
C
      NBARS = 1
      NGROUP = 1 
      IWARNU = .TRUE. 
     
      BI_PLOT = .FALSE.
      VEC_FIELD = VECTOR_FIELD
C
C Set initial values for the text/arrow dragging data..................
C
      STORE = .TRUE.
      I = 0
      CALL SAVEIT$(I,
     +             STORE)
      CALL SAVEOB$(I,
     +             STORE)
      J = 0
      CALL SAVEMN$(I, J,
     +             STORE)
      XMAX = ONE
      XMIN = ZERO
      CALL SAVEXY$(XMIN, XMAX,
     +             STORE)
C
C First time set up all defaults, o/w set up critical ones ............
C
      ZMAX = ONE
      ZMIN = ZERO
      CALL DEFOLT$(ISHAPE, KANGLE, KCOLOR, KPANEL, LCOLOR,
     +             MTRANS, MTSAV, MXDROP, MXTIC, MYTIC, MZTIC,
     +             NCFONT, NFILES, NFSAV, NGRAFS, NKCOL,
     +             NLOG, NTFONT, NTYPE1, NTYPE2, NTYPE3, NWORDS, NXFONT,
     +             NY, NYFONT, NZ,
     +             DRAGTI, DRAGXL, DRAGYL, DRAGZL, PSCALE, SIZE, SPC,
     +             SPT, SPX, SPY, THICK, WIDE,
     +             XCLIP, XPC, XPDRAG, XPMAX, XPMIN, XPT, XPX, XPY,
     +             YCLIP, YDROP, YMAX3, YMAX4, YMIN3, YMIN4, YPDRAG,
     +             YPMAX, YPMIN, YSCALE, ZSCALE,
     +             ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ, 
     +             PTITLE, QTITLE,
     +             WORDX, WORDY, XTITLE, YTITLE, ZTITLE,
     +             BAR_CHART, BORDER, BRAY_CURTIS, CENTRE,
     +             EXTEND_LINES, GRATICULE,
     +             MONO, MONO_SAV, NATLOG, NUMBRX,
     +             PANEL_LINES, PANEL_SYMBOLS, 
     +             PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY, PHIGHZ,
     +             PIE_CHART, PLOT_LABELS, PLOT_TITLE, PLOTX, PLOTY,
     +             PLOTZ, POWERX, POWERY, POWERZ, PSHOW, ROTATE,
     +             SHOW_BACKGROUND, SHOW_QUADRANTS,
     +             SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS, SWAP_YZ, THREE_D,
     +             TWO_PLOTS, VIDEO, VIDEO_SAV, XGRID, XTOINT, YGRID,
     +             YTOINT, YVERT, ZTOINT)
C
C Parameters: FNAME = BLANK to make GKSFIL$ open a file
C =========== NFILES = 0 to force library file or the loop
C             LIB_FILE = .FALSE. since decision not now made previously (commented out 24/08/2018)
C             YES = .FALSE. so only repeat if not a library file
C
      STORE = .TRUE.
      CALL SAVLGL$(K6,
     +             PANEL_LINES, STORE)
      CALL SAVLGL$(K7,
     +             PANEL_SYMBOLS, STORE)      
      NFILES = K0
      FNAME = BLANK      
      BI_PLOT = .FALSE.
      YES = .FALSE.
                                      
C***********************************************************************
C End of code to initialise graphics parameters 
C***********************************************************************      
                                                        
C***********************************************************************
C Start of code to deal with data supplied directly to this routine
C***********************************************************************

      IF (SUPPLY_XY) THEN
         IF (NFILE1.LT.K1) THEN
            CALL DELEET (ADJLAB,
     +                   ASKIF, THERE) 
            CALL DELEET (LABFIL,
     +                   ASKIF, THERE)              
            CALL DELEET (VFFILE,
     +                   ASKIF, THERE) 
            ISEND = K0
            CALL GKSSAV$(ISEND, K0,
     +                   ABORT)             
            RETURN
         ELSEIF (PIE_CHART) THEN
            FNAME = FSAV(1)
            CLOSE (UNIT = NIN) 
            CALL PIEFIL$(IFILL, IHUE, NIN, NPIE, NPTS,
     +                   FACTOR, X,
     +                   FNAME, LABELS, TITLE, ABORT, SUPPLY_XY) 
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               NFILES = K0
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE) 
                ISEND = K0
                CALL GKSSAV$(ISEND, K0,
     +                       ABORT)   
               RETURN
            ELSE
               NFILES = K1
              DO I = K1, NPTS
                  IF (LCOLOR.EQ.K15 .AND. IHUE(I).EQ.K15) IHUE(I) = K0
               ENDDO
               THREE_D = .FALSE.
               MTRANS = K0
               NFILES = K1
               NPTSAV = NPTS
               NTYPE = K4
               XMAX = ONE
               XMIN = ZERO
               YMAX = ONE
               YMIN = ZERO
               ZMAX = ONE
               ZMIN = ZERO
               FSAV(1) = FNAME
               PTITLE(MTRANS) = CHOP80(TITLE)
               XTITLE(MTRANS) = BLANK
               YTITLE(MTRANS) = BLANK
               ZTITLE(MTRANS) = BLANK
               STORE = .FALSE.
               I = 1
               J = 1
               CALL SAVCHR$ (I, J,
     +                       ARRAYT(MTRANS),
     +                       STORE)
            ENDIF
         ELSEIF (BAR_CHART) THEN
            FNAME = FSAV(1)
            CALL GKSF2B$(NGROUP, NIN,
     +                   FNAME,
     +                   ABORT, SUPPLY_XY)
            IF (ABORT) THEN
               NFILES = K0
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE) 
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)   
               RETURN
            ELSE
               FSAV(1) = FNAME
               NFILES = K1
               OPEN (UNIT = NIN, FILE = FNAME)
               READ (NIN,'(A)',IOSTAT=IOS) LINE
               READ (NIN,*,IOSTAT=IOS) NROW, NCOL
               IF (NROW.LT.K1 .OR. NCOL.NE.K9) THEN
                  CLOSE (UNIT = NIN)
                  NFILES = K0
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)         
                  RETURN
               ELSE
                  NPTS = NROW
                  NPTSAV = NPTS
                  NBARS = NPTS
                  IF (NPTS.GT.0) THEN
                     NBAR_1 = NBARS
                     NGROUP_1 = NGROUP
                     NPTS_1 = NPTS
                     STORE = .TRUE.
                     CALL SAVINT$(K3, K3, NBAR_1,
     +                            STORE) 
                     CALL SAVINT$(K4, K4, NGROUP_1,
     +                            STORE) 
                     CALL SAVINT$(K6, K6, NPTS_1,
     +                            STORE)                     
                  ENDIF   
                  L(1) = K0
                  M(1) = K0
               ENDIF
               XMIN = XBIG
               XMAX = - XMIN
               YMIN = XMIN
               YMAX = XMAX
               DO I = K1, NROW
                  READ (NIN,*,IOSTAT=IOS) (BARVAL(J), J = K1, K9)
                  IF (IOS.NE.K0) EXIT
                  IF (BARVAL(1).LT.XMIN) XMIN = BARVAL(1)
                  IF (BARVAL(1).GT.XMAX) XMAX = BARVAL(1)
                  DO J = K2, K6
                     IF (BARVAL(J).LT.YMIN) YMIN = BARVAL(J)
                     IF (BARVAL(J).GT.YMAX) YMAX = BARVAL(J)
                  ENDDO
                  IFILL(I) = NINT(BARVAL(7))
                  FACTOR(I) = BARVAL(8)
                  IHUE(I) = NINT(BARVAL(9))
               ENDDO
               READ (NIN,*,IOSTAT=IOS) J
               DO I = K1, J
                  READ (NIN,'(A)',IOSTAT=IOS) LABELS(I)
                  IF (IOS.NE.K0) EXIT
               ENDDO
               CLOSE (UNIT = NIN)
               PTITLE(0) = TITLES(1)
               XTITLE(0) = TITLES(2)
               YTITLE(0) = TITLES(3)
               ZTITLE(0) = TITLES(4)
               STORE = .FALSE.
               I = 1
               J = 1 
               CALL SAVCHR$ (I, J,
     +                       ARRAYT(0),
     +                       STORE)
               J = 2
               CALL SAVCHR$ (I, J,
     +                       ARRAYX(0),
     +                       STORE)
               J = 3
               CALL SAVCHR$ (I, J,
     +                       ARRAYY(0),
     +                       STORE)    
               J = 4
               CALL SAVCHR$ (I, J,
     +                       ARRAYZ(0),
     +                       STORE)    
               J = 5
               CALL SAVCHR$ (I, J,
     +                       ARRAYQ,
     +                       STORE) 
C
C Add an additional data file if NFILE1 = 2
C     
               IF (NFILE1.EQ.2) THEN
                  NFILES = 2
                  L(2) = 0
                  M(2) = 1
               ENDIF                         
            ENDIF
            
         ELSEIF (VECTOR_FIELD) THEN
            CALL GKSVF5 (NPTS, NIN, NMAX, NWORDS,
     +                   XMAX, XMIN, YMAX, YMIN,       
     +                   FSAV(1),
     +                   ABORT, BI_PLOT, VEC_FIELD)
            IF (ABORT) THEN
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE) 
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)           
               RETURN
            ENDIF     
            NFILES = K1
            NPTSAV = NPTS  
            IF (BI_PLOT) THEN
               IF (LABSAV.EQ.NO_LABELS .OR. NPTS.GT.NWMAX) THEN
                  PLOT_LABELS = .FALSE.
               ELSE
                  PLOT_LABELS = .TRUE.
               ENDIF     
               NTYPE = K3
               IF (PLOT_LABELS) THEN   
                  OPEN (UNIT = NIN, FILE = LABFIL)
                  DO I = 1, NPTS
                     READ (NIN,'(A)',IOSTAT=IOS) LABELS(I)
                     IF (IOS.NE.K0) EXIT
                     IF (LABELS(1).EQ.NO_LABELS) EXIT  
                  ENDDO
                  CLOSE (UNIT = NIN) 
                  IF (IOS.NE.K0 .OR. 
     +                LABELS(1).EQ.NO_LABELS) PLOT_LABELS = .FALSE.       
               ENDIF      
            ELSEIF (VEC_FIELD) THEN 
               PLOT_LABELS = .FALSE.   
               NTYPE = K2  
C
C Check if type, size, and colour have been appended to the input file
C      
C               CLOSE (UNIT = NIN)
C               OPEN (NIN, FILE = FSAV(1), IOSTAT = IOS) 
C               LOOP_VF: DO WHILE (IOS.EQ.0)
C                  READ (NIN,'(A)',IOSTAT=IOS) LINE
C                  IF (IOS.EQ.0) THEN
C                     IF (INDEX(LINE,'begin{vfield}').GT.0) THEN
C                        J = 0
C                        DO WHILE (IOS.EQ.0)
C                           READ (NIN,'(A)',IOSTAT=IOS) LINE
C                           IF (INDEX(LINE,'end{vfield}').GT.0) THEN
C                              IOS = -1
C                              EXIT LOOP_VF
C                           ENDIF   
C                           IF (IOS.EQ.0) READ (LINE,*,IOSTAT=IOS) IFI,
C     +                                                       FAC, IHU
C                           IF (IOS.EQ.0 .AND. J.LT.NXTRA) THEN
C                              J = J + 1
C               WRITE (*,'(I4,A,I4,F8.4)') J, ' LINE 651 ', IHU, FAC 
C                              IFILL(J) = IFI
C                              FACTOR(J) = FAC
C                              IHUE(J) = IHU
C                           ELSE
C               WRITE (*,'(A,I4)') 'EXIT GKSGRF$ LINE 659 WITH IOS =',IOS                  
C                              EXIT LOOP_VF
C                           ENDIF   
C                        ENDDO
C                     ENDIF      
C                  ENDIF  
C               ENDDO LOOP_VF 
C               CLOSE (UNIT = NIN)
            ELSE
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE)
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)            
               RETURN               
            ENDIF 
            NSAV(1) = NTYPE
            VEC_FIELD = .TRUE.   
         ELSE
            NFILES = NFILE1
            IF (TWO_PLOTS) THEN 
               CALL SUPPYZ$(NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                      NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                      XMAX, XMIN,
     +                      YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                      YMIN4, ZMAX, ZMIN,
     +                      FSAV, TSAV,
     +                      ABORT, BARCAP, LOWER, UPPER, YAXIS)
            ELSE     
               CALL SUPPXY$(NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                      NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                      XMAX, XMIN,
     +                      YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                      YMIN4,
     +                      FSAV, TSAV,
     +                      ABORT, BARCAP, LOWER, UPPER)
            ENDIF
            IF (ABORT) THEN
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE)
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)           
               RETURN
            ENDIF  
            PTITLE(0) = TITLES(1)
            XTITLE(0) = TITLES(2)
            YTITLE(0) = TITLES(3)
            ZTITLE(0) = TITLES(4)
            STORE = .FALSE.
            I = 1
            J = 1
            CALL SAVCHR$ (I, J,
     +                    ARRAYT(0),
     +                    STORE)
            J = 2
            CALL SAVCHR$ (I, J,
     +                    ARRAYX(0),
     +                    STORE)
            J = 3
            CALL SAVCHR$ (I, J,
     +                    ARRAYY(0),
     +                    STORE)    
            J = 4
            CALL SAVCHR$ (I, J,
     +                    ARRAYZ(0),
     +                    STORE)    
            J = 5
            CALL SAVCHR$ (I, J,
     +                    ARRAYQ,
     +                    STORE)         
         ENDIF
      ELSEIF (TYPE_IN) THEN
         CALL TYPEIN$(NGROUP,
     +                FNAME,
     +                ABORT, BAR_CHART, PIE_CHART)
         IF (ABORT) THEN
            CALL DELEET (ADJLAB,
     +                   ASKIF, THERE) 
            CALL DELEET (LABFIL,
     +                   ASKIF, THERE)              
            CALL DELEET (VFFILE,
     +                   ASKIF, THERE)
            ISEND = K0
            CALL GKSSAV$(ISEND, K0,
     +                   ABORT)        
            RETURN
         ENDIF   
         IF (PIE_CHART) THEN
            CLOSE (UNIT = NIN) 
            CALL TYPEPC$(IFILL, IHUE, NIN, NPIE, NPTS, NWORDS,
     +                   FACTOR, X,
     +                   FNAME, LABELS, TITLE, ABORT) 
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE)
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)          
               RETURN
            ENDIF   
           DO I = K1, NPTS
               IF (LCOLOR.EQ.K15 .AND. IHUE(I).EQ.K15) IHUE(I) = K0
               FACTOR(I) = ZERO
            ENDDO
            THREE_D = .FALSE.
            MTRANS = K0
            NFILES = K1
            NPTSAV = NPTS
            NTYPE = K4
            XMAX = ONE
            XMIN = ZERO
            YMAX = ONE
            YMIN = ZERO
            ZMAX = ONE
            ZMIN = ZERO
            PTITLE(MTRANS) = 'Pie Chart'
            XTITLE(MTRANS) = BLANK
            YTITLE(MTRANS) = BLANK
            ZTITLE(MTRANS) = BLANK
            FSAV(1) = FNAME
         ELSE
            CLOSE (UNIT = NIN) 
            CALL TYPEPF$(IFILL, IHUE, L, M, NFILES, NGRAFS, NIN, NMAX,
     +                   NPTS, NSAV, NTYPE, NTYPE1, NTYPE2, NTYPE3,
     +                   NWORDS, NY, NZ,
     +                   FACTOR, X, XH, XL, XMAX, XMIN,
     +                   Y, YH, YL, YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                   YMIN4, ZMAX, ZMIN,
     +                   FNAME, FSAV, LABELS, TITLE, TSAV,
     +                   ABORT, BARCAP, BAR_CHART, LOWER,
     +                   UPPER, VECTOR_FIELD, YAXIS)
            NPTSAV = NPTS
            IF (BAR_CHART .AND. NPTS.GT.0) THEN
               NBARS = NPTS
               NBAR_1 = NBARS
               NGROUP_1 = NGROUP
               NPTS_1 = NPTS
               STORE = .TRUE.
               CALL SAVINT$(K3, K3, NBAR_1,
     +                      STORE) 
               CALL SAVINT$(K4, K4, NGROUP_1,
     +                      STORE) 
               CALL SAVINT$(K6, K6, NPTS_1,
     +                      STORE)           
            ENDIF   
            FSAV(1) = FNAME
            CLOSE (UNIT = NIN)
            IF (ABORT) THEN
               CALL DELEET (ADJLAB,
     +                     ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE) 
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)          
               RETURN
            ENDIF  
         ENDIF   
C***********************************************************************
C End of code to deal with data supplied directly to this routine 
C***********************************************************************      
                                                        
C***********************************************************************
C Start of code to deal with data supplied as data files to this routine
C*********************************************************************** 
        
      ELSEIF (PIE_CHART) THEN
C
C Main Entry 1: Here to use PIEFIL$ for piecharts only with just 1 file
C =====================================================================
C
         CLOSE (UNIT = NIN)  
         CALL PIEFIL$(IFILL, IHUE, NIN, NPIE, NPTS,
     +                FACTOR, X,
     +                FNAME, LABELS, TITLE, ABORT, SUPPLY_XY) 
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            NFILES = K0
         ELSE
          DO I = K1, NPTS
               IF (LCOLOR.EQ.K15 .AND. IHUE(I).EQ.K15) IHUE(I) = K0
            ENDDO
            THREE_D = .FALSE.
            MTRANS = K0
            NFILES = K1
            NPTSAV = NPTS
            NTYPE = K4
            XMAX = ONE
            XMIN = ZERO
            YMAX = ONE
            YMIN = ZERO
            ZMAX = ONE
            ZMIN = ZERO
            FSAV(1) = FNAME
            PTITLE(MTRANS) = CHOP80(TITLE)
            XTITLE(MTRANS) = BLANK
            YTITLE(MTRANS) = BLANK
            ZTITLE(MTRANS) = BLANK
         ENDIF
      ELSE

C
C.......................................................................
C

C
C Main Entry 2: Use PFILES$ or LIBFIL$ if not barchart or double plot
C====================================================================
C
C         LIB_FILE = .FALSE.
         YES = .FALSE.
         NFILES = K0
         IF (BAR_CHART .OR. TWO_PLOTS) THEN
C
C Take no action here for barcharts or double plots
C ==================================================
C
            I = K1!to silence ftn95... originally CONTINUE
         ELSE
C
C Use LIBFIL$ to try to read in a file and check using ISITLF
C If unsuccessful: NFILES = 0, LIB_FILE = .FALSE., FNAME = BLANK
C ==============================================================
C
            CLOSE (UNIT = NIN)
            CALL LIBFIL$(L, M, NFILES, NGRAFS, NIN,
     +                   NMAX, NPTS, NSAV,
     +                   NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                   XMAX, XMIN, YMAX, YMAX3,
     +                   YMAX4, YMIN, YMIN3, YMIN4,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   ABORT, BARCAP, LIB_FILE, LOWER, UPPER,
     +                   VECTOR_FIELD, YAXIS)
            CLOSE (UNIT = NIN)
C
C If library file has not been located set NFILES = 0 and try again
C If LIBFIL$ fails it sets FNAME = BLANK to force GKSFIL$ to open a file
C
            IF (ABORT) NFILES = K0
         ENDIF
         IF (LIB_FILE) THEN
C
C No action if a library file has now been located
C
            I = K1!to silence ftn95... originally CONTINUE
         ELSE
C
C The main loop
C =============
C Here because a barchart or double plot is expected or LIBFIL$ did not succeed
C Statement 20 : Use PFILES$ to read in files with graph coordinates....
C ==============
C
            NFILES = K0
   20       CONTINUE

            IF (BAR_CHART .OR. TWO_PLOTS .OR. LIB_FILE) THEN
C
C Loop possibility 1:
C Take no action for barcharts, double plots or current library files
C ===================================================================
C
               I = K1!to silence ftn95... originally CONTINUE
            ELSEIF (NFILES.EQ.K0 .AND. FNAME.EQ.BLANK) THEN
C
C Loop possibility 2
C Special entry to try a library file again
C =========================================
C Here if failure to read the first file and not a barchart or double plot
C ========================================================================
C
               CLOSE (UNIT = NIN)
               CALL LIBFIL$(L, M, NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                      NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                      XMAX, XMIN, YMAX,
     +                      YMAX3, YMAX4, YMIN, YMIN3, YMIN4,
     +                      FNAME, FSAV, TITLE, TSAV,
     +                      ABORT, BARCAP, LIB_FILE, LOWER, UPPER,
     +                      VECTOR_FIELD, YAXIS)
               CLOSE (UNIT = NIN)
               IF (ABORT) NFILES = K0
            ENDIF
            IF (LIB_FILE) THEN
C
C Loop possibility 3
C No action if a library file has been located
C ============================================
C
               I = K1!to silence ftn95... originally CONTINUE
            ELSE
C
C Loop possibility 4
C Here if barchart, failure or normal repeat while cycling through files
C ======================================================================
C
               CLOSE (UNIT = NIN) 
               CALL PFILES$(IFILL, IHUE, L, M, NFILES, NGRAFS, NGROUP,
     +                      NIN, NMAX, NPTS, NSAV, NTYPE, NTYPE1,
     +                      NTYPE2, NTYPE3, NWORDS, NXTRA, NY, NZ,
     +                      FACTOR, XMAX, XMIN,
     +                      YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                      YMIN4, ZMAX, ZMIN,
     +                      FNAME, FSAV, LABELS, TITLE, TSAV,
     +                      ABORT, BARCAP, BAR_CHART, LOWER, TWO_PLOTS,
     +                      UPPER, VECTOR_FIELD, YAXIS, YES) 
               CLOSE (UNIT = NIN)
C
C If failure first time round then set FNAME = BLANK and try again
C This forces GKSFIL$ to try to open a new file not the previous one
C
               IF (NFILES.EQ.K0) FNAME = BLANK
               IF (BAR_CHART .AND. NFILES.EQ.K1 .AND. NPTS.GT.0) THEN
                  NBARS = NPTS
                  NPTSAV = NPTS
                  NBAR_1 = NBARS
                  NGROUP_1 = NGROUP
                  NPTS_1 = NPTS
                  STORE = .TRUE.
                  CALL SAVINT$(K3, K3, NBAR_1,
     +                         STORE) 
                  CALL SAVINT$(K4, K4, NGROUP_1,
     +                         STORE) 
                  CALL SAVINT$(K6, K6, NPTS_1,
     +                         STORE)           
               ENDIF
               IF (YES) GOTO 20
            ENDIF
         ENDIF
      ENDIF
      
C***********************************************************************
C End of code to deal with data supplied as files to this routine 
C***********************************************************************      
                                                        
C***********************************************************************
C Start of code to prepare for plotting
C***********************************************************************
      
      IF (NFILES.LT.K1) THEN
C
C Return if no data
C
         CALL DELEET (ADJLAB,
     +                ASKIF, THERE) 
         CALL DELEET (LABFIL,
     +                ASKIF, THERE)              
         CALL DELEET (VFFILE,
     +                ASKIF, THERE)
         ISEND = K0
         CALL GKSSAV$(ISEND, K0,
     +                ABORT)       
         RETURN
      ELSE
C
C Define default values for XCOORD, YCOORD and ZCOORD...................
C
         XCOORD = MIN(XMAX, XMIN)
         YCOORD = MIN(YMAX, YMIN)
         ZCOORD = MAX(XMAX, XMIN)
      ENDIF           
C
C Special action if VECTOR_FIELD = .TRUE. and file has not been supplied directly
C     
      IF (VECTOR_FIELD .AND. .NOT.SUPPLY_XY) THEN 
         CALL ISITMF (NCOL, NROW,
     +                FSAV(1))
         IF (NCOL.EQ.K9) THEN 
C
C It is a BI_PLOT ... so create plot labels type files 
C Note: arrow types and colours were set when the file was first accessed as
C if it was a bar-chart type file, which has the same type of format 
C          
            BI_PLOT = .TRUE. 
            IF (LABELS(1).EQ.NO_LABELS .OR. NROW.GT.NWMAX) THEN
               PLOT_LABELS = .FALSE.
            ELSE
               PLOT_LABELS = .TRUE.
            ENDIF      
            IF (PLOT_LABELS) THEN 
               CLOSE (UNIT = NIN)
               ISEND = 1
               CALL GETWRD (ISEND, NCOL, NIN, NROW, NWORDS,
     +                      FSAV(1),
     +                      LABELS)
               CLOSE (UNIT = NIN)
               IF (LABELS(1).EQ.NO_LABELS) PLOT_LABELS = .FALSE.
            ENDIF  
            CLOSE (UNIT = NIN) 
            OPEN (UNIT = NIN, FILE = FSAV(1))
            READ (NIN,'(A)',IOSTAT=IOS) TITLE 
            READ (NIN,*,IOSTAT=IOS) NROW, NCOL
            DO I = 1, NROW 
               READ (NIN,*,IOSTAT=IOS) (BARVAL(J), J = 1, NCOL)
               IF (IOS.NE.K0) EXIT
               X(I) = BARVAL(3)
               Y(I) = BARVAL(6)
            ENDDO  
            CLOSE (UNIT = NIN) 
            IF (IOS.NE.K0) THEN 
               CALL DELEET (ADJLAB,
     +                      ASKIF, THERE) 
               CALL DELEET (LABFIL,
     +                      ASKIF, THERE)              
               CALL DELEET (VFFILE,
     +                      ASKIF, THERE)
               ISEND = K0
               CALL GKSSAV$(ISEND, K0,
     +                      ABORT)          
               RETURN
            ENDIF   
C
C 'f$vfield.tmp' is a %simfitplotlabelsfile%
C            
            IF (PLOT_LABELS) THEN
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = VFFILE)
               WRITE (NIN,'(A)',IOSTAT=IOS) '%simfitplotlabelsfile%'
               WRITE (NIN,'(2I6)',IOSTAT=IOS) NROW, K2
               DO I = 1, NROW
                  WRITE (NIN,'(1P,2E13.5)',IOSTAT=IOS) X(I), Y(I)
                  IF (IOS.NE.K0) EXIT
               ENDDO  
               CLOSE (UNIT = NIN)
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)         
                  RETURN   
               ENDIF   
C
C 'f$labels.tmp' is a simple list of labels
C            
               OPEN (UNIT = NIN, FILE = LABFIL)
               DO I = 1, NROW
                  WRITE (NIN,'(A)',IOSTAT=IOS) LABELS(I)
                  IF (IOS.NE.K0) EXIT
               ENDDO
               CLOSE (UNIT = NIN)
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)        
                  RETURN
               ENDIF   
C
C 'f$rotate.tmp' is a %simfitrotatelabelsfile%
C    
               OPEN (UNIT = NIN, FILE = ADJLAB)
               WRITE (NIN,'(A)',IOSTAT=IOS) '%simfitrotatelabelsfile%'
               WRITE (NIN,'(2I6)',IOSTAT=IOS) NROW, K5
               DO I = 1, NROW
                  WRITE (NIN,'(1P,5E13.5)',IOSTAT=IOS) X(I), ZERO, Y(I),
     +                                                 ZERO, ZERO
                  IF (IOS.NE.K0) EXIT 
               ENDDO 
               CLOSE (UNIT = NIN)
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)        
                  RETURN         
               ENDIF   
               NSAV(1) = K3
            ELSE    
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = VFFILE)
               WRITE (NIN,'(A)',IOSTAT=IOS)
     +'%simfitplotlabelsfile%no_labels%'
               CLOSE (UNIT = NIN) 
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)       
                  RETURN
               ENDIF   
                 
C
C 'f$labels.tmp' is a simple list of labels
C            
               OPEN (UNIT = NIN, FILE = LABFIL)
               WRITE (NIN,'(A)',IOSTAT=IOS) NO_LABELS
               CLOSE (UNIT = NIN)
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)       
                  RETURN
               ENDIF   
               
C
C 'f$rotate.tmp' is a %simfitrotatelabelsfile%
C    
               OPEN (UNIT = NIN, FILE = ADJLAB)
               WRITE (NIN,'(A)',IOSTAT=IOS) 
     +'%simfitrotatelabelsfile%no_labels%'
               CLOSE (UNIT = NIN)
               IF (IOS.NE.K0) THEN
                  CALL DELEET (ADJLAB,
     +                         ASKIF, THERE) 
                  CALL DELEET (LABFIL,
     +                         ASKIF, THERE)              
                  CALL DELEET (VFFILE,
     +                         ASKIF, THERE)
                  ISEND = K0  
                  CALL GKSSAV$(ISEND, K0,
     +                         ABORT)       
                  RETURN 
               ENDIF   
               NSAV(1) = K3       
            ENDIF      
         ELSE          
            NSAV(1) = K2  
            IFILL(1) = K1
            IHUE(1) = K0
            FACTOR(1) = HSIZE
            BI_PLOT = .FALSE. 
            PLOT_LABELS = .FALSE.   
         ENDIF                
      ENDIF
C
C Define NFILE1 then copy all files FSAV to temporary files FSAV1
C
      NFILE1 = NFILES
      CLOSE (UNIT = NIN)
      J = 0
      DO I = 1, NFILES
         CALL COPYFL (MODE2,
     +                FSAV(I), FSAV1(I),
     +                ABORT)
         IF (ABORT) THEN
            WRITE (LINE,'(A,I4)') 'COPYFL cannot copy file', I
            CALL PUTFAT$(LINE)
         ELSE
            J = J + 1
         ENDIF
      ENDDO
      IF (ABORT .OR. J.NE.NFILES) THEN
         CALL DELEET (ADJLAB,
     +                ASKIF, THERE) 
         CALL DELEET (LABFIL,
     +                ASKIF, THERE)              
         CALL DELEET (VFFILE,
     +                ASKIF, THERE) 
         ISEND = K0  
         CALL GKSSAV$(ISEND, K0,
     +                ABORT)           
         RETURN
      ENDIF   

C
C Special action if TWO_PLOTS but only one data type...................
C
      IF (TWO_PLOTS .AND. NY*NZ.EQ.K0) THEN
         CALL PUTFAT$(
     +'Only one plot type requested ... Reverting to 1-plot mode')
         TWO_PLOTS = .FALSE.
         DO I = K1, NFILES
            YAXIS(I) = .TRUE.
         ENDDO
      ENDIF
C
C Special action if BAR_CHART ... set X, NPTSAV, XMAX, XMIN............
C
      IF (BAR_CHART) THEN
         MXTIC = - K1
         I = K2
         CLOSE (UNIT = NIN) 
         CALL GKSFIL$(IFILL, IHUE, I, NFILES, NGROUP, NIN, NMAX, NPTSAV,
     +                NTYPE, NWORDS, NXTRA,
     +                FACTOR, X, XH, XL, Y, YH,
     +                YL, YMAX3, YMAX4, YMIN3, YMIN4,
     +                FSAV1(1), TITLE, ABORT, BAR_CHART, VECTOR_FIELD) 
         CLOSE (UNIT = NIN)
         NPTS = NPTSAV
         THREE_D = .FALSE.
         DO I = K1, NPTSAV
            IF (LCOLOR.EQ.K15 .AND. IHUE(I).EQ.K15 
     +                        .AND. IFILL(I).NE.2) IHUE(I) = K0
         ENDDO
         XMAX = X(NPTSAV) + PNT5
         XMIN = X(1) - PNT5
         XGRID = .FALSE.
         CALL BCKEYS$(K0, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                NOUT_PS, NPTS,
     +                XPDRAG, YPDRAG, WIDE(1), WIDE(NGRAFS + 1), XPC,
     +                Y_SCALE, 
     +                PLINE, PSYMB,
     +                HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
      ENDIF
C
C Special action if a dendrogram or principal components plot-label type file
C                                
      IF (BAR_CHART .OR. PIE_CHART .OR. VECTOR_FIELD) THEN
         DENDRO_GRAM = .FALSE.
         BRAY_CURTIS = .FALSE.
      ELSE
         DENDRO_GRAM = .FALSE.
         BRAY_CURTIS = .FALSE.
         OPEN (UNIT = NIN, FILE = FSAV(1))
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.EQ.K0) THEN
            READ (NIN,*,IOSTAT=IOS) I, J
            IF (IOS.NE.K0) TITLE = BLANK
            CLOSE (UNIT = NIN)
         ELSE
            TITLE = BLANK
         ENDIF
         IF (TITLE(1:22).EQ.'%simfitdendrogramfile%') THEN
C
C A dendrogram file has been identified
C
            DENDRO_GRAM = .TRUE.
            BORDER = .FALSE.
            PANEL = .FALSE.
            PANEL_1 = .FALSE.
            STORE = .TRUE.
            CALL SAVLGL$(K11,
     +                   PANEL_1, STORE)           
            NPTSAV = I/K4 + K1
            NPTS = NPTSAV
            XMIN = ONE
            XMAX = DBLE(NPTSAV)
            IF (TITLE(22:32).EQ.NO_LABELS) THEN
               XLABEL = .FALSE.
               MXTIC = -K1
               STORE = .TRUE.
               CALL SAVLGL$(K2, 
     +                      XLABEL, STORE)    
            ELSE
               XLABEL = .TRUE.
               STORE = .TRUE.
               CALL SAVLGL$(K2, 
     +                      XLABEL, STORE)    
               INQUIRE (FILE = LABFIL, EXIST = THERE)
               IF (THERE) THEN
                  OPEN (UNIT = NIN, FILE = LABFIL)
                  IOS = K0
                  DO I = 1, MIN(NPTSAV, NWORDS)
                     IF (IOS.EQ.K0) READ (NIN,'(A)',IOSTAT=IOS) TITLE
                     IF (IOS.EQ.K0) WORDX(I) = TITLE
                  ENDDO
                  CLOSE (UNIT = NIN)
               ENDIF
            ENDIF   
            IF (TITLES(3).EQ.'Bray-Curtis Similarity') THEN
C
C It is also a Bray-Curtis type file (y_label = (100 - y_value)%)
C
               BRAY_CURTIS = .TRUE.
               YTOINT = .TRUE.
               PCENTY = .TRUE.
            ENDIF
         ELSEIF (TITLE(1:22).EQ.'%simfitplotlabelsfile%') THEN
C
C A plot labels type file has been identified
C
            IF (TITLE(22:32).EQ.NO_LABELS) THEN
               PLOT_LABELS = .FALSE.
            ELSE     
               PLOT_LABELS = .TRUE.
               INQUIRE (FILE = LABFIL, EXIST = THERE)
               IF (THERE) THEN
                  OPEN (UNIT = NIN, FILE = LABFIL)
                  NPTSAV = I
                  NPTS = NPTSAV
                  IOS = K0
                  DO I = 1, MIN(NPTSAV, NWORDS)
                     IF (IOS.EQ.K0) READ (NIN,'(A)',IOSTAT=IOS) TITLE
                     IF (IOS.EQ.K0) LABELS(I) = TITLE
                  ENDDO
                  CLOSE (UNIT = NIN)
               ENDIF
            ENDIF   
         ENDIF
      ENDIF                    
      
C***********************************************************************
C End of code to prepare for plotting 
C***********************************************************************      
                                                        
C***********************************************************************
C Start of code to set up the plotting window and parameters
C***********************************************************************      

C
C Initialise linetype and linewidth....................................
C
      CALL GSLN$(K1)
      CALL GSLWSC$(ONE)
      STORE = .TRUE.
      CALL SAVE11$(BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, STORE,
     +             TWO_PLOTS, VECTOR_FIELD)
C
C Proceed to plotting but set FIRST = .TRUE. before calling GKSSTY .....
C This call is required to initialise GKSSTY
C
      FIRST = .TRUE.
      IF (BAR_CHART .OR. DENDRO_GRAM .OR. PIE_CHART) NPTS = NPTSAV 
      CALL GKSSTY$(IFILL, IHUE, ISHAPE, JCOLOR,
     +             KANGLE, KCOLOR, KPANEL, KTIC,
     +             L, LCOLOR, M, MTRANS, MXDROP, MXTIC, MYTIC, MZTIC,
     +             NCLIP, NFILES, NGRAFS, NGROUP, NIN, NKCOL,
     +             NLOG, NPRESS, NPTS, NSAV, NWORDS, NXTRA,
     +             ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +             FACTOR, SIZE, THICK, WIDE,
     +             XCLIP, XCOORD, XMAX, XMIN,
     +             YCLIP, YCOORD, YDROP, YMAX, YMAX3, YMAX4, YMIN,
     +             YMIN3, YMIN4,
     +             ZCOORD, ZMAX, ZMIN, ZSCALE,
     +             ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             FSAV, FSAV1, LABELS, LABVEC, PLINE, PSYMB,
     +             PTITLE, QTITLE,
     +             TSAV, WORDX, WORDY, XTITLE, YTITLE, ZTITLE,
     +             ABORT, BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +             CENTRE, DENDRO_GRAM, EXTEND_LINES, FIRST, FRAME,
     +             GRATICULE, LOWER, MONO_SAV, NATLOG, NUMBRX, OFFSET,
     +             PANEL, PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY,
     +             PHIGHZ, PIE_CHART, PLOT_LABELS, PLOT_TITLE, PLOTX,
     +             PLOTY, PLOTZ, POWERX, POWERY, POWERZ, ROTATE,
     +             SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +             SHOW_YAXIS, SHOW_ZAXIS, SIDE, SWAP_YZ, THREE_D,
     +             TWO_PLOTS, UPPER, XGRID, XTOINT, VECTOR_FIELD,
     +             VIDEO_SAV, YAXIS, YGRID, YTOINT, ZTOINT)
      PANEL_1 = PANEL
      STORE = .TRUE.
      CALL SAVLGL$(K11,
     +             PANEL_1, STORE)   
      SIDE_1 = SIDE
      CALL SAVLGL$(K9,
     +             SIDE_1, STORE)     
      IF (BAR_CHART .OR. PIE_CHART) BORDER = .FALSE.
     
C
C Make sure symbol is 8 for characters > 127 by calling ISOLAT$
C
      DO I = 0, 15
         CALL ISOLAT$(ARRAYT(I), PTITLE(I))
         CALL ISOLAT$(ARRAYX(I), XTITLE(I))
         CALL ISOLAT$(ARRAYY(I), YTITLE(I))
         CALL ISOLAT$(ARRAYZ(I), ZTITLE(I))
      ENDDO
C
C Initialise PLOTYN$ to make sure all files will be plotted
C
      I = 1
      CALL PLOTYN$(I, L, M, NFILES,
     +             FSAV,
     +             BARCAP, LOWER, UPPER)
      IF (BAR_CHART .OR. VECTOR_FIELD) THEN
         L(1) = K0
         M(1) = K0
      ENDIF       
C
C Set SWITCH_ON = .TRUE. in PLTOBJ$ if standard plot with normal data
C
      IF (PIE_CHART) THEN
         I = K0
         CALL PLTOBJ$(K6, I)
      ELSE   
         I = K0
         CALL PLTOBJ$(K0, I)
      ENDIF   
     
      
C***********************************************************************
C End of code to set up the plotting window and parameters
C***********************************************************************

C***********************************************************************
C Everything is now initialise so proceed with plotting
C***********************************************************************                  

C
C Statement 40 : Set up parameters for the display .....................
C=======================================================================
C
   40 CONTINUE
C
C Set FIRST = .TRUE. then call GKSDEK$ to decide on next type of output..
C
      FIRST = .TRUE.
      CALL DECGKS$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS ...............
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
C
C Now must set FIRST = .FALSE. before calling GKSSTY ..................
C This call allows parameters to be changed to sculpture the graph
C
      FIRST = .FALSE.
      IF (BAR_CHART .OR. PIE_CHART) NPTS = NPTSAV   
      CALL GKSSTY$(IFILL, IHUE, ISHAPE, JCOLOR,
     +             KANGLE, KCOLOR, KPANEL, KTIC,
     +             L, LCOLOR, M, MTRANS, MXDROP, MXTIC, MYTIC, MZTIC,
     +             NCLIP, NFILES, NGRAFS, NGROUP, NIN, NKCOL,
     +             NLOG, NPRESS, NPTS, NSAV, NWORDS, NXTRA,
     +             ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +             FACTOR, SIZE, THICK, WIDE,
     +             XCLIP, XCOORD, XMAX, XMIN,
     +             YCLIP, YCOORD, YDROP, YMAX, YMAX3, YMAX4, YMIN,
     +             YMIN3, YMIN4, ZCOORD, ZMAX, ZMIN, ZSCALE,
     +             ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             FSAV, FSAV1, LABELS, LABVEC, PLINE, PSYMB,
     +             PTITLE, QTITLE, TSAV, WORDX, WORDY,
     +             XTITLE, YTITLE, ZTITLE,
     +             ABORT, BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +             CENTRE, DENDRO_GRAM, EXTEND_LINES, FIRST, FRAME,
     +             GRATICULE, LOWER, MONO_SAV, NATLOG, NUMBRX,
     +             OFFSET, PANEL, PCENTX, PCENTY, PCENTZ, PHIGHX,
     +             PHIGHY, PHIGHZ, PIE_CHART, PLOT_LABELS, PLOT_TITLE,
     +             PLOTX, PLOTY, PLOTZ, POWERX, POWERY, POWERZ, ROTATE,
     +             SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +             SHOW_YAXIS, SHOW_ZAXIS, SIDE, SWAP_YZ, THREE_D,
     +             TWO_PLOTS, UPPER, XGRID,  XTOINT, VECTOR_FIELD,
     +             VIDEO_SAV, YAXIS, YGRID, YTOINT, ZTOINT)
      IF (ABORT) THEN
         CALL DELEET (ADJLAB,
     +                ASKIF, THERE) 
         CALL DELEET (LABFIL,
     +                ASKIF, THERE)              
         CALL DELEET (VFFILE,
     +                ASKIF, THERE)
         ISEND = K0  
         CALL GKSSAV$(ISEND, K0,
     +                ABORT)           
         RETURN
      ENDIF   
      IF (BAR_CHART .AND. IWARNU) THEN
         IWARNU = .FALSE.
         IF (NGROUP_1.GT.NBAR_1) CALL PUTADV$(
     +  'The group size is greater than the number of bars')
         IF (NGROUP_1.GT.0) THEN
            I = NBAR_1/NGROUP_1
            I = I*NGROUP_1
            IF (I.NE.NBAR_1) CALL PUTADV$(
     +  'The number of bars is not divisible by the group size')
         ENDIF
      ENDIF
C
C Statement 60 : We can now draw the required display ..................
C=======================================================================
C
   60 CONTINUE
C
C Check if larger arrays have been requested for new data
C  
      STORE = .FALSE.
      CALL SAVINT$(K5, K5, NMAX1,
     +             STORE) 
      IF (NMAX1.GT.NMAX) THEN
          CALL GKSSAV$(K2, NMAX,
     +                 ABORT)  
          IF (ABORT) RETURN 
      ENDIF   
        
C
C First initialise the graph plotting routine and colour scheme.........
C
      CALL INIT_1$(I)
      IF (HARD_COPY .AND. MONO_CHROME) THEN
         MONO = .TRUE.
         VIDEO = .FALSE.
      ELSE
         MONO = MONO_SAV
         VIDEO = VIDEO_SAV
      ENDIF
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = K15
            MCOLOR = K0
         ELSE
            LCTEMP = K0
            MCOLOR = K15
         ENDIF
      ELSE
         LCTEMP = LCOLOR
         MCOLOR = KCOLOR(5)
      ENDIF
C
C Special action if BAR_CHART ... set X, NPTSAV, XMAX, XMIN.............
C
      IF (BAR_CHART) THEN
         MXTIC = - K1
         I = K2
         CLOSE (UNIT = NIN) 
         CALL GKSFIL$(IFILL, IHUE, I, NFILES, NGROUP, NIN, NMAX, NPTSAV,
     +                NTYPE, NWORDS, NXTRA,
     +                FACTOR, X, XH, XL, Y, YH,
     +                YL, YMAX3, YMAX4, YMIN3, YMIN4,
     +                FSAV1(1), TITLE, ABORT, BAR_CHART, VECTOR_FIELD)
         CLOSE (UNIT = NIN)
         XMAX = X(NPTSAV) + PNT5
         XMIN = X(1) - PNT5
         XGRID = .FALSE.
      ENDIF
C
C Check the values for XCOORD, YCOORD and ZCOORD........................
C
      IF (XCOORD.LT.XMIN .OR. XCOORD.GT.XMAX) XCOORD = MIN(XMAX,XMIN)
      IF (YCOORD.LT.YMIN .OR. YCOORD.GT.YMAX) YCOORD = MIN(YMAX,YMIN)
      IF (ZCOORD.LT.XMIN .OR. ZCOORD.GT.XMAX) ZCOORD = MAX(XMAX,XMIN)
C
C Make sure sensible values are used for POWERX, POWERY and POWERZ
C
      IF (MTRANS.GE.8) THEN
         POWERX_1 = POWERX
         POWERY_1 = POWERY
         POWERZ_1 = POWERZ
      ELSE
         POWERX_1 = .FALSE.
         POWERY_1 = .FALSE.
         POWERZ_1 = .FALSE.
      ENDIF
C
C Set FIRST = .TRUE. then Call PANELS$ to set IPANEL,etc. for GKSPLT....
C
      IF (NPRESS.EQ.19) THEN
C
C Button 19 has been pressed so move side panel
C..............................................
C
         CALL SAVEXY$(XTEMP, YTEMP,
     +                STORE)
         IF (PIE_CHART .AND. SIDE) THEN
            XPDRAG = XTEMP
            YPDRAG = YTEMP 
            CALL PCKEYS$(K0, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS,
     +                   XPDRAG, YPDRAG, WIDE(1), WIDE(NGRAFS + 1),
     +                   XPC, Y_SCALE,
     +                   FSAV1(1), PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
         ELSEIF (BAR_CHART .AND. SIDE) THEN
            XPDRAG = XTEMP
            YPDRAG = YTEMP 
            CALL BCKEYS$(K3, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS,
     +                   XPDRAG, YPDRAG, WIDE(1), WIDE(NGRAFS + 1),
     +                   XPC, Y_SCALE,
     +                   PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
         ELSE
            XPDRAG = XTEMP - PNT85
            YPDRAG = TWO*(YTEMP - PNT5)
         ENDIF
      ENDIF
      FIRST = .TRUE.
      CALL PANELS$(IPANEL, ISHAPE, KPANEL, L, M, NFILES, NGRAFS,
     +             PSCALE, XDIFF, XMAX, XMIN, XPANEL, XPDRAG, XPMAX,
     +             XPMIN, XSTART, YDIFF, YMAX, YMIN, YPDRAG, YPXTRA,
     +             PLINE, FIRST, PANEL, SIDE)
      IF (BAR_CHART .AND. SIDE) THEN
         I = K1
      ELSEIF (PANEL .AND. SIDE) THEN
         I = K1
      ELSE
         I = K0
      ENDIF
      STORE = .TRUE.
      CALL SAVEIT$(I,
     +             STORE)

C
C Do we need to drag text, arrows, etc. Find out by checking NPRESS...
C This has been stored when buttons 15,16, 17 are pressed
C
      STORE = .FALSE.
      IF (NPRESS.EQ.15) THEN
C
C Button 15 has been pressed so move text string(i)
C..................................................
C
         CALL SAVEMN$(I, J,
     +                STORE)
         IF (I.GT.0) THEN
            CALL SAVEXY$(XTEMP, YTEMP,
     +                   STORE)
         ENDIF
         CALL PLTOBJ$(K3, NPRESS)
      ELSEIF (NPRESS.EQ.16) THEN
C
C Button 16 has been pressed so move arrow head(i)
C.................................................
C
         CALL SAVEMN$(I, J,
     +               STORE)
         IF (J.GT.0) THEN
            CALL SAVEXY$(XTEMP, YTEMP,
     +                   STORE)
         ENDIF
         CALL PLTOBJ$(K3, NPRESS)
      ELSEIF (NPRESS.EQ.17) THEN
C
C Button 17 has been pressed so move arrow tail(i)
C.................................................
C
         CALL SAVEMN$(I, J,
     +                STORE)
         IF (J.GT.0) THEN
            CALL SAVEXY$(XTEMP, YTEMP,
     +                   STORE)
         ENDIF
         CALL PLTOBJ$(K3, NPRESS)
      ELSEIF (NPRESS.EQ.18) THEN
C
C Button 18 has been pressed so move OBJECT
C.................................................
C
         CALL SAVEOB$(K,
     +                STORE)
         IF (K.GT.0) THEN
            CALL SAVEXY$(XTEMP, YTEMP,
     +                   STORE)
         ENDIF
         CALL PLTOBJ$(K3, NPRESS)
      ENDIF

C
C Re-set font parameters before call to GKSPLT$..........................
C 102 = Helvetica, 106 = TimesRoman, 107 = TimesItalic
C
      CALL WGBFNT$(NTFONT, NFONT_PS,
     +             SLANT)
      IF (NTFONT.EQ.107) THEN
         NCFONT = 106
      ELSE
         NCFONT = NTFONT
      ENDIF
      NXFONT = NTFONT
      NYFONT = NTFONT
      IF (TWO_PLOTS) THEN
         ZTITLE_1 = ZTITLE(MTRANS)
         ARRAYZ_1 = ARRAYZ(MTRANS)
      ELSE
         ZTITLE_1 = BLANK
         ARRAYZ_1 = BLANK
      ENDIF
C
C Calculate NPLOTS
C
      IF (BAR_CHART .OR. PIE_CHART .OR. TWO_PLOTS .OR.
     +    VECTOR_FIELD) THEN
         NPLOTS = NFILES
      ELSE
         NPLOTS = K0
         DO I = K1, NFILES
            IF (L(I).GT.K0 .OR. M(I).GT.0) NPLOTS = NPLOTS + K1
         ENDDO
C
C Must be at least 1 plot with a plot labels type file
C
         IF (NPLOTS.EQ.K0 .AND. PLOT_LABELS) NPLOTS = K1
      ENDIF
      IF (PIE_CHART) BORDER = .FALSE.
      IF (DENDRO_GRAM .AND. MXTIC.NE.NPTSAV - K1) MXTIC = NPTSAV - K1
C
C Call GKSPLT$ to start the plotting ...................................
C
      IF (.NOT.XLABEL) MXTIC = -K1
C
C Draw background objects before axes and data have been plotted
C
      IF (.NOT.PIE_CHART) THEN
         I = K0
         CALL PLTOBJ$(K5, I)
      ENDIF
C
C Retrieve edited parameters
C      
      STORE = .FALSE.
      CALL SAVLGL$(K5,
     +             WIDE_PANEL, STORE) 
      CALL SAVLGL$(K6,
     +             PANEL_LINES, STORE) 
      CALL SAVLGL$(K7,
     +             PANEL_SYMBOLS, STORE)        
C
C Check if OFFSET needs re-setting before calling GKSPLT$ in case SVG uses re-scaling 
C
      OFFSET_SVG = OFFSET     
      IF (.NOT.BAR_CHART) THEN
         CALL SVGPAR (K0,
     +                X_SVG, Y_SVG,
     +                ACTIVE_SVG)
         IF (ACTIVE_SVG) THEN
           IF (X_SVG.GT.ONE + PNT5 .OR.
     +         Y_SVG.GT.ONE + PNT5) OFFSET_SVG = .FALSE.
         ENDIF    
      ENDIF
C      
C Resume normal plotting
C        
      CALL GKSPLT$(IPANEL, ISHAPE, KANGLE, KCOLOR, KTIC, LCTEMP,
     +             MTRANS, MXDROP, MXTIC, MYTIC, MZTIC,
     +             NCFONT, NCLIP, NGROUP, NKCOL, NLOG, NMAX, NPLOTS,
     +             NPTSAV, NTFONT, NWORDS, NXFONT, NYFONT,
     +             A, B, C, CZ, D, DRAGTI, DRAGXL, DRAGYL, DRAGZL, DZ,
     +             FACTOR, THICK, X, XCLIP, XCOORD, XMAX, XMIN,
     +             XPC, XPDRAG, XPMAX, XPMIN, XPT, XPX, XPY, YCLIP,
     +             YCOORD, YDROP, YMAX, YMAX1, YMIN, YMIN1, YPCHT,
     +             YPMAX, YPMIN, YSCALE,
     +             ZCOORD, ZMAX, ZMAX1, ZMIN, ZMIN1,
     +             ARRAYQ, ARRAYT(MTRANS), ARRAYX(MTRANS),
     +             ARRAYY(MTRANS), ARRAYZ_1,
     +             LABELS, LABVEC, PTITLE(MTRANS), QTITLE, WORDX, WORDY,
     +             XTITLE(MTRANS), YTITLE(MTRANS), ZTITLE_1,
     +             ABORT, BAR_CHART, BORDER, BOXIT, BRAY_CURTIS, CENTRE,
     +             FRAME, GRATICULE, MONO, NATLOG, NUMBRX, OFFSET_SVG,
     +             PANEL, PCENTX, PCENTY, PCENTZ,
     +             PHIGHX, PHIGHY, PHIGHZ,
     +             PIE_CHART, PLOT_TITLE, PLOTX, PLOTY, PLOTZ, POWERX_1,
     +             POWERY_1, POWERZ_1, ROTATE,
     +             SHOW_BACKGROUND, SHOW_QUADRANTS,
     +             SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS, SIDE, SWAP_YZ,
     +             THREE_D, TWO_PLOTS,
     +             VIDEO, XGRID, XTOINT, YGRID, YTOINT, ZTOINT)
      IF (ABORT) GOTO 40
C
C Set FIRST = .FALSE. then call PANELS$ to define XPMAX,XPMIN,etc.......
C
      IF (PANEL .AND. .NOT.BAR_CHART .AND. .NOT.PIE_CHART) THEN
         FIRST = .FALSE.
         CALL PANELS$(IPANEL, ISHAPE, KPANEL, L, M, NFILES, NGRAFS,
     +                PSCALE, XDIFF, XMAX, XMIN, XPANEL, XPDRAG, XPMAX,
     +                XPMIN, XSTART, YDIFF, YMAX, YMIN, YPDRAG, YPXTRA,
     +                PLINE, FIRST, PANEL, SIDE)
      ENDIF

C
C Draw intermediate objects after axes but before data have been plotted
C
      IF (.NOT.PIE_CHART) THEN
         I = K0
         CALL PLTOBJ$(K7, I)
      ENDIF    
C
C Define YDELTA and YPDIFF ....................................
C
      YDELTA = (YMAX1 - YMIN1)/YSCALE
      YPDIFF = YPMAX - YPMIN
C
C Now draw the points on the graph as follows:-
C GKSFIL to read in coordinates from input files
C GKSTRN to transform coordinates depending on MTRANS
C Define PSHOW = .TRUE. if points to be plotted
C GKSMRK to draw lines if in feasible region
C GKSBAR to draw error bars if appropriate
C GKSHOL to draw and fill plotting symbols
C
C First loop ... Call GKSFIL/GKSTRN/GKSMRK/GKSBAR ......................
C                Also calls BARCHT and PIECHT and plots vector field arrows
C
C **.............This loop draws line sections for a normal plot and it
C **.............draws the barchart and piechart plotting symbols.
C **.............It draws the panels also for bar and pie charts.
C
      IF (VECTOR_FIELD) THEN
         L(1) = 0
         M(1) = 0
      ENDIF   
        
      CALL LOOP01$(ICOLOR, IFILL, IHUE, IPANEL, ISHAPE, JCOLOR, KCOLOR, 
     +             KPANEL, L, LCTEMP, M, MTRANS,
     +             NFILES, NGRAFS, NIN, NKCOL, NLOG, NMAX, NPANEL, NPTS,
     +             NT, NTYPE, NWORDS, NXTRA,
     +             A, ASYMP, B, C, CZ, D, DZ,
     +             FACTOR, PSCALE, SIZE, WIDE,
     +             X, XH, XHT, XL, XLT, XMAX, XMIN, XPANEL,
     +             XT, Y, YDIFF, YDELTA, YH, YHT, YL, YLT, YMAX,
     +             YMAX3, YMAX4, YMIN, YMIN1, YMIN3, YMIN4, YPANEL,
     +             YPDIFF, YPXTRA, YT, ZMAX, ZMIN, ZSCALE,
     +             FSAV1, PLINE,
     +             ABORT, BARCAP, BARCAP_1, BAR_CHART, LOWER, MONO,
     +             NATLOG, PANEL, PANEL_LINES, PIE_CHART, PS, PSHOW,
     +             SIDE, THREE_D, UPPER, VECTOR_FIELD, VIDEO,
     +             WIDE_PANEL, YAXIS)
C
C Second loop: Call GKSHOL to draw/fill-in markers if in feasible region
C              PSHOW must be defined by the previous call to LOOP01.....
C
C **...........This loop draws plotting symbols but not for bar charts.
C **...........It draws bars as plotting symbols if requested instead of
C **...........circles triangles squares etc.
C
C
      IF (.NOT.PIE_CHART) THEN
         CALL LOOP02$(ICOLOR, IFILL, IHUE, IPANEL, ISHAPE, JCOLOR,
     +                KPANEL, LCTEMP, M, MTRANS,
     +                NFILES, NGRAFS, NIN, NLOG, NMAX, NPANEL, NPTS, NT,
     +                NTYPE, NWORDS, NXTRA,
     +                A, ASYMP, C, CZ,
     +                FACTOR, PSCALE, SIZE, WIDE,
     +                X, XH, XHT, XL, XLT, XMAX, XMIN,
     +                XPANEL, XT,
     +                Y, YDIFF, YDELTA, YH, YHT, YL, YLT, YMAX,YMAX3,
     +                YMAX4, YMIN, YMIN1, YMIN3, YMIN4, YPANEL,
     +                YPDIFF, YPXTRA, YT, ZMAX, ZMIN, ZSCALE,
     +                FSAV1,
     +                ABORT, BARCAP, BAR_CHART, MONO,
     +                NATLOG, PANEL, PANEL_LINES, PANEL_SYMBOLS, PS, 
     +                PSHOW, SIDE, VECTOR_FIELD, VIDEO, WIDE_PANEL,
     +                YAXIS)
      ENDIF
C
C Third loop: Draw text next to line/marker for panel if required ......
C
      IF (PANEL) THEN  
         IF (PIE_CHART) THEN
            CALL PCKEYS$(K1, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS,
     +                   XPDRAG, YPDRAG, WIDE(1), WIDE(NGRAFS + 1),
     +                   XPC, Y_SCALE,
     +                   FSAV1(1), PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
         ELSEIF (BAR_CHART) THEN
            CALL BCKEYS$(K1, IFILL, IHUE, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS,
     +                   XPDRAG, YPDRAG, WIDE(1), WIDE(NGRAFS + 1),
     +                   XPC, Y_SCALE,
     +                   PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
         ELSE
            IFONT = NCFONT
            CALL LOOP03$(ICOLOR, IFONT, IPANEL, ISHAPE, KCOLOR, KPANEL,
     +                   L, M, NFILES, NKCOL, K0, NOUT_PS,
     +                   XPC, XSTART,
     +                   YPCHT, YPDIFF, YPMAX, YPMIN, YPXTRA, Y_SCALE,
     +                   PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PANEL, PANEL_LINES, PS,
     +                   PSHOW, SIDE, VIDEO, WIDE_PANEL)
         ENDIF
      ENDIF
C
C Plot labels instead of symbols
C
      IF (PLOT_LABELS) THEN
         IF (DFOLT_1) THEN
            DO I = K1, NWORDS
               JKOLOR(I) = IHUE(I)
            ENDDO
         ELSE
            DO I = K1, NWORDS
               JKOLOR(I) = JCOLOR(1)
            ENDDO
         ENDIF        
         IF (BI_PLOT) THEN 
            CALL PLTLAB$(JKOLOR, M(1), MTRANS, NCFONT, NIN, NMAX,
     +                   NOUT_PS, NWORDS,
     +                   ASYMP, SIZE(1),
     +                   X, XMAX, XMIN, XPC, XT,
     +                   Y, YMAX, YMIN, Y_SCALE, YT,
     +                   VFFILE, LABELS, LABVEC,
     +                   HARD_COPY, HPGL, MONO, NATLOG, PLOTZ, PS,
     +                   VIDEO)
         ELSE
            CALL PLTLAB$(JKOLOR, M(1), MTRANS, NCFONT, NIN, NMAX,
     +                   NOUT_PS, NWORDS,
     +                   ASYMP, SIZE(1),
     +                   X, XMAX, XMIN, XPC, XT,
     +                   Y, YMAX, YMIN, Y_SCALE, YT,
     +                   FSAV(1), LABELS, LABVEC,
     +                   HARD_COPY, HPGL, MONO, NATLOG, PLOTZ, PS,
     +                   VIDEO)
         ENDIF
      ENDIF

C
C Draw foreground arrows, objects and all extra texts after data have been plotted
C
      I = K0
      CALL PLTOBJ$(K4, I)
C
C Plot is cancelled so call GKSDEC to decide next course of action .....
C=======================================================================
C
      FIRST = .FALSE.
      NPRESS = K1
      CALL DECGKS$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS ................
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL,
     +             PS)
C
C Now decide what to do next, plot, print, file or stop
C=======================================================================
C
      IF (NPRESS.EQ.20) THEN
         CALL DELEET (ADJLAB,
     +                ASKIF, THERE) 
         CALL DELEET (LABFIL,
     +                ASKIF, THERE)              
         CALL DELEET (VFFILE,
     +                ASKIF, THERE)
         ISEND = K0  
         CALL GKSSAV$(ISEND, K0,
     +                ABORT)
C
C Switch off background objects before quitting GKSGRF$
C     
         I = K0 
         CALL PLTOBJ$(K6, I)      
         RETURN
      ELSEIF (NPRESS.EQ.21 .OR. NPRESS.EQ.23) THEN
         GOTO 60
      ELSE
         GOTO 40
      ENDIF
      END
C
C
