C
C GKSHB4
C ======
C
C Read the introduction to gks004
C
C Horizontal error bars by interchanging X and Y
C
      SUBROUTINE GKSHB4 (ITYPE,
     +                   L1, L2, L3, L4, M1, M2, M3, M4,
     +                   N1D, N2D, N3D, N4D,
     +                   X1D, X2D, X3D, X4D,
     +                   YH1D, YH3D, YL1D, YL3D, Y1D, Y2D, Y3D, Y4D,
     +                   PTITLE, YTITLE, XTITLE,
     +                   AXES, GSAVE)
C
C ACTION  : Call GKS as for GKSEB4 except as follows:
C
C           ITYPE = 0: no transformation
C           ITYPE = 1: y to log base e of y
C           ITYPE = 2: y to log base 10 of y
C           All arguments are (input/unchanged) as for GKSEB4
C
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Modification of GKSEB4 to draw horizontal error bars 6/8/99
C           Note: In this version X and Y as input are interchanged
C                 as are the x and y legends. The idea is that it can
C                 be called with the same argument list as GKSEB4 and
C                 it will interchange X and Y. Note also that any ASCII
C                 coordinate files saved will be in the original space.
C           23/09/1999 Changed definition of TEXT into PTEXT = PTITLE, etc.
C           29/01/2000 Changed meaning of ITYPE
C           12/03/2001 introduced SMPLOT$
C           24/08/2001 introduced call to GSCALE$
C           25/10/2004 added XGRID and XHAIRS in call to GKSMNU and GKSBOX
C           21/12/2004 corrected call to GKSBAR$ with N1 instead of N3 for X3,Y3
C           10/01/2005 made PTITLE, XTITLE, YTITLE arrays to input titles, etc.
C                      for transfer to SIMPLOT, also disabled TEXTS
C           29/06/2006 introduced allocatable arrays, I1FILE, and I2FILE 
C           19/04/2007 added INTENTS 
C           14/06/2007 removed defngks.ins and added GETGKS_LGL
C           29/10/2007 reversed TITLES(2) and TITLES(3) for call to SMPLOT$
C           29/12/2008 restored option for ITYPE = 0 and added checks for illegal logs
C           29/07/2009 added calls to GKSTIC$ and GKSLGL$
C           04/08/2009 added call to GKSCOL$
C           13/08/2009 replaced GSCALE$ by DOAXIS$ and added SIGGKS$
C           10/03/2021 added call to NXXFIL$
C           14/03/2021 added MSYMBL$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ITYPE,
     +                                    L1, L2, L3, L4,
     +                                    M1, M2, M3, M4,
     +                                    N1D, N2D, N3D, N4D
      DOUBLE PRECISION,    INTENT (IN) :: X1D(*), X2D(*), X3D(*), X4D(*)
      DOUBLE PRECISION,    INTENT (IN) :: YH1D(*), YH3D(*), YL1D(*),
     +                                    YL3D(*)
      DOUBLE PRECISION,    INTENT (IN) :: Y1D(*), Y2D(*), Y3D(*), Y4D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE(2), XTITLE(2),
     +                                    YTITLE(2)
      LOGICAL,             INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: X1(:), X2(:), X3(:), X4(:)
      DOUBLE PRECISION, ALLOCATABLE :: XH1(:), XH3(:), XL1(:), XL3(:)
      DOUBLE PRECISION, ALLOCATABLE :: Y1(:), Y2(:), Y3(:), Y4(:)      
C
C Locals
C
      INTEGER    ISEND, JSEND, NJCOL, NKCOL, NLGL
      PARAMETER (ISEND = 1, JSEND = 3, NJCOL = 5, NKCOL = 4, NLGL = 7)
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K10, K15
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K10 = 10, K15 = 15)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    KTIC, KTYPE, LCTEMP, NPLOTS, MXTIC, MYTIC
      INTEGER    NLDGX, NLDGY, NXSIG, NYSIG
      INTEGER    N1, N2, N3, N4
      INTEGER    I, ICOL(K4), IERR, J, LN(K4), MK(K4)
      INTEGER    LN1, LN2, LN3, LN4, MK1, MK2, MK3, MK4
      INTEGER    IFAIL, JFILES(K4), LFILES(K4), MFILES(K4), NFILES,
     +           NOUT, NUMBER(K4)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 7)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      DOUBLE PRECISION ONE, PNT25, ZERO
      PARAMETER (ONE = 1.0D+00, PNT25 = 0.25D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION A, B, C, D, FACTOR
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  CIPHER(K4)*60, INFO(K6)*60, TEXT(10)*100, TITLES(K4)*80
      CHARACTER  FILES(K4)*1024, LINE*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ') 
      CHARACTER  ERROR*80
      PARAMETER (ERROR = 'Cannot have log(x) for x =< 0') 
      LOGICAL    LGLVAR(NLGL)
      LOGICAL    HARD_COPY
      LOGICAL    BARCAP, LOWER, UPPER
      PARAMETER (BARCAP = .TRUE., LOWER = .TRUE., UPPER = .TRUE.)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      LOGICAL    ABORT, ASCII, FIRST, MONO, PCX, VIDEO
      LOGICAL    BOXIT, FRAME, OFFSET, TEXTS, XGRID, XHAIRS, YGRID
      LOGICAL    XTOINT, YTOINT, YVERT
      LOGICAL    PLOT(K4)
      EXTERNAL   GKSD2S$, MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, GKSMRK$,
     +           GKSBAR$, GKSHOL$, NX2FIL$, NX4FIL$, DEFGKS$, PUTFAT$,
     +           SMPLOT$, DOAXIS$, GKSTIC$, GKSLGL$, GKSCOL$, GKSSIG$
      EXTERNAL   GETGKS_LGL, NXXFIL$, MSYMBL$
      EXTERNAL   LBOX02, GETTMP, GETNOU, DELEET, I1FILE, I2FILE
      INTRINSIC  MAX, LOG10, LOG
C
C Data to confer SAVE and avoid UNDEF
C
      SAVE ICOL, LCTEMP
      DATA ICOL / K0, K0, K0, K0 /
      DATA LCTEMP / K15 /
      DATA NUMPOS / NUMOPT*1 /
C
C Check 0 =< ITYPE =< 2
C
      IF (ITYPE.LT.0 .OR. ITYPE.GT.2) THEN
         WRITE (LINE,100)
         CALL PUTFAT$(LINE)
         RETURN
      ENDIF 

      WRITE (INFO,200)
C
C Initialise DEFNGKS.INS
C
      CALL DEFGKS$
C
C How many plots and find the minimum and maximum of the X and Y values
C
      KTYPE = K0
      NPLOTS = K0
      PLOT(K1) = .FALSE.
      PLOT(K2) = .FALSE.
      PLOT(K3) = .FALSE.
      PLOT(K4) = .FALSE.
      MXTIC = K4
      MYTIC = K4
      N1 = MAX(N1D, K0)
      N2 = MAX(N2D, K0)
      N3 = MAX(N3D, K0)
      N4 = MAX(N4D, K0)
      NUMBER(K1) = N1
      NUMBER(K2) = N2
      NUMBER(K3) = N3
      NUMBER(K4) = N4
      IF (N1 + N2 + N3 + N4 .EQ. K0) RETURN
C
C Allocate workspaces
C     
      IERR = K0  
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XH1)) DEALLOCATE(XH1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XH3)) DEALLOCATE(XH3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XL1)) DEALLOCATE(XL1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XL3)) DEALLOCATE(XL3, STAT = IERR)
      IF (IERR.NE.0) RETURN       
C
C Copy titles for plotting and transfer to SIMPLOT
C
      PTEXT = PTITLE(K1)
      XTEXT = XTITLE(K1)
      YTEXT = YTITLE(K1)
      TITLES(K1) = PTITLE(K2)
C
C Note: X and Y are interchanged in order to call SMPLOT$ 
C      
      TITLES(K2) = YTITLE(K2)
      TITLES(K3) = XTITLE(K2)
      TITLES(K4) = BLANK
C
C Initialise CIPHER
C
      DO I = K1, K4
         CIPHER(I) = INFO(K1)
      ENDDO
      IF (N1.GT.K0 .AND. (L1.GT.K0 .OR. M1.GT.K0)) THEN
C
C Copy X1D, Y1D, YH1D, YL1D to Y1, X1, XH1, XL1
C     
         ALLOCATE(X1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XH1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XL1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K1) = .TRUE.
         CIPHER(K1) = INFO(K2)
         CALL GKSD2S$(N1, X1D, Y1)
         CALL GKSD2S$(N1, Y1D, X1)
         CALL GKSD2S$(N1, YH1D, XH1)
         CALL GKSD2S$(N1, YL1D, XL1)
         IF (ITYPE.EQ.K1) THEN
C
C Transform X1, XH1, XL1 to log base e
C
            DO I = K1, N1
               IF (X1(I).LE.ZERO .OR. XH1(I).LE.ZERO .OR.
     +             XL1(I).LE.ZERO) THEN
                   CALL PUTFAT$(ERROR)
                   RETURN
               ELSE    
                  X1(I) = LOG(X1(I))
                  XH1(I) = LOG(XH1(I))
                  XL1(I) = LOG(XL1(I))
               ENDIF   
            ENDDO
         ELSEIF (ITYPE.EQ.K2) THEN
C
C Transform X1, XH1, XL1 to log base 10
C
            DO I = K1, N1
              IF (X1(I).LE.ZERO .OR. XH1(I).LE.ZERO .OR.
     +             XL1(I).LE.ZERO) THEN
                   CALL PUTFAT$(ERROR)
                   RETURN
               ELSE    
                  X1(I) = LOG10(X1(I))
                  XH1(I) = LOG10(XH1(I))
                  XL1(I) = LOG10(XL1(I))
               ENDIF   
            ENDDO
         ENDIF
         CALL MAXMIN$(KTYPE, N1, X1, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N1, Y1, YMAX, YMIN)
         KTYPE = K1
         CALL MAXMIN$(K1, N1, XH1, XMAX, XMIN)
         CALL MAXMIN$(K1, N1, XL1, XMAX, XMIN)
      ELSE
         ALLOCATE(X1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XH1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XL1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (N2.GT.K0 .AND. (L2.GT.K0 .OR. M2.GT.K0)) THEN
         ALLOCATE(X2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K2) = .TRUE.
         CIPHER(K2) = INFO(K3)
         CALL GKSD2S$(N2, X2D, Y2)
         CALL GKSD2S$(N2, Y2D, X2)
         IF (ITYPE.EQ.K1) THEN
C
C Transform X2 to log base e
C
            DO I = K1, N2
               IF (X2(I).LE.ZERO) THEN
                  CALL PUTFAT$(ERROR)
                  RETURN
               ELSE   
                  X2(I) = LOG(X2(I))
               ENDIF   
            ENDDO
         ELSEIF (ITYPE.EQ.K2) THEN
C
C Transform X2 to log base 10
C
            DO I = K1, N2
               IF (X2(I).LE.ZERO) THEN
                  CALL PUTFAT$(ERROR)
                  RETURN
               ELSE   
                  X2(I) = LOG10(X2(I))
               ENDIF   
            ENDDO
         ENDIF
         CALL MAXMIN$(KTYPE, N2, X2, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N2, Y2, YMAX, YMIN)
         KTYPE = K1
      ELSE
         ALLOCATE(X2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (N3.GT.K0 .AND. (L3.GT.K0 .OR. M3.GT.K0)) THEN
         ALLOCATE(X3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XH3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XL3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K3) = .TRUE.
         CIPHER(K3) = INFO(K2)
         CALL GKSD2S$(N3, X3D, Y3)
         CALL GKSD2S$(N3, Y3D, X3)
         CALL GKSD2S$(N3, YH3D, XH3)
         CALL GKSD2S$(N3, YL3D, XL3)
         IF (ITYPE.EQ.K1) THEN
C
C Transform X3, XH3, XL3 to log base e
C
            DO I = K1, N3
              IF (X3(I).LE.ZERO .OR. XH3(I).LE.ZERO .OR.
     +             XL3(I).LE.ZERO) THEN
                   CALL PUTFAT$(ERROR)
                   RETURN
               ELSE                  
                  X3(I) = LOG(X3(I))
                  XH3(I) = LOG(XH3(I))
                  XL3(I) = LOG(XL3(I))
               ENDIF   
            ENDDO
         ELSEIF (ITYPE.EQ.K2) THEN
C
C Transform X3, XH3, XL3 to log base 10
C
            DO I = K1, N3
              IF (X3(I).LE.ZERO .OR. XH3(I).LE.ZERO .OR.
     +             XL3(I).LE.ZERO) THEN
                   CALL PUTFAT$(ERROR)
                   RETURN
               ELSE                  
                  X3(I) = LOG10(X3(I))
                  XH3(I) = LOG10(XH3(I))
                  XL3(I) = LOG10(XL3(I))
               ENDIF   
            ENDDO
         ENDIF
         CALL MAXMIN$(KTYPE, N3, X3, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N3, Y3, YMAX, YMIN)
         KTYPE = K1
         CALL MAXMIN$(K1, N3, XH3, XMAX, XMIN)
         CALL MAXMIN$(K1, N3, XL3, XMAX, XMIN)   
      ELSE
         ALLOCATE(X3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XH3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(XL3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N4.GT.K0 .AND. (L4.GT.K0 .OR. M4.GT.K0)) THEN
         ALLOCATE(X4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT(K4) = .TRUE.
         CIPHER(K4) = INFO(K3)
         CALL GKSD2S$(N4, X4D, Y4)
         CALL GKSD2S$(N4, Y4D, X4)
         IF (ITYPE.EQ.K1) THEN
C
C Transform X4 to log base e
C
            DO I = K1, N4
               IF (X4(I).LE.ZERO) THEN
                  CALL PUTFAT$(ERROR)
                  RETURN
               ELSE   
                  X4(I) = LOG(X4(I))
               ENDIF   
            ENDDO
         ELSEIF (ITYPE.EQ.K2) THEN
C
C Transform X4 to log base 10
C
            DO I = K1, N4
               IF (X4(I).LE.ZERO) THEN
                  CALL PUTFAT$(ERROR)
                  RETURN
               ELSE                 
                  X4(I) = LOG10(X4(I))
               ENDIF   
            ENDDO
         ENDIF
         CALL MAXMIN$(KTYPE, N4, X4, XMAX, XMIN)
         CALL MAXMIN$(KTYPE, N4, Y4, YMAX, YMIN)
      ELSE
         ALLOCATE(X4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN 
         ALLOCATE(Y4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (NPLOTS.EQ.K0) GOTO 80
C
C Find suitable ranges for X and Y axes
C
      CALL DOAXIS$(MXTIC, NLDGX,
     +             XMAX, XMIN) 
      CALL DOAXIS$(MYTIC, NLDGY,
     +             YMAX, YMIN)           
      CALL GKSTIC$(ISEND, MXTIC, MYTIC)
C
C Set default significance
C      
      NXSIG = K2
      NYSIG = K2
      CALL GKSSIG$(ISEND, NLDGX, NXSIG, NLDGY, NYSIG)           
C
C Initialise GKSDEC
C
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      KTIC = K3
      LN(K1) = L1
      LN(K2) = L2
      LN(K3) = L3
      LN(K4) = L4
      MK(K1) = M1
      MK(K2) = M2
      MK(K3) = M3
      MK(K4) = M4
      CALL MSYMBL$(MK(K1), N1)
      CALL MSYMBL$(MK(K2), N2)
      CALL MSYMBL$(MK(K3), N3)
      CALL MSYMBL$(MK(K4), N4)
C
C Initialise plot style parameters
C
      TEXTS = .FALSE.
      XTOINT = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.
      CALL GKSLGL$(JSEND, NLGL,
     +             LGLVAR)
      BOXIT = LGLVAR(1)      
      FRAME = LGLVAR(2)      
      OFFSET = LGLVAR(3)      
      XGRID = LGLVAR(4)      
      YGRID = LGLVAR(5)      
      XHAIRS = LGLVAR(6) 
      IF (LGLVAR(7)) THEN
         KTIC = K3
      ELSE
         KTIC = K1
      ENDIF           
C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Enquire if default axes are satisfactory
C              
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY)      
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, K4, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
      LN1 = LN(K1)
      LN2 = LN(K2)
      LN3 = LN(K3)
      LN4 = LN(K4)
      MK1 = MK(K1)
      MK2 = MK(K2)
      MK3 = MK(K3)
      MK4 = MK(K4)
C
C Call GKSBOX to set up a GKS portrait frame
C
      CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +             NCFONT, NTFONT, NXFONT, NYFONT,
     +             A, B, C, D,
     +             ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +             XPC, XPT, XPX, XPY, YMAX, YMIN,
     +             PTEXT, XTEXT, YTEXT,
     +             ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +             XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      IF (ABORT) RETURN
C
C Set colours then call GKSMRK to draw lines
C
      LCTEMP = K15
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = K15
            ICOL(K1) = K0
            ICOL(K2) = K0
            ICOL(K3) = K0
            ICOL(K4) = K0
         ELSE
            LCTEMP = K0
            ICOL(K1) = K15
            ICOL(K2) = K15
            ICOL(K3) = K15
            ICOL(K4) = K15
         ENDIF
      ELSE
         CALL GKSCOL$(JSEND, JCOL, KCOL, NJCOL, NKCOL)
         LCTEMP = JCOL(5)
         ICOL(K1) = KCOL(K1)
         ICOL(K2) = KCOL(K2)
         ICOL(K3) = KCOL(K3)
         ICOL(K4) = KCOL(K4)
      ENDIF
C
C Call GKSMRK/GKSBAR to draw lines and/or markers and error bars
C
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K1), K1, LN1, MK1, N1, A, B, C, D, FACTOR,
     +                ONE, X1, XMAX, XMIN, Y1, YMAX, YMIN)
         CALL GKSBAR$(ICOL(K1), K1, K10, N1, A, B, C, D, FACTOR, ONE,
     +                X1, XH1, XL1, XMAX, XMIN,
     +                Y1, Y1, Y1, YMAX, YMIN, BARCAP, LOWER, UPPER)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K2), K1, LN2, MK2, N2, A, B, C, D, FACTOR,
     +                ONE, X2, XMAX, XMIN, Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K3), K1, LN3, MK3, N3, A, B, C, D, FACTOR,
     +                ONE, X3, XMAX, XMIN, Y3, YMAX, YMIN)
         CALL GKSBAR$(ICOL(K3), K1, K10, N3, A, B, C, D, FACTOR, ONE,
     +                X3, XH3, XL3, XMAX, XMIN,
     +                Y3, Y3, Y3, YMAX, YMIN, BARCAP, LOWER, UPPER)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSMRK$(ICOL(K4), K1, LN4, MK4, N4, A, B, C, D, FACTOR,
     +                ONE, X4, XMAX, XMIN, Y4, YMAX, YMIN)
      ENDIF
      IF (PLOT(K1)) THEN
         IF (MK1.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K1), K1, LCTEMP, MK1, N1, A, C, FACTOR, ONE,
     +                X1, XMAX, XMIN, Y1, YMAX, YMIN)
      ENDIF
      IF (PLOT(K2)) THEN
         IF (MK2.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K2), K1, LCTEMP, MK2, N2, A, C, FACTOR, ONE,
     +                X2, XMAX, XMIN, Y2, YMAX, YMIN)
      ENDIF
      IF (PLOT(K3)) THEN
         IF (MK3.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K3), K1, LCTEMP, MK3, N3, A, C, FACTOR, ONE,
     +                X3, XMAX, XMIN, Y3, YMAX, YMIN)
      ENDIF
      IF (PLOT(K4)) THEN
         IF (MK4.EQ.K1) THEN
            FACTOR = PNT25
         ELSE
            FACTOR = ONE
         ENDIF
         CALL GKSHOL$(ICOL(K4), K1, LCTEMP, MK4, N4, A, C, FACTOR, ONE,
     +                X4, XMAX, XMIN, Y4, YMAX, YMIN)
      ENDIF
C
C LABEL 40
C ========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      IF (ASCII) THEN
C
C LABEL 60: Note that original data is written to the ASCII output files
C =========
C
   60    CONTINUE
         WRITE (TEXT,300) (CIPHER(I), I = K1, K4)
         NUMDEC = NUMOPT - K2
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.K1) THEN
            IF (PLOT(K1)) THEN
               CALL NX4FIL$(N1D, X1D, YL1D, Y1D, YH1D)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  CIPHER(K1) = INFO(K2)
               ELSE   
                  CIPHER(K1) = INFO(K4)
               ENDIF   
            ELSE
               WRITE(LINE,400) K1
               CALL PUTFAT$(LINE)
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K2) THEN
            IF (PLOT(K2)) THEN
               CALL NX2FIL$(N2D, X2D, Y2D)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  CIPHER(K2) = INFO(K3)
               ELSE   
                  CIPHER(K2) = INFO(K5)
               ENDIF   
            ELSE
               WRITE(LINE,400) K2
               CALL PUTFAT$(LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.K3) THEN
            IF (PLOT(K3)) THEN
               CALL NX4FIL$(N3D, X3D, YL3D, Y3D, YH3D)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  CIPHER(K3) = INFO(K2)
               ELSE   
                  CIPHER(K3) = INFO(K4)
               ENDIF   
            ELSE
               WRITE(LINE,400) K3
               CALL PUTFAT$(LINE)
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K4) THEN
            IF (PLOT(K4)) THEN
               CALL NX2FIL$(N4D, X4D, Y4D)
               CALL NXXFIL$ (ABORT, STORE)
               IF (ABORT) THEN
                  CIPHER(K4) = INFO(K3)
               ELSE   
                  CIPHER(K4) = INFO(K5)
               ENDIF   
            ELSE
               WRITE(LINE,400) K4
               CALL PUTFAT$(LINE)
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.K5) THEN
            NFILES = K0
            DO I = K1, K4
               IF (PLOT(I)) THEN
                  NFILES = NFILES + K1
                  JFILES(NFILES) = ICOL(I)
                  LFILES(NFILES) = LN(I)
                  MFILES(NFILES) = MK(I)
                  CALL GETTMP (IFAIL, FILES(NFILES))
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FILES(NFILES))
                  WRITE (NOUT,'(A)') INFO(K6)
                  IF (I.EQ.K1 .OR. I.EQ.K3) THEN   
                     CALL I2FILE (NOUT, NUMBER(I), K4)
                  ELSE
                     CALL I2FILE (NOUT, NUMBER(I), K2)
                  ENDIF
                  DO J = K1, NUMBER(I)
                     IF (I.EQ.K1) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X1D(J), YL1D(J),
     +                                             Y1D(J), YH1D(J)
                     ELSEIF (I.EQ.K2) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X2D(J), Y2D(J)
                     ELSEIF (I.EQ.K3) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X3D(J), YL3D(J),
     +                                             Y3D(J), YH3D(J)
                     ELSEIF (I.EQ.K4) THEN
                        WRITE (NOUT,'(1P,2E13.5)') X4D(J), Y4D(J)
                     ENDIF
                  ENDDO
                  CALL I1FILE (NOUT, K1)
                  WRITE (NOUT,'(A)') INFO(K6)
                  CLOSE (UNIT = NOUT)
               ENDIF
            ENDDO
            CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES, 
     +                   FILES, TITLES)
            DO I = K1, NFILES
               CALL DELEET (FILES(I),
     +                      ASKIF, THERE)
            ENDDO
            GOTO 60
         ELSEIF (NUMDEC.EQ.K6) THEN
            ASCII = .TRUE.
            GOTO 40
         ELSE
            RETURN
         ENDIF
      ENDIF
      IF (.NOT.ABORT) GOTO 20
   80 CONTINUE        
      DEALLOCATE (X1, STAT = IERR)    
      DEALLOCATE (X2, STAT = IERR)
      DEALLOCATE (X3, STAT = IERR)
      DEALLOCATE (X4, STAT = IERR)
      DEALLOCATE (Y1, STAT = IERR)
      DEALLOCATE (Y2, STAT = IERR)
      DEALLOCATE (Y3, STAT = IERR)
      DEALLOCATE (Y4, STAT = IERR)
      DEALLOCATE (XH1, STAT = IERR)
      DEALLOCATE (XH3, STAT = IERR)
      DEALLOCATE (XL1, STAT = IERR)
      DEALLOCATE (XL3, STAT = IERR)
C
C Format statements
C      
  100 FORMAT ('ITYPE out of range in call to GKSHB4')
  200 FORMAT (
     + 'Missing'
     +/'Error Bars (Save As ... ASCII/project ?)'
     +/'Line (Save As ... ASCII/project ?)'
     +/'Error Bars (Now saved *** ?)'
     +/'Line (Now saved *** ?)'
     +/'Temporary File')
  300 FORMAT (
     + 'Data 1',1X,A
     +/'Data 2',1X,A
     +/'Data 3',1X,A
     +/'Data 4',1X,A
     +/'Advanced editing'
     +/'Return to default graph'
     +/'Cancel')
  400 FORMAT ('No data set',i2)
      END
C
C
