C
C
      SUBROUTINE GKSHOL$(J, K, L, M, N, 
     +                   A, C, SIZE, WIDE, X, XMAX, XMIN, Y, YMAX, YMIN)
C
C ACTION : FILL INSIDE OF SYMBOLS WITH BACKGROUND COLOUR THEN RE-DRAW
C          J = COLOUR, K = ARGUMENT TO GSELNT, L = BACKGROUND COLOUR, M(ARKER)
C
C          DESIGNED TO CLIP X, Y BEFORE PRODUCING OUTPUT
C          A, B, C, D ARE REQUIRED TO PROJECT BETWEEN SPACES
C
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 7/10/92
C          12/10/1992 REMOVED MONO ADDED JOIN
C          28/11/1992 CHANGED GKSPIC TO GKSWGB TO INCLUDE MORE MARKERS
C          23/04/1993 DERIVED FROM GKSMRK 
C          08/07/2006 introduced allocatable arrays but left in JOIN and NTEMP
C                     code (to deal with N > NMAX) for possible future use
C          24/07/2009 added XMAX1, XMIN1, YMAX1 and YMIN1 to prevent excessive clipping   
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: J, K, L, M, N 
      DOUBLE PRECISION, INTENT (IN) :: A, C, SIZE, WIDE, 
     +                                 X(N), XMAX, XMIN,
     +                                 Y(N), YMAX, YMIN
C
C Local allocatable arrays
C  
      DOUBLE PRECISION, ALLOCATABLE :: XTEMP(:), YTEMP(:)
C
C Locals
C                
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I, IERR, NMAX, NTEMP
      DOUBLE PRECISION DELTA, XMAX1, XMIN1, YMAX1, YMIN1
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-04)
      LOGICAL    JOIN  
      EXTERNAL   GKSSYM$
      IF (N.LT.N1) RETURN
      IERR = 0
      IF (ALLOCATED(XTEMP)) DEALLOCATE(XTEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(YTEMP)) DEALLOCATE(YTEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      NMAX = N
      ALLOCATE(XTEMP(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(YTEMP(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN 
C
C Define clipping limits XMAX1, XMIN1, YMAX1, YMIN1
C        
      DELTA = EPSI*(XMAX - XMIN)
      XMAX1 = XMAX + DELTA
      XMIN1 = XMIN - DELTA  
      DELTA = EPSI*(YMAX - YMIN)
      YMAX1 = YMAX + DELTA
      YMIN1 = YMIN - DELTA
C
C Plot points only if within clipping limits
C        
      NTEMP = 0
      JOIN = .FALSE.
      DO I = N1, N
         IF (X(I).GE.XMIN1 .AND. X(I).LE.XMAX1 .AND.
     +       Y(I).GE.YMIN1 .AND. Y(I).LE.YMAX1) THEN
            IF (JOIN) THEN
               NTEMP = 1
               XTEMP(NTEMP) = X(I - 1)
               YTEMP(NTEMP) = Y(I - 1)
               JOIN = .FALSE.
            ENDIF
            NTEMP = NTEMP + 1
            XTEMP(NTEMP) = X(I)
            YTEMP(NTEMP) = Y(I)
            IF (NTEMP.EQ.NMAX) THEN
               CALL GKSSYM$(J, K, L, M, NTEMP, A, C, SIZE, WIDE, XTEMP,
     +                      XMAX, XMIN, YTEMP)
               NTEMP = 0
               JOIN = .TRUE.
            ENDIF
         ELSE
            JOIN = .FALSE.
            IF (NTEMP.GT.0) THEN
               CALL GKSSYM$(J, K, L, M, NTEMP, A, C, SIZE, WIDE, XTEMP,
     +                      XMAX, XMIN, YTEMP)
               NTEMP = 0
            ENDIF
         ENDIF
      ENDDO
      IF (NTEMP.GT.0) THEN
         CALL GKSSYM$(J, K, L, M, NTEMP, A, C, SIZE, WIDE, XTEMP, XMAX,
     +                XMIN, YTEMP)
      ENDIF  
      DEALLOCATE(XTEMP, STAT = IERR)
      DEALLOCATE(YTEMP, STAT = IERR)
      END
C
C                                     
