c
c
      subroutine gkshov$(noct1, noct2,
     +                   xmax, xmin, xsol1, xsol2, x1, x2,
     +                   ymax, ymin, ysol1, ysol2, y1, y2,
     +                   horiz, ok, vert)
c
c action: calculate intersection with allowed region for horizontal/vertical cases
c author: w.g.bardsley, university of manchester, u.k., 02/08/2005
c         19/04/2007 added intents
c
c         noct1: (input/unchanged) 0 or 1 as set by gkslim$
c         noct2: (input/unchamged) 0 or 1 as set by gkslim$
c          xmax: (input/unchanged) limit
c          xmin: (input/unchanged) limit
c         xsol1: (output) solution
c         xsol2: (output) solution
c            x1: (input/unchanged) coordinates
c            x2: (input/unchanged) coordinates
c          ymax: (input/unchanged) limit
c          ymin: (input/unchanged) limit
c         ysol1: (output) solution
c         ysol2: (output) solution
c            y1: (input/unchanged) coordinates
c            y2: (input/unchanged) coordinates
c         horiz: (input/unchanged) horizontal line segment if .true.
c            ok: (output) success indicator
c          vert: (input/unchanged) vertical line segment if .true.
c
      implicit   none
c
c arguments
c
      integer,          intent (in)  :: noct1, noct2
      double precision, intent (in)  :: xmax, xmin, x1, x2  
      double precision, intent (out) :: xsol1, xsol2
      double precision, intent (in)  :: ymax, ymin, y1, y2 
      double precision, intent (out) :: ysol1, ysol2
      logical,          intent (in)  :: horiz, vert
      logical,          intent (out) :: ok
c
c locals
c
      double precision xmean, ymean
      double precision two
      parameter (two = 2.0d+00)
c
c check
c
      ok = .true.
      if (horiz .and. vert .or.
     +    .not.horiz .and. .not.vert) then
         ok = .false.
         return
      elseif (horiz) then
         ymean = (y1 + y2)/two
      else
         xmean = (x1 + x2)/two
      endif
      if (noct1.eq.0 .and. noct2.eq.1) then
c
c case 1: x1,y1 is in range but x2,y2 is out of range so
c ======= define xsol2, ysol2 to add point from outside to inside range
c
         if (horiz) then
            if (x2.ge.x1) then
               xsol2 = xmax
            else
               xsol2 = xmin
            endif
            ysol2 = ymean
         else
            if (y2.ge.y1) then
               ysol2 = ymax
            else
               ysol2 = ymin
            endif
            xsol2 = xmean
         endif
      elseif (noct1.eq.1 .and. noct2.eq.0) then
c
c case 2: x1,y1 is out of range, x2,y2 is in range so
c ======= define xsol1, ysol1 to add point from outside to inside
c
         if (horiz) then
            if (x2.ge.x1) then
               xsol1 = xmin
            else
               xsol1 = xmax
            endif
            ysol1 = ymean
         else
            if (y2.ge.y1) then
               ysol1 = ymin
            else
               ysol1 = ymax
            endif
            xsol1 = xmean
         endif
      elseif (noct1.eq.1 .and. noct2.eq.1) then
c
c case 3: x1,y1 and x2,y2 are both out of range so
c ======= must redefine xsol1, ysol1 and xsol2, ysol2
c
         if (horiz .and. ymean.ge.ymin .and. ymean.le.ymax) then
            if (x1.le.xmin .and. x2.ge.xmax) then
               xsol1 = xmin
               xsol2 = xmax
               ysol1 = ymean
               ysol2 = ymean
            elseif (x2.le.xmin .and. x1.ge.xmax) then
               xsol1 = xmax
               xsol2 = xmin
               ysol1 = ymean
               ysol2 = ymean
            else
               ok = .false.
            endif
         elseif (vert .and. xmean.ge.xmin .and. xmean.le.xmax) then
            if (y1.le.ymin .and. y2.ge.ymax) then
               ysol1 = ymin
               ysol2 = ymax
               xsol1 = xmean
               xsol2 = xmean
            elseif (y2.le.ymin .and. y1.ge.ymax) then
               ysol1 = ymax
               ysol2 = ymin
               xsol1 = xmean
               xsol2 = xmean
            else
               ok = .false.
            endif
         else
            ok = .false.
         endif
      endif
      end
c
c
