c
c
      subroutine gkslim$(n, nmax, nnew,
     +                   x, xmax, xmin, xnew,
     +                   y, ymax, ymin, ynew,
     +                   abort, extend)
c
c action: extend lines by introducing new points at intersection with limits
c author: w.g.bardsley, university of manchester, u.k., 03/08/2005
c         19/04/2007 added intents
c
c         n: (input/unchanged) dimension
c      nmax: (input/unchanged) dimension
c      nnew: (output) number of new points
c         x: (input/unchanged) data
c      xmax: (input/unchanged) limit for clipping rectangle
c      xmin: (input/unchanged) limit for clipping rectangle
c      xnew: (output) new points
c         y: (input/unchanged) data
c      ymax: (input/unchanged) limit for clipping rectangle
c      ymin: (input/unchanged) limit for clipping rectangle
c      ynew: (output) new points
c     abort: (output) error indicator
c    extend: (input/unchanged) extend lines to boundary if .true.
c
c advice: normally nmax should be big enough to accomodate extra points
c         introduced when lines for plotting cross over the range boundaries
c         This version only allows noct1 and noct2 to be 0 or 1. These are
c         retained in case a return to values in range 0 to 8 are done to
c         streamline the calculation of intersections by using octant values.
c         noct1 = 0 if previous point is in range
c         noct1 = 1 if previous point is out of range
c         noct2 = 0 if current point is in range
c         noct2 = 1 if current point is out of range
c         fracn = fraction of range added/subtracted to allow for error
c
      implicit   none
c
c arguments
c
      integer,          intent (in)  :: n, nmax   
      integer,          intent (out) :: nnew
      double precision, intent (in)  :: x(n), xmax, xmin, 
     +                                  y(n), ymax, ymin
      double precision, intent (out) :: xnew(nmax), ynew(nmax)
      logical,          intent (in)  :: extend   
      logical,          intent (out) :: abort
c
c locals
c
      integer    i, noct1, noct2
      double precision xsol1, xsol2, x1, x2, ysol1, ysol2, y1, y2
      double precision xdiff, xmax1, xmin1, ydiff, ymax1, ymin1
      double precision fracn
      parameter (fracn = 1.0d-4)
      logical    ok
      external   gksoct$
      intrinsic  min
c
c check input
c
      if (n.lt.1 .or. nmax.lt.1 .or.
     +    xmax.le.xmin .or. ymax.le.ymin) then
         abort = .true.
         return
      else
         abort = .false.
      endif
      if (n.eq.1) then
         nnew = 1
         xnew(nnew) = x(1)
         ynew(nnew) = y(1)
         return
      endif
      if (extend) then
c
c extend = .true. ... extend to boundaries: first initialise x1, y1, noct1
c ===============
c
         xdiff = xmax - xmin
         ydiff = ymax - ymin
         xmax1 = xmax + fracn*xdiff
         xmin1 = xmin - fracn*xdiff
         ymax1 = ymax + fracn*ydiff
         ymin1 = ymin - fracn*ydiff
         x1 = x(1)
         y1 = y(1)
         if (x1.ge.xmin1 .and. x1.le.xmax1 .and.
     +       y1.ge.ymin1 .and. y1.le.ymax1) then
            noct1 = 0
         else
            noct1 = 1
         endif
         nnew = 1
         xnew(nnew) = x(1)
         ynew(nnew) = y(1)
c
c main loop to compare each point with the previous one
c
         do i = 2, n
c
c check that xnew,ynew array dimensions are not exceeded
c
            if (nnew.eq.nmax) return
c
c define x2, y2, noct2
c
            x2 = x(i)
            y2 = y(i)
            if (x2.ge.xmin1 .and. x2.le.xmax1 .and.
     +          y2.ge.ymin1 .and. y2.le.ymax1) then
               noct2 = 0
            else
               noct2 = 1
            endif
c
c action depending on noct1 and noct2
c
            if (noct1.eq.0 .and. noct2.eq.0) then
c
c both points are in range so just add the new point
c
               nnew = nnew + 1
               xnew(nnew) = x(i)
               ynew(nnew) = y(i)
            else
c
c at least one point is out of range so intersection(s) calculated
c
               call gksoct$(noct1, noct2,
     +                      xmax, xmax1, xmin, xmin1, xsol1, xsol2,
     +                      x1, x2,
     +                      ymax, ymax1, ymin, ymin1, ysol1, ysol2,
     +                      y1, y2,
     +                      ok)
               if (ok) then
                  if (noct1.eq.0 .and. noct2.eq.1) then
c
c add one point: previous is in range but current is out of range
c
                     nnew = nnew + 1
                     xnew(nnew) = xsol2
                     ynew(nnew) = ysol2
                  elseif (noct1.eq.1 .and. noct2.eq.0) then
c
c add one point: previous is out of range but current is in range
c
                     nnew = nnew + 1
                     xnew(nnew) = xsol1
                     ynew(nnew) = ysol1
                  else
c
c add two points: previous and current are out of range
c
                     nnew = nnew + 1
                     xnew(nnew) = xsol1
                     ynew(nnew) = ysol1
                     nnew = nnew + 1
                     xnew(nnew) = xsol2
                     ynew(nnew) = ysol2
                  endif
               endif
c
c increment nnew to include the current point
c
               nnew = nnew + 1
               xnew(nnew) = x(i)
               ynew(nnew) = y(i)
            endif
c
c swap definitions of x1, x2, y1, y2, noct1, noct2 for next iteration
c
            x1 = x2
            y1 = y2
            noct1 = noct2
         enddo
      else
c
c extend = .false. ... no extensions to boundary
c ================
c
         nnew = min(n, nmax)
         do i = 1, nnew
           xnew(i) = x(i)
           ynew(i) = y(i)
         enddo
      endif
      end
c
c
     