C
C Version of GKSMRK$ to plot dendrogram segments
C
      SUBROUTINE GKSM2D$(J, K, L, M, N,
     +                   A, B, C, D, SIZE, WIDE, X, XMAX, XMIN,
     +                   Y, YMAX, YMIN)
C
C ACTION : TRY TO DRAW SYMBOLS AND LINES USING MARKERS AS FOLLOWS:-
C          J = COLOUR, K = ARGUMENT TO GSELNT, L(INE), M(ARKER)
C
C          DESIGNED TO CLIP X, Y BEFORE PRODUCING OUTPUT
C          A, B, C, D ARE REQUIRED TO PROJECT BETWEEN SPACES
C
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 7/10/92
C          Derived from GKSMRK 20/07/2001
C          Date of this version 20/072/2001
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: J, K, L, M, N 
      DOUBLE PRECISION, INTENT (IN) :: A, B, C, D, SIZE, WIDE,
     +                                 X(N), XMAX, XMIN,
     +                                 Y(N), YMAX, YMIN
C
C Locals
C      
      INTEGER    N0, N1, N4, NMAX
      PARAMETER (N0 = 0, N1 = 1, N4 = 4, NMAX = 4)
      INTEGER    I, JTEMP, KTEMP, NTEMP
      DOUBLE PRECISION XTEMP(NMAX), YTEMP(NMAX)
      LOGICAL JOIN
      EXTERNAL GKSWGB$  
      IF (N.LT.N1) RETURN
C
C Initialise I
C
      I = M!to silence ftn95
      I = N0
C
C Loop over the data in sets of 4
C
      DO JTEMP = N1, N/N4
         NTEMP = N0
         JOIN = .TRUE.
         DO KTEMP = N1, N4
            I = I + N1
            NTEMP = NTEMP + N1
            IF (X(I).GE.XMIN .AND. X(I) .LE.XMAX .AND. Y(I).GE.YMIN
     +         .AND. Y(I) .LE.YMAX) THEN
C
C In range so plot
C
                XTEMP(NTEMP) = X(I)
                YTEMP(NTEMP) = Y(I)
             ELSE
C
C Out of range so cancel plot
C
                JOIN = .FALSE.
             ENDIF
         ENDDO
C
C Plot dendrogram polygon if in range setting M = 0, no symbol
C
         IF (JOIN) CALL GKSWGB$(J, K, L, N0, NTEMP,
     +                          A, B, C, D, SIZE, WIDE, XTEMP, XMAX,
     +                          XMIN, YTEMP)
      ENDDO
      END
C 
C
