C
C GKSMNU$
C ======
C
C This subroutine was part of the SIMFIT implementation of GKS but it
C now only has a minimal function. After displaying a plot in the simple
C plotting routines like gks004, gks012, gkseb4, etc. the user can make
C limited editing changes to the plot. These changes are not very extensive,
C since the idea is to make users turn to SIMPLOT for graph preparation.
C
      SUBROUTINE GKSMNU$(KTIC, KPLOTS, L, M, MXTIC, MYTIC, NPLOTS,
     +                   XMAX, XMIN, YMAX, YMIN,
     +                   PTEXT, XTEXT, YTEXT,
     +                   AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                   TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
C
C ACTION : Adapted from MENU0S of SIMPLOT for FTN77 GKS look alike
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, 21/12/93
C          01/02/1994 Added calls to DBOS menu type routines 
C          03/02/1994 Disabled effect of AXES
C          01/23/1997 Win32 version
C          01/12/1997 Seems that NPLOTS is not used but KPLOTS = no. plots
C          09/03/1998 Extensive revision and added MXTIC, MYTIC to arguments
C          25/10/1998 NPLOTS and AXES are not used in this version
C          21/01/1999 Removed the colours option
C          12/09/1999 added GRAVE1 and call to TBOX01
C          06/12/2000 replaced TBOX1 by LVIEW2
C          25/10/2004 added XGRID and XHAIRS
C          19/04/2007 added INTENTS
C          23/07/2009 added precision
C          04/08/2009 added call to GKSCOL$
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: KPLOTS, NPLOTS 
      INTEGER,             INTENT (INOUT) :: KTIC
      INTEGER,             INTENT (INOUT) :: L(KPLOTS), M(KPLOTS),
     +                                       MXTIC, MYTIC
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX, YMIN 
      CHARACTER (LEN = *), INTENT (INOUT) :: PTEXT, XTEXT, YTEXT 
      LOGICAL,             INTENT (INOUT) :: AXES, BOXIT, FRAME, MONO,
     +                                       OFFSET, PLOT(KPLOTS),
     +                                       TEXTS, VIDEO, XGRID, 
     +                                       XHAIRS, YGRID
C
C Locals
C      
      INTEGER    ISEND, NJCOL, NKCOL
      PARAMETER (ISEND = 3, NJCOL = 8, NKCOL = 12)
      INTEGER    JCOL(NJCOL), KCOL(NKCOL)
      INTEGER    COLOUR, ICOLOR
      PARAMETER (COLOUR = 3, ICOLOR = 3)
      INTEGER    IXM, IYM, KXM, KYM
      PARAMETER (IXM = 4, IYM = 4, KXM = 4, KYM = 4)
      INTEGER    KTEMP
      INTEGER    NUMHDR
      PARAMETER (NUMHDR = 12)
      INTEGER    ITEMP, KUMPOS(20), MUMPOS(9), NUMBLD(20), NUMPOS(20)
      INTEGER    LSHADE, NUMOPT, N0, N1, N7, N17
      PARAMETER (LSHADE = 1, NUMOPT = 9, N0 = 0, N1 = 1,
     +           N7 = 7, N17 = 17)
      INTEGER    IFIGX, IFIGY, ISIGX, ISIGY
      INTEGER    ISIG
      PARAMETER (ISIG = 2) 
      INTEGER    I, NDEC, NSTART, NTEXT
      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1
      CHARACTER  HEADER(NUMHDR)*100, LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*10, FRMAT*5, LINES(0:6)*11, SYMBOL(0:16)*13
      CHARACTER  GRAVE1*1
      PARAMETER (GRAVE1 = '`')
      LOGICAL    BORDER,  FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    YES
      EXTERNAL   PUTFAT$, GETDG2$, GETSTR$, GETJGE$, GKSSIG$, GKSCOL$
      EXTERNAL   TITLE1, ANSWER, LVIEW2, TRIML1, RBOX01, LBOX02, TRIMC1
C
C Header for main menu
C
      DATA HEADER /
     +'From this menu you can only perform',
     +'very simple editing. Note that the Undo',
     +'option restores titles and legends.',
     +' ',
     +'For more extensive editing, select the',
     +'option to transfer directly to Simplot.',
     +' ',
     +'To store data for retrospective editing,',
     +'make coordinate files and add them to',
     +'your graphics archive file. This eases',
     +'subsequent creation of library files or',
     +'interactive use in a SIMPLOT project.'/
C Highlights .....  C  R  S  U  T  X  Y  L  V
      DATA MUMPOS / 1, 1, 1, 1, 1, 1, 1, 1, 1 /
      DATA NUMBLD / 20*0 /
      DATA KUMPOS / 20*1 /
C Data for line/symbol type menu
C
      DATA LINES / 'No line    ', 'Solid line ', 'Dashed line',
     +             'Dotted line', 'Dash-Dotted',
     +             'Vector >>>>', 'Vector <<<<' /
      DATA SYMBOL / 'No symbol',      'Point (.)',
     +'Plus (+)',   'Cross (X)',      'Asterisk (*)',
     +'Circle',     'Half-circle',    'Full-circle',
     +'Triangle',   'Half-triangle',  'Full-triangle',
     +'Square',     'Half-square',    'Full-square',
     +'Diamond',    'Half-diamond',   'Full-diamond' /
C
C Start of main branch point. Set NDEC = 1, MONO = VIDEO = .TRUE. to begin.
C
      IF (AXES) I = NPLOTS!to silence ftn95
      NDEC = 1
      MONO = .TRUE.
      VIDEO = .TRUE.
C
C Check if GKSCOL$ is not in default mode
C  
      CALL GKSCOL$(ISEND, JCOL, KCOL, NJCOL, NKCOL)
      DO I = 1, NJCOL
         IF (I.EQ.5) THEN
            IF (JCOL(I).NE.15) MONO = .FALSE.
         ELSE
            IF (JCOL(I).NE.0) MONO = .FALSE.
         ENDIF
         IF (.NOT.MONO) EXIT
      ENDDO             
      IF (MONO) THEN
         DO I = 1, NKCOL
            IF (KCOL(I).NE.0) THEN
               MONO = .FALSE.
               EXIT
            ENDIF   
         ENDDO  
      ENDIF  
                
C
C......................................................................
C
   20 CONTINUE
      NDEC = 9
      TEXT(1) = 'Range'
      TEXT(2) = 'Style'
      TEXT(3) = 'Undo'
      TEXT(4) = 'Title'
      TEXT(5) = 'x legend'
      TEXT(6) = 'y legend'
      TEXT(7) = 'Line/Symbol'
      TEXT(8) = 'Precision'
      TEXT(9) = 'Quit/View'
      CALL TITLE1 (ICOLOR, NUMBLD, NDEC, NUMHDR, NUMOPT, MUMPOS,
     +             HEADER, TEXT)
C
C......................................................................
C
      IF (NDEC.EQ.1) THEN
C
C Ranges and tick marks
C
         ITEMP = 8
         TEXT(1) = 'You can select new ranges for the (x,y) axes'
         TEXT(2) = ' '
         TEXT(3) = 'The current ranges for the plotting axes are'
         WRITE (TEXT(4),100) 'X', XMIN, XMAX
         WRITE (TEXT(5),100) 'Y', YMIN, YMAX
         WRITE (TEXT(6),200) 'X', MXTIC + 1
         WRITE (TEXT(7),200) 'Y', MYTIC + 1
         TEXT(8) = ' '
         LINE = 'Change these values ?'
         YES = .FALSE.
         NUMBLD(1) = 1
         CALL ANSWER (COLOUR, NUMBLD, ITEMP,
     +                TEXT, LINE,
     +                YES)
         NUMBLD(1) = 0
         IF (YES) THEN
            WRITE (LINE,300) XMIN, XMAX
            XMIN1 = XMIN
            XMAX1 = XMAX
            CALL GETDG2$(XMIN1, XMAX1,
     +                  'Start-, Stop-value on x-axis: '//LINE)
            XMAX = XMAX1
            XMIN = XMIN1
            WRITE (LINE,200) 'X', MXTIC + N1
            I = MXTIC + 1
            CALL GETJGE$(I, N0,
     +                  'No. of X-divisions required: '//LINE)
            MXTIC = I - N1
            IF (MXTIC.LT.N1) MXTIC = N1
            WRITE (LINE,300) YMIN, YMAX
            YMIN1 = YMIN
            YMAX1 = YMAX
            CALL GETDG2$(YMIN1, YMAX1,
     +                  'Start-, Stop-value on y-axis: '//LINE)
            YMAX = YMAX1
            YMIN = YMIN1
            WRITE (LINE,200) 'Y', MYTIC + N1
            I = MYTIC + 1
            CALL GETJGE$(I, N0,
     +                  'No. of Y-divisions required: '//LINE)
            MYTIC = I - N1
            IF (MYTIC.LT.N1) MYTIC = N1
         ENDIF
         NDEC = 2
         GOTO 20
      ELSEIF (NDEC.EQ.2) THEN
C
C Plotting style
C
         TEXT(1) =
     +   'Select the plotting features required'
         TEXT(2) =
     +   '...'
         TEXT(3) =
     +   'Tick marks pointing outwards'
         TEXT(4) =
     +   'Box around the data plotting area'
         TEXT(5) =
     +   'Offset the X and Y origins'
         TEXT(6) =
     +   'Frame round outside edges of graph'
         TEXT(7) =
     +   'Horizontal grid lines'
         TEXT(8) =
     +   'Vertical grid lines'
         TEXT(9) =
     +   'Lines intersecting at (0,0)'
         NDEC = 1
         NSTART = 3
         NTEXT = 9
         IF (KTIC.EQ.1) THEN
            NUMPOS(1) = 1
         ELSE
            NUMPOS(1) = 0
         ENDIF
         IF (BOXIT) THEN
            NUMPOS(2) = 1
         ELSE
            NUMPOS(2) = 0
         ENDIF
         IF (OFFSET) THEN
            NUMPOS(3) = 1
         ELSE
            NUMPOS(3) = 0
         ENDIF
         IF (FRAME) THEN
            NUMPOS(4) = 1
         ELSE
            NUMPOS(4) = 0
         ENDIF
         IF (YGRID) THEN
            NUMPOS(5) = 1
         ELSE
            NUMPOS(5) = 0
         ENDIF
         IF (XGRID) THEN
            NUMPOS(6) = 1
         ELSE
            NUMPOS(6) = 0
         ENDIF
         IF (XHAIRS) THEN
            NUMPOS(7) = 1
         ELSE
            NUMPOS(7) = 0
         ENDIF
         NUMBLD(1) = 1
         CALL RBOX01 (COLOUR, IXM, IYM, LSHADE, NUMBLD, NDEC,
     +                N7, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMPOS(1).EQ.1) THEN
            KTIC = 1
         ELSE
            KTIC = 3
         ENDIF
         IF (NUMPOS(2).EQ.1) THEN
            BOXIT = .TRUE.
         ELSE
            BOXIT = .FALSE.
         ENDIF
         IF (NUMPOS(3).EQ.1) THEN
            OFFSET = .TRUE.
         ELSE
            OFFSET = .FALSE.
         ENDIF
         IF (NUMPOS(4).EQ.1) THEN
            FRAME = .TRUE.
         ELSE
            FRAME = .FALSE.
         ENDIF
         IF (NUMPOS(5).EQ.1) THEN
            YGRID = .TRUE.
         ELSE
            YGRID = .FALSE.
         ENDIF
         IF (NUMPOS(6).EQ.1) THEN
            XGRID = .TRUE.
         ELSE
            XGRID = .FALSE.
         ENDIF
         IF (NUMPOS(7).EQ.1) THEN
            XHAIRS = .TRUE.
         ELSE
            XHAIRS = .FALSE.
         ENDIF
         NDEC = 4
         GOTO 20
      ELSEIF (NDEC.EQ.3) THEN
C
C Restore original title and legends
C
         TEXTS = .FALSE.
         GOTO 20
      ELSEIF (NDEC.EQ.4) THEN
C
C New plot title
C
         TEXTS = .TRUE.
         CALL TRIML1 (PTEXT)
         LINE = 'Now edit/input the plot title'
         CALL GETSTR$ (LINE, PTEXT)
         CALL TRIMC1 (PTEXT)
         NDEC = 5
         GOTO 20
      ELSEIF (NDEC.EQ.5) THEN
C
C New x-legend
C
         TEXTS = .TRUE.
         CALL TRIML1 (XTEXT)
         LINE = 'Now edit/input the x-axis legend'
         CALL GETSTR$ (LINE, XTEXT)
         CALL TRIMC1 (XTEXT)
         NDEC = 6
         GOTO 20
      ELSEIF (NDEC.EQ.6) THEN
C
C New y-legend
C
         TEXTS = .TRUE.
         CALL TRIML1 (YTEXT)
         LINE = 'Now edit/input the y-axis legend'
         CALL GETSTR$ (LINE, YTEXT)
         CALL TRIMC1 (YTEXT)
         NDEC = 7
         GOTO 20
      ELSEIF (NDEC.EQ.7) THEN
C
C Line and marker types
C
   40    CONTINUE
         TEXT(1) =
     +   'Data Set  `Status of Data  `Type of Line  `Type of Symbol'
         KTEMP = 1
         DO I = 1, KPLOTS
            KTEMP = KTEMP + 1
            WRITE (FRMAT,'(I2,3X)') I
            IF (PLOT(I)) THEN
               CIPHER = 'Plotted'
               TEXT(KTEMP) = FRMAT//GRAVE1//CIPHER//
     +                              GRAVE1//LINES(L(I))//
     +                              GRAVE1//SYMBOL(M(I))
            ELSE
               CIPHER = 'No data'
               TEXT(KTEMP) = FRMAT//GRAVE1//CIPHER
            ENDIF
         ENDDO
         KTEMP = KTEMP + 1
         TEXT(KTEMP) = 'Apply'
         I = KPLOTS + 1
         NDEC = I
         CALL LVIEW2 (KXM, KYM, NDEC, I,
     +                TEXT,
     +                TITLES)
         IF (NDEC.EQ.KPLOTS + 1) THEN
            NDEC = 8
            GOTO 20
         ENDIF
         IF (PLOT(NDEC)) THEN
            I = NDEC
            NDEC = L(I) + N1
            IF (NDEC.LT.N1) THEN
               NDEC = N1
            ELSEIF (NDEC.GT.N7) THEN
               NDEC = N7
            ENDIF
            CALL LBOX02 (COLOUR, IXM, IYM, NDEC, N7, KUMPOS,
     +                   LINES)
            L(I) = NDEC - N1
            NDEC = M(I) + N1
            IF (NDEC.LT.N1) THEN
               NDEC = N1
            ELSEIF (NDEC.GT.N17) THEN
               NDEC = N17
            ENDIF
            CALL LBOX02 (COLOUR, IXM, IYM,  NDEC, N17, KUMPOS, 
     +                   SYMBOL)
            M(I) = NDEC - N1
         ELSE
            CALL PUTFAT$('Data set selected is absent ... Try again')
         ENDIF
         GOTO 40
      ELSEIF (NDEC.EQ.8) THEN
C
C Precision of x,y-labels
C      
         CALL GKSSIG$(ISIG, IFIGX, ISIGX, IFIGY, ISIGY)
         GOTO 20   
      ENDIF          
C
C Format statements
C      
  100 FORMAT (A,' from',1P,E12.4,2X,'to',E12.4)
  200 FORMAT ('Current no. of ',A,' tick marks =',I4)
  300 FORMAT ('Current values',1P,E12.4,',',E12.4)
      END
C
C
