C 
C
      SUBROUTINE GKSMRK$(J, K, L, M, N,
     +                   A, B, C, D, SIZE, WIDE, X, XMAX, XMIN, Y, YMAX,
     +                   YMIN)
C
C ACTION : TRY TO DRAW SYMBOLS AND LINES USING MARKERS AS FOLLOWS:-
C          J = COLOUR, K = ARGUMENT TO GSELNT, L(INE), M(ARKER)
C
C          DESIGNED TO CLIP X, Y BEFORE PRODUCING OUTPUT
C          A, B, C, D ARE REQUIRED TO PROJECT BETWEEN SPACES
C
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 7/10/92
C          12/10/1992 REMOVED MONO ADDED JOIN
C          28/11/1992 CHANGED GKSPIC TO GKSWGB TO INCLUDE MORE MARKERS
C          23/02/1997 Version for FTN77 GKS look alike
C          07/08/2005 Allowed lines to be extended to boundaries
C          08/07/2006 Introduced allocatable arrays but left in JOIN and
C                     NTEMP for possible future use 
C          13/04/2007 Added INTENTS 
C          15/06/2007 Removed savegks.ins and added SAVGKS$
C          02/12/2010 Replaced SAVGKS$ by SAVLGL$
C          21/06/2011 Used N0 = 0 instead of M in call to GKSWGB$ to suppress the obsolete
C                     line breaking algorithm used to avoid lines crossing symbols in GKSWGB$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: J, K, L, M, N
      DOUBLE PRECISION, INTENT (IN) :: A, B, C, D, SIZE, WIDE, 
     +                                 X(N), XMAX, XMIN,
     +                                 Y(N), YMAX, YMIN
C
C Local allocatable arrays
C                         
      DOUBLE PRECISION, ALLOCATABLE :: XNEW(:), XTEMP(:),
     +                                 YNEW(:), YTEMP(:)
C
C Locals
C              
      INTEGER    ISEND
      PARAMETER (ISEND = 1) 
      INTEGER    N0, N1, N2, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N5 = 5)    
      INTEGER    IERR, NMAX, NMAXP2, NMAXT5
      INTEGER    I, JLOOP, KSTART, KSTOP, NLOOP, NNEW, NSTART, NSTOP,
     +           NTEMP 
      DOUBLE PRECISION ERROR, XMAX1, XMIN1, YMAX1, YMIN1
      DOUBLE PRECISION FRACN
      PARAMETER (FRACN = 1.0D-03)
      LOGICAL    JOIN
      LOGICAL    ABORT, EXTEND_LINES  
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GKSWGB$, GKSDRW$, GKSLIM$, SAVLGL$
      IF (N.LT.N1) RETURN 
      NTEMP = M!to silence FTN95       
      IERR = N0
      IF (ALLOCATED(XNEW)) DEALLOCATE(XNEW, STAT = IERR)
      IF (IERR.NE.N0) RETURN  
      IF (ALLOCATED(XTEMP)) DEALLOCATE(XTEMP, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(YNEW)) DEALLOCATE(YNEW, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(YTEMP)) DEALLOCATE(YTEMP, STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      NMAX = N
      NMAXP2 = NMAX + N2
      NMAXT5 = N5*NMAX
      ALLOCATE(XNEW(NMAXT5), STAT = IERR)
      IF (IERR.NE.N0) RETURN   
      ALLOCATE(XTEMP(NMAXP2), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YNEW(NMAXT5), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YTEMP(NMAXP2), STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      ERROR = FRACN*ABS(XMAX - XMIN)
      XMAX1 = XMAX + ERROR
      XMIN1 = XMIN - ERROR
      ERROR = FRACN*(YMAX - YMIN)
      YMAX1 = YMAX + ERROR
      YMIN1 = YMIN - ERROR 
      CALL SAVLGL$(ISEND,
     +             EXTEND_LINES, STORE)    
      IF (EXTEND_LINES) THEN
C
C Extend lines to boundaries ... NLOOP must be at least 1
C
         NLOOP = N/NMAX + N1
         NSTART = N1 - NMAX
         NSTOP = N0
         DO JLOOP = N1, NLOOP
            NSTART = NSTART + NMAX
            IF (NSTART.GT.N) RETURN
            NSTOP = NSTOP + NMAX
            IF (NSTOP.GT.N) NSTOP = N
            IF (NSTART.GT.NSTOP) RETURN
            IF (NSTART.EQ.N1) THEN
               KSTART = NSTART
            ELSE
               KSTART = NSTART - N1
            ENDIF
            IF (NSTOP.EQ.N) THEN
               KSTOP = NSTOP
            ELSE
               KSTOP = NSTOP + N1
            ENDIF
            NTEMP = KSTOP - KSTART + N1
            IF (NTEMP.LE.N0) RETURN
C
C Calculate XNEW, YNEW, NNEW with extra points at intersection with boundaries
C
            CALL GKSLIM$(NTEMP, NMAXT5, NNEW,
     +                   X(KSTART), XMAX, XMIN, XNEW,
     +                   Y(KSTART), YMAX, YMIN, YNEW,
     +                   ABORT, EXTEND_LINES)
            IF (ABORT) RETURN
            IF (NNEW.GT.N0) THEN
C
C Plot XNEW, YNEW in sections if in range
C
               NTEMP = N0
               DO I = N1, NNEW
                  IF (XNEW(I).GE.XMIN1 .AND. XNEW(I) .LE.XMAX1 .AND.
     +                YNEW(I).GE.YMIN1 .AND. YNEW(I) .LE.YMAX1) THEN
                     NTEMP = NTEMP + N1
                     XTEMP(NTEMP) = XNEW(I)
                     YTEMP(NTEMP) = YNEW(I)
                     IF (NTEMP.EQ.NMAXP2) THEN
                        CALL GKSDRW$(J, K, L, NTEMP,
     +                               WIDE, XTEMP, YTEMP)
                        NTEMP = N0
                     ENDIF
                  ELSE
                     IF (NTEMP.GT.N0) THEN
                        CALL GKSDRW$(J, K, L, NTEMP,
     +                               WIDE, XTEMP, YTEMP)
                        NTEMP = N0
                     ENDIF
                  ENDIF
               ENDDO
               IF (NTEMP.GT.N0) THEN
                  CALL GKSDRW$(J, K, L, NTEMP,
     +                         WIDE, XTEMP, YTEMP)
               ENDIF
            ENDIF
         ENDDO
      ELSE
C
C Do not extend lines to boundaries
C
         NTEMP = N0
         JOIN = .FALSE.
         DO I = N1, N
            IF (X(I).GE.XMIN1 .AND. X(I) .LE.XMAX1 .AND.
     +          Y(I).GE.YMIN1 .AND. Y(I) .LE.YMAX1) THEN
               IF (JOIN) THEN
                  NTEMP = N1
                  XTEMP(NTEMP) = X(I - 1)
                  YTEMP(NTEMP) = Y(I - 1)
                  JOIN = .FALSE.
               ENDIF
               NTEMP = NTEMP + N1
               XTEMP(NTEMP) = X(I)
               YTEMP(NTEMP) = Y(I)
               IF (NTEMP.EQ.NMAX) THEN
C
C Swap next lines if line breaking is required
C                 
                  CALL GKSWGB$(J, K, L, N0, NTEMP,
C*****************CALL GKSWGB$(J, K, L, M, NTEMP,
     +                         A, B, C, D, SIZE, WIDE, XTEMP, XMAX,
     +                         XMIN, YTEMP)
                  NTEMP = N0
                  JOIN = .TRUE.
               ENDIF
            ELSE
               JOIN = .FALSE.
               IF (NTEMP.GT.N0) THEN
C
C Swap next lines if line breaking is required
C                 
                  CALL GKSWGB$(J, K, L, N0, NTEMP,
C*****************CALL GKSWGB$(J, K, L, M, NTEMP,
     +                         A, B, C, D, SIZE, WIDE, XTEMP, XMAX,
     +                         XMIN, YTEMP)
                  NTEMP = N0
               ENDIF
            ENDIF
         ENDDO
         IF (NTEMP.GT.N0) THEN
C
C Swap next lines if line breaking is required
C           
            CALL GKSWGB$(J, K, L, N0, NTEMP,
C***********CALL GKSWGB$(J, K, L, M, NTEMP,            
     +                   A, B, C, D, SIZE, WIDE, XTEMP, XMAX,
     +                   XMIN, YTEMP)
         ENDIF
      ENDIF 
      DEALLOCATE(XNEW, STAT = IERR) 
      DEALLOCATE(XTEMP, STAT = IERR)
      DEALLOCATE(YNEW, STAT = IERR) 
      DEALLOCATE(YTEMP, STAT = IERR)
      END
C 
C                     
