c
c
      subroutine gksoct$(noct1, noct2,
     +                   xmax, xmax1, xmin, xmin1, xsol1, xsol2, x1, x2,
     +                   ymax, ymax1, ymin, ymin1, ysol1, ysol2, y1, y2,
     +                   ok)
c
c action: calculate intersection with allowed boundary rectangle
c author: w.g.bardsley, university of manchester, u.k., 02/08/2005 
c         19/04/2007 added intents
c
c         noct1: (input/unchanged) 0 or 1 as set by gkslim$
c         noct2: (input/unchanged) 0 or 1 as set by gkslim$
c          xmax: (input/unchanged) limit as set by gkslim$
c         xmax1: (input/unchanged) limit as set by gkslim$ >= xmax
c          xmin: (input/unchanged) limit as set by gkslim$
c         xmin1: (input/unchanged) limit as set by gkslim$ =< xmin
c         xsol1: (output) solution
c         xsol2: (output) solution
c            x1: (input/unchanged) coordinates
c            x2: (input/unchanged) coordinates
c          ymax: (input/unchanged) limit as set by gkslim$
c         ymax1: (input/unchanged) limit as set by gkslim$ >= ymax
c          ymin: (input/unchanged) limit as set by gkslim$
c         ymin1: (input/unchanged) limit as set by gkslim$ =< ymin
c         ysol1: (output) solution
c         ysol2: (output) solution
c            y1: (input/unchanged) coordinates
c            y2: (input/unchanged) coordinates
c            ok: (output) success indicator
c
      implicit   none
c
c arguments
c
      integer,          intent (in)  :: noct1, noct2
      double precision, intent (in)  :: xmax, xmax1, xmin, xmin1, x1, x2 
      double precision, intent (out) :: xsol1, xsol2
      double precision, intent (in)  :: ymax, ymax1, ymin, ymin1, y1, y2   
      double precision, intent (out) :: ysol1, ysol2
      logical,          intent (out) :: ok
c
c locals
c
      integer    icount
      double precision const, slope, xdiff, xtry, ydiff, ytry
      double precision d1, d2, xmax2, xmin2, ymax2, ymin2
      double precision xtemp1, xtemp2, ytemp1, ytemp2
      double precision epsi, fracn, zero
      parameter (fracn = 1.0d-04, zero = 0.0d+00)
      logical    horiz, vert
      external   gkshov$
      intrinsic  abs, min, max
c
c calculate defaults for slope, const
c
      xdiff = x2 - x1
      epsi = fracn*(xmax - xmin)
      if (abs(xdiff).le.epsi) then
         vert = .true.
      else
         vert = .false.
      endif
      ydiff = y2 - y1
      epsi = fracn*(ymax - ymin)
      if (abs(ydiff).le.epsi) then
         horiz = .true.
      else
         horiz = .false.
      endif
      if (horiz .and. vert) then
c
c x2,y2 is a replicate of x1,y1 so return
c
         ok = .false.
         return
      elseif (horiz .or. vert) then
c
c deal separately with horizontal and vertical cases then return
c
         call gkshov$(noct1, noct2,
     +                xmax, xmin, xsol1, xsol2, x1, x2,
     +                ymax, ymin, ysol1, ysol2, y1, y2,
     +                horiz, ok, vert)
         return
      else
c
c x2,y2 is a new point so proceed to calculate intersections
c
         ok = .true.
      endif
c
c calculate parameters for iteration over each edge of the rectangle
c
      slope = ydiff/xdiff
      const = (x2*y1 - x1*y2)/xdiff
      epsi = fracn*abs(x2 - x1)
      xmax2 = max(x1,x2) + epsi
      xmin2 = min(x1,x2) - epsi
      epsi = fracn*abs(y2 - y1)
      ymax2 = max(y1,y2) + epsi
      ymin2 = min(y1,y2) - epsi
c
c calculate intersections of the line joining x1,y1 to x2,y2 with
c the boundary of the rectangle defined by (xmin,ymin), (xmax,ymax)
c i.e., the actual bounadry limits, but included within the rectangles
c defined by (xminl,ymin1), (xmax1,ymax1) the enlarged boundary region
c and (xmin2,ymin2), (xmax2,ymax2) the region defined by the two data
c points (x1,y1) and (x2,y2).
c
      icount = 0
      if (xmin.ge.xmin2 .and. xmin.le.xmax2) then
         xtry = xmin
         ytry = slope*xmin + const
         if (ytry.ge.ymin1 .and. ytry.le.ymax1 .and.
     +       ytry.ge.ymin2 .and. ytry.le.ymax2) then
            icount = icount + 1
            xsol1 = xtry
            ysol1 = ytry
         endif
      endif
      if (xmax.ge.xmin2 .and. xmax.le.xmax2) then
         xtry = xmax
         ytry = slope*xmax + const
         if (ytry.ge.ymin1 .and. ytry.le.ymax1 .and.
     +       ytry.ge.ymin2 .and. ytry.le.ymax2) then
            icount = icount + 1
            if (icount.eq.1) then
               xsol1 = xtry
               ysol1 = ytry
            else
              xsol2 = xtry
              ysol2 = ytry
            endif
         endif
      endif
      if (icount.lt.2) then
         if (ymin.ge.ymin2 .and. ymin.le.ymax2) then
            ytry = ymin
            xtry = (ymin - const)/slope
            if (xtry.ge.xmin1 .and. xtry.le.xmax1 .and.
     +          xtry.ge.xmin2 .and. xtry.le.xmax2) then
               icount = icount + 1
               if (icount.eq.1) then
                  xsol1 = xtry
                  ysol1 = ytry
               else
                  xsol2 = xtry
                  ysol2 = ytry
               endif
            endif
         endif
      endif
      if (icount.lt.2) then
         if (ymax.ge.ymin2 .and. ymax.le.ymax2) then
            ytry = ymax
            xtry = (ymax - const)/slope
            if (xtry.ge.xmin1 .and. xtry.le.xmax1 .and.
     +          xtry.ge.xmin2 .and. xtry.le.xmax2) then
               icount = icount + 1
               if (icount.eq.1) then
                  xsol1 = xtry
                  ysol1 = ytry
               else
                  xsol2 = xtry
                  ysol2 = ytry
               endif
            endif
         endif
      endif
      if (icount.lt.1) then
c
c there appear to be no intersections so set ok = .false. and return
c
         ok = .false.
         return
      endif
      if (noct1.eq.0 .and. noct2.eq.1) then
c
c case 1: x1,y1 is in range but x2,y2 is out of range so
c ======= define xsol2, ysol2 to add point from outside to inside range
c
            if (icount.eq.1) then
               xsol2 = xsol1
               ysol2 = ysol1
            else
               d1 = (x2 - xsol1)**2 + (y2 - ysol1)**2
               d2 = (x2 - xsol2)**2 + (y2 - ysol2)**2
               if (d1.lt.d2) then
                  xsol2 = xsol1
                  ysol2 = ysol1
               endif
            endif
c
c check that (xsol2,ysol2) is distinct from (x1,y1)
c
            d1 = (x1 - xsol2)**2 + (y1 - ysol2)**2
            if (d1.gt.zero) then
               ok = .true.
            else
               ok = .false.
            endif
      elseif (noct1.eq.1 .and. noct2.eq.0) then
c
c case 2: x1,y1 is out of range, x2,y2 is in range so
c ======= define xsol1, ysol1 to add point from outside to inside
c
         if (icount.gt.1) then
            d1 = (x1 - xsol1)**2 + (y1 - ysol1)**2
            d2 = (x1 - xsol2)**2 + (y1 - ysol2)**2
            if (d1.gt.d2) then
               xsol1 = xsol2
               ysol1 = ysol2
            endif
         endif
c
c check that (xsol1,ysol1) is distinct from (x2,y2)
c
         d2 = (x2 - xsol1)**2 + (y2 - ysol1)**2
         if (d2.gt.zero) then
            ok = .true.
         else
            ok = .false.
         endif
      elseif (noct1.eq.1 .and. noct2.eq.1) then
c
c case 3: x1,y1 and x2,y2 are both out of range so we
c ======= must check then define xsol1, ysol1 and xsol2, ysol2
c

         d1 = (x1 - xsol1)**2 + (y1 - ysol1)**2
         d2 = (x1 - xsol2)**2 + (y1 - ysol2)**2
         if (d1.gt.d2) then
            xtemp1 = xsol1
            xtemp2 = xsol2
            ytemp1 = ysol1
            ytemp2 = ysol2
            xsol1 = xtemp2
            xsol2 = xtemp1
            ysol1 = ytemp2
            ysol2 = ytemp1
         endif
         ok = .true.
      endif
      end
c
c