C
C
C SIMPLOT2.INS: Insert file number 2 for SIMPLOT
C ==============================================
C
C GKSPLT$: the main frame plotting subroutine
C
C
      SUBROUTINE GKSPLT$(IPANEL, ISHAPE, KANGLE, KCOLOR, KTIC, LCTEMP,
     +                   MTRANS, MXDROP, MXTIC, MYTIC, MZTIC,
     +                   NCFONT, NCLIP, NGROUP, NKCOL, NLOG, NMAX,
     +                   NPLOTS, NPTS, NTFONT, NWORDS, NXFONT, NYFONT,
     +                   A, B, C, CZ,
     +                   D, DRAGTI, DRAGXL, DRAGYL, DRAGZL, DZ,
     +                   FACTOR, THICK,
     +                   X, XCLIP, XCOORD, XMAX, XMIN,
     +                   XPC, XPDRAG, XPMAX, XPMIN, XPT, XPX, XPY,
     +                   YCLIP, YCOORD, YDROP, YMAX, YMAX1, YMIN, YMIN1,
     +                   YPCHT, YPMAX, YPMIN, YSCALE,
     +                   ZCOORD, ZMAX, ZMAX1, ZMIN, ZMIN1,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   LABELS, LABVEC, PTITLE, QTITLE, WORDX, WORDY,
     +                   XTITLE, YTITLE, ZTITLE,
     +                   ABORT, BAR_CHART, BORDER, BOXIT, BRAY_CURTIS,
     +                   CENTRE, FRAME,
     +                   GRATICULE, MONO, NATLOG, NUMBRX, OFFSET,
     +                   PANEL, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ,
     +                   PIE_CHART, PLOT_TITLE,
     +                   PLOTX, PLOTY, PLOTZ, POWERX, POWERY, POWERZ,
     +                   ROTATE, SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                   SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS, SIDE,
     +                   SWAP_YZ, THREE_D, TWO_PLOTS,
     +                   VIDEO, XGRID, XTOINT, YGRID, YTOINT,
     +                   ZTOINT)
C
C ACTION : Set up 4 by 3 PC portrait frame with legends etc. for a GKS plot
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 17/1/92
C          12/10/1992 Added ICOLOR and VIDEO
C          04/11/1992 GKSBOX derived from GKSPOR
C          17/11/1992 Added ZSCALE and code to shrink output
C          06/12/1992 Corrected calculation of A, B, C and D
C          11/12/1992 Altered coordinates for graph placement and axis annotation
C          27/04/1993 EXTRA1, EXTRA2, XBOX1, XBOX2, YBOX1, YBOX2 to allow for
C                     exponents on X axis and correct for tic marks and KTIC
C                     Also XPTFAC, XPXFAC, XPYFAC to scale XPT, XPX and XPY
C          04/05/1993 THICK added to control line thickness for axes and frame
C                     and XGRID, YGRID to specify grid lines
C          15/05/1993 GSCLIP
C          24/05/1993 Edited out workstation 2, changed XHEIGHT from .035 to .04
C          26/10/1993 Derived from GKSBOX
C          07/11/1993 Added KCOLOR and LCTEMP
C          04/12/1993 Added IPANEL, PANEL, SIDE, XYJUMP etc. for information panel
C          01/12/1994 Edited for DBOS version
C          06/06/1995 Heavily condensed and shortened by introducing calls
C                     to xlabel, ylabel, spaces, etc
C          21/09/1995 Added bar_chart, npts, x, labels and call to blabel
C          08/08/1995 Added call to ZLABEL
C          30/07/1996 added ISHAPE
C          18/09/1996 Added ARRAYT, etc.
C          30/09/1996 Overhaul and introduced XS1, XS2, XS3
C          16/10/1996 Introduced NYFIG, NZFIG to space Y and Z axes labels
C          06/11/1996 Added XCLIP, YCLIP
C          14/07/1997 win32 version
C          28/11/1997 revised to allow for mouse movement
C          09/12/1998 Added NGROUP
C          01/02/2000 Added NATLOG and MTRANS and reduced XEND1
C          21/02/2000 Added DRAGTI, DRAGXL, DRAGYL, DRAGZL
C          23/02/2000 added PHIGHX, PHIGHY, PHIGHZ
C          10/04/2001 added coloured border using KCOLOR(6) and
C                     graticule using KCOLOR(7)
C          20/07/2001 added SHOW_XAXIS
C          10/08/2001 added BRAY_CURTIS
C          15/08/2001 added MXDROP and YDROP
C          03/09/2001 added PSSPEC$
C          08/09/2001 added FACTOR and THREE_D
C          10/01/2003 added YADD to control YSTART with rotated labels
C          15/10/2004 changed position of SIDE in argument list
C          21/10/2004 added SHOW_BACKGROUND and SHOW_QUADRANTS to argument list
C          26/08/2005 defined SHOWIT depending on SHOW_BACKGROUND and LCTEMP 
C          09/05/2007 added INTENTS 
C          19/12/2007 checked NLOOP to prevent overflow when defining PLOTX(I) 
C          20/07/2008 replaced KCOLOR(2) by ICOLOR to draw CROSS_HAIRS
C          21/07/2009 changed XTOINT, YTOINT, and ZTOINT to INTENT (INOUT)
C          22/08/2014 added calls to SET_END_CAP and PSLCAP$ to correct tick marks for thick lines
C          21/05/2016 corrected backround filling for clipping due to aspect ratio changes
C          02/10/2018 made SHOW_BACKGROUND to work with white in %gr output as well as in PostScript 
C          17/06/2019 added call to SVGPAR to define X_SVG, Y_SVG, X_TICK, Y_TICK
C
C ADVICE : IPANEL = No. of panel labels
C          MKID = Workstation, MTYPE = type
C          KCOLOR = colours (1 = title, 2 = axes, 3 = numbers, 4 = legends)
C          KTIC = 1: tick marks point out; = 0: none; = 3: point in
C          M?TIC = no. tic marks on X and Y axes
C          N?FONT = C(haracter), T(itle), X(legend), Y(legend) font nos.
C          A, B, C, D required for error bar caps in Scatchard plot
C          SP? = C, T, X, Y character   spacing factors called by GSCHSP
C          XP? = C, T, X, Y character expansion factors called by GSCHXP
C          NMAX1 = max. powers of 10 accepted... this sets EPSI
C          YTOX = ratio Y/X of physical lengths of the display
C          EPSI = min. size difference to allow fixed X or fixed Y plots
C          ?HEIGHT = C, E(xponent), T, X, Y character heights
C          TFACX, TFACY = axes thickness factor
C          YPCHT, YPMAX and YPMIN for panel
C
C
C     Factors for PS output
C     PSADDY ... Move left for exponent show on Y axis
C
      IMPLICIT   NONE  
C
C Integers in argument list
C     
      INTEGER, INTENT (IN) :: NCLIP, NKCOL, NLOG, NMAX, NWORDS    
      INTEGER, INTENT (IN) :: IPANEL, ISHAPE, KANGLE, KCOLOR(NKCOL),
     +                        KTIC, LCTEMP, MTRANS,  MXDROP, MXTIC,
     +                        MYTIC, MZTIC, NCFONT, NGROUP, NPLOTS,
     +                        NPTS, NTFONT, NXFONT, NYFONT      
C
C Reals in argument list
C
      DOUBLE PRECISION, INTENT (IN)    :: DRAGTI, DRAGXL, DRAGYL, DRAGZL
      DOUBLE PRECISION, INTENT (IN)    :: FACTOR(NWORDS), THICK,
     +                                    X(NMAX), XCLIP(NCLIP), XCOORD
      DOUBLE PRECISION, INTENT (IN)    :: XPC, XPDRAG, XPT,
     +                                    XPX, XPY, YCLIP(NCLIP)
      DOUBLE PRECISION, INTENT (IN)    :: YCOORD, YDROP, ZCOORD  
      DOUBLE PRECISION, INTENT (INOUT) :: A, B, C, CZ, D, DZ,
     +                                    XMAX, XMIN,
     +                                    YMAX, YMAX1, YMIN, YMIN1,
     +                                    ZMAX, ZMAX1, ZMIN, ZMIN1
      DOUBLE PRECISION, INTENT (INOUT) :: XPMAX, XPMIN, YPCHT, YPMAX,
     +                                    YPMIN, YSCALE       
C
C Character variables in argument list
C
      CHARACTER (LEN = *), INTENT (IN) :: ARRAYQ, ARRAYT, ARRAYX,
     +                                    ARRAYY, ARRAYZ,
     +                                    LABELS(NWORDS),
     +                                    LABVEC(NWORDS),
     +                                    PTITLE, QTITLE, WORDX(NWORDS),
     +                                    WORDY(NWORDS), XTITLE, YTITLE,
     +                                    ZTITLE     
C
C Logicals in argument list
C
      LOGICAL, INTENT (IN)    :: BAR_CHART, BORDER, BOXIT,
     +                           BRAY_CURTIS, CENTRE, FRAME,
     +                           GRATICULE, MONO, NATLOG(NLOG), NUMBRX,
     +                           OFFSET, PANEL, PCENTX, PCENTY, PCENTZ,
     +                           PHIGHX, PHIGHY, PHIGHZ, PIE_CHART, 
     +                           PLOT_TITLE, PLOTX(NWORDS), 
     +                           PLOTY(NWORDS), PLOTZ(NWORDS), POWERX,
     +                           POWERY, POWERZ, ROTATE,
     +                           SHOW_BACKGROUND, SHOW_QUADRANTS, 
     +                           SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                           SIDE, SWAP_YZ, THREE_D, TWO_PLOTS
      LOGICAL, INTENT (IN)    :: VIDEO, XGRID, YGRID 
      LOGICAL, INTENT (INOUT) :: XTOINT, YTOINT, ZTOINT  
      LOGICAL, INTENT (OUT)   :: ABORT   
C
C Parameters from DLL in common block in DEFGKS.INS ...................
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
C
C Parameters for PS output
C
      DOUBLE PRECISION PSADDY
      PARAMETER (PSADDY = - 0.08)
C
C Integer parameters and scalars
C
      INTEGER    NMAX1, NXGRID, NYGRID
      PARAMETER (NMAX1 = 300, NXGRID = 80, NYGRID = 60)
      INTEGER    N0, N1, N2, N3, N4, N10, N15, N71
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N10 = 10,
     +           N15 = 15, N71 = 71)
      INTEGER    I, ICOLOR, ICOUNT, L, NXMAG, NYFIG, NYMAG, NZFIG, NZMAG
      INTEGER    LEN200, NLOOP
C
C Parameters to scale axes line thickness and fonts
C
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = ONE/(TEN**NMAX1))
      DOUBLE PRECISION YTOX
      PARAMETER (YTOX = THREE/FOUR)
      DOUBLE PRECISION CHEIGHT, EHEIGHT, THEIGHT, XHEIGHT
      PARAMETER (CHEIGHT = 0.035D+00, EHEIGHT = 0.75D+00*CHEIGHT,
     +           THEIGHT = 0.045D+00, XHEIGHT = 0.04D+00)
C
C Parameters to set up the default axes
C
      DOUBLE PRECISION XEND, XSTART
      DOUBLE PRECISION XEND1, XEND2, XEND3, XSTRT1
C 02/02/2000 reduced XEND1 to include 1/10000 in dilution curve
C 23/02/2000 increased XSTRT1 to allow for larger fonts
C*****PARAMETER (XSTRT1 = 0.15D+00, XEND1 = 0.95D+00,
      PARAMETER (XSTRT1 = 0.175D+00, XEND1 = 0.925D+00,
     +           XEND2 = 1.0D+00 - XSTRT1, XEND3 = 0.75D+00)
      DOUBLE PRECISION YEND, YSTART
      DOUBLE PRECISION YEND1, YEND2, YSTRT1
C 23/02/2000 decreased YEND1 and YEND2 to allow for larger fonts
C*****PARAMETER (YSTRT1 = 0.20D+00, YEND1 = 0.96D+00, YEND2 = 0.89D+00)
      PARAMETER (YSTRT1 = 0.20D+00, YEND1 = 0.94D+00, YEND2 = 0.87D+00)
      DOUBLE PRECISION YADD, YADD1
      PARAMETER (YADD1 = 0.15D+00)
      DOUBLE PRECISION XTIC, YTIC
      DOUBLE PRECISION YXJUMP, YYJUMP
      PARAMETER (YXJUMP = 0.09D+00, YYJUMP = 0.075D+00)
C
C Parameters to set up information panel
C XS1, XS2, XS3 must agree with those in PANELS$
C
      DOUBLE PRECISION XS1, XS2, XS3
      PARAMETER (XS1 = 0.81D+00, XS2 = 0.81D+00, XS3 = 0.81D+00)
      DOUBLE PRECISION XXS1, XXS2, XXS3
      PARAMETER (XXS1 = 0.72D+00, XXS2 = 0.72D+00, XXS3 = 0.72D+00)
C
C Parameter to scale TRUE_TYPE fonts
C
      DOUBLE PRECISION XPC_SCALE, XPT_SCALE, XPX_SCALE, XPY_SCALE
      PARAMETER (XPC_SCALE = 1.10D+00, XPT_SCALE = 1.20D+00,
     +           XPX_SCALE = 1.20D+00, XPY_SCALE = 1.20D+00)
C
C Temporary real variables
C
      DOUBLE PRECISION XEND_1, XEND_2, XSTRT_1, X1, X2,
     +                 YEND_1, YEND_2, Y1, Y2
      DOUBLE PRECISION XA, XB, XC, XD, XDIFF, XBEGIN, XMAX1, XMIN1
      DOUBLE PRECISION YA, YB, YC, YD, YDIFF, YBEGIN
      DOUBLE PRECISION ZA, ZB, ZC, ZD, ZDIFF
      DOUBLE PRECISION EXTRA1, EXTRA2, EXTRA3, EXTRA4
      DOUBLE PRECISION XPC1, XPT1, XPX1, XPY1
      DOUBLE PRECISION XBOX1, XBOX2, YTEMP
      DOUBLE PRECISION XDELTA, YDELTA
      DOUBLE PRECISION X_SVG, Y_SVG 
C
C Character parameter
C
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
C
C Temporary logical variables
C
      LOGICAL    ACTIVE_SVG
      LOGICAL    CROSS_HAIRS, NORMAL, SHOWIT, TRUE_TYPE
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
C
C Externals
C
      EXTERNAL  SVGPAR
      EXTERNAL  GSWN$, GSVP$, GSELNT$, BLOCK$, GSLN$, PSSPEC$,
     +          GETDEF$, GSLWSC$, TITLES$, FRAMES$, CHECKS$,
     +          SPACES$, XLABEL$, YLABEL$, BLABEL$, PLABEL$, ZLABEL$,
     +          DASHED_LINE$, SOLID_LINE$
      EXTERNAL  LEN200
      EXTERNAL  SET_END_CAP, PSLCAP$
      INTRINSIC ABS, DBLE, MIN
C
C Define XTIC and YTIC then check if SVG is active and, if so, adjust
C
      XTIC = 0.01D+00
      YTIC = YTOX*XTIC
      CALL SVGPAR (N0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG)
      IF (ACTIVE_SVG) THEN
         XTIC = XTIC/Y_SVG
         YTIC = YTIC/X_SVG
      ENDIF   
C
C Get parameters from DLL in common block in DEFGKS.INS ...............
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL,
     +             PS)
      ABORT = .TRUE.
      TRUE_TYPE = .TRUE.
C
C Check if plot is possible ...........................................
C
      CALL CHECKS$(NXMAG, NYMAG, NZMAG,
     +             XMAX, XMIN, YMAX, YMIN, ZMAX, ZMIN,
     +             ABORT, TWO_PLOTS)
      IF (ABORT) RETURN
C
C Data seems to be OK so set up a plotting frame ......................
C
      IF (SHOW_QUADRANTS) THEN
         IF (XMIN.LT.ZERO .AND. XMAX.GT.ZERO .AND.
     +       YMIN.LT.ZERO .AND. YMAX.GT.ZERO) THEN
            CROSS_HAIRS = .TRUE.
         ELSE
            CROSS_HAIRS = .FALSE.
         ENDIF
      ELSE
         CROSS_HAIRS = .FALSE.
      ENDIF
      IF (SWAP_YZ) THEN
         XEND_1 = ONE - XSTRT1
         XSTRT_1 = ONE - XEND1
      ELSE
         XEND_1 = XEND1
         XSTRT_1 = XSTRT1
      ENDIF
      IF (BAR_CHART .AND. PANEL .AND. SIDE .AND. ISHAPE.EQ.2) THEN
         XEND_2 = XEND3
      ELSE
         XEND_2 = XEND2
      ENDIF
      IF (QTITLE.EQ.BLANK) THEN
         YEND_1 = YEND1
         YEND_2 = YEND2
      ELSE
         YEND_1 = YEND1 - THEIGHT - THEIGHT/FOUR
         YEND_2 = YEND2 - THEIGHT - THEIGHT/FOUR
      ENDIF
      YADD = ZERO
      IF (ROTATE) THEN
C
C Calculate YADD
C
         IF (BAR_CHART) THEN
            NLOOP = NPTS/NGROUP
         ELSE
            NLOOP = MXTIC + N1
         ENDIF
         ICOUNT = N0
         DO I = N1, MIN(NLOOP,NWORDS)
            IF (PLOTX(I)) THEN
               L = LEN200(LABELS(I))
               IF (L.GT.ICOUNT) ICOUNT = L
            ENDIF
         ENDDO
         IF (ICOUNT.GT.N15) THEN
            YADD = YADD1
         ELSE
            YADD = DBLE(ICOUNT)*YADD1/DBLE(N15)
         ENDIF
      ENDIF
      CALL SPACES$(IPANEL, ISHAPE, KANGLE, KTIC, NXMAG,
     +             A, B, C, CZ, D, DZ, EHEIGHT, EPSI,
     +             EXTRA1, EXTRA2, EXTRA3, EXTRA4,
     +             XA, XB, XC, XD, XDIFF, XEND, XEND_1, XEND_2,
     +             XMAX, XMAX1, XMIN, XMIN1, XSTART, XSTRT_1, XTIC,
     +             YA, YADD, YB, YC, YD, YDIFF, YEND, YEND_1, YEND_2,
     +             YMAX, YMAX1, YMIN, YMIN1, YSTART, YSTRT1, YTIC,
     +             YYJUMP, ZA, ZB, ZC, ZD, ZDIFF, ZMAX, ZMAX1, ZMIN,
     +             ZMIN1,
     +             XTITLE,
     +             BAR_CHART, OFFSET, PANEL, PLOT_TITLE, ROTATE, SIDE,
     +             TWO_PLOTS)
C
C Ready to start plotting so set ABORT = .FALSE............ ...........
C
      ABORT = .FALSE.
C
C Set up windows, viewports and normalising transformations ...........
C======================================================================
C
C Set up N1 for data plotting
C
      IF (PIE_CHART) THEN
         CALL GSWN$(N1, 
     +              ZERO, ONE, ZERO, ONE)
         CALL GSVP$(N1,
     +              ZERO, ONE, ZERO, ONE)
      ELSE
         CALL GSWN$(N1,
     +              XMIN1, XMAX1, YMIN1, YMAX1)
         CALL GSVP$(N1,
     +              XC, XD, YC, YD)
      ENDIF
C
C Set up N2 for basic reference frame
C
      CALL GSWN$(N2,
     +           ZERO, ONE, ZERO, ONE)
      CALL GSVP$(N2,
     +           ZERO, ONE, ZERO, ONE)
C
C If PANEL then set up N3 to draw lines and symbols in side panel .....
C
      IF (PANEL) THEN
         CALL GSWN$(N3,
     +              XMIN1, XMAX1, YMIN1, YMAX1)
         YPCHT = XHEIGHT
         IF (SIDE) THEN
C
C Slide transformation N1 along to RHS then define parameters for panel
C
            IF (ISHAPE.EQ.1) THEN
               X1 = XXS1
               X2 = XS1
            ELSEIF (ISHAPE.EQ.2) THEN
               X1 = XXS2
               X2 = XS2
            ELSEIF (ISHAPE.EQ.3) THEN
               X1 = XXS3
               X2 = XS3
            ELSE
               X1 = XXS1
               X2 = XS1
            ENDIF
            X1 = X1 + XPDRAG
            X2 = X2 + XPDRAG
            CALL GSVP$(N3, 
     +                 XC + ONE - XD + XPDRAG, ONE + XPDRAG, YC, YD)
            XPMAX = XMIN1 +
     +        (X2 - (XC + ONE - XD + XPDRAG))*(XMAX1 - XMIN1)/(XD - XC)
            XPMIN = XMIN1 +
     +        (X1 - (XC + ONE - XD + XPDRAG))*(XMAX1 - XMIN1)/(XD - XC)
            YPMAX = YC + (YMAX - YMIN1)*(YD - YC)/(YMAX1 - YMIN1)
            YPMIN = YC + (YMIN - YMIN1)*(YD - YC)/(YMAX1 - YMIN1)
         ELSE
C
C Drop transformation N1 down to zero and adjust for aspect ratio
C
            YPMIN = ZERO
            YSCALE = (YD - YC)/(XD - XC)
            CALL GSVP$(N3, 
     +                ZERO, ONE, YPMIN, YSCALE)
            YPMAX = XHEIGHT
            IF (IPANEL.LE.3) THEN
               YPMAX = YPMAX + YXJUMP/TWO
            ELSE
               YPMAX = YPMAX + YXJUMP
            ENDIF
         ENDIF
      ENDIF
C
C If TWO_PLOTS set up N4 for E-xtra axis
C
      IF (TWO_PLOTS) THEN
         CALL GSWN$(N4,
     +              XMIN1, XMAX1, ZMIN1, ZMAX1)
         CALL GSVP$(N4,
     +              XC, XD, ZC, ZD)
      ELSEIF (SWAP_YZ) THEN
         CALL GSWN$(N4,
     +              XMIN1, XMAX1, YMIN1, YMAX1)
         CALL GSVP$(N4,
     +              XC, XD, YC, YD)
      ENDIF
C
C Call transformation N2 for axes etc. ................................
C
      CALL GSELNT$(N2)
      CALL GSLN$(N1)
      IF (MONO) THEN
         IF (VIDEO) THEN
            ICOLOR = N0
         ELSE
            ICOLOR = N15
         ENDIF
      ENDIF
C
C Next code causes full overprinting in Postscript and %gr for insets/overlays
C
      IF (.NOT.PS .AND. LCTEMP.EQ.N15 .AND. SHOW_BACKGROUND) THEN
C
C Block out the clipping region with background colour (corrected for %gr as well as PostScript (02/10/2018)
C
         X1 = XCLIP(1) + YTIC/FOUR
         X2 = XCLIP(2) - YTIC/FOUR
         Y1 = YCLIP(1) + XTIC/FOUR
         Y2 = YCLIP(2) - XTIC/FOUR
         CALL BLOCK$(X1, Y1, X2, Y2, LCTEMP)
      ELSEIF (PS .OR. LCTEMP.NE.N15) THEN
         IF (PS) THEN
C
C Redefine the background colour using LCTEMP
C
            IF (LCTEMP.LT.N10) THEN
               WRITE (NOUT_PS,100) LCTEMP
            ELSEIF (LCTEMP.LE.N71) THEN
               WRITE (NOUT_PS,200) LCTEMP
            ENDIF
         ENDIF
         IF (LCTEMP.EQ.N15) THEN
            SHOWIT = SHOW_BACKGROUND
         ELSE
            SHOWIT = .TRUE.
         ENDIF
         IF (SHOWIT) THEN
C
C Block out the clipping region with background colour (corrected 21/05/2016)
C
            X1 = XCLIP(1) + YTIC/FOUR
            X2 = XCLIP(2) - YTIC/FOUR
            Y1 = YCLIP(1) + XTIC/FOUR
            Y2 = YCLIP(2) - XTIC/FOUR
            CALL BLOCK$(X1, Y1, X2, Y2, LCTEMP)
         ENDIF
      ENDIF
      IF (PS) THEN
C
C Set Postscript linecaps for tick marks .......................PS only
C
         CALL PSLCAP$(N2) 
         CALL PSSPEC$(N2, NOUT_PS)
      ELSE      
         I = N2
         CALL SET_END_CAP (I,
     +                     STORE) 
      ENDIF
C
C Colour the border
C
      IF (BORDER .AND.KCOLOR(6).NE.LCTEMP) THEN
         IF (OFFSET) THEN
            X1 = ZERO
            Y1 = ZERO
            X2 = XSTART
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XEND
            Y1 = ZERO
            X2 = ONE
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XSTART
            Y1 = ZERO
            X2 = XEND
            Y2 = YSTART
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XSTART
            Y1 = YEND
            X2 = XEND
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
         ELSE
            X1 = ZERO
            Y1 = ZERO
            X2 = XA
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XB
            Y1 = ZERO
            X2 = ONE
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XA
            Y1 = ZERO
            X2 = XB
            Y2 = YA
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
            X1 = XA
            Y1 = YB
            X2 = XB
            Y2 = ONE
            CALL BLOCK$(X1, Y1, X2, Y2, KCOLOR(6))
         ENDIF
      ENDIF
C
C Draw graph paper type text positioning mesh
C
      IF (GRATICULE .AND. KCOLOR(7).NE.LCTEMP) THEN
         CALL GSLWSC$(ONE/TWO)
         XDELTA = ONE/DBLE(NXGRID - 1)
         X1 = ZERO
         Y1 = ZERO
         Y2 = ONE
         DO I = 1, NXGRID - 1
            X2 = X1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, KCOLOR(7))
            X1 = X1 + XDELTA
         ENDDO
         X1 = ONE
         X2 = X1
         CALL SOLID_LINE$(X1, Y1, X2, Y2, KCOLOR(7))
         YDELTA = ONE/DBLE(NYGRID - 1)
         X1 = ZERO
         X2 = ONE
         Y1 = ZERO
         DO I = 1, NYGRID - 1
            Y2 = Y1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, KCOLOR(7))
            Y1 = Y1 + YDELTA
         ENDDO
         Y1 = ONE
         Y2 = Y1
         CALL SOLID_LINE$(X1, Y1, X2, Y2, KCOLOR(7))
      ENDIF
C
C Draw X-Axis, Y-Axis, Box and Frame if required ......................
C
      CALL GSLWSC$(THICK)
      CALL FRAMES$(ICOLOR, KCOLOR, NKCOL, NPLOTS,
     +             XA, XB, XCLIP, XCOORD, XEND, XMAX, XMIN, XSTART,
     +             XTIC,
     +             YA, YB, YCLIP, YCOORD, YEND, YMAX, YMIN, YSTART,
     +             YTIC,
     +             ZCOORD, ZMAX, ZMIN,
     +             BAR_CHART, BOXIT, FRAME, MONO, NORMAL, OFFSET,
     +             PIE_CHART, PS, SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +             SWAP_YZ, TWO_PLOTS)
C
C Draw cross hairs if approppriate
C
      IF (CROSS_HAIRS) THEN
         CALL GSLWSC$(ONE)
         IF (OFFSET) THEN
            X1 = XA - XMIN*(XB - XA)/XDIFF
            X2 = X1
            Y1 = YSTART
            Y2 = YEND
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
            X1 = XSTART
            X2 = XEND
            Y1 = YA - YMIN*(YB - YA)/YDIFF
            Y2 = Y1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
         ELSE
            X1 = XA - XMIN*(XB - XA)/XDIFF
            X2 = X1
            Y1 = YA
            Y2 = YB
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
            X1 = XA
            X2 = XB
            Y1 = YA - YMIN*(YB - YA)/YDIFF
            Y2 = Y1
            CALL SOLID_LINE$(X1, Y1, X2, Y2, ICOLOR)
         ENDIF
      ENDIF
C
C
C Adjust the font sizes
C
      IF (TRUE_TYPE) THEN
         XPC1 = XPC_SCALE*XPC
         XPT1 = XPT_SCALE*XPT
         XPX1 = XPX_SCALE*XPX
         XPY1 = XPY_SCALE*XPY
      ELSE
         XPC1 = XPC
         XPT1 = XPT
         XPX1 = XPX
         XPY1 = XPY
      ENDIF
C
C Return if NPLOTS = 0
C
      IF (NPLOTS.LE.0) RETURN
C
C First work out labelling scheme for Y-Axis ..............................
C This must be done before X if BAR_CHART and YGRID are .TRUE.
C
      IF (.NOT.PIE_CHART) THEN
         IF (NORMAL) THEN
            XBEGIN = XSTART
         ELSE
            XBEGIN = XA + (XCOORD - XMIN)*(XB - XA)/(XMAX - XMIN)
         ENDIF
         IF (SWAP_YZ) THEN
            IF (OFFSET) THEN
               XBEGIN = XEND
            ELSEIF (NORMAL) THEN
               XBEGIN = XB
            ELSE
               XBEGIN = XA + (XCOORD - XMIN)*(XB - XA)/(XMAX - XMIN)
            ENDIF
            CALL ZLABEL$(ICOLOR, KCOLOR, KTIC, MYTIC, NCFONT, NKCOL,
     +                   NLOG, NOUT_PS, NWORDS, NYFIG, NYMAG,
     +                   CHEIGHT,
     +                   EXTRA3, EXTRA4,
     +                   XBEGIN, XPC1,
     +                   YA, YB, YMAX, YMIN, Y_SCALE, YTIC,
     +                   HARD_COPY, HPGL, MONO,
     +                   NATLOG, PCENTY, PHIGHY, PLOTY, POWERY, PS,
     +                   SHOW_ZAXIS, YTOINT)
            IF (BOXIT .AND. .NOT.TWO_PLOTS .AND. KTIC.NE.2 .AND.
     +          MYTIC.GE.0) THEN
               IF (OFFSET) THEN
                  XBOX1 = XSTART
               ELSE
                  XBOX1 = XA
               ENDIF
               IF (KTIC.EQ.1) THEN
                  XBOX2 = XBOX1 - YTIC
               ELSE
                  XBOX2 = XBOX1 + YTIC
               ENDIF
               DO I = 0, MYTIC
                  IF (MYTIC.EQ.0) THEN
                     YTEMP = (YA + YB)/TWO
                  ELSE
                     YTEMP = (I*(YB - YA)/MYTIC) + YA
                  ENDIF
                  IF (.NOT.MONO) ICOLOR = KCOLOR(2)
                  IF (PLOTY(I + 1)) CALL SOLID_LINE$(XBOX1, YTEMP,
     +                                               XBOX2, YTEMP,
     +                                               ICOLOR)
               ENDDO
            ENDIF
            IF (YGRID .AND. MYTIC.GE.0) THEN
               IF (OFFSET) THEN
                  XBOX1 = XEND
               ELSE
                  XBOX1 = XB
               ENDIF
               DO I = 0, MYTIC
                  IF (MYTIC.EQ.0) THEN
                     YTEMP = (YA + YB)/TWO
                  ELSE
                     YTEMP = (I*(YB - YA)/MYTIC) + YA
                  ENDIF
                  IF (.NOT.MONO) ICOLOR = KCOLOR(2)
                  CALL GSLN$(N3)
                  CALL GSLWSC$(THICK/FOUR)
                  CALL DASHED_LINE$(XSTART, YTEMP, XBOX1, YTEMP, ICOLOR)
                  CALL GSLWSC$(THICK)
               ENDDO
            ENDIF
         ELSE
            CALL YLABEL$(ICOLOR, KCOLOR, KTIC, MYTIC, NCFONT, NKCOL,
     +                   NLOG, NOUT_PS, NWORDS, NYFIG, NYMAG,
     +                   CHEIGHT,
     +                   EXTRA3, EXTRA4, PSADDY, THICK,
     +                   XB, XBEGIN, XEND, XPC1, XSTART,
     +                   YA, YB, YMAX, YMIN, Y_SCALE, YTIC,
     +                   BOXIT, BRAY_CURTIS, HARD_COPY, HPGL, MONO,
     +                   NATLOG, OFFSET, PCENTY, PHIGHY,
     +                   PLOTY, POWERY, PS, SHOW_YAXIS, TWO_PLOTS,
     +                   YGRID, YTOINT)
         ENDIF
      ENDIF
C
C Now work out labelling scheme for X-Axis ................................
C
      IF (PIE_CHART) THEN
         CALL PLABEL$(ICOLOR, KCOLOR, NCFONT, NKCOL, NOUT_PS, NPTS,
     +                FACTOR, X, XPC1, Y_SCALE, LABELS, LABVEC,
     +                HARD_COPY, HPGL, MONO, PANEL, PS, SIDE, THREE_D)
      ELSEIF (BAR_CHART) THEN
         IF (OFFSET .AND. ABS(YMIN - YCOORD).LE.EPSI) THEN
            YBEGIN = YSTART
         ELSE
            YBEGIN = YA + (YCOORD - YMIN)*(YB - YA)/(YMAX - YMIN)
         ENDIF
         CALL BLABEL$(ICOLOR, KANGLE, KCOLOR, MXDROP, MXTIC, NCFONT,
     +                NGROUP, NKCOL, NOUT_PS, NPTS,
     +                CHEIGHT, EHEIGHT, EXTRA1, EXTRA2, THICK,
     +                X, XA, XB, XEND,
     +                XMAX, XMIN, XPC1, XSTART, XTIC,
     +                YBEGIN, YDROP, YEND, Y_SCALE, YSTART,
     +                LABELS, LABVEC,
     +                BOXIT, HARD_COPY, HPGL, MONO, OFFSET,
     +                PS, ROTATE, SHOW_XAXIS)
      ELSE
         IF (NORMAL) THEN
            YBEGIN = YSTART
         ELSE
            YBEGIN = YA + (YCOORD - YMIN)*(YB - YA)/(YMAX - YMIN)
         ENDIF
         CALL XLABEL$(ICOLOR, KANGLE, KCOLOR, KTIC,
     +                MTRANS, MXDROP, MXTIC,
     +                NCFONT, NKCOL, NLOG, NOUT_PS, NWORDS, NXMAG,
     +                CHEIGHT, EXTRA1, EXTRA2, THICK,
     +                XA, XB, XMAX, XMIN, XPC1, XTIC,
     +                YB, YBEGIN, YDROP, YEND, Y_SCALE, YSTART,
     +                WORDX, WORDY,
     +                BOXIT, HARD_COPY, HPGL, MONO,
     +                NATLOG, NUMBRX, OFFSET, PCENTX, PHIGHX,
     +                PLOTX, POWERX, PS, ROTATE, SHOW_XAXIS,
     +                XGRID, XTOINT)
      ENDIF
C
C Now work out labelling scheme for Z-Axis ..............................
C
      IF (TWO_PLOTS) THEN
         IF (OFFSET) THEN
            XBEGIN = XEND
         ELSEIF (NORMAL) THEN
            XBEGIN = XB
         ELSE
            XBEGIN = XA + (ZCOORD - XMIN)*(XB - XA)/(XMAX - XMIN)
         ENDIF
         CALL ZLABEL$(ICOLOR, KCOLOR, KTIC, MZTIC, NCFONT, NKCOL, NLOG,
     +                NOUT_PS, NWORDS, NZFIG, NZMAG,
     +                CHEIGHT,
     +                EXTRA3, EXTRA4,
     +                XBEGIN, XPC1,
     +                ZA, ZB, ZMAX, ZMIN, Y_SCALE, YTIC,
     +                HARD_COPY, HPGL, MONO,
     +                NATLOG, PCENTZ, PHIGHZ, PLOTZ, POWERZ, PS,
     +                SHOW_ZAXIS, ZTOINT)
      ENDIF
C
C Draw the Plot Title and legends.......................................
C
      CALL TITLES$(ICOLOR, IPANEL, ISHAPE, KCOLOR, KTIC,
     +             NKCOL, NOUT_PS, NTFONT, NXFONT, NYFIG, NYFONT, NZFIG,
     +             DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +             THEIGHT,
     +             XA, XB, XCLIP, XEND, XHEIGHT, XPX1, XPY1, XPT1,
     +             XSTART,
     +             YA, YB, Y_SCALE, YTIC, YXJUMP,
     +             ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +             CENTRE, HARD_COPY, HPGL, MONO,
     +             PANEL, PLOT_TITLE, PS, SIDE, SWAP_YZ)
      IF (PS) THEN 
C
C Set Postscript linecaps for tick marks .......................PS only
C
         CALL PSLCAP$(N0)
      ELSE
         I = N0
         CALL SET_END_CAP (I,
     +                     STORE)
      ENDIF            
      ABORT = .FALSE.   
C
C These format statements must NOT be edited
C      
  100 FORMAT ('/background{c',I1,'}D')
  200 FORMAT ('/background{c',I2,'}D')
      END
C
C
