C
C
      SUBROUTINE GKSR2I$(IX, IY, 
     +                   X, Y)
C
C ACTION : Transform a real number pair into an integer pair for plotting
C          Required for FTN77 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/12/93
C          28/10/1994 Added code if HARD_COPY = .true.
C          13/04/2007 added INTENTS 
C          15/06/2007 removed defngks.ins and added GKSGET routines  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (OUT) :: IX, IY
      DOUBLE PRECISION, INTENT (IN)  :: X, Y 
C
C Locals
C              
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      INTEGER    IXBOT0, IXDIF0, IXTOP0, IYBOT0, IYDIF0, IYTOP0
      INTEGER    IXBOT1, IXDIF1, IXTOP1, IYBOT1, IYDIF1, IYTOP1
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE    
      DOUBLE PRECISION XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      EXTERNAL   GETDEF$, GETGKS_OT0, GETGKS_OT1, GETGKS_FF1
      INTRINSIC  DBLE, NINT 
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)  
      CALL GETGKS_FF1 (XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01)
      CALL GETGKS_OT0 (IXBOT0, IXDIF0, IXTOP0, IYBOT0, IYDIF0, IYTOP0)
      CALL GETGKS_OT1 (IXBOT1, IXDIF1, IXTOP1, IYBOT1, IYDIF1, IYTOP1)
      IF (HARD_COPY) THEN
         IF (DOTMAT .OR. PCL) THEN
            IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
            IY = NINT(DBLE(IYBOT0) - DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
            IX = NINT(DBLE(IX_OFF) + DBLE(IX)*X_SCALE)
            IY = NINT(DBLE(IY_OFF) + DBLE(IY)*Y_SCALE)
         ELSEIF (HPGL) THEN
            IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
            IY = NINT(DBLE(IYBOT1) - IYBOT0
     +                             + DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
            IX = NINT(DBLE(IX_OFF) + DBLE(IX)*X_SCALE)
            IY = NINT(DBLE(IY_OFF) + DBLE(IY)*Y_SCALE)
         ELSEIF (PS) THEN
            IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
            IY = NINT(DBLE(IYBOT1 - IYBOT0)
     +                             + DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
         ELSE
C
C Presume SVG is required
C           
            IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
            IY = NINT(DBLE(IYBOT0) - DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
         ENDIF
      ELSE
         IX = NINT(DBLE(IXBOT0) + DBLE(IXDIF0)*((X - XMIN01)/XDIFF1))
         IY = NINT(DBLE(IYBOT0) - DBLE(IYDIF0)*((Y - YMIN01)/YDIFF1))
      ENDIF
      END
C 
C----------------------------------------------------------------------------
C
C
C
      SUBROUTINE GKSR2D$(DX, DY, 
     +                   X, Y)
C
C ACTION : Transform a real number pair into a double precision pair for plotting
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          23/11/2013 derived from GKSR2I$ 
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION, INTENT (OUT) :: DX, DY
      DOUBLE PRECISION, INTENT (IN)  :: X, Y 
C
C Locals
C              
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION DXBOT0, DXDIF0, DXTOP0, DYBOT0, DYDIF0, DYTOP0
      DOUBLE PRECISION DXBOT1, DXDIF1, DXTOP1, DYBOT1, DYDIF1, DYTOP1
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE    
      DOUBLE PRECISION XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      EXTERNAL   GETDEF$, GETGKS_DT0, GETGKS_DT1, GETGKS_FF1
      INTRINSIC  DBLE 
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)  
      CALL GETGKS_FF1 (XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01)
      CALL GETGKS_DT0 (DXBOT0, DXDIF0, DXTOP0, DYBOT0, DYDIF0, DYTOP0)
      CALL GETGKS_DT1 (DXBOT1, DXDIF1, DXTOP1, DYBOT1, DYDIF1, DYTOP1)
      IF (HARD_COPY) THEN
         IF (DOTMAT .OR. PCL) THEN
            DX = DXBOT0 + DXDIF0*(X - XMIN01)/XDIFF1
            DY = DYBOT0 - DYDIF0*(Y - YMIN01)/YDIFF1
            DX = DBLE(IX_OFF) + DX*X_SCALE
            DY = DBLE(IY_OFF) + DY*Y_SCALE
         ELSEIF (HPGL) THEN
            DX = DXBOT0 + DXDIF0*(X - XMIN01)/XDIFF1
            DY = DYBOT1 - DYBOT0
     +                             + DYDIF0*(Y - YMIN01)/YDIFF1
            DX = DBLE(IX_OFF) + DX*X_SCALE
            DY = DBLE(IY_OFF) + DY*Y_SCALE
         ELSEIF (PS) THEN
            DX = DXBOT0 + DXDIF0*(X - XMIN01)/XDIFF1
            DY = DYBOT1 - DYBOT0
     +                             + DYDIF0*(Y - YMIN01)/YDIFF1
         ELSE
            DX = DXBOT0 + DXDIF0*(X - XMIN01)/XDIFF1
            DY = DYBOT0 - DYDIF0*(Y - YMIN01)/YDIFF1           
         ENDIF
      ELSE
         DX = DXBOT0 + DXDIF0*(X - XMIN01)/XDIFF1
         DY = DYBOT0 - DYDIF0*(Y - YMIN01)/YDIFF1
      ENDIF
      END
C 
C----------------------------------------------------------------------------
C