c
c-----------------------------------------------------------------------
c 
      subroutine gkssav$ (isend, n,
     +                    abort)

      use module_savegks, only : nmax1,
     +                           x, xh, xht, xl, xlt, xt, 
     +                           y, yh, yht, yl, ylt, yt
           
c
c action: allocate/deallocate graphics workspace in module_savegks
c author: w.g.bardsley, university of manchester, u.k., 28/01/2008
c         16/09/2011 compressed down to minum components
c
c         isend = 0: just deallocate
c         isend = 1: allocate first time round with existing nmax1
c         isend = 2: deallocate then allocate x, xh, xht, xl, xlt, xt,
c                                             y, yh, yht, yl, ylt, yt 
c                    using increased value for nmax1
c      
      implicit none
c
c arguments
c      
      integer, intent (in)  :: isend, n
      logical, intent (out) :: abort
c
c locals
c      
      integer    ierr, k0, k5
      parameter (k0 = 0, k5 = 5)
      logical    store
      parameter (store = .true.) 
      external   savint$
      ierr = k0
      if (isend.eq.0) then
c
c isend = 0: deallocate everything
c              
         abort = .true.
         if (allocated(x)) deallocate(x, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(xh)) deallocate(xh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xht)) deallocate(xht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xl)) deallocate(xl, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xlt)) deallocate(xlt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xt)) deallocate(xt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(y)) deallocate(y, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yh)) deallocate(yh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yht)) deallocate(yht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yl)) deallocate(yl, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(ylt)) deallocate(ylt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yt)) deallocate(yt, stat = ierr)  
         if (ierr.ne.k0) return    
         abort = .false.        
      elseif (isend.eq.1) then
c
c isend = 1: allocate first time with initial value of nmax1
c          
         abort = .true.
         if (allocated(x)) deallocate(x, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(xh)) deallocate(xh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xht)) deallocate(xht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xl)) deallocate(xl, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xlt)) deallocate(xlt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xt)) deallocate(xt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(y)) deallocate(y, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yh)) deallocate(yh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yht)) deallocate(yht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yl)) deallocate(yl, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(ylt)) deallocate(ylt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yt)) deallocate(yt, stat = ierr)  
         if (ierr.ne.k0) return
           
         allocate(x(nmax1), stat = ierr)
         if (ierr.ne.k0) return 
         allocate(xh(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xht(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xl(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xlt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(y(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yh(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yht(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yl(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(ylt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yt(nmax1), stat = ierr)
         if (ierr.ne.k0) return  
         abort = .false.
       elseif (isend.eq.2) then
c
c isend = 2: deallocate then increase nmax1 and allocate x, ..., yt if n > current nmax1
c       
         abort = .false.
         if (n.le.nmax1) then
            return
         else
            nmax1 = n
            call savint$(k5, k5, nmax1,
     +                   store)           
         endif  
         abort = .true.    
         if (allocated(x)) deallocate(x, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(xh)) deallocate(xh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xht)) deallocate(xht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xl)) deallocate(xl, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xlt)) deallocate(xlt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(xt)) deallocate(xt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(y)) deallocate(y, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yh)) deallocate(yh, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yht)) deallocate(yht, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yl)) deallocate(yl, stat = ierr)  
         if (ierr.ne.k0) return  
         if (allocated(ylt)) deallocate(ylt, stat = ierr)  
         if (ierr.ne.k0) return
         if (allocated(yt)) deallocate(yt, stat = ierr)  
         if (ierr.ne.k0) return
         
         allocate(x(nmax1), stat = ierr)
         if (ierr.ne.k0) return 
         allocate(xh(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xht(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xl(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xlt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(xt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(y(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yh(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yht(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yl(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(ylt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         allocate(yt(nmax1), stat = ierr)
         if (ierr.ne.k0) return
         abort = .false. 
       else
          abort = .true.           
       endif
       end  
c
c--------------------------------------------------------------------
c   