C
C GKSSTY : This subroutine communicates with the clearwin modulke in w_clearwin.dll
C          to initialise metafiles and store/retrieve plotting parameters
C          as follows:
C
C          MENU02$ ... titles and legends
C          MENU04$ ... x, y axes manipulation
C          MENU05$ ... frames and sizes
C          MENU06$ ... data, i.e. error bars and lines
C          MENU07$ ... extra text and arrows
C          MENU10$ ... colours
C          MENU11$ ... coordinate transformations
C
C The use of ISEND/JSEND in the menus is as follows:
C ==================================================
C ISEND = 1: just store
C ISEND = 2: edit then retrieve and store
C ISEND = 3: just retrieve
C
      SUBROUTINE GKSSTY$(IFILL, IHUE, ISHAPE, JCOLOR,
     +                   KANGLE, KCOLOR, KPANEL, KTIC,
     +                   L, LCOLOR, M, MTRANS, MXDROP, MXTIC, MYTIC,
     +                   MZTIC, NCLIP, NFILES, NGRAFS, NGROUP, NIN,
     +                   NKCOL, NLOG, NPRESS, NPTS, NSAV, NWORDS, NXTRA,
     +                   ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   FACTOR, SIZE, THICK, WIDE,
     +                   XCLIP, XCOORD, XMAX, XMIN,
     +                   YCLIP, YCOORD, YDROP, YMAX, YMAX3, YMAX4, YMIN,
     +                   YMIN3, YMIN4, ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   FSAV, FSAV1, LABELS, LABVEC, PLINE,
     +                   PSYMB, PTITLE, QTITLE, TSAV, WORDX, WORDY,
     +                   XTITLE, YTITLE, ZTITLE,
     +                   ABORT, BARCAP, BARCAP_1, BAR_CHART, BORDER,
     +                   BOXIT,  CENTRE, DENDRO_GRAM, EXTEND_LINES,
     +                   FIRST, FRAME, GRATICULE, LOWER,
     +                   MONO, NATLOG, NUMBRX, OFFSET,
     +                   PANEL, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ,
     +                   PIE_CHART, PLOT_LABELS, PLOT_TITLE, PLOTX,
     +                   PLOTY, PLOTZ, POWERX, POWERY, POWERZ, ROTATE,
     +                   SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +                   SHOW_YAXIS, SHOW_ZAXIS, SIDE, SWAP_YZ,
     +                   THREE_D, TWO_PLOTS, UPPER, XGRID,
     +                   XTOINT, VECTOR_FIELD, VIDEO, YAXIS, YGRID,
     +                   YTOINT, ZTOINT)
C
C ACTION : Set up frame for GKSPLT
C          FIRST = .TRUE. then set up defaults
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 2/11/92
C          14/10/1996 Extensive revision to control ranges and ticks
C          19/10/1996 Added CONFIG$
C          04/11/1996 Added XCLIP, YCLIP
C          14/11/1996 Added XRANGE and SIMHLP
C          20/02/1997 Added BARCAP_1
C          14/07/1997 win32 version
C          23/11/1997 extensive revision as follows:-
C          FIRST = .TRUE. Initialise and set NPRESS = 0 to create a plot
C          FIRST = .FALSE. ... NPRESS = 0 return to plot
C                              NPRESS = 1 fire up the menu system
C                              NPRESS = 2, 14 fire off from button presses
C                              NPRESS < 0 or > 14 return
C          09/03/1998 Added VECTOR_FIELD
C          10/09/1998 Added FSAV1
C          10/12/1998 Added NGROUP
C          22/07/1999 Adjusted for extended transformations
C                     Note: transformations 0 to 15 now correspond to 0 to 15
C                     of MENU08$ but 16 to 23 correspond to 8 to 15 when
C                     log10 is used instead of log. Hence the use of IADD8.
C          01/02/2000 Added BLOG2 so default is log base 2 not log base e
C                     Added MTRAN1 = MTRANS + IADD8 to access arrays, i.e.
C                     MTRANS is in (0,15) but MTRAN1 is in (0,23)
C                     Also added MAXTIC to prevent overfloe in no. ticks
C          18/02/2000 Added DRAGTI, DRAGXL, DRAGYL, DRAGZL
C          23/02/2000 Added PHIGHX, PHIGHY, PHIGHZ
C          03/07/2000 Added A, B, C, D, E, F, XSMALL, YSMALL and warnings
C                     for unsuitable data
C          29/10/2000 extensive re-editing
C          24/01/2001 now calls STYGKS$ if FIRST = .FALSE.
C          20/07/2001 added DENDRO_GRAM and SHOW_XAXIS
C          31/07/2001 defined MAXTIC = NWORDS - 1
C          15/08/2001 added MXDROP and YDROP
C          08/09/2001 added THREE_D
C          07/01/2002 redimensioned WIDE(5*NRMAX)
C          21/10/2004 added SHOW_BACKGROUND and SHOW_QUADRANTS
C          14/07/2005 added PLOT_LABELS to MENU04$
C          19/08/2005 added EXTEND_LINES 
C          09/05/2007 added INTENTS
C          01/01/2008 added NXTRA
C          30/07/2009 added call to GRFLGL$ and used MXTIX, MYTIC from call to DEFOLT$
C          17/08/2009 replaced XRANGE$ by DOAXIS$ and corrected ranges for MTRAN1 >= 16 
C          26/08/2009 added calls to GRFSIG$ and SIGGKS$
C          02/11/2009 added calls to EXPAND$
c          07/02/2011 incresed nlgl to 9 and added panel = lglvar(8) and side = lglvar(9)
C
      IMPLICIT   NONE 
C
C Integers in argument list
C      
      INTEGER, INTENT (IN)    :: KPANEL, NCLIP, NGRAFS, NKCOL, NIN,
     +                           NLOG, NWORDS, NXTRA
      INTEGER, INTENT (INOUT) :: NFILES, IFILL(NXTRA), IHUE(NXTRA),
     +                           ISHAPE, NGROUP, JCOLOR(NGRAFS),
     +                           KANGLE, KCOLOR(NKCOL), KTIC,
     +                           L(NGRAFS), LCOLOR, M(NGRAFS), NPRESS,
     +                           NPTS, NSAV(NGRAFS), MTRANS, MXDROP,
     +                           MXTIC, MYTIC, MZTIC
C
C Reals in argument list 
C     
      DOUBLE PRECISION, INTENT (INOUT) :: ASYMP, DRAGTI, DRAGXL, DRAGYL,
     +                                    DRAGZL, FACTOR(NXTRA),
     +                                    SIZE(NGRAFS), THICK,
     +                                    WIDE(5*NGRAFS)
      DOUBLE PRECISION, INTENT (INOUT) :: XCLIP(NCLIP), XCOORD, XMAX,
     +                                    XMIN
      DOUBLE PRECISION, INTENT (INOUT) :: YCLIP(NCLIP), YCOORD, YDROP,
     +                                    YMAX, YMAX3, YMAX4, YMIN,
     +                                    YMIN3, YMIN4, ZCOORD, ZMAX,
     +                                    ZMIN, ZSCALE
C
C Characters in argument list
C
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYQ, ARRAYT(0:15),
     +                                       ARRAYX(0:15), ARRAYY(0:15),
     +                                       ARRAYZ(0:15), FSAV(NGRAFS),
     +                                       FSAV1(NGRAFS),
     +                                       LABELS(NWORDS),
     +                                       LABVEC(NWORDS),
     +                                       TSAV(NGRAFS),
     +                                       PLINE(KPANEL), 
     +                                       PSYMB(KPANEL),
     +                                       PTITLE(0:15), QTITLE,
     +                                       WORDX(NWORDS),
     +                                       WORDY(NWORDS), 
     +                                       XTITLE(0:15), YTITLE(0:15),
     +                                       ZTITLE(0:15)
C
C Logicals in argument list
C
      LOGICAL, INTENT (INOUT) :: BARCAP(NGRAFS), BARCAP_1, BAR_CHART,
     +                           BORDER, LOWER(NGRAFS), UPPER(NGRAFS)
      LOGICAL, INTENT (INOUT) :: BOXIT, CENTRE, DENDRO_GRAM,
     +                           EXTEND_LINES, FIRST, FRAME, GRATICULE,
     +                           NATLOG(NLOG), NUMBRX, OFFSET, PANEL,
     +                           PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY,
     +                           PHIGHZ, PIE_CHART, PLOT_LABELS,
     +                           PLOT_TITLE,  PLOTX(NWORDS),
     +                           PLOTY(NWORDS), PLOTZ(NWORDS), POWERX,
     +                           POWERY, POWERZ, ROTATE
      LOGICAL, INTENT (INOUT) :: SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                           SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                           SIDE, SWAP_YZ, THREE_D, TWO_PLOTS,
     +                           XGRID, XTOINT, YGRID, YTOINT, ZTOINT 
      LOGICAL, INTENT (INOUT) :: YAXIS (NGRAFS)
      LOGICAL, INTENT (INOUT) :: MONO, VECTOR_FIELD, VIDEO
      LOGICAL, INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    LPREV, LPREV_1
      INTEGER    I, IADD8, ISEND, J, NCOL, NROW, NSIG
      INTEGER    MTRAN1, MXTICT(0:23), MYTICT(0:23)
      INTEGER    MXTICT_1(0:23), MYTICT_1(0:23)
      INTEGER    NLDIG
      INTEGER    MAXTIC, MINTIC
      PARAMETER (MINTIC = - 1) 
      INTEGER    JSEND, KSEND, NLGL
      PARAMETER (JSEND = 3, KSEND = 1, NLGL = 9)  
      DOUBLE PRECISION RTOL, RTOL1
      DOUBLE PRECISION XCOORD_T(0:23), YCOORD_T(0:23)
      DOUBLE PRECISION XCOORD_1(0:23), YCOORD_1(0:23)
      DOUBLE PRECISION XMAXT(0:23), XMINT(0:23), YMAXT(0:23),
     +                 YMINT(0:23)
      DOUBLE PRECISION XMAXT_1(0:23), XMINT_1(0:23), YMAXT_1(0:23),
     +                 YMINT_1(0:23)
      DOUBLE PRECISION ASAV, YSAV1, YSAV2
      DOUBLE PRECISION ASAV_1, YSAV1_1, YSAV2_1
      DOUBLE PRECISION X02AME$
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.49999D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION BLOG2
      DOUBLE PRECISION A, B, C, D, E, F
      DOUBLE PRECISION XBIG, XSMALL, YBIG, YSMALL     
      CHARACTER  LINE*100
      LOGICAL    STORE
      LOGICAL    XDIL, XDIV, XLOG, YDIV, YLOG 
      LOGICAL    LGLVAR(NLGL)
      EXTERNAL   X02AME$
      EXTERNAL   MENU02$, MENU04$, MENU05$, MENU06$, MENU07$, MENU10$,
     +           MENU11$, DOAXIS$, STYGKS$, SAVETR$, GRFLGL$, GRFSIG$,
     +           EXPAND$ 
      INTRINSIC  ABS, MAX, LOG, MIN, LOG10, NINT, DBLE
      SAVE       MXTICT, MYTICT
      SAVE       IADD8, LPREV
      SAVE       ASAV, XMAXT, XMINT, YMAXT, YMINT, YSAV1, YSAV2
      SAVE       XCOORD_T, YCOORD_T
      SAVE       XDIL, XDIV, XLOG, YDIV, YLOG
      DATA       MXTICT / 24*4 /
      DATA       MYTICT / 24*4 /
      DATA       IADD8 / 0 /
      DATA       LPREV / 0 /
      DATA           XDIL,    XDIV,    XLOG,    YDIV,    YLOG
     +          / .FALSE., .FALSE., .FALSE., .FALSE., .FALSE. /
C
C Initialise
C
      ABORT = .FALSE.
      LINE = 'OK'                        !to silence NAGfor
      IF (LINE.EQ.'OK') ABORT = .FALSE.  !to silence NAGfor 
      RTOL = 1.0D+09*X02AME$()
      RTOL1 = - RTOL
      MAXTIC = NWORDS - 1
      IF (PIE_CHART) ISHAPE = 1
C
C=======================================================================
C First time only ..... Initialise defaults if FIRST = .TRUE.
C=======================================================================
C
      IF (FIRST) THEN
         CALL EXPAND$ (XMAX, XMIN)
         CALL EXPAND$ (YMAX, YMIN)
         DO I = 0, 23
            MXTICT(I) = MXTIC
            MYTICT(I) = MYTIC
         ENDDO   
         NPRESS = 0
         FIRST = .FALSE.
         LPREV = 0
         IF (ABS(YMAX).LT.2.0D+09) THEN
            ASYMP = MAX(ONE,DBLE(NINT(YMAX)))
            IF (ASYMP.LT.YMAX) ASYMP = ASYMP + ONE
         ELSE
            ASYMP = 1.25D+00*YMAX
         ENDIF
         ASAV  = 1.25D+00*YMIN
         YSAV1 = YMIN
         YSAV2 = YMAX
C
C Find XSMALL, YSMALL, the smallest positive nonzero values and
C then check for extreme X and Y values
C
         A = ONE/RTOL
         XBIG = - A
         XSMALL = A
         YBIG = - A
         YSMALL = A
         XDIV = .TRUE.
         XLOG = .TRUE.
         XDIL = .TRUE.
         YDIV = .TRUE.
         YLOG = .TRUE.
         DO I = 1, NFILES
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV1(I))
            READ (NIN,'(A)') LINE
            READ (NIN,*) NROW, NCOL
            IF (NROW.GE.1) THEN
               DO J = 1, NROW
                  IF (NCOL.EQ.2) THEN
                     READ (NIN,*) A, B
                     IF (A.LT.RTOL1 .AND. A.GT.XBIG) XBIG = A
                     IF (A.GT.RTOL .AND. A.LT.XSMALL) XSMALL = A
                     IF (A.LE.RTOL) XLOG = .FALSE.
                     IF (ABS(A).LE.RTOL) XDIV = .FALSE.
                     IF (A.GT.ONE) XDIL = .FALSE.
                     IF (B.LT.RTOL1 .AND. B.GT.YBIG) YBIG = B
                     IF (B.GT.RTOL .AND. B.LT.YSMALL) YSMALL = B
                     IF (B.LE.RTOL) YLOG = .FALSE.
                     IF (ABS(B).LE.RTOL) YDIV = .FALSE.
                  ELSEIF (NCOL.EQ.3) THEN
                     READ (NIN,*) A, B, C
                     IF (A.LT.RTOL1 .AND. A.GT.XBIG) XBIG = A
                     IF (A.GT.RTOL .AND. A.LT.XSMALL) XSMALL = A
                     IF (A.LE.RTOL) XLOG = .FALSE.
                     IF (ABS(A).LE.RTOL) XDIV = .FALSE.
                     IF (A.GT.ONE) XDIL = .FALSE.
                     IF (B.LT.RTOL1 .AND. B.GT.YBIG) YBIG = B
                     IF (B.GT.RTOL .AND. B.LT.YSMALL) YSMALL = B
                     IF (B.LE.RTOL) YLOG = .FALSE.
                     IF (ABS(B).LE.RTOL) YDIV = .FALSE.
                  ELSEIF (NCOL.EQ.4) THEN
                     READ (NIN,*) A, B, C, D
                     IF (A.LT.RTOL1 .AND. A.GT.XBIG) XBIG = A
                     IF (A.GT.RTOL .AND. A.LT.XSMALL) XSMALL = A
                     IF (A.LE.RTOL) XLOG = .FALSE.
                     IF (ABS(A).LE.RTOL) XDIV = .FALSE.
                     IF (A.GT.ONE) XDIL = .FALSE.
                     IF (B.LT.RTOL1 .AND. B.GT.YBIG) YBIG = B
                     IF (B.GT.RTOL .AND. B.LT.YSMALL) YSMALL = B
                     IF (C.LT.RTOL1 .AND. C.GT.YBIG) YBIG = C
                     IF (C.GT.RTOL .AND. C.LT.YSMALL) YSMALL = C
                     IF (D.LT.RTOL1 .AND. D.GT.YBIG) YBIG = D
                     IF (D.GT.RTOL .AND. D.LT.YSMALL) YSMALL = D
                     IF (ABS(B).LE.RTOL) YDIV = .FALSE.
                     IF (ABS(C).LE.RTOL) YDIV = .FALSE.
                     IF (ABS(D).LE.RTOL) YDIV = .FALSE.
                     IF (B.LE.RTOL) YLOG = .FALSE.
                     IF (C.LE.RTOL) YLOG = .FALSE.
                     IF (D.LE.RTOL) YLOG = .FALSE.
                  ELSEIF (NCOL.EQ.6) THEN
                     READ (NIN,*) A, B, C, D, E, F
                     IF (A.LT.RTOL1 .AND. A.GT.XBIG) XBIG = A
                     IF (A.GT.RTOL .AND. A.LT.XSMALL) XSMALL = A
                     IF (B.LT.RTOL1 .AND. B.GT.XBIG) XBIG = B
                     IF (B.GT.RTOL .AND. B.LT.XSMALL) XSMALL = B
                     IF (C.LT.RTOL1 .AND. C.GT.XBIG) XBIG = C
                     IF (C.GT.RTOL .AND. C.LT.XSMALL) XSMALL = C
                     IF (ABS(A).LE.RTOL) XDIV = .FALSE.
                     IF (ABS(B).LE.RTOL) XDIV = .FALSE.
                     IF (ABS(C).LE.RTOL) XDIV = .FALSE.
                     IF (A.LE.RTOL) XLOG = .FALSE.
                     IF (B.LE.RTOL) XLOG = .FALSE.
                     IF (C.LE.RTOL) XLOG = .FALSE.
                     IF (A.GT.ONE) XDIL = .FALSE.
                     IF (B.GT.ONE) XDIL = .FALSE.
                     IF (C.GT.ONE) XDIL = .FALSE.
                     IF (D.LT.RTOL1 .AND. D.GT.YBIG) YBIG = D
                     IF (D.GT.RTOL .AND. D.LT.YSMALL) YSMALL = D
                     IF (E.LT.RTOL1 .AND. E.GT.YBIG) YBIG = E
                     IF (E.GT.RTOL .AND. E.LT.YSMALL) YSMALL = E
                     IF (F.LT.RTOL1 .AND. F.GT.YBIG) YBIG = F
                     IF (F.GT.RTOL .AND. F.LT.YSMALL) YSMALL = F
                     IF (ABS(D).LE.RTOL) YDIV = .FALSE.
                     IF (ABS(E).LE.RTOL) YDIV = .FALSE.
                     IF (ABS(F).LE.RTOL) YDIV = .FALSE.
                     IF (D.LE.RTOL) YLOG = .FALSE.
                     IF (E.LE.RTOL) YLOG = .FALSE.
                     IF (F.LE.RTOL) YLOG = .FALSE.
                  ENDIF
               ENDDO
            ENDIF
         ENDDO
         CLOSE (UNIT = NIN)
C
C Select default plotting ranges
C
         BLOG2 = ONE/LOG(TWO)
         XMAXT(0) = XMAX
         XMAXT(1) = YMAX
         XMAXT(2) = XMAX
         IF (XMAX.LT. - RTOL) THEN
            XMAXT(3) = ONE/XMIN
            XMAXT(4) = ONE/XMIN
         ELSE
            XMAXT(3) = ONE/XSMALL
            XMAXT(4) = ONE/XSMALL
         ENDIF
         XMAXT(5) = YMAX
         XMAXT(6) = YMAX3
         XMAXT(7) = XMAX
         XMAXT(8) = BLOG2*LOG(MAX(RTOL,XMAX))
         XMAXT(9) = XMAX
         XMAXT(10) = BLOG2*LOG(MAX(RTOL,XMAX))
         XMAXT(11) = BLOG2*LOG(MAX(RTOL,XMAX))
         XMAXT(12) = BLOG2*LOG(ONE/MAX(RTOL,XMIN))
         XMAXT(13) = BLOG2*LOG(MAX(RTOL,YMAX))
         XMAXT(14) = YMAX
         XMAXT(15) = BLOG2*LOG(MAX(RTOL,YMAX))
C........ now log10
         XMAXT(16) = LOG10(MAX(RTOL,XMAX))
         XMAXT(17) = XMAX
         XMAXT(18) = LOG10(MAX(RTOL,XMAX))
         XMAXT(19) = LOG10(MAX(RTOL,XMAX))
         XMAXT(20) = LOG10(ONE/MAX(RTOL,XMIN))
         XMAXT(21) = LOG10(MAX(RTOL,YMAX))
         XMAXT(22) = YMAX
         XMAXT(23) = LOG10(MAX(RTOL,YMAX))

         XMINT(0) = XMIN
         XMINT(1) = YMIN
         XMINT(2) = XMIN
         IF (XMIN.LT. - RTOL) THEN
            XMINT(3) = ONE/XBIG
            XMINT(4) = ONE/XBIG
         ELSE
            XMINT(3) = ONE/MAX(RTOL,XMAX)
            XMINT(4) = ONE/MAX(RTOL,XMAX)
         ENDIF
         XMINT(5) = YMIN
         XMINT(6) = YMIN3
         XMINT(7) = XMIN
         XMINT(8) = BLOG2*LOG(XSMALL)
         XMINT(9) = XMIN
         XMINT(10) = BLOG2*LOG(XSMALL)
         XMINT(11) = BLOG2*LOG(XSMALL)
         XMINT(12) = BLOG2*LOG(ONE/MAX(RTOL,MIN(ONE,XMAX)))
         IF (XMINT(12).LT.ZERO) XMINT(12) = ZERO
         XMINT(13) = BLOG2*LOG(YSMALL)
         XMINT(14) = YMIN
         XMINT(15) = BLOG2*LOG(YSMALL)
C........now log10
         XMINT(16) = LOG10(XSMALL)
         XMINT(17) = XMIN
         XMINT(18) = LOG10(XSMALL)
         XMINT(19) = LOG10(XSMALL)
         XMINT(20) = LOG10(ONE/MAX(RTOL,MIN(ONE,XMAX)))
         IF (XMINT(20).LT.ZERO) XMINT(20) = ZERO
         XMINT(21) = LOG10(YSMALL)
         XMINT(22) = YMIN
         XMINT(23) = LOG10(YSMALL)

         YMAXT(0) = YMAX
         YMAXT(1) = XMAX
         IF (YMAX.LT. - RTOL) THEN
            YMAXT(2) = ONE/YMIN
         ELSE
            YMAXT(2) = ONE/YSMALL
         ENDIF
         YMAXT(3) = YMAX
         IF (YMAX.LT. - RTOL) THEN
            YMAXT(4) = ONE/YMIN
         ELSE
            YMAXT(4) = ONE/YSMALL
         ENDIF
         YMAXT(5) = YMAX3
         YMAXT(6) = YMAX
         YMAXT(7) = YMAX4
         YMAXT(8) = YMAX
         YMAXT(9) = BLOG2*LOG(MAX(RTOL,YMAX))
         YMAXT(10) = BLOG2*LOG(MAX(RTOL,YMAX))
         YMAXT(11) =
     +   BLOG2*LOG(MAX(RTOL, YSAV2/MAX(RTOL,(ASYMP - YSAV2))))
         YMAXT(12) = YMAX
         YMAXT(13) = XMAX
         YMAXT(14) = BLOG2*LOG(MAX(RTOL,XMAX))
         YMAXT(15) = BLOG2*LOG(MAX(RTOL,XMAX))
C........now log10
         YMAXT(16) = YMAX
         YMAXT(17) = LOG10(MAX(RTOL,YMAX))
         YMAXT(18) = LOG10(MAX(RTOL,YMAX))
         YMAXT(19) = LOG10(MAX(RTOL, YSAV2/MAX(RTOL,(ASYMP - YSAV2))))
         YMAXT(20) = YMAX
         YMAXT(21) = XMAX
         YMAXT(22) = LOG10(MAX(RTOL,XMAX))
         YMAXT(23) = LOG10(MAX(RTOL,XMAX))

         YMINT(0) = YMIN
         YMINT(1) = XMIN
         IF (YMIN.LT. - RTOL) THEN
            YMINT(2) = ONE/YBIG
         ELSE
            YMINT(2) = ONE/MAX(RTOL,YMAX)
         ENDIF
         YMINT(3) = YMIN
         IF (YMIN.LT. - RTOL) THEN
            YMINT(4) = ONE/YBIG
         ELSE
            YMINT(4) = ONE/MAX(RTOL,YMAX)
         ENDIF
         YMINT(5) = YMIN3
         YMINT(6) = YMIN
         YMINT(7) = YMIN4
         YMINT(8) = YMIN
         YMINT(9) = BLOG2*LOG(YSMALL)
         YMINT(10) = BLOG2*LOG(YSMALL)
         YMINT(11) =
     +   BLOG2*LOG(MAX(RTOL, YSAV1/MAX(RTOL,(ASYMP - YSAV1))))
         YMINT(12) = YMIN
         YMINT(13) = XMIN
         YMINT(14) = BLOG2*LOG(XSMALL)
         YMINT(15) = BLOG2*LOG(XSMALL)
C........now log10
         YMINT(16) = YMIN
         YMINT(17) = LOG10(YSMALL)
         YMINT(18) = LOG10(YSMALL)
         YMINT(19) = LOG10(MAX(RTOL, YSAV1/MAX(RTOL,(ASYMP - YSAV1))))
         YMINT(20) = YMIN
         YMINT(21) = XMIN
         YMINT(22) = LOG10(XSMALL)
         YMINT(23) = LOG10(XSMALL)
C
C Check the ranges
C 
         DO I = 0, 23
            IF (XMAXT(I).LE.XMINT(I)) XMAXT(I) = XMINT(I) + ONE
            IF (YMAXT(I).LE.YMINT(I)) YMAXT(I) = YMINT(I) + ONE
         ENDDO
C
C Set range and tick marks using the DOAXIS$ algorithm except for logs
C
         DO I = 0, 15
            IF (DENDRO_GRAM) THEN
               MXTICT(I) = NPTS - 1
            ELSEIF (I.NE.8 .AND. I.NE.10 .AND. I.NE.11 .AND.
     +              I.NE.12 .AND. I.NE.13 .AND. I.NE.15) THEN
                CALL DOAXIS$(MXTICT(I), NLDIG, 
     +                       XMAXT(I), XMINT(I))
                J = I
                CALL GRFSIG$(KSEND, J, NLDIG, NSIG,
     +                       'X')                                 
            ENDIF
            IF (I.NE.9 .AND. I.NE.10 .AND. I.NE.11 .AND. I.NE.14 .AND.
     +          I.NE.15)
     +          CALL DOAXIS$(MYTICT(I), NLDIG,
     +                       YMAXT(I), YMINT(I))
                J = I
                CALL GRFSIG$(KSEND, J, NLDIG, NSIG,
     +                       'Y')   
         ENDDO
C
C Set ticks where axes are untransformed
C
         MYTICT(16) = MYTICT(8)
         YMAXT(16) = YMAXT(8)
         YMINT(16) = YMINT(8)
         
         MXTICT(17) = MXTICT(9)
         XMAXT(17) = XMAXT(9)
         XMINT(17) = XMINT(9)
         
         MYTICT(20) = MYTICT(12)
         YMAXT(20) = YMAXT(12)
         YMINT(20) = YMINT(12)
         
         MYTICT(21) = MYTICT(13)
         YMAXT(21) = YMAXT(13)
         YMINT(21) = YMINT(13)
         
         MXTICT(22) = MXTICT(14)
         XMAXT(22) = XMAXT(14)
         XMINT(22) = XMINT(14)
C
C Adjust tick marks and extremes for logs/powers-of-ten
C

C
C log2(x)
C
         I = NINT(XMINT(8) - HALF)
         J = NINT(XMAXT(8) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MXTICT(8) = J - I
         XMINT(8) = DBLE(I)
         XMAXT(8) = DBLE(J)
         MXTICT(10) = MXTICT(8)
         XMINT(10) = XMINT(8)
         XMAXT(10) = XMAXT(8)
         MXTICT(11) = MXTICT(8)
         XMINT(11) = XMINT(8)
         XMAXT(11) = XMAXT(8)
         MYTICT(14) = MXTICT(8)
         YMINT(14) = XMINT(8)
         YMAXT(14) = XMAXT(8)
         MYTICT(15) = MXTICT(8)
         YMINT(15) = XMINT(8)
         YMAXT(15) = XMAXT(8)
C
C log10(x)
C
         I = NINT(XMINT(16) - HALF)
         J = NINT(XMAXT(16) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MXTICT(16) = J - I
         XMINT(16) = DBLE(I)
         XMAXT(16) = DBLE(J)
         MXTICT(18) = MXTICT(16)
         XMINT(18) = XMINT(16)
         XMAXT(18) = XMAXT(16)
         MXTICT(19) = MXTICT(16)
         XMINT(19) = XMINT(16)
         XMAXT(19) = XMAXT(16)
         MYTICT(22) = MXTICT(16)
         YMINT(22) = XMINT(16)
         YMAXT(22) = XMAXT(16)
         MYTICT(23) = MXTICT(16)
         YMINT(23) = XMINT(16)
         YMAXT(23) = XMAXT(16)
C
C log2(y)
C
         I = NINT(YMINT(9) - HALF)
         J = NINT(YMAXT(9) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MYTICT(9) = J - I
         YMINT(9) = DBLE(I)
         YMAXT(9) = DBLE(J)
         MYTICT(10) = MYTICT(9)
         YMINT(10) = YMINT(9)
         YMAXT(10) = YMAXT(9)
         MXTICT(13) = MYTICT(9)
         XMINT(13) = YMINT(9)
         XMAXT(13) = YMAXT(9)
         MXTICT(15) = MYTICT(9)
         XMINT(15) = YMINT(9)
         XMAXT(15) = YMAXT(9)
C
C log10(y)
C
         I = NINT(YMINT(17) - HALF)
         J = NINT(YMAXT(17) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MYTICT(17) = J - I
         YMINT(17) = DBLE(I)
         YMAXT(17) = DBLE(J)
         MYTICT(18) = MYTICT(17)
         YMINT(18) = YMINT(17)
         YMAXT(18) = YMAXT(17)
         MXTICT(21) = MYTICT(17)
         XMINT(21) = YMINT(17)
         XMAXT(21) = YMAXT(17)
         MXTICT(23) = MYTICT(17)
         XMINT(23) = YMINT(17)
         XMAXT(23) = YMAXT(17)
C
C log[y/(A-y)] and log10[y/(A-y)]
C
         I = NINT(YMINT(11) - HALF)
         J = NINT(YMAXT(11) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MYTICT(11) = J - I
         YMINT(11) = DBLE(I)
         YMAXT(11) = DBLE(J)

         I = NINT(YMINT(19) - HALF)
         J = NINT(YMAXT(19) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MYTICT(19) = J - I
         YMINT(19) = DBLE(I)
         YMAXT(19) = DBLE(J)
C
C log[1/x] and log10[1/x]
C
         I = NINT(XMINT(12) - HALF)
         J = NINT(XMAXT(12) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MXTICT(12) = J - I
         XMINT(12) = DBLE(I)
         XMAXT(12) = DBLE(J)

         I = NINT(XMINT(20) - HALF)
         J = NINT(XMAXT(20) + HALF)
         IF (I.EQ.J) THEN
            I = I - 1
            J = J + 1
         ENDIF
         MXTICT(20) = J - I
         XMINT(20) = DBLE(I)
         XMAXT(20) = DBLE(J)
C
C Initialise XCOORD_T, YCOORD_T
C
         DO I = 0, 23
            XCOORD_T(I) = XMINT(I)
            YCOORD_T(I) = YMINT(I)
         ENDDO
C
C Further initialisations
C
         KANGLE = 1
         CALL GRFLGL$(JSEND, NLGL,
     +                LGLVAR)
         BOXIT = LGLVAR(1)
         FRAME = LGLVAR(2)
         OFFSET = LGLVAR(3)  
         IF (LGLVAR(7)) THEN
            KTIC = 3
         ELSE
            KTIC = 1
         ENDIF  
         PANEL = LGLVAR(8)
         SIDE = LGLVAR(9)     
         NUMBRX = .TRUE.
         ROTATE = .FALSE.
         IF (BAR_CHART) THEN
            KTIC = 1
            BOXIT = .FALSE.
            CENTRE = .TRUE.
            NUMBRX = .FALSE.
            OFFSET = .TRUE.
            ROTATE = .TRUE.
            KANGLE = 3
         ELSEIF (DENDRO_GRAM) THEN
            KTIC = 1
            BOXIT = .FALSE.
            CENTRE = .TRUE.
            NUMBRX = .FALSE.
            ROTATE = .TRUE.
            KANGLE = 6
            SHOW_XAXIS = .FALSE.
            SHOW_YAXIS = .FALSE.
            PANEL = .FALSE.
            BORDER = .FALSE.
         ELSEIF (PIE_CHART) THEN
            CENTRE = .TRUE.
         ENDIF
C
C Set the defaults for data ranges using IADD8 = 8 for log10/powers-of-ten
C
         DO I = 0, 23
            IF (MXTICT(I).GT.MAXTIC) MXTICT(I) = MAXTIC
            IF (MYTICT(I).GT.MAXTIC) MYTICT(I) = MAXTIC
            IF (MXTICT(I).LT.MINTIC) MXTICT(I) = MINTIC
            IF (MYTICT(I).LT.MINTIC) MYTICT(I) = MINTIC
         ENDDO
         IF (MTRANS.GE.8 .AND. MTRANS.LE.15 .AND. NATLOG(10)) THEN
            IADD8 = 8
         ELSE
            IADD8 = 0
         ENDIF
         MTRAN1 = MTRANS + IADD8
         MXTIC = MXTICT(MTRAN1)
         MYTIC = MYTICT(MTRAN1)
         XMAX = XMAXT(MTRAN1)
         XMIN = XMINT(MTRAN1)
         YMAX = YMAXT(MTRAN1)
         YMIN = YMINT(MTRAN1)
         XCOORD = XMIN
         YCOORD = YMIN
         ZCOORD = XMAX
         IF (TWO_PLOTS) THEN
            CALL EXPAND$ (ZMAX, ZMIN)
            CALL DOAXIS$(MZTIC, NLDIG, 
     +                   ZMAX, ZMIN)
            J = MTRANS
            CALL GRFSIG$(KSEND, J, NLDIG, NSIG,
     +                  'Z')             
         ELSE
            MZTIC = 2
         ENDIF
C
C ISEND = 1: First time, so store all the initialised parameters.
C
         STORE = .TRUE.
         CALL SAVETR$(MTRANS, STORE)
         ISEND = 1
         CALL MENU02$(ISEND, NPRESS,
     +                DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
         CALL MENU04$(ISEND,
     +                KANGLE, KTIC, MXDROP, MXTICT(MTRAN1),
     +                MYTICT(MTRAN1),
     +                MZTIC, NGROUP, NPTS, NWORDS,
     +                XCOORD, XMAX, XMIN, YCOORD, YDROP, YMAX, YMIN,
     +                ZCOORD, ZMAX, ZMIN,
     +                LABELS, LABVEC, WORDX, WORDY,
     +                BAR_CHART,
     +                NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                PLOTX, PLOTY, PLOTZ, ROTATE,
     +                SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS, TWO_PLOTS,
     +                XTOINT, YTOINT, ZTOINT)
         CALL MENU05$(ISEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
     +                ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
     +                EXTEND_LINES, FRAME, GRATICULE, OFFSET, PIE_CHART,
     +                PLOT_TITLE, SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                THREE_D, TWO_PLOTS, XGRID, YGRID)
         CALL MENU06$(ISEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                FACTOR, SIZE, WIDE, FSAV, FSAV1,
     +                LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
     +                BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                VECTOR_FIELD)
         CALL MENU07$(IFILL, IHUE, ISEND, ISHAPE, KPANEL, NFILES,
     +                NPTS, NXTRA,
     +                FSAV1(1), PLINE, PSYMB,
     +                BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
         CALL MENU10$(NGRAFS, NKCOL, ISEND, JCOLOR, KCOLOR, LCOLOR,
     +                NFILES, FSAV, MONO, VIDEO)
         CALL MENU11$(ISEND, MTRANS, NLOG,
     +                ASYMP, ASAV, YMAXT, YMINT, YSAV1,
     +                YSAV2, RTOL, NATLOG, POWERX, POWERY, POWERZ)
      ELSE
C
C=======================================================================
C After FIRST call enter here ... Normal entry when not first time round
C=======================================================================
C
         STORE = .FALSE.
         CALL SAVETR$(MTRANS, STORE)
         LPREV_1 = LPREV
         ASAV_1 = ASAV
         YSAV1_1 = YSAV1
         YSAV2_1 = YSAV2
         DO I = 0, 23
            MXTICT_1(I) = MXTICT(I)
            MYTICT_1(I) = MYTICT(I)
            XCOORD_1(I) = XCOORD_T(I)
            XMAXT_1(I) = XMAXT(I)
            XMINT_1(I) = XMINT(I)
            YCOORD_1(I) = YCOORD_T(I)
            YMAXT_1(I) = YMAXT(I)
            YMINT_1(I) = YMINT(I)
         ENDDO
         CALL STYGKS$(IFILL, IHUE, ISHAPE, JCOLOR,
     +                KANGLE, KCOLOR, KPANEL, KTIC,
     +                L, LCOLOR, LPREV_1, M, MTRANS, MXDROP, MXTIC,
     +                MXTICT_1, MYTIC, MYTICT_1, MZTIC,
     +                NCLIP, NFILES, NGRAFS, NGROUP, NIN,
     +                NKCOL, NLOG, NPRESS, NPTS, NSAV, NWORDS, NXTRA,
     +                ASAV_1, ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                FACTOR, RTOL, SIZE, THICK, WIDE,
     +                XCLIP, XCOORD, XCOORD_1, XMAX, XMAXT_1, XMIN,
     +                XMINT_1,
     +                YCLIP, YCOORD, YCOORD_1, YDROP, YMAX, YMAXT_1,
     +                YMAX3,
     +                YMAX4, YMIN, YMINT_1, YMIN3, YMIN4, YSAV1_1,
     +                YSAV2_1,
     +                ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                FSAV, FSAV1, LABELS, LABVEC, PLINE,
     +                PSYMB, PTITLE, QTITLE, TSAV, WORDX, WORDY,
     +                XTITLE, YTITLE, ZTITLE,
     +                ABORT, BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +                CENTRE, DENDRO_GRAM, EXTEND_LINES, FRAME,
     +                GRATICULE, LOWER, MONO, NATLOG, NUMBRX, OFFSET,
     +                PANEL, PCENTX, PCENTY, PCENTZ,
     +                PHIGHX, PHIGHY, PHIGHZ,
     +                PIE_CHART, PLOT_LABELS, PLOT_TITLE, PLOTX, PLOTY,
     +                PLOTZ, POWERX, POWERY, POWERZ, ROTATE,
     +                SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +                SHOW_YAXIS, SHOW_ZAXIS, SIDE, SWAP_YZ, THREE_D,
     +                TWO_PLOTS, UPPER, XDIL, XDIV, XGRID, XLOG, XTOINT,
     +                VECTOR_FIELD, VIDEO, YAXIS,
     +                YDIV, YGRID, YLOG, YTOINT,
     +                ZTOINT)
         LPREV = LPREV_1
         DO I = 0, 23
            MXTICT(I) = MXTICT_1(I)
            MYTICT(I) = MYTICT_1(I)
            XCOORD_T(I) = XCOORD_1(I)
            XMAXT(I) = XMAXT_1(I)
            XMINT(I) = XMINT_1(I)
            YCOORD_T(I) = YCOORD_1(I)
            YMAXT(I) = YMAXT_1(I)
            YMINT(I) = YMINT_1(I)
         ENDDO
         IF (XCOORD.LT.XMIN .OR. XCOORD.GT.XMAX) XCOORD = XMIN
         IF (YCOORD.LT.YMIN .OR. YCOORD.GT.YMAX) YCOORD = YMIN
         IF (ZCOORD.LT.XMIN .OR. ZCOORD.GT.XMAX) ZCOORD = XMAX
      ENDIF
      END
C
C
