C
C
      SUBROUTINE GKSSYM$(J, K, L, M, N,
     +                   A, C, SIZE, WIDE, X, XMAX, XMIN, Y)
C
C ACTION : FILL IN PART HOLLOW SYMBOLS WITH BACKGROUND THEN RE-DRAW
C          J = COLOUR, K = ARGUMENT TO GSELNT, L = BACKGROUND COLOUR, M(ARKER)
C          marker type:- 1=dot,2=+,3=x,4=*,
C          5=circle,6=half-filled circle,7=filled circle
C          8=triangle,9=half-filled triangle,10=filled triangle
C          11=square,12=half-filled square,13=filled square
C          14=diamond,15=half-filled diamond,16=filled diamond
C          17=minus,18=male,19=female
C          20-29 bar chart symbols
C          30=circle(outline),31=triangle(outline)
C          32=square(outline),33=diamond(outline) 
C          34=u_triangle,35=u_triangle(half filled), 36=u_triangle(filled), 37=u_triangle(outline) 
C                   ... argument is M
C          ******************
C          WARNING ... ADJUST MUST AGREE WITH ADJUST IN GKSBAR
C          *******************
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 2/2/92
C          08/10/1992 TESTS ON N BEFORE CALL TO GPL
C          12/10/1992 REMOVED MONO
C          28/11/1992 DERIVED FROM GKSPIC
C          04/12/1992 ADDED CODE TO LEAVE SPACES WHEN JOINING MARKERS
C          23/04/1993 DERIVED FROM GKSWGB
C          06/05/1993 Removed L, B, D
C          03/11/1993 Simplified using ISEND and WGB_DFILL, EFILL, SFILL, TFILL
C          03/10/1995 Added minus signs
C          23/02/1997 Edited
C          13/04/2007 Added INTENTS 
C          15/06/2007 removed defngks.ins and added GETGKS_LGL  
C          16/08/2008 added symbols 30 to 33
C          28/08/2008 increased NPTS from 25 to 100 
C          20/06/2011 added upside_down triangles
C          16/06/2019 calls SVGPAR to adjust HEIGHT and RADIUS dimensions of symbols
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: J, K, L, M, N
      DOUBLE PRECISION, INTENT (IN) :: A, C, SIZE, WIDE, X(N), XMAX,
     +                                 XMIN, Y(N)
C
C Locals
C      
      INTEGER    NPTS, N0, N1, N6
      PARAMETER (NPTS = 100, N0 = 0, N1 = 1, N6 = 6)
      INTEGER    I, ISEND, JSEND
      DOUBLE PRECISION ADJUST, FACTOR, TWO, THREE
      PARAMETER (ADJUST = 0.012D+00, FACTOR = 1.2D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00)
      DOUBLE PRECISION FR, HEIGHT, RADIUS, TR, TRIANG, XSHIFT, YDROP,
     +                 YSHIFT
      DOUBLE PRECISION X_SVG, Y_SVG
      DOUBLE PRECISION XDELTA, XTEMP(NPTS), YTEMP(NPTS)
      DOUBLE PRECISION X1, X2, Y1, Y2
      LOGICAL    ACTIVE_SVG
      LOGICAL    PS 
      EXTERNAL   GSELNT$, WGB_PLUS$, WGB_CROSS$, WGB_EFILL$,
     +           WGB_TFILL$, WGB_SFILL$, WGB_DFILL$, GSLN$, GSLWSC$,
     +           WGB_MINUS$, LINE$, PSLINE$, WGB_UFILL$
      EXTERNAL   PSSYMB$, SVGPAR   
      EXTERNAL   GETGKS_LGL
      INTRINSIC  SQRT
      IF (N.LT.N1) RETURN
      CALL GSELNT$(K)
      CALL GSLN$(N1)
      CALL GSLWSC$(WIDE)
C
C Marker is required so define height and radius in
C mathmatical space and use A, C to map into physical space
C
      XDELTA = XMAX - XMIN
      RADIUS = ADJUST*SIZE*XDELTA
      HEIGHT = RADIUS*A/C
      CALL SVGPAR (N0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG) 
      IF (ACTIVE_SVG) THEN
         HEIGHT = HEIGHT/X_SVG
         RADIUS = RADIUS/X_SVG
      ENDIF   
      TRIANG = TWO/SQRT(THREE)
      FR = FACTOR*RADIUS
      TR = TRIANG*RADIUS
      XSHIFT = 1.75D+00*RADIUS
      YDROP = 1.75D+00*HEIGHT
      YSHIFT = 1.75D+00*HEIGHT
C
C Main loop, triangles made equilateral using TRIANG
C                          
      CALL GETGKS_LGL (N6,
     +                 PS) 
      IF (PS) THEN
         DO I = 1, N
            XTEMP(1) = X(I)
            XTEMP(2) = X(I) + RADIUS
            YTEMP(1) = Y(I)
            YTEMP(2) = Y(I)
            IF (M.EQ.8 .OR. M.EQ.9 .OR. M.EQ.10) THEN
               XTEMP(2) = X(I) + TR
            ELSEIF (M.EQ.14 .OR. M.EQ.15 .OR. M.EQ.16) THEN
               XTEMP(2) = X(I) + FR
            ENDIF
            ISEND = 2
            IF (M.EQ.18) THEN
               X2 = X(I)
               X1 = X2 + XSHIFT
               Y2 = Y(I)
               Y1 = Y2 + YSHIFT
               CALL PSLINE$(J, X1, Y1, X2, Y2)
               X2 = X1 - RADIUS
               Y2 = Y1
               CALL PSLINE$(J, X1, Y1, X2, Y2)
               X2 = X1
               Y2 = Y1 - HEIGHT
               CALL PSLINE$(J, X1, Y1, X2, Y2)
               JSEND = 5
               CALL PSSYMB$(J, JSEND, ISEND, XTEMP, YTEMP)
            ELSEIF (M.EQ.19) THEN
               YTEMP(1) = Y(I) - YDROP
               YTEMP(2) = Y(I)
               JSEND = 2
               CALL PSSYMB$(J, JSEND, ISEND, XTEMP, YTEMP)
               YTEMP(1) = Y(I)
               YTEMP(2) = Y(I)
               JSEND = 5
               CALL PSSYMB$(J, JSEND, ISEND, XTEMP, YTEMP)
            ELSE
               CALL PSSYMB$(J, M, ISEND, XTEMP, YTEMP)
            ENDIF
         ENDDO
      ELSE
         DO I = N1, N
            IF (M.EQ.1) THEN
               ISEND = 3
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.2) THEN
               CALL WGB_PLUS$(X(I), RADIUS, Y(I), HEIGHT, J)
            ELSEIF (M.EQ.3) THEN
               CALL WGB_CROSS$(X(I), RADIUS, Y(I), HEIGHT, J)
            ELSEIF (M.EQ.4) THEN
               CALL WGB_CROSS$(X(I), RADIUS, Y(I), HEIGHT, J)
               CALL WGB_PLUS$(X(I), RADIUS, Y(I), HEIGHT, J)
            ELSEIF (M.EQ.5) THEN
               ISEND = 1
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.6) THEN
               ISEND = 2
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.7) THEN
               ISEND = 3
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.8) THEN
               ISEND = 1
               CALL WGB_TFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.9) THEN
               ISEND = 2
               CALL WGB_TFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.10) THEN
               ISEND = 3
               CALL WGB_TFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.11) THEN
               ISEND = 1
               CALL WGB_SFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.12) THEN
               ISEND = 2
               CALL WGB_SFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.13) THEN
               ISEND = 3
               CALL WGB_SFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.14) THEN
               ISEND = 1
               CALL WGB_DFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.15) THEN
               ISEND = 2
               CALL WGB_DFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.16) THEN
               ISEND = 3
               CALL WGB_DFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.17) THEN
               CALL WGB_MINUS$(X(I), RADIUS, Y(I), J)
            ELSEIF (M.EQ.18) THEN
               X2 = X(I)
               X1 = X2 + XSHIFT
               Y2 = Y(I)
               Y1 = Y2 + YSHIFT
               CALL LINE$(X1, Y1, X2, Y2, J)
               X2 = X1 - RADIUS
               Y2 = Y1
               CALL LINE$(X1, Y1, X2, Y2, J)
               X2 = X1
               Y2 = Y1 - HEIGHT
               CALL LINE$(X1, Y1, X2, Y2, J)
               ISEND = 1
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.19) THEN
               X1 = X(I)
               Y1 = Y(I) - YDROP
               CALL WGB_PLUS$(X1, RADIUS, Y1, HEIGHT, J)
               ISEND = 1
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)
            ELSEIF (M.EQ.30) THEN
               ISEND = 4
               CALL WGB_EFILL$(ISEND, L, NPTS, RADIUS, HEIGHT, X(I),
     +                         XTEMP, Y(I), YTEMP, J)            
            ELSEIF (M.EQ.31) THEN
               ISEND = 4
               CALL WGB_TFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)            
            ELSEIF (M.EQ.32) THEN
               ISEND = 4
               CALL WGB_SFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J)            
            ELSEIF (M.EQ.33) THEN
               ISEND = 4
               CALL WGB_DFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, X(I),
     +                         XTEMP, Y(I), YTEMP, J) 
            ELSEIF (M.EQ.34) THEN
               ISEND = 1
               CALL WGB_UFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)    
            ELSEIF (M.EQ.35) THEN
               ISEND = 2
               CALL WGB_UFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)    
            ELSEIF (M.EQ.36) THEN
               ISEND = 3
               CALL WGB_UFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)    
            ELSEIF (M.EQ.37) THEN
               ISEND = 4
               CALL WGB_UFILL$(ISEND, L, NPTS, HEIGHT, RADIUS, TRIANG,
     +                         X(I), XTEMP, Y(I), YTEMP, J)               
            ENDIF
         ENDDO
      ENDIF
      END
C
C
