C
C GKST04
C ======
C
C See the description of gks004
C
      SUBROUTINE GKST04 ( L1,  L2,  L3,  L4,
     +                    M1,  M2,  M3,  M4,
     +                   N1D, N2D, N3D, N4D,
     +                   A, X1D, X2D, X3D, X4D, 
     +                      Y1D, Y2D, Y3D, Y4D,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   AXES, SAVEIT)
C
C ACTION : SUPPLY  NI, A, XI, YI, THEN PLOT TRANSFORMS AS SELECTED
C          HILL PLOT IS NOT DONE IF A =< 0
C ADVICE : XI, YI ARE RETURNED UNCHANGED IN THIS VERSION WHETHER PLOTTED OR NOT
C          SO THE ROUTINE CAN BE CALLED WITH XI = XJ OR YI = YJ
C          UNPLOTTED DATA IS NOT TRANSFORMED AT ALL IN THIS VERSION
C AUTHOR : W. G. BARDSLEY, 13/12/91
C          06/04/1993 Derived from GKST03
C          11/04/1993 Added NPLOTS
C          28/05/1993 Added AXES
C          12/10/1993 DOUBLE PRECISION
C          26/03/1994 NDEC = 1 1st time but then NDEC = 10 for each return to 20
C          14/11/1997 Altered menu to allow tabbing in lbox01
C          15/12/1997 Altered dimensions to (*)
C          07/03/1999 extensive revision to avoid reversing the transformations
C                     and to allow extrapolation
C          09/09/1999 replaced lbox01 by tbox01 for tabbing
C          29/01/2000 added y against log(1/x)
C          12/03/2001 added AXES_1 and GSAVE_1
C          28/06/2006 introduced allocatable workspaces 
C          19/04/2007 added INTENTS
C          20/11/2013 introduced YSIZE to improve the test criterion for linearity 
C          08/01/2016 added ICOUNT to prevent crash when calling DOAXIS$
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: L1, L2, L3, L4,
     +                                    M1, M2, M3, M4, 
     +                                    N1D, N2D, N3D, N4D
      DOUBLE PRECISION,    INTENT (IN) :: A
      DOUBLE PRECISION,    INTENT (IN) :: X1D(*), X2D(*), X3D(*), X4D(*)
      DOUBLE PRECISION,    INTENT (IN) :: Y1D(*), Y2D(*), Y3D(*), Y4D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE 
      LOGICAL,             INTENT (IN) :: AXES, SAVEIT
C
C Local allocatable arrays
C     
      DOUBLE PRECISION, ALLOCATABLE :: X1(:), X2(:), X3(:), X4(:)
      DOUBLE PRECISION, ALLOCATABLE :: Y1(:), Y2(:), Y3(:), Y4(:) 
C
C Locals
C      
      INTEGER    N1, N2, N3, N4
      INTEGER    I, IERR, J, K, NPLOTS
      INTEGER    ICOLOR, IXL, IYL, K0, K1
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, K0 = 0, K1 = 1)
      INTEGER    LSHADE, NUMOPT
      PARAMETER (LSHADE = 1, NUMOPT = 11)
      INTEGER    NDEC
      INTEGER    KUMDEC, KUMOPT, KSTART, KTEXT
      PARAMETER (KUMDEC = 1, KUMOPT = 4, KSTART = 3, KTEXT = 6)
      INTEGER    KUMBLD(KTEXT), KUMPOS(KUMOPT)
      INTEGER    ICOUNT
      DOUBLE PRECISION ABSXI, ABSYI, TEMP, XTEMP, XTRAN, YTEMP, YTRAN
      DOUBLE PRECISION CONST, SLOPE, XDIFF, YDIFF, YSIZE
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EPSI, RTOL
      PARAMETER (EPSI = 1.0D-4, RTOL = 1.0D-200)
      CHARACTER  PLABEL*24, XLABEL*10, YLABEL*14
      CHARACTER  CIPHER(4)*21, TEXT(30)*100
      LOGICAL    ABORT, PLOT, PLOT1, PLOT2, PLOT3, PLOT4
      LOGICAL    AXES_1, SAVEIT_1, TITLES
      PARAMETER (AXES_1 = .TRUE., SAVEIT_1 = .FALSE., TITLES = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GKS004, PUTFAT$, RBOX01, LVIEW2
      INTRINSIC  ABS, LOG10, MAX
      DATA KUMBLD / 1, 1, -1, -1, -1, -1 /
      DATA KUMPOS / KUMOPT* 0 /
C
C Initialise and check if graph can be created
C     
      N1 = MAX(N1D,K0)
      N2 = MAX(N2D,K0)
      N3 = MAX(N3D,K0)
      N4 = MAX(N4D,K0)
      IF (N1 + N2 + N3 + N4 .EQ. K0) THEN
         RETURN
      ELSE 
         IERR = K0
         IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
         IF (IERR.NE.K0) RETURN
      ENDIF     
      NPLOTS = K0
      PLOT1 = .FALSE.
      PLOT2 = .FALSE.
      PLOT3 = .FALSE.
      PLOT4 = .FALSE.
      CIPHER(1) = 'Component 1 absent'
      CIPHER(2) = 'Component 2 absent'
      CIPHER(3) = 'Component 3 absent'
      CIPHER(4) = 'Component 4 absent'
      ICOUNT = K0
      IF (N1.GT.K0 .AND. (L1.GT.K0 .OR. M1.GT.K0)) THEN 
         ICOUNT = ICOUNT + K1
         ALLOCATE(X1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y1(N1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT1 = .TRUE.
         IF (L1.GT.K0 .AND. M1.LE.K0) THEN
            CIPHER(1) = 'Component 1 (line ?)'
         ELSE
            CIPHER(1) = 'Component 1 (symbols)'
         ENDIF   
      ELSE 
         ALLOCATE(X1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y1(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN  
      ENDIF
      IF (N2.GT.K0 .AND. (L2.GT.K0 .OR. M2.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y2(N2), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         NPLOTS = NPLOTS + K1
         PLOT2 = .TRUE.
         IF (L2.GT.K0 .AND. M2.LE.K0) THEN
            CIPHER(2) = 'Component 2 (line ?)'
         ELSE
            CIPHER(2) = 'Component 2 (symbols)'
         ENDIF
      ELSE
         ALLOCATE(X2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y2(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
      ENDIF
      IF (N3.GT.K0 .AND. (L3.GT.K0 .OR. M3.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y3(N3), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT3 = .TRUE.
         IF (L3.GT.K0 .AND. M3.LE.K0) THEN
            CIPHER(3) = 'Component 3 (line ?)'
         ELSE
            CIPHER(3) = 'Component 3 (symbols)'
         ENDIF  
      ELSE
         ALLOCATE(X3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y3(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (N4.GT.K0 .AND. (L4.GT.K0 .OR. M4.GT.K0)) THEN
         ICOUNT = ICOUNT + K1
         ALLOCATE(X4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y4(N4), STAT = IERR)
         IF (IERR.NE.K0) RETURN   
         NPLOTS = NPLOTS + K1
         PLOT4 = .TRUE.
         IF (L4.GT.K0 .AND. M4.LE.K0) THEN
            CIPHER(4) = 'Component 4 (line ?)'
         ELSE
            CIPHER(4) = 'Component 4 (symbols)'
         ENDIF
      ELSE 
         ALLOCATE(X4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE(Y4(K1), STAT = IERR)
         IF (IERR.NE.K0) RETURN      
      ENDIF
      IF (ICOUNT.EQ.K0) GOTO 80
C
C Choose action required: note that NDEC goes to NDEC - 1
C
      NDEC = K1
   20 CONTINUE
      ABORT = .FALSE.
      WRITE (TEXT,100)
      CALL LVIEW2 (IXL, IYL, NDEC, NUMOPT,
     +             TEXT, 
     +             TITLES)
      NDEC = NDEC - 1
C
C If NDEC = 0 plot then return to 20: otherwise set plot labels
C
      IF (NDEC.EQ.0) THEN
         CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4,
     +                X1D, X2D, X3D, X4D, Y1D, Y2D, Y3D, Y4D,
     +                PTITLE, XTITLE, YTITLE, 
     +                AXES, SAVEIT)
         NDEC = NUMOPT
         GOTO 20
      ELSEIF (NDEC.EQ.1) THEN
         PLABEL = 'Lineweaver-Burk Plot'
         XLABEL = '  1/x'
         YLABEL = '     1/y'
      ELSEIF (NDEC.EQ.2) THEN
         PLABEL = '    Scatchard Plot'
         XLABEL = '   y'
         YLABEL = '     y/x'
      ELSEIF (NDEC.EQ.3) THEN
         PLABEL = ' Eadie-Hofstee Plot'
         XLABEL = '  y/x'
         YLABEL = '      y'
      ELSEIF (NDEC.EQ.4) THEN
         PLABEL = '     Hanes Plot'
         XLABEL = '   x'
         YLABEL = '     x/y'
      ELSEIF (NDEC.EQ.5) THEN
         PLABEL = '     X-semilog Plot'
         XLABEL = ' log10[x]'
         YLABEL = '     y'
      ELSEIF (NDEC.EQ.6) THEN
         PLABEL = '     Y-semilog Plot'
         XLABEL = '   x'
         YLABEL = '   log10[y]'
      ELSEIF (NDEC.EQ.7) THEN
         PLABEL = '      log-log Plot'
         XLABEL = 'log10[x]'
         YLABEL = ' log10[y]'
      ELSEIF (NDEC.EQ.8) THEN
         IF (A.LE.RTOL) THEN
            CALL PUTFAT$('Plot does not make sense ... No Hill Plot')
            NDEC = NUMOPT
            GOTO 20
         ENDIF
         WRITE (PLABEL,200) A
         XLABEL = 'log10[x]'
         YLABEL = 'log10[y/(A-y)]'
      ELSEIF (NDEC.EQ.9) THEN
         PLABEL = '    X-Dilution Plot'
         YLABEL = '    y'
         XLABEL = 'log10[1/x]'
      ELSE
         GOTO 80
      ENDIF
C
C Check to see if required transformation is possible
C
      DO J = 1, 4
         IF (J.EQ.1) THEN
            PLOT = PLOT1
            K = N1
         ELSEIF (J.EQ.2) THEN
            PLOT = PLOT2
            K = N2
         ELSEIF (J.EQ.3) THEN
            PLOT = PLOT3
            K = N3
         ELSEIF (J.EQ.4) THEN
            PLOT = PLOT4
            K = N4
         ENDIF
         IF (PLOT) THEN
            DO I = 1, K
               IF (J.EQ.1) THEN
                  XTEMP = X1D(I)
                  YTEMP = Y1D(I)
               ELSEIF (J.EQ.2) THEN
                  XTEMP = X2D(I)
                  YTEMP = Y2D(I)
               ELSEIF (J.EQ.3) THEN
                  XTEMP = X3D(I)
                  YTEMP = Y3D(I)
               ELSEIF (J.EQ.4) THEN
                  XTEMP = X4D(I)
                  YTEMP = Y4D(I)
               ENDIF
               ABSXI = ABS(XTEMP)
               ABSYI = ABS(YTEMP)
C
C Both x and y must be nonzero to transform 1 to 4 reversibly
C
               IF (NDEC.LE.4) THEN
                  IF (ABSXI.LE.RTOL .OR. ABSYI.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.5) THEN
                  IF (XTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.6) THEN
                  IF (YTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.7) THEN
                  IF (XTEMP.LE.RTOL .OR. YTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.8) THEN
                  TEMP = A - YTEMP
                  IF (TEMP.GT.RTOL) THEN
                     TEMP = YTEMP/TEMP
                     IF (TEMP.LT.RTOL .OR. XTEMP.LT.RTOL) THEN
                        ABORT = .TRUE.
                     ENDIF
                  ELSE
                     ABORT = .TRUE.
                  ENDIF
               ELSEIF (NDEC.EQ.9) THEN
                  IF (XTEMP.LE.RTOL) ABORT = .TRUE.
               ENDIF
               IF (ABORT) GOTO 60
            ENDDO
         ENDIF
      ENDDO
C
C Return if plot is not possible
C
   60 CONTINUE
      IF (ABORT) THEN
         CALL PUTFAT$('Value too small ... Plot not possible')
         NDEC = NUMOPT
         GOTO 20
      ENDIF
C
C Now do the transforms
C
      DO J = 1, 4
         IF (J.EQ.1) THEN
            PLOT = PLOT1
            K = N1
         ELSEIF (J.EQ.2) THEN
            PLOT = PLOT2
            K = N2
         ELSEIF (J.EQ.3) THEN
            PLOT = PLOT3
            K = N3
         ELSEIF (J.EQ.4) THEN
            PLOT = PLOT4
            K = N4
         ENDIF
         IF (PLOT) THEN
            DO I = 1, K
               IF (J.EQ.1) THEN
                  XTEMP = X1D(I)
                  YTEMP = Y1D(I)
               ELSEIF (J.EQ.2) THEN
                  XTEMP = X2D(I)
                  YTEMP = Y2D(I)
               ELSEIF (J.EQ.3) THEN
                  XTEMP = X3D(I)
                  YTEMP = Y3D(I)
               ELSEIF (J.EQ.4) THEN
                  XTEMP = X4D(I)
                  YTEMP = Y4D(I)
               ENDIF
               IF (NDEC.EQ.1) THEN
                  XTRAN = ONE/XTEMP
                  YTRAN = ONE/YTEMP
               ELSEIF (NDEC.EQ.2) THEN
                  XTRAN = YTEMP
                  YTRAN = YTEMP/XTEMP
               ELSEIF (NDEC.EQ.3) THEN
                  XTRAN = YTEMP/XTEMP
                  YTRAN = YTEMP
               ELSEIF (NDEC.EQ.4) THEN
                  XTRAN = XTEMP
                  YTRAN = XTEMP/YTEMP
               ELSEIF (NDEC.EQ.5) THEN
                  XTRAN = LOG10(XTEMP)
                  YTRAN = YTEMP
               ELSEIF (NDEC.EQ.6) THEN
                  XTRAN = XTEMP
                  YTRAN = LOG10(YTEMP)
               ELSEIF (NDEC.EQ.7) THEN
                  XTRAN = LOG10(XTEMP)
                  YTRAN = LOG10(YTEMP)
               ELSEIF (NDEC.EQ.8) THEN
                  TEMP = YTEMP/(A - YTEMP)
                  XTRAN = LOG10(XTEMP)
                  YTRAN = LOG10(TEMP)
               ELSEIF (NDEC.EQ.9) THEN
                  XTRAN = LOG10(ONE/XTEMP)
                  YTRAN = YTEMP
               ENDIF
               IF (J.EQ.1) THEN
                  X1(I) = XTRAN
                  Y1(I) = YTRAN
               ELSEIF (J.EQ.2) THEN
                  X2(I) = XTRAN
                  Y2(I) = YTRAN
               ELSEIF (J.EQ.3) THEN
                  X3(I) = XTRAN
                  Y3(I) = YTRAN
               ELSEIF (J.EQ.4) THEN
                  X4(I) = XTRAN
                  Y4(I) = YTRAN
               ENDIF
            ENDDO
         ENDIF
      ENDDO
C
C Extrapolate if requested
C
      IF (NDEC.EQ.1) THEN
         DO I = 1, 4
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 4)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(1) - X1(N1)
            YDIFF = Y1(1) - Y1(N1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(N1) = - CONST/SLOPE
                  Y1(N1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(1) - X2(N2)
            YDIFF = Y2(1) - Y2(N2)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(N2) = - CONST/SLOPE
                  Y2(N2) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(1) - X3(N3)
            YDIFF = Y3(1) - Y3(N3)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(N3) = - CONST/SLOPE
                  Y3(N3) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(1) - X4(N4)
            YDIFF = Y4(1) - Y4(N4)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(N4) = - CONST/SLOPE
                  Y4(N4) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (NDEC.EQ.2) THEN
         DO I = 1, 4
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 4)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(N1) - X1(1)
            YDIFF = Y1(N1) - Y1(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(1) = ZERO
                  Y1(1) = CONST
                  X1(N1) = - CONST/SLOPE
                  Y1(N1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(N2) - X2(1)
            YDIFF = Y2(N2) - Y2(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(1) = ZERO
                  Y2(1) = CONST
                  X2(N2) = - CONST/SLOPE
                  Y2(N2) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(N3) - X3(1)
            YDIFF = Y3(N3) - Y3(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(1) = ZERO
                  Y3(1) = CONST
                  X3(N3) = - CONST/SLOPE
                  Y3(N3) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(N4) - X4(1)
            YDIFF = Y4(N4) - Y4(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(1) = ZERO
                  Y4(1) = CONST
                  X4(N4) = - CONST/SLOPE
                  Y4(N4) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (NDEC.EQ.3) THEN
         DO I = 1, 4
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 4)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(1) - X1(N1)
            YDIFF = Y1(1) - Y1(N1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(N1) = ZERO
                  Y1(N1) = CONST
                  X1(1) = - CONST/SLOPE
                  Y1(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(1) - X2(N2)
            YDIFF = Y2(1) - Y2(N2)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(N2) = ZERO
                  Y2(N2) = CONST
                  X2(1) = - CONST/SLOPE
                  Y2(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(1) - X3(N3)
            YDIFF = Y3(1) - Y3(N3)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(N3) = ZERO
                  Y3(N3) = CONST
                  X3(1) = - CONST/SLOPE
                  Y3(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(1) - X4(N4)
            YDIFF = Y4(1) - Y4(N4)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(N4) = ZERO
                  Y4(N4) = CONST
                  X4(1) = - CONST/SLOPE
                  Y4(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ENDIF
C
C Plot the transforms
C
      CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4,
     +             X1, X2, X3, X4, Y1, Y2, Y3, Y4,
     +             PLABEL, XLABEL, YLABEL, 
     +             AXES_1, SAVEIT_1)
      NDEC = NUMOPT
      GOTO 20
C
C Finally close down the plot
C
   80 CONTINUE              
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     + 'Name of the Transformation`x-axis  `y-axis'
     +/'Original plot axes        `x       `y'
     +/'Lineweaver-Burk           `1/x     `1/y'
     +/'Scatchard                 `y       `y/x'
     +/'Eadie-Hofstee             `y/x     `y'
     +/'Hanes                     `x       `x/y'
     +/'x-semilog                 `log[x]  `y'
     +/'y-semilog                 `x       `log[y]'
     +/'log-log                   `log[x]  `log[y]'
     +/'Hill                      `log[x]  `log[y/(A - y)]'
     +/'Dilution curve            `log[1/x]`y'
     +/'Cancel this plot          `...     `...'
     +/'log[.] is base 10'
     +/'Save ASCII files for SIMPLOT (as x and y)'
     +/'Dilution curves are as 1, 1:10, 1:100, etc.'
     +/'Hill plot A is y(x = infinity), and this'
     +/'plot is only done for saturation functions.')
  200 FORMAT ('Hill Plot, A =',1P,E10.3)
  300 FORMAT (
     + 'Select components for linear extrapolation'
     +/'...'
     +/A
     +/A
     +/A
     +/A)
      END
C
C
