C
C GKST12
C ======
C
C Read the introduction to gks004
C
      SUBROUTINE GKST12 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11,
     +                   L12,
     +                   M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11,
     +                   M12,
     +                   N1D, N2D, N3D, N4D, N5D, N6D, N7D, N8D, N9D,
     +                   N10D, N11D, N12D,
     +                   A,
     +                   X1D, X2D, X3D, X4D, X5D, X6D, X7D, X8D, X9D,
     +                   X10D, X11D, X12D,
     +                   Y1D, Y2D, Y3D, Y4D, Y5D, Y6D, Y7D, Y8D, Y9D,
     +                   Y10D, Y11D, Y12D,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, SAVEIT)
C
C ACTION : SUPPLY  NI, A, XID, YID, THEN PLOT TRANSFORMS AS SELECTED
C          HILL PLOT IS NOT DONE IF A =< 0
C ADVICE : XID, YID ARE RETURNED UNCHANGED IN THIS VERSION WHETHER PLOTTED OR NOT
C          SO THE ROUTINE CAN BE CALLED WITH XID = XJD OR YID = YJD, 1 =< I, J =< 12
C          UNPLOTTED DATA IS NOT TRANSFORMED AT ALL IN THIS VERSION
C AUTHOR : W. G. Bardsley, 30/08/2000 ... derived from GKST04     
C          29/06/2006 introduced allocatable arrays, I1FILE and I2FILE
c          20/11/2013 corrected error using only cipher(1) to (4) instead of (1) to (12)
C                     and introduced YSIZE to improve the test criterion for linearity 
C
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,              INTENT (IN) ::
     +L1,  L2,  L3,  L4,  L5,  L6,  L7,  L8,  L9,  L10,  L11,  L12,
     +M1,  M2,  M3,  M4,  M5,  M6,  M7,  M8,  M9,  M10,  M11,  M12,
     +N1D, N2D, N3D, N4D, N5D, N6D, N7D, N8D, N9D, N10D, N11D, N12D 
      DOUBLE PRECISION,     INTENT (IN) :: A
      DOUBLE PRECISION,     INTENT (IN) ::
     +X1D(*), X2D(*), X3D(*), X4D(*),  X5D(*),  X6D(*),
     +X7D(*), X8D(*), X9D(*), X10D(*), X11D(*), X12D(*)
      DOUBLE PRECISION,    INTENT (IN) ::
     +Y1D(*), Y2D(*), Y3D(*), Y4D(*),  Y5D(*),  Y6D(*),
     +Y7D(*), Y8D(*), Y9D(*), Y10D(*), Y11D(*), Y12D(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL,             INTENT (IN) :: AXES, SAVEIT
C
C Local allocatable arrays
C                          
      DOUBLE PRECISION, ALLOCATABLE ::
     +X1(:), X2(:), X3(:), X4(:),  X5(:),  X6(:),
     +X7(:), X8(:), X9(:), X10(:), X11(:), X12(:)
      DOUBLE PRECISION, ALLOCATABLE ::
     +Y1(:), Y2(:), Y3(:), Y4(:),  Y5(:),  Y6(:),
     +Y7(:), Y8(:), Y9(:), Y10(:), Y11(:), Y12(:)
C
C Locals
C     
      INTEGER    N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      INTEGER    I, IERR, J, K, NPLOTS, NTEMP
      INTEGER    ICOLOR, IXL, IYL, K0, K1
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, K0 = 0, K1 = 1)
      INTEGER    LSHADE, NUMOPT
      PARAMETER (LSHADE = 1, NUMOPT = 11)
      INTEGER    NDEC
      INTEGER    KUMDEC, KUMOPT, KSTART, KTEXT
      PARAMETER (KUMDEC = 1, KUMOPT = 12, KSTART = 3, KTEXT = 14)
      INTEGER    KUMBLD(KTEXT), KUMPOS(KUMOPT)
      DOUBLE PRECISION ABSXI, ABSYI, TEMP, XTEMP, XTRAN, YTEMP, YTRAN
      DOUBLE PRECISION CONST, SLOPE, XDIFF, YDIFF, YSIZE
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EPSI, RTOL
      PARAMETER (EPSI = 1.0D-4, RTOL = 1.0D-200)
      CHARACTER  PLABEL*24, XLABEL*10, YLABEL*14
      CHARACTER  CIPHER(12)*22, TEXT(30)*100
      LOGICAL    AXES_1, SAVEIT_1
      PARAMETER (AXES_1 = .TRUE., SAVEIT_1 = .FALSE.)
      LOGICAL    ABORT, PLOT, PLOT1, PLOT2, PLOT3, PLOT4, PLOT5, PLOT6,
     +           PLOT7, PLOT8, PLOT9, PLOT10, PLOT11, PLOT12
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GKS012, PUTFAT$, RBOX01, LVIEW2
      INTRINSIC  ABS, LOG10, MAX
      DATA KUMBLD /  1,  1, -1, -1, -1, -1, -1,
     +              -1, -1, -1, -1, -1, -1, -1 /
      DATA KUMPOS / KUMOPT* 0 /
C
C Initialise and check if graph can be created
C
      NPLOTS = 0
      PLOT1 = .FALSE.
      PLOT2 = .FALSE.
      PLOT3 = .FALSE.
      PLOT4 = .FALSE.
      PLOT5 = .FALSE.
      PLOT6 = .FALSE.
      PLOT7 = .FALSE.
      PLOT8 = .FALSE.
      PLOT9 = .FALSE.
      PLOT10 = .FALSE.
      PLOT11 = .FALSE.
      PLOT12 = .FALSE.
      N1 = K0
      N2 = K0
      N3 = K0
      N4 = K0
      N5 = K0
      N6 = K0
      N7 = K0
      N8 = K0
      N9 = K0
      N10 = K0
      N11 = K0
      N12 = K0
      CIPHER(1) = 'Component 1 absent'
      CIPHER(2) = 'Component 2 absent'
      CIPHER(3) = 'Component 3 absent'
      CIPHER(4) = 'Component 4 absent'
      CIPHER(5) = 'Component 5 absent'
      CIPHER(6) = 'Component 6 absent'
      CIPHER(7) = 'Component 7 absent'
      CIPHER(8) = 'Component 8 absent'
      CIPHER(9) = 'Component 9 absent'
      CIPHER(10) = 'Component 10 absent'
      CIPHER(11) = 'Component 11 absent'
      CIPHER(12) = 'Component 12 absent'   
C
C Make sure workspaces are deallocated
C             
      IERR = K0
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X3)) DEALLOCATE(X3, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X4)) DEALLOCATE(X4, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X5)) DEALLOCATE(X5, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X6)) DEALLOCATE(X6, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X7)) DEALLOCATE(X7, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X8)) DEALLOCATE(X8, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X9)) DEALLOCATE(X9, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X10)) DEALLOCATE(X10, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X11)) DEALLOCATE(X11, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(X12)) DEALLOCATE(X12, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y3)) DEALLOCATE(Y3, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y4)) DEALLOCATE(Y4, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y5)) DEALLOCATE(Y5, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y6)) DEALLOCATE(Y6, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y7)) DEALLOCATE(Y7, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y8)) DEALLOCATE(Y8, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y9)) DEALLOCATE(Y9, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y10)) DEALLOCATE(Y10, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y11)) DEALLOCATE(Y11, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(Y12)) DEALLOCATE(Y12, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (N1D.GT.0 .AND. (L1.GT.0 .OR. M1.GT.0)) THEN
         N1 = N1D
         NPLOTS = NPLOTS + 1
         PLOT1 = .TRUE.
         IF (L1.GT.0 .AND. M1.LE.0) THEN
            CIPHER(1) = 'Component 1 (line ?)'
         ELSE
            CIPHER(1) = 'Component 1 (symbols)'
         ENDIF
      ENDIF
      IF (N2D.GT.0 .AND. (L2.GT.0 .OR. M2.GT.0)) THEN
         N2 = N2D
         NPLOTS = NPLOTS + 1
         PLOT2 = .TRUE.
         IF (L2.GT.0 .AND. M2.LE.0) THEN
            CIPHER(2) = 'Component 2 (line ?)'
         ELSE
            CIPHER(2) = 'Component 2 (symbols)'
         ENDIF
      ENDIF
      IF (N3D.GT.0 .AND. (L3.GT.0 .OR. M3.GT.0)) THEN
         N3 = N3D
         NPLOTS = NPLOTS + 1
         PLOT3 = .TRUE.
         IF (L3.GT.0 .AND. M3.LE.0) THEN
            CIPHER(3) = 'Component 3 (line ?)'
         ELSE
            CIPHER(3) = 'Component 3 (symbols)'
         ENDIF
      ENDIF
      IF (N4D.GT.0 .AND. (L4.GT.0 .OR. M4.GT.0)) THEN
         N4 = N4D
         NPLOTS = NPLOTS + 1
         PLOT4 = .TRUE.
         IF (L4.GT.0 .AND. M4.LE.0) THEN
            CIPHER(4) = 'Component 4 (line ?)'
         ELSE
            CIPHER(4) = 'Component 4 (symbols)'
         ENDIF
      ENDIF
      IF (N5D.GT.0 .AND. (L5.GT.0 .OR. M5.GT.0)) THEN
         N5 = N5D
         NPLOTS = NPLOTS + 1
         PLOT5 = .TRUE.
         IF (L5.GT.0 .AND. M5.LE.0) THEN
            CIPHER(5) = 'Component 5 (line ?)'
         ELSE
            CIPHER(5) = 'Component 5 (symbols)'
         ENDIF
      ENDIF
      IF (N6D.GT.0 .AND. (L6.GT.0 .OR. M6.GT.0)) THEN
         N6 = N6D
         NPLOTS = NPLOTS + 1
         PLOT6 = .TRUE.
         IF (L6.GT.0 .AND. M6.LE.0) THEN
            CIPHER(6) = 'Component 6 (line ?)'
         ELSE
            CIPHER(6) = 'Component 6 (symbols)'
         ENDIF
      ENDIF
      IF (N7D.GT.0 .AND. (L7.GT.0 .OR. M7.GT.0)) THEN
         N7 = N7D
         NPLOTS = NPLOTS + 1
         PLOT7 = .TRUE.
         IF (L7.GT.0 .AND. M7.LE.0) THEN
            CIPHER(7) = 'Component 7 (line ?)'
         ELSE
            CIPHER(7) = 'Component 7 (symbols)'
         ENDIF
      ENDIF
      IF (N8D.GT.0 .AND. (L8.GT.0 .OR. M8.GT.0)) THEN
         N8 = N8D
         NPLOTS = NPLOTS + 1
         PLOT8 = .TRUE.
         IF (L8.GT.0 .AND. M8.LE.0) THEN
            CIPHER(8) = 'Component 8 (line ?)'
         ELSE
            CIPHER(8) = 'Component 8 (symbols)'
         ENDIF
      ENDIF
      IF (N9D.GT.0 .AND. (L9.GT.0 .OR. M9.GT.0)) THEN
         N9 = N9D
         NPLOTS = NPLOTS + 1
         PLOT9 = .TRUE.
         IF (L9.GT.0 .AND. M9.LE.0) THEN
            CIPHER(9) = 'Component 9 (line ?)'
         ELSE
            CIPHER(9) = 'Component 9 (symbols)'
         ENDIF
      ENDIF
      IF (N10D.GT.0 .AND. (L10.GT.0 .OR. M10.GT.0)) THEN
         N10 = N10D
         NPLOTS = NPLOTS + 1
         PLOT10 = .TRUE.
         IF (L10.GT.0 .AND. M10.LE.0) THEN
            CIPHER(10) = 'Component 10 (line ?)'
         ELSE
            CIPHER(10) = 'Component 10 (symbols)'
         ENDIF
      ENDIF
      IF (N11D.GT.0 .AND. (L11.GT.0 .OR. M11.GT.0)) THEN
         N11 = N11D
         NPLOTS = NPLOTS + 1
         PLOT11 = .TRUE.
         IF (L11.GT.0 .AND. M11.LE.0) THEN
            CIPHER(11) = 'Component 11 (line ?)'
         ELSE
            CIPHER(11) = 'Component 11 (symbols)'
         ENDIF
      ENDIF
      IF (N12D.GT.0 .AND. (L12.GT.0 .OR. M12.GT.0)) THEN
         N12 = N12D
         NPLOTS = NPLOTS + 1
         PLOT12 = .TRUE.
         IF (L12.GT.0 .AND. M12.LE.0) THEN
            CIPHER(12) = 'Component 12 (line ?)'
         ELSE
            CIPHER(12) = 'Component 12 (symbols)'
         ENDIF
      ENDIF
      IF (NPLOTS.EQ.K0) GOTO 80
      NTEMP = MAX(N1,K1)  
      ALLOCATE(X1(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
       NTEMP = MAX(N2,K1)
      ALLOCATE(X2(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN  
      NTEMP = MAX(N3,K1) 
      ALLOCATE(X3(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N4,K1) 
      ALLOCATE(X4(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N5,K1) 
      ALLOCATE(X5(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N6,K1) 
      ALLOCATE(X6(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N7,K1) 
      ALLOCATE(X7(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N8,K1)
      ALLOCATE(X8(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N9,K1) 
      ALLOCATE(X9(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N10,K1) 
      ALLOCATE(X10(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N11,K1) 
      ALLOCATE(X11(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N12,K1)
      ALLOCATE(X12(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N1,K1) 
      ALLOCATE(Y1(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N2,K1) 
      ALLOCATE(Y2(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN  
      NTEMP = MAX(N3,K1) 
      ALLOCATE(Y3(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N4,K1)
      ALLOCATE(Y4(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N5,K1) 
      ALLOCATE(Y5(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N6,K1)
      ALLOCATE(Y6(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N7,K1) 
      ALLOCATE(Y7(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N8,K1)
      ALLOCATE(Y8(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N9,K1) 
      ALLOCATE(Y9(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N10,K1) 
      ALLOCATE(Y10(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N11,K1) 
      ALLOCATE(Y11(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      NTEMP = MAX(N12,K1) 
      ALLOCATE(Y12(NTEMP), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
C
C Choose action required: note that NDEC goes to NDEC - 1
C
      NDEC = 1
   20 CONTINUE
      ABORT = .FALSE.
      WRITE (TEXT,100)
      CALL LVIEW2 (IXL, IYL, NDEC, NUMOPT, 
     +             TEXT, TITLES)
      NDEC = NDEC - 1
C
C If NDEC = 0 plot then return to 20: otherwise set plot labels
C
      IF (NDEC.EQ.0) THEN
         CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +                M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +                N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +                X1D, X2D, X3D, X4D, X5D, X6D, X7D, X8D, X9D, X10D,
     +                X11D, X12D,
     +                Y1D, Y2D, Y3D, Y4D, Y5D, Y6D, Y7D, Y8D, Y9D, Y10D,
     +                Y11D, Y12D,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, SAVEIT)
         NDEC = NUMOPT
         GOTO 20
      ELSEIF (NDEC.EQ.1) THEN
         PLABEL = 'Lineweaver-Burk Plot'
         XLABEL = '  1/x'
         YLABEL = '     1/y'
      ELSEIF (NDEC.EQ.2) THEN
         PLABEL = '    Scatchard Plot'
         XLABEL = '   y'
         YLABEL = '     y/x'
      ELSEIF (NDEC.EQ.3) THEN
         PLABEL = ' Eadie-Hofstee Plot'
         XLABEL = '  y/x'
         YLABEL = '      y'
      ELSEIF (NDEC.EQ.4) THEN
         PLABEL = '     Hanes Plot'
         XLABEL = '   x'
         YLABEL = '     x/y'
      ELSEIF (NDEC.EQ.5) THEN
         PLABEL = '     X-semilog Plot'
         XLABEL = ' log10[x]'
         YLABEL = '     y'
      ELSEIF (NDEC.EQ.6) THEN
         PLABEL = '     Y-semilog Plot'
         XLABEL = '   x'
         YLABEL = '   log10[y]'
      ELSEIF (NDEC.EQ.7) THEN
         PLABEL = '      log-log Plot'
         XLABEL = 'log10[x]'
         YLABEL = ' log10[y]'
      ELSEIF (NDEC.EQ.8) THEN
         IF (A.LE.RTOL) THEN
            CALL PUTFAT$('Plot does not make sense ... No Hill Plot')
            NDEC = NUMOPT
            GOTO 20
         ENDIF
         WRITE (PLABEL,200) A
         XLABEL = 'log10[x]'
         YLABEL = 'log10[y/(A-y)]'
      ELSEIF (NDEC.EQ.9) THEN
         PLABEL = '    X-Dilution Plot'
         YLABEL = '    y'
         XLABEL = 'log10[1/x]'
      ELSE
         GOTO 80
      ENDIF
C
C Check to see if required transformation is possible
C
      DO J = 1, 12
         IF (J.EQ.1) THEN
            PLOT = PLOT1
            K = N1
         ELSEIF (J.EQ.2) THEN
            PLOT = PLOT2
            K = N2
         ELSEIF (J.EQ.3) THEN
            PLOT = PLOT3
            K = N3
         ELSEIF (J.EQ.4) THEN
            PLOT = PLOT4
            K = N4
         ELSEIF (J.EQ.5) THEN
            PLOT = PLOT5
            K = N5
         ELSEIF (J.EQ.6) THEN
            PLOT = PLOT6
            K = N6
         ELSEIF (J.EQ.7) THEN
            PLOT = PLOT7
            K = N7
         ELSEIF (J.EQ.8) THEN
            PLOT = PLOT8
            K = N8
         ELSEIF (J.EQ.9) THEN
            PLOT = PLOT9
            K = N9
         ELSEIF (J.EQ.10) THEN
            PLOT = PLOT10
            K = N10
         ELSEIF (J.EQ.11) THEN
            PLOT = PLOT11
            K = N11
         ELSEIF (J.EQ.12) THEN
            PLOT = PLOT12
            K = N12
         ENDIF
         IF (PLOT) THEN
            DO I = 1, K
               IF (J.EQ.1) THEN
                  XTEMP = X1D(I)
                  YTEMP = Y1D(I)
               ELSEIF (J.EQ.2) THEN
                  XTEMP = X2D(I)
                  YTEMP = Y2D(I)
               ELSEIF (J.EQ.3) THEN
                  XTEMP = X3D(I)
                  YTEMP = Y3D(I)
               ELSEIF (J.EQ.4) THEN
                  XTEMP = X4D(I)
                  YTEMP = Y4D(I)
               ELSEIF (J.EQ.5) THEN
                  XTEMP = X5D(I)
                  YTEMP = Y5D(I)
               ELSEIF (J.EQ.6) THEN
                  XTEMP = X6D(I)
                  YTEMP = Y6D(I)
               ELSEIF (J.EQ.7) THEN
                  XTEMP = X7D(I)
                  YTEMP = Y7D(I)
               ELSEIF (J.EQ.8) THEN
                  XTEMP = X8D(I)
                  YTEMP = Y8D(I)
               ELSEIF (J.EQ.9) THEN
                  XTEMP = X9D(I)
                  YTEMP = Y9D(I)
               ELSEIF (J.EQ.10) THEN
                  XTEMP = X10D(I)
                  YTEMP = Y10D(I)
               ELSEIF (J.EQ.11) THEN
                  XTEMP = X11D(I)
                  YTEMP = Y11D(I)
               ELSEIF (J.EQ.12) THEN
                  XTEMP = X12D(I)
                  YTEMP = Y12D(I)
               ENDIF
               ABSXI = ABS(XTEMP)
               ABSYI = ABS(YTEMP)
C
C Both x and y must be nonzero to transform 1 to 4 reversibly
C
               IF (NDEC.LE.4) THEN
                  IF (ABSXI.LE.RTOL .OR. ABSYI.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.5) THEN
                  IF (XTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.6) THEN
                  IF (YTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.7) THEN
                  IF (XTEMP.LE.RTOL .OR. YTEMP.LE.RTOL) ABORT = .TRUE.
               ELSEIF (NDEC.EQ.8) THEN
                  TEMP = A - YTEMP
                  IF (TEMP.GT.RTOL) THEN
                     TEMP = YTEMP/TEMP
                     IF (TEMP.LT.RTOL .OR. XTEMP.LT.RTOL) THEN
                        ABORT = .TRUE.
                     ENDIF
                  ELSE
                     ABORT = .TRUE.
                  ENDIF
               ELSEIF (NDEC.EQ.9) THEN
                  IF (XTEMP.LE.RTOL) ABORT = .TRUE.
               ENDIF
               IF (ABORT) GOTO 60
            ENDDO
         ENDIF
      ENDDO
C
C Return if plot is not possible
C
   60 CONTINUE
      IF (ABORT) THEN
         CALL PUTFAT$('Value too small ... Plot not possible')
         NDEC = NUMOPT
         GOTO 20
      ENDIF
C
C Now do the transforms
C
      DO J = 1, 12
         IF (J.EQ.1) THEN
            PLOT = PLOT1
            K = N1
         ELSEIF (J.EQ.2) THEN
            PLOT = PLOT2
            K = N2
         ELSEIF (J.EQ.3) THEN
            PLOT = PLOT3
            K = N3
         ELSEIF (J.EQ.4) THEN
            PLOT = PLOT4
            K = N4
         ELSEIF (J.EQ.5) THEN
            PLOT = PLOT5
            K = N5
         ELSEIF (J.EQ.6) THEN
            PLOT = PLOT6
            K = N6
         ELSEIF (J.EQ.7) THEN
            PLOT = PLOT7
            K = N7
         ELSEIF (J.EQ.8) THEN
            PLOT = PLOT8
            K = N8
         ELSEIF (J.EQ.9) THEN
            PLOT = PLOT9
            K = N9
         ELSEIF (J.EQ.10) THEN
            PLOT = PLOT10
            K = N10
         ELSEIF (J.EQ.11) THEN
            PLOT = PLOT11
            K = N11
         ELSEIF (J.EQ.12) THEN
            PLOT = PLOT12
            K = N12
         ENDIF
         IF (PLOT) THEN
            DO I = 1, K
               IF (J.EQ.1) THEN
                  XTEMP = X1D(I)
                  YTEMP = Y1D(I)
               ELSEIF (J.EQ.2) THEN
                  XTEMP = X2D(I)
                  YTEMP = Y2D(I)
               ELSEIF (J.EQ.3) THEN
                  XTEMP = X3D(I)
                  YTEMP = Y3D(I)
               ELSEIF (J.EQ.4) THEN
                  XTEMP = X4D(I)
                  YTEMP = Y4D(I)
               ELSEIF (J.EQ.5) THEN
                  XTEMP = X5D(I)
                  YTEMP = Y5D(I)
               ELSEIF (J.EQ.6) THEN
                  XTEMP = X6D(I)
                  YTEMP = Y6D(I)
               ELSEIF (J.EQ.7) THEN
                  XTEMP = X7D(I)
                  YTEMP = Y7D(I)
               ELSEIF (J.EQ.8) THEN
                  XTEMP = X8D(I)
                  YTEMP = Y8D(I)
               ELSEIF (J.EQ.9) THEN
                  XTEMP = X9D(I)
                  YTEMP = Y9D(I)
               ELSEIF (J.EQ.10) THEN
                  XTEMP = X10D(I)
                  YTEMP = Y10D(I)
               ELSEIF (J.EQ.11) THEN
                  XTEMP = X11D(I)
                  YTEMP = Y11D(I)
               ELSEIF (J.EQ.12) THEN
                  XTEMP = X12D(I)
                  YTEMP = Y12D(I)
               ENDIF
               IF (NDEC.EQ.1) THEN
                  XTRAN = ONE/XTEMP
                  YTRAN = ONE/YTEMP
               ELSEIF (NDEC.EQ.2) THEN
                  XTRAN = YTEMP
                  YTRAN = YTEMP/XTEMP
               ELSEIF (NDEC.EQ.3) THEN
                  XTRAN = YTEMP/XTEMP
                  YTRAN = YTEMP
               ELSEIF (NDEC.EQ.4) THEN
                  XTRAN = XTEMP
                  YTRAN = XTEMP/YTEMP
               ELSEIF (NDEC.EQ.5) THEN
                  XTRAN = LOG10(XTEMP)
                  YTRAN = YTEMP
               ELSEIF (NDEC.EQ.6) THEN
                  XTRAN = XTEMP
                  YTRAN = LOG10(YTEMP)
               ELSEIF (NDEC.EQ.7) THEN
                  XTRAN = LOG10(XTEMP)
                  YTRAN = LOG10(YTEMP)
               ELSEIF (NDEC.EQ.8) THEN
                  TEMP = YTEMP/(A - YTEMP)
                  XTRAN = LOG10(XTEMP)
                  YTRAN = LOG10(TEMP)
               ELSEIF (NDEC.EQ.9) THEN
                  XTRAN = LOG10(ONE/XTEMP)
                  YTRAN = YTEMP
               ENDIF
               IF (J.EQ.1) THEN
                  X1(I) = XTRAN
                  Y1(I) = YTRAN
               ELSEIF (J.EQ.2) THEN
                  X2(I) = XTRAN
                  Y2(I) = YTRAN
               ELSEIF (J.EQ.3) THEN
                  X3(I) = XTRAN
                  Y3(I) = YTRAN
               ELSEIF (J.EQ.4) THEN
                  X4(I) = XTRAN
                  Y4(I) = YTRAN
               ELSEIF (J.EQ.5) THEN
                  X5(I) = XTRAN
                  Y5(I) = YTRAN
               ELSEIF (J.EQ.6) THEN
                  X6(I) = XTRAN
                  Y6(I) = YTRAN
               ELSEIF (J.EQ.7) THEN
                  X7(I) = XTRAN
                  Y7(I) = YTRAN
               ELSEIF (J.EQ.8) THEN
                  X8(I) = XTRAN
                  Y8(I) = YTRAN
               ELSEIF (J.EQ.9) THEN
                  X9(I) = XTRAN
                  Y9(I) = YTRAN
               ELSEIF (J.EQ.10) THEN
                  X10(I) = XTRAN
                  Y10(I) = YTRAN
               ELSEIF (J.EQ.11) THEN
                  X11(I) = XTRAN
                  Y11(I) = YTRAN
               ELSEIF (J.EQ.12) THEN
                  X12(I) = XTRAN
                  Y12(I) = YTRAN
               ENDIF
            ENDDO
         ENDIF
      ENDDO
C
C Extrapolate if requested
C
      IF (NDEC.EQ.1) THEN
         DO I = 1, 12
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 12)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(1) - X1(N1)
            YDIFF = Y1(1) - Y1(N1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(N1) = - CONST/SLOPE
                  Y1(N1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(1) - X2(N2)
            YDIFF = Y2(1) - Y2(N2)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(N2) = - CONST/SLOPE
                  Y2(N2) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(1) - X3(N3)
            YDIFF = Y3(1) - Y3(N3)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(N3) = - CONST/SLOPE
                  Y3(N3) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(1) - X4(N4)
            YDIFF = Y4(1) - Y4(N4)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(N4) = - CONST/SLOPE
                  Y4(N4) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(5).EQ.1 .AND. L5.GT.0 .AND. M5.LE.0) THEN
            XDIFF = X5(1) - X5(N5)
            YDIFF = Y5(1) - Y5(N5)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y5(1) - SLOPE*X5(1)
               I = N5/2
               XTEMP = X5(I)
               YTEMP = Y5(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 5 is nonlinear')
               ELSE
                  X5(N5) = - CONST/SLOPE
                  Y5(N5) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(6).EQ.1 .AND. L6.GT.0 .AND. M6.LE.0) THEN
            XDIFF = X6(1) - X6(N6)
            YDIFF = Y6(1) - Y6(N6)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y6(1) - SLOPE*X6(1)
               I = N6/2
               XTEMP = X6(I)
               YTEMP = Y6(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 6 is nonlinear')
               ELSE
                  X6(N6) = - CONST/SLOPE
                  Y6(N6) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(7).EQ.1 .AND. L7.GT.0 .AND. M7.LE.0) THEN
            XDIFF = X7(1) - X7(N7)
            YDIFF = Y7(1) - Y7(N7)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y7(1) - SLOPE*X7(1)
               I = N7/2
               XTEMP = X7(I)
               YTEMP = Y7(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 7 is nonlinear')
               ELSE
                  X7(N7) = - CONST/SLOPE
                  Y7(N7) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(8).EQ.1 .AND. L8.GT.0 .AND. M8.LE.0) THEN
            XDIFF = X8(1) - X8(N8)
            YDIFF = Y8(1) - Y8(N8)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y8(1) - SLOPE*X8(1)
               I = N8/2
               XTEMP = X8(I)
               YTEMP = Y8(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 8 is nonlinear')
               ELSE
                  X8(N8) = - CONST/SLOPE
                  Y8(N8) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(9).EQ.1 .AND. L9.GT.0 .AND. M9.LE.0) THEN
            XDIFF = X9(1) - X9(N9)
            YDIFF = Y9(1) - Y9(N9)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y9(1) - SLOPE*X9(1)
               I = N9/2
               XTEMP = X9(I)
               YTEMP = Y9(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 9 is nonlinear')
               ELSE
                  X9(N9) = - CONST/SLOPE
                  Y9(N9) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(10).EQ.1 .AND. L10.GT.0 .AND. M10.LE.0) THEN
            XDIFF = X10(1) - X10(N10)
            YDIFF = Y10(1) - Y10(N10)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y10(1) - SLOPE*X10(1)
               I = N10/2
               XTEMP = X10(I)
               YTEMP = Y10(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 10 is nonlinear')
               ELSE
                  X10(N10) = - CONST/SLOPE
                  Y10(N10) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(11).EQ.1 .AND. L11.GT.0 .AND. M11.LE.0) THEN
            XDIFF = X11(1) - X11(N11)
            YDIFF = Y11(1) - Y11(N11)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y11(1) - SLOPE*X11(1)
               I = N11/2
               XTEMP = X11(I)
               YTEMP = Y11(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 11 is nonlinear')
               ELSE
                  X11(N11) = - CONST/SLOPE
                  Y11(N11) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(12).EQ.1 .AND. L12.GT.0 .AND. M12.LE.0) THEN
            XDIFF = X12(1) - X12(N12)
            YDIFF = Y12(1) - Y12(N12)
            IF (XDIFF.GT.RTOL .AND. YDIFF.GT.RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y12(1) - SLOPE*X12(1)
               I = N12/2
               XTEMP = X12(I)
               YTEMP = Y12(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 12 is nonlinear')
               ELSE
                  X12(N12) = - CONST/SLOPE
                  Y12(N12) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (NDEC.EQ.2) THEN
         DO I = 1, 12
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 12)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(N1) - X1(1)
            YDIFF = Y1(N1) - Y1(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(1) = ZERO
                  Y1(1) = CONST
                  X1(N1) = - CONST/SLOPE
                  Y1(N1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(N2) - X2(1)
            YDIFF = Y2(N2) - Y2(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(1) = ZERO
                  Y2(1) = CONST
                  X2(N2) = - CONST/SLOPE
                  Y2(N2) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(N3) - X3(1)
            YDIFF = Y3(N3) - Y3(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(1) = ZERO
                  Y3(1) = CONST
                  X3(N3) = - CONST/SLOPE
                  Y3(N3) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(N4) - X4(1)
            YDIFF = Y4(N4) - Y4(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(1) = ZERO
                  Y4(1) = CONST
                  X4(N4) = - CONST/SLOPE
                  Y4(N4) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(5).EQ.1 .AND. L5.GT.0 .AND. M5.LE.0) THEN
            XDIFF = X5(N5) - X5(1)
            YDIFF = Y5(N5) - Y5(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y5(1) - SLOPE*X5(1)
               I = N5/2
               XTEMP = X5(I)
               YTEMP = Y5(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 5 is nonlinear')
               ELSE
                  X5(1) = ZERO
                  Y5(1) = CONST
                  X5(N5) = - CONST/SLOPE
                  Y5(N5) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(6).EQ.1 .AND. L6.GT.0 .AND. M6.LE.0) THEN
            XDIFF = X6(N6) - X6(1)
            YDIFF = Y6(N6) - Y6(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y6(1) - SLOPE*X6(1)
               I = N6/2
               XTEMP = X6(I)
               YTEMP = Y6(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 6 is nonlinear')
               ELSE
                  X6(1) = ZERO
                  Y6(1) = CONST
                  X6(N6) = - CONST/SLOPE
                  Y6(N6) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(7).EQ.1 .AND. L7.GT.0 .AND. M7.LE.0) THEN
            XDIFF = X7(N7) - X7(1)
            YDIFF = Y7(N7) - Y7(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y7(1) - SLOPE*X7(1)
               I = N7/2
               XTEMP = X7(I)
               YTEMP = Y7(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 7 is nonlinear')
               ELSE
                  X7(1) = ZERO
                  Y7(1) = CONST
                  X7(N7) = - CONST/SLOPE
                  Y7(N7) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(8).EQ.1 .AND. L8.GT.0 .AND. M8.LE.0) THEN
            XDIFF = X8(N8) - X8(1)
            YDIFF = Y8(N8) - Y8(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y8(1) - SLOPE*X8(1)
               I = N8/2
               XTEMP = X8(I)
               YTEMP = Y8(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 8 is nonlinear')
               ELSE
                  X8(1) = ZERO
                  Y8(1) = CONST
                  X8(N8) = - CONST/SLOPE
                  Y8(N8) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(9).EQ.1 .AND. L9.GT.0 .AND. M9.LE.0) THEN
            XDIFF = X9(N9) - X9(1)
            YDIFF = Y9(N9) - Y9(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y9(1) - SLOPE*X9(1)
               I = N9/2
               XTEMP = X9(I)
               YTEMP = Y9(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 9 is nonlinear')
               ELSE
                  X9(1) = ZERO
                  Y9(1) = CONST
                  X9(N9) = - CONST/SLOPE
                  Y9(N9) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(10).EQ.1 .AND. L10.GT.0 .AND. M10.LE.0) THEN
            XDIFF = X10(N10) - X10(1)
            YDIFF = Y10(N10) - Y10(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y10(1) - SLOPE*X10(1)
               I = N10/2
               XTEMP = X10(I)
               YTEMP = Y10(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 10 is nonlinear')
               ELSE
                  X10(1) = ZERO
                  Y10(1) = CONST
                  X10(N10) = - CONST/SLOPE
                  Y10(N10) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(11).EQ.1 .AND. L11.GT.0 .AND. M11.LE.0) THEN
            XDIFF = X11(N11) - X11(1)
            YDIFF = Y11(N11) - Y11(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y11(1) - SLOPE*X11(1)
               I = N11/2
               XTEMP = X11(I)
               YTEMP = Y11(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 11 is nonlinear')
               ELSE
                  X11(1) = ZERO
                  Y11(1) = CONST
                  X11(N11) = - CONST/SLOPE
                  Y11(N11) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(12).EQ.1 .AND. L12.GT.0 .AND. M12.LE.0) THEN
            XDIFF = X12(N12) - X12(1)
            YDIFF = Y12(N12) - Y12(1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y12(1) - SLOPE*X12(1)
               I = N12/2
               XTEMP = X12(I)
               YTEMP = Y12(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 12 is nonlinear')
               ELSE
                  X12(1) = ZERO
                  Y12(1) = CONST
                  X12(N12) = - CONST/SLOPE
                  Y12(N12) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ELSEIF (NDEC.EQ.3) THEN
         DO I = 1, 12
            KUMPOS(I) = 0
         ENDDO
         WRITE (TEXT,300) (CIPHER(I), I = 1, 12)
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, KUMBLD, KUMDEC, KUMOPT,
     +                KUMPOS, KSTART, KTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (KUMPOS(1).EQ.1 .AND. L1.GT.0 .AND. M1.LE.0) THEN
            XDIFF = X1(1) - X1(N1)
            YDIFF = Y1(1) - Y1(N1)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y1(1) - SLOPE*X1(1)
               I = N1/2
               XTEMP = X1(I)
               YTEMP = Y1(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 1 is nonlinear')
               ELSE
                  X1(N1) = ZERO
                  Y1(N1) = CONST
                  X1(1) = - CONST/SLOPE
                  Y1(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(2).EQ.1 .AND. L2.GT.0 .AND. M2.LE.0) THEN
            XDIFF = X2(1) - X2(N2)
            YDIFF = Y2(1) - Y2(N2)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y2(1) - SLOPE*X2(1)
               I = N2/2
               XTEMP = X2(I)
               YTEMP = Y2(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 2 is nonlinear')
               ELSE
                  X2(N2) = ZERO
                  Y2(N2) = CONST
                  X2(1) = - CONST/SLOPE
                  Y2(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(3).EQ.1 .AND. L3.GT.0 .AND. M3.LE.0) THEN
            XDIFF = X3(1) - X3(N3)
            YDIFF = Y3(1) - Y3(N3)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y3(1) - SLOPE*X3(1)
               I = N3/2
               XTEMP = X3(I)
               YTEMP = Y3(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 3 is nonlinear')
               ELSE
                  X3(N3) = ZERO
                  Y3(N3) = CONST
                  X3(1) = - CONST/SLOPE
                  Y3(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(4).EQ.1 .AND. L4.GT.0 .AND. M4.LE.0) THEN
            XDIFF = X4(1) - X4(N4)
            YDIFF = Y4(1) - Y4(N4)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y4(1) - SLOPE*X4(1)
               I = N4/2
               XTEMP = X4(I)
               YTEMP = Y4(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 4 is nonlinear')
               ELSE
                  X4(N4) = ZERO
                  Y4(N4) = CONST
                  X4(1) = - CONST/SLOPE
                  Y4(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(5).EQ.1 .AND. L5.GT.0 .AND. M5.LE.0) THEN
            XDIFF = X5(1) - X5(N5)
            YDIFF = Y5(1) - Y5(N5)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y5(1) - SLOPE*X5(1)
               I = N5/2
               XTEMP = X5(I)
               YTEMP = Y5(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 5 is nonlinear')
               ELSE
                  X5(N5) = ZERO
                  Y5(N5) = CONST
                  X5(1) = - CONST/SLOPE
                  Y5(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(6).EQ.1 .AND. L6.GT.0 .AND. M6.LE.0) THEN
            XDIFF = X6(1) - X6(N6)
            YDIFF = Y6(1) - Y6(N6)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y6(1) - SLOPE*X6(1)
               I = N6/2
               XTEMP = X6(I)
               YTEMP = Y6(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 6 is nonlinear')
               ELSE
                  X6(N6) = ZERO
                  Y6(N6) = CONST
                  X6(1) = - CONST/SLOPE
                  Y6(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(7).EQ.1 .AND. L7.GT.0 .AND. M7.LE.0) THEN
            XDIFF = X7(1) - X7(N7)
            YDIFF = Y7(1) - Y7(N7)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y7(1) - SLOPE*X7(1)
               I = N7/2
               XTEMP = X7(I)
               YTEMP = Y7(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 7 is nonlinear')
               ELSE
                  X7(N7) = ZERO
                  Y7(N7) = CONST
                  X7(1) = - CONST/SLOPE
                  Y7(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(8).EQ.1 .AND. L8.GT.0 .AND. M8.LE.0) THEN
            XDIFF = X8(1) - X8(N8)
            YDIFF = Y8(1) - Y8(N8)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y8(1) - SLOPE*X8(1)
               I = N8/2
               XTEMP = X8(I)
               YTEMP = Y8(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 8 is nonlinear')
               ELSE
                  X8(N8) = ZERO
                  Y8(N8) = CONST
                  X8(1) = - CONST/SLOPE
                  Y8(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(9).EQ.1 .AND. L9.GT.0 .AND. M9.LE.0) THEN
            XDIFF = X9(1) - X9(N9)
            YDIFF = Y9(1) - Y9(N9)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y9(1) - SLOPE*X9(1)
               I = N9/2
               XTEMP = X9(I)
               YTEMP = Y9(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 9 is nonlinear')
               ELSE
                  X9(N9) = ZERO
                  Y9(N9) = CONST
                  X9(1) = - CONST/SLOPE
                  Y9(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(10).EQ.1 .AND. L10.GT.0 .AND. M10.LE.0) THEN
            XDIFF = X10(1) - X10(N10)
            YDIFF = Y10(1) - Y10(N10)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y10(1) - SLOPE*X10(1)
               I = N10/2
               XTEMP = X10(I)
               YTEMP = Y10(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 10 is nonlinear')
               ELSE
                  X10(N10) = ZERO
                  Y10(N10) = CONST
                  X10(1) = - CONST/SLOPE
                  Y10(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(11).EQ.1 .AND. L11.GT.0 .AND. M11.LE.0) THEN
            XDIFF = X11(1) - X11(N11)
            YDIFF = Y11(1) - Y11(N11)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y11(1) - SLOPE*X11(1)
               I = N11/2
               XTEMP = X11(I)
               YTEMP = Y11(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 11 is nonlinear')
               ELSE
                  X11(N11) = ZERO
                  Y11(N11) = CONST
                  X11(1) = - CONST/SLOPE
                  Y11(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
         IF (KUMPOS(12).EQ.1 .AND. L12.GT.0 .AND. M12.LE.0) THEN
            XDIFF = X12(1) - X12(N12)
            YDIFF = Y12(1) - Y12(N12)
            IF (XDIFF.GT.RTOL .AND. YDIFF.LT. - RTOL) THEN
               YSIZE = EPSI*(ABS(YDIFF) + EPSI)
               SLOPE = YDIFF/XDIFF
               CONST = Y12(1) - SLOPE*X12(1)
               I = N12/2
               XTEMP = X12(I)
               YTEMP = Y12(I)
               YTRAN = SLOPE*XTEMP + CONST
               IF (ABS(YTEMP - YTRAN).GT.YSIZE) THEN
                  CALL PUTFAT$('Transformed component 12 is nonlinear')
               ELSE
                  X12(N12) = ZERO
                  Y12(N12) = CONST
                  X12(1) = - CONST/SLOPE
                  Y12(1) = ZERO
               ENDIF
            ENDIF
         ENDIF
      ENDIF
C
C Plot the transforms
C
      CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +             M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +             N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +             X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12,
     +             Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +             PTITLE, XLABEL, YLABEL,
     +             AXES_1, SAVEIT_1)
      NDEC = NUMOPT
      GOTO 20
C
C Finally close down the plot
C
   80 CONTINUE  
      DEALLOCATE(X1, STAT = IERR)
      DEALLOCATE(X2, STAT = IERR)
      DEALLOCATE(X3, STAT = IERR)
      DEALLOCATE(X4, STAT = IERR)
      DEALLOCATE(X5, STAT = IERR)
      DEALLOCATE(X6, STAT = IERR)
      DEALLOCATE(X7, STAT = IERR)
      DEALLOCATE(X8, STAT = IERR)
      DEALLOCATE(X9, STAT = IERR)
      DEALLOCATE(X10, STAT = IERR)
      DEALLOCATE(X11, STAT = IERR)
      DEALLOCATE(X12, STAT = IERR) 
      DEALLOCATE(Y1, STAT = IERR)
      DEALLOCATE(Y2, STAT = IERR)
      DEALLOCATE(Y3, STAT = IERR)
      DEALLOCATE(Y4, STAT = IERR)
      DEALLOCATE(Y5, STAT = IERR)
      DEALLOCATE(Y6, STAT = IERR)
      DEALLOCATE(Y7, STAT = IERR)
      DEALLOCATE(Y8, STAT = IERR)
      DEALLOCATE(Y9, STAT = IERR)
      DEALLOCATE(Y10, STAT = IERR)
      DEALLOCATE(Y11, STAT = IERR)
      DEALLOCATE(Y12, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     + 'Name of The Transformation`x-axis   `y-axis'
     +/'Original plot axes        `x        `y'
     +/'Lineweaver-Burk           `1/x      `1/y'
     +/'Scatchard                 `y        `y/x'
     +/'Eadie-Hofstee             `y/x      `y'
     +/'Hanes                     `x        `x/y'
     +/'x-semilog                 `log[x]   `y'
     +/'y-semilog                 `x        `log[y]'
     +/'log-log                   `log[x]   `log[y]'
     +/'Hill                      `log[x]   `log[y/(A - y)]'
     +/'Dilution curve            `log[1/x] `y'
     +/'Cancel this plot          `...     `...'
     +/'log[.] is base 10'
     +/'Save ASCII files for SIMPLOT (as x and y)'
     +/'Dilution curves are as 1, 1:10, 1:100, etc.'
     +/'Hill plot A is y(x = infinity), and this'
     +/'plot is only done for saturation functions.')
  200 FORMAT ('Hill Plot, A =',1P,E10.3)
  300 FORMAT (
     + 'Select components for linear extrapolation'
     +/'...'
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A
     +/A)
      END
C
C
