C
C
      SUBROUTINE GKSTRN$(MTRANS, N, NLOG, NT, NTYPE,
     +                   ASYMP, X, XH, XHT, XL, XLT, XT, 
     +                          Y, YH, YHT, YL, YLT, YT,
     +                   NATLOG)
C
C ACTION : SUPPLY  N, A, X, Y then derive transforms as selected
C          NT = NT + N1 only if transformation can be done
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 9/11/92
C          14/07/1997 win32 version
C          22/07/1999 changed transformation scheme as follows:-
C          01/02/2000 changed transformation 12 and NATLOG to NATLOG(12)
C                     also introduced transformations 13 to 15
C          02/06/2000 changed .GE.RTOL to .GT.RTOL
C          19/04/2007 added INTENTS and NLOG to arguments
C
C          original 0:    x,     1/y
C          ======== 1:   1/x,      y
C                   2:   1/x,    1/y
C                   3:     y,    y/x
C                   4:   y/x,      y
C                   5:    /x,    x/y
C                   6:  logx,      y
C                   7:     x,   logy
C                   8:  logx,   logy
C                   9:  logx,   log[y/(A-y)]
C                  10:     x,      y
C
C               new 0:    x,       y
C               === 1:    y,       x
C                   2:    x,     1/y
C                   3:   1/x,      y
C                   4:   1/x,    1/y
C                   5:     y,    y/x
C                   6:   y/x,      y
C                   7:     x,    x/y
C                   8:  logx,      y
C                   9:     x,   logy
C                  10:  logx,   logy
C                  11:  logx,   log[y/(A-y)]
C                  12:  log[1/x],  y
C                  13:  logy       x
C                  14:     y    logx
C                  15:  logy    logx
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: MTRANS, N, NLOG, NTYPE  
      INTEGER,          INTENT (OUT) :: NT
      DOUBLE PRECISION, INTENT (IN)  :: ASYMP
      DOUBLE PRECISION, INTENT (IN)  :: X(N), XH(N), XL(N)  
      DOUBLE PRECISION, INTENT (OUT) :: XHT(N), XLT(N), XT(N)
      DOUBLE PRECISION, INTENT (IN)  :: Y(N), YH(N), YL(N)      
      DOUBLE PRECISION, INTENT (OUT) :: YHT(N), YLT(N), YT(N)
C
C Only the first ten elements of NATLOG are used by GKSTRN$
C
      LOGICAL,          INTENT (IN)  :: NATLOG(NLOG)
C
C Locals
C            
      INTEGER    N0, N1, N2, N7, N9
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N7 = 7, N9 = 9)
      INTEGER    I
      DOUBLE PRECISION ABSXI, ABSXHI, ABSXLI, ABSYI, ABSYHI, ABSYLI
      DOUBLE PRECISION RTOL, X02AME$
      DOUBLE PRECISION BLOG, TEMP, TEMPH, TEMPL
      DOUBLE PRECISION ONE, TEN
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00)
      LOGICAL    AGAIN
      EXTERNAL   X02AME$, PUTFAT$
      INTRINSIC  LOG, ABS, DBLE
C
C Check MTRANS
C
      IF (MTRANS.LT.0 .OR. MTRANS.GT.15) THEN
         CALL PUTFAT$('MTRANS out of range in call to GKSTRN')
         RETURN
      ENDIF
C
C Initialise
C
      RTOL = 1.0D+09*X02AME$()
      IF (MTRANS.GT.N7) THEN
C
C Define BLOG = 1/log(base) if log transform required
C
         IF (NATLOG(1)) THEN
            BLOG = ONE
         ELSEIF (NATLOG(10)) THEN
            BLOG = ONE/LOG(TEN)
         ELSE
            AGAIN = .TRUE.
            DO I = N2, N9
               IF (AGAIN) THEN
                  IF (NATLOG(I)) THEN
                     AGAIN = .FALSE.
                     BLOG = ONE/LOG(DBLE(I))
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
      ENDIF
      NT = N0
C
C NTYPE = 1: transform when no error bars involved
C
      IF (NTYPE.EQ.1) THEN
         DO I = N1, N
            ABSXI = ABS(X(I))
            ABSYI = ABS(Y(I))
            IF (MTRANS.EQ.0) THEN
               NT = NT + N1
               XT(NT) = X(I)
               YT(NT) = Y(I)
            ELSEIF (MTRANS.EQ.1) THEN
               NT = NT + N1
               XT(NT) = Y(I)
               YT(NT) = X(I)
            ELSEIF (MTRANS.EQ.2) THEN
               IF (ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.3) THEN
               IF (ABSXI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = ONE/X(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.4) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = ONE/X(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.5) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)
                  YT(NT) = Y(I)/X(I)
               ENDIF
            ELSEIF (MTRANS.EQ.6) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)/X(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.7) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = X(I)/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.8) THEN
               IF (X(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(X(I))
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.9) THEN
               IF (Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.10) THEN
               IF (X(I).GT.RTOL .AND. Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(X(I))
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.11) THEN
               TEMP = ASYMP - Y(I)
               IF (TEMP.GT.RTOL) THEN
                  TEMP = Y(I)/TEMP
                  IF (TEMP.GT.RTOL .AND. X(I).GT.RTOL) THEN
                     NT = NT + N1
                     XT(NT) = BLOG*LOG(X(I))
                     YT(NT) = BLOG*LOG(TEMP)
                  ENDIF
               ENDIF
            ELSEIF (MTRANS.EQ.12) THEN
               TEMP = X(I)
               IF (TEMP.GT.RTOL .AND.
     +             TEMP.LE.ONE) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(ONE/TEMP)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.13) THEN
               IF (Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(Y(I))
                  YT(NT) = X(I)
               ENDIF
            ELSEIF (MTRANS.EQ.14) THEN
               IF (X(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ELSEIF (MTRANS.EQ.15) THEN
               IF (X(I).GT.RTOL .AND. Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(Y(I))
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ENDIF
         ENDDO
      ELSE
C
C NTYPE .NE. 1: transform when error bars involved
C
         DO I = N1, N
            ABSXI = ABS(X(I))
            ABSXHI = ABS(XH(I))
            ABSXLI = ABS(XL(I))
            ABSYI = ABS(Y(I))
            ABSYHI = ABS(YH(I))
            ABSYLI = ABS(YL(I))
            IF (MTRANS.EQ.0) THEN
               NT = NT + N1
               XHT(NT) = XH(I)
               XLT(NT) = XL(I)
               XT(NT) = X(I)
               YHT(NT) = YH(I)
               YLT(NT) = YL(I)
               YT(NT) = Y(I)
            ELSEIF (MTRANS.EQ.1) THEN
               NT = NT + N1
               XHT(NT) = YH(I)
               XLT(NT) = YL(I)
               XT(NT) = Y(I)
               YHT(NT) = XH(I)
               YLT(NT) = XL(I)
               YT(NT) = X(I)
            ELSEIF (MTRANS.EQ.2) THEN
               IF (ABSYI.GT.RTOL .AND. ABSYHI.GT.RTOL .AND.
     +             ABSYLI.GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = XH(I)
                  XLT(NT) = XL(I)
                  XT(NT) = X(I)
                  YHT(NT) = ONE/YH(I)
                  YLT(NT) = ONE/YL(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.3) THEN
               IF (ABSXI.GT.RTOL .AND. ABSXHI.GT.RTOL .AND.
     +             ABSXLI.GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = ONE/XH(I)
                  XLT(NT) = ONE/XL(I)
                  XT(NT) = ONE/X(I)
                  YHT(NT) = YH(I)
                  YLT(NT) = YL(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.4) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL .AND.
     +             ABSXHI.GT.RTOL .AND. ABSYHI.GT.RTOL .AND.
     +             ABSXLI.GT.RTOL .AND. ABSYLI.GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = ONE/XH(I)
                  XLT(NT) = ONE/XL(I)
                  XT(NT) = ONE/X(I)
                  YHT(NT) = ONE/YH(I)
                  YLT(NT) = ONE/YL(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.5) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL .AND.
     +             ABSXHI.GT.RTOL .AND. ABSYHI.GT.RTOL .AND.
     +             ABSXLI.GT.RTOL .AND. ABSYLI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)
                  YT(NT) = Y(I)/X(I)
                  XHT(NT) = YH(I)
                  YHT(NT) = YH(I)/XH(I)
                  XLT(NT) = YL(I)
                  YLT(NT) = YL(I)/XL(I)
               ENDIF
            ELSEIF (MTRANS.EQ.6) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL .AND.
     +             ABSXHI.GT.RTOL .AND. ABSYHI.GT.RTOL .AND.
     +             ABSXLI.GT.RTOL .AND. ABSYLI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)/X(I)
                  YT(NT) = Y(I)
                  XHT(NT) = YH(I)/XH(I)
                  YHT(NT) = YH(I)
                  XLT(NT) = YL(I)/XL(I)
                  YLT(NT) = YL(I)
               ENDIF
            ELSEIF (MTRANS.EQ.7) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL .AND.
     +             ABSXHI.GT.RTOL .AND. ABSYHI.GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = XH(I)
                  XLT(NT) = XL(I)
                  XT(NT) = X(I)
                  YHT(NT) = XH(I)/YH(I)
                  YLT(NT) = XL(I)/YL(I)
                  YT(NT) = X(I)/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.8) THEN
               IF (X(I).GT.RTOL .AND. XH(I).GT.RTOL .AND.
     +             XL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = BLOG*LOG(XH(I))
                  XLT(NT) = BLOG*LOG(XL(I))
                  XT(NT) = BLOG*LOG(X(I))
                  YHT(NT) = YH(I)
                  YLT(NT) = YL(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.9) THEN
               IF (Y(I).GT.RTOL .AND. YH(I).GT.RTOL .AND.
     +             YL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = XH(I)
                  XLT(NT) = XL(I)
                  XT(NT) = X(I)
                  YHT(NT) = BLOG*LOG(YH(I))
                  YLT(NT) = BLOG*LOG(YL(I))
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.10) THEN
               IF (X(I).GT.RTOL .AND. XH(I).GT.RTOL .AND. XL(I).GT.RTOL
     +            .AND. Y(I).GT.RTOL .AND. YH(I).GT.RTOL .AND.
     +             YL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = BLOG*LOG(XH(I))
                  XLT(NT) = BLOG*LOG(XL(I))
                  XT(NT) = BLOG*LOG(X(I))
                  YHT(NT) = BLOG*LOG(YH(I))
                  YLT(NT) = BLOG*LOG(YL(I))
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.11) THEN
               TEMP = ASYMP - Y(I)
               TEMPH = ASYMP - YH(I)
               TEMPL = ASYMP - YL(I)
               IF (TEMP.GT.RTOL .AND. TEMPH.GT.RTOL .AND.
     +             TEMPL.GT.RTOL) THEN
                  TEMP = Y(I)/TEMP
                  TEMPH = YH(I)/TEMPH
                  TEMPL = YL(I)/TEMPL
                  IF (TEMP.GT.RTOL .AND. X(I).GT.RTOL .AND.
     +                TEMPH.GT.RTOL .AND. XH(I).GT.RTOL .AND.
     +                TEMPL.GT.RTOL .AND. XL(I).GT.RTOL) THEN
                     NT = NT + N1
                     XHT(NT) = BLOG*LOG(XH(I))
                     XLT(NT) = BLOG*LOG(XL(I))
                     XT(NT) = BLOG*LOG(X(I))
                     YHT(NT) = BLOG*LOG(TEMPH)
                     YLT(NT) = BLOG*LOG(TEMPL)
                     YT(NT) = BLOG*LOG(TEMP)
                  ENDIF
               ENDIF
            ELSEIF (MTRANS.EQ.12) THEN
               IF ( X(I) .GT.RTOL .AND.
     +              XH(I).GT.RTOL .AND.
     +              XL(I).GT.RTOL .AND.
     +              X(I) .LE. ONE .AND.
     +              XH(I).LE. ONE .AND.
     +              XL(I).LE. ONE) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(ONE/X(I))
                  XHT(NT) = BLOG*LOG(ONE/XH(I))
                  XLT(NT) = BLOG*LOG(ONE/XL(I))
                  YHT(NT) = YH(I)
                  YLT(NT) = YL(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.13) THEN
               IF (Y(I).GT.RTOL .AND. YH(I).GT.RTOL .AND.
     +             YL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = BLOG*LOG(YH(I))
                  XLT(NT) = BLOG*LOG(YL(I))
                  XT(NT) = BLOG*LOG(Y(I))
                  YHT(NT) = XH(I)
                  YLT(NT) = XL(I)
                  YT(NT) = X(I)
               ENDIF
            ELSEIF (MTRANS.EQ.14) THEN
               IF (X(I).GT.RTOL .AND. XH(I).GT.RTOL .AND.
     +             XL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = YH(I)
                  XLT(NT) = YL(I)
                  XT(NT) = Y(I)
                  YHT(NT) = BLOG*LOG(XH(I))
                  YLT(NT) = BLOG*LOG(XL(I))
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ELSEIF (MTRANS.EQ.15) THEN
               IF (X(I).GT.RTOL .AND. XH(I).GT.RTOL .AND. XL(I).GT.RTOL
     +            .AND. Y(I).GT.RTOL .AND. YH(I).GT.RTOL .AND.
     +             YL(I).GT.RTOL) THEN
                  NT = NT + N1
                  XHT(NT) = BLOG*LOG(YH(I))
                  XLT(NT) = BLOG*LOG(YL(I))
                  XT(NT) = BLOG*LOG(Y(I))
                  YHT(NT) = BLOG*LOG(XH(I))
                  YLT(NT) = BLOG*LOG(XL(I))
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ENDIF
         ENDDO
      ENDIF
      END
C
C
