C
C GKSVF1
C ======
C
C Plot a vector field
C
      SUBROUTINE GKSVF1 (IARROW, IKOLOR, JARROW, LCOLOR, NGKS,
     +                   HEAD, X1, X2, Y1, Y2,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
C
C ACTION  : Call LOOPD4$ to draw arrows (e.g. a vector field)
C           Arguments are input/unchanged in this version
C           IARROW : type
C           IKOLOR : colour
C           JARROW : no. of arrows
C           LCOLOR : backgound colour
C           NGKS   : transformation
C           HEAD   : size
C           X1     : head
C           X2     : tail
C           Y1     : head
C           Y2     : tail
C
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K.
C           MODIFICATION OF GKSEB4 TO DRAW ARROWS
C           29/01/2001 Introduced DEFGKS$ and dimensioned arrays
C           25/10/2004 added XGRID and XHAIRS in call to GKSMNU and GKSBOX
C           30/06/2006 introduced allocatable arrays
C           22/08/2006 introduced LABELS, calls to GKSVF2 and TRIML1, and
C                      made sure MONO = .FALSE.
C           14/09/2006 added BI_PLOT and VECTOR_FIELD as arguments in call to GKSVF2 
C           14/06/2007 removed defngks.ins and added GETGKS_LGL, etc.
C           29/12/2007 made dummy label = '%no_labels%' 
C           11/01/2008 added JCOLOR for argument list to GKSVF2
C           08/04/2008 increased labels from labels*1 to labels*11
C           19/08/2009 added call to GKSSIG$
C           19/06/2016 changed MXIC, MYTIC fro 2 to 1, i.e. 2 tick marks
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: JARROW
      INTEGER,             INTENT (IN) :: IARROW(JARROW),
     +                                    IKOLOR(JARROW),
     +                                    LCOLOR, NGKS
      DOUBLE PRECISION,    INTENT (IN) :: HEAD(JARROW),
     +                                    X1(JARROW), X2(JARROW),
     +                                    Y1(JARROW), Y2(JARROW)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL,             INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C
      DOUBLE PRECISION,     ALLOCATABLE :: XX1(:), XX2(:), YY1(:),
     +                                     YY2(:)
      CHARACTER (LEN = 11), ALLOCATABLE :: LABELS(:)
C
C Locals
C
      INTEGER    K0, K1, K2, K3, NPLOTS
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, NPLOTS = 1)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    I, IERR, KTIC, LCTEMP, MXTIC, MYTIC, LN(1), MK(1), N,
     +           NTEMP
      INTEGER    ISEND, NXFIG, NXSIG, NYFIG, NYSIG
      INTEGER    BLACK, BRIGHT_WHITE
      PARAMETER (BLACK = 1, BRIGHT_WHITE = 16)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 0)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION A, B, C, D
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  NO_LABELS*11
      PARAMETER (NO_LABELS = '%no_labels%')
      LOGICAL    HARD_COPY    
      LOGICAL    PLOT(NPLOTS)
      LOGICAL    ABORT, ASCII, FIRST, MONO, PCX, VIDEO
      LOGICAL    BOXIT, FRAME, OFFSET, TEXTS, XGRID, XHAIRS, YGRID
      LOGICAL    XTOINT, YTOINT, YVERT
      LOGICAL    BI_PLOT, VECTOR_FIELD
      EXTERNAL   MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, LOOPD4$,
     +           GSELNT$, GKSD2D$, DEFGKS$, GKSSIG$
      EXTERNAL   GETGKS_LGL
      EXTERNAL   GKSVF2
C
C Data (background colour) to avoid UNDEF
C
      SAVE LCTEMP
      DATA LCTEMP  / 15 /
C
C Initialise DEFNGKS.INS data
C
       CALL DEFGKS$
C
C Initialise then find the minimum and maximum of the X and Y values
C
      N = JARROW
      IF (N.LE.K0) RETURN
      IERR = K0
      IF (ALLOCATED(XX1)) DEALLOCATE(XX1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(XX2)) DEALLOCATE(XX2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY1)) DEALLOCATE(YY1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY2)) DEALLOCATE(YY2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(LABELS)) DEALLOCATE(LABELS, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(XX1(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(XX2(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY1(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY2(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(LABELS(1), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      LN(1) = K0
      MK(1) = K0
      PLOT(1) = .FALSE.
      CALL MAXMIN$(K0, N,
     +             X1, XMAX, XMIN)
      CALL MAXMIN$(K0, N,
     +             Y1, YMAX, YMIN)
      CALL MAXMIN$(K1, N,
     +             X2, XMAX, XMIN)
      CALL MAXMIN$(K1, N,
     +             Y2, YMAX, YMIN)
      MXTIC = K1
      MYTIC = K1
      ISEND = K1
      NXFIG = K3
      NXSIG = K3
      NYFIG = K3
      NYSIG = K3
      CALL GKSSIG$(ISEND, NXFIG, NXSIG, NYFIG, NYSIG)     
C
C Initialise GKSDEC
C
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
C
C Make sure MONO = .FALSE.
C
      MONO = .FALSE.
      KTIC = K1
      PTEXT = 'Not yet initialised'
      XTEXT = PTEXT
      YTEXT = XTEXT(1:41)
C
C Initialise plot style parameters
C
      BOXIT = .FALSE.
      FRAME = .FALSE.
      OFFSET = .TRUE.
      TEXTS = .FALSE.
      XGRID = .FALSE.
      XHAIRS = .FALSE.
      XTOINT = .FALSE.
      YGRID = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.
C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Enquire if default axes are satisfactory
C                          
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY)      
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, K1, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
C
C Call GKSBOX to set up a GKS portrait frame
C
      MONO = .FALSE.
      IF (TEXTS) THEN
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTEXT, XTEXT, YTEXT,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ELSE
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTITLE, XTITLE, YTITLE,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ENDIF
      IF (ABORT) GOTO 60
C
C Set colours then call LOOPD4$ to draw arrows
C
      LCTEMP = 15
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = 15
         ELSE
            LCTEMP = 0
         ENDIF
      ELSE
         LCTEMP = LCOLOR
      ENDIF
C
C Transform into standard coordinates before calling arrows
C
      CALL GSELNT$(K1)
C
C Now map into (0,1) type space to agree with NGKS = 0 in GSELNT$(NGKS)
C
      NTEMP = JARROW
      DO I = 1, NTEMP
         CALL GKSD2D$(X1(I), XX1(I), Y1(I), YY1(I))
         CALL GKSD2D$(X2(I), XX2(I), Y2(I), YY2(I))
      ENDDO
C
C Create the vector field
C
      CALL LOOPD4$(IARROW, IKOLOR, NTEMP, LCTEMP, NGKS,
     +             HEAD, XX1, XX2, YY1, YY2,
     +             MONO, VIDEO, BLACK, BRIGHT_WHITE)
C
C LABEL 40: decisions
C =========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      MONO = .FALSE.
      IF (ASCII) THEN
C
C Temporary code to generate dummy label...may not be used by GKSVF2
C
         LABELS(1) = NO_LABELS
         BI_PLOT = .FALSE.
         VECTOR_FIELD = .TRUE.
         CALL GKSVF2 (IARROW, IKOLOR, JARROW, JCOLOR,
     +                HEAD, X1, X2, X1, Y1, Y2, Y1,
     +                LABELS,
     +                ABORT, BI_PLOT, VECTOR_FIELD)
         IF (.NOT.ABORT) GOTO 40
      ENDIF
      IF (.NOT.ABORT) GOTO 20
C
C LABEL 60: Close down plot
C =========
C
   60 CONTINUE
      DEALLOCATE(XX1, STAT = IERR)
      DEALLOCATE(XX2, STAT = IERR)
      DEALLOCATE(YY1, STAT = IERR)
      DEALLOCATE(YY2, STAT = IERR)
      DEALLOCATE(LABELS, STAT = IERR)
      END
C
C
