c
c
      subroutine gksvf2 (iarrow, ikolor, jarrow, jcolor, 
     +                   head, x1, x2, x3, y1, y2, y3,
     +                   labels,
     +                   abort, bi_plot, vector_field)
c
c action: save arrow type files or transfer to simplot
c author: w.g.bardsley, university of manchester, uk, 21/08/2006
c         14/09/2006 altered format for biplot files to agree with barchart files
c         29/12/2007 added no_labels to deal with case when labels are not required
c         11/01/2008 added jcolor for call to gksvf6 
c
c arguments are all unchanged by this routine
c
c iarrow: arrow_type
c ikolor: arrow_colour
c jarrow: number of arrows
c   head: arrow head_size
c x1, x2, x3, y1, y2, y3: head(x1,y1), tail(x2,y2), label(x3,y3) coordinates
c labels: labels
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: jarrow
      integer,             intent (in)  :: iarrow(jarrow), 
     +                                     ikolor(jarrow), jcolor
      double precision,    intent (in)  :: head(jarrow),
     +                                     x1(jarrow), x2(jarrow),
     +                                     x3(jarrow),
     +                                     y1(jarrow), y2(jarrow),
     +                                     y3(jarrow)
      character (len = *), intent (in)  :: labels(*)
      logical,             intent (in)  :: bi_plot, vector_field
      logical,             intent (out) :: abort
c
c locals
c
      integer    i, nout, numdec, numopt, numtxt
      parameter (numopt = 5, numtxt = 22)
      integer    n1, n2, n3, n9
      parameter (n1 = 1, n2 = 2, n3 = 3, n9 = 9)
      integer    numbld(numtxt)
      character  fname*1024, text(numtxt)*100, title*80
      character  cipher1*40, cipher2*40
      character  begin_labels*13, end_labels*11, no_labels*11
      parameter (begin_labels = 'begin{labels}',
     +             end_labels = 'end{labels}',      
     +              no_labels = '%no_labels%')
      logical    repeet
      external   listbx, patch2, i1file, i2file, getnou, gettxt
      external   gksvf6
      external   nx4fil$, ofiles$
      data       numbld / numtxt*0 /
c
c check and initialise
c
      abort = .true.
      if (jarrow.lt.1) return
      if (bi_plot) then
         cipher1 = 'a biplot file'
      elseif (vector_field) then
         cipher1 = 'a vector field file'
      else
         return
      endif
      cipher2 = 'Transfer data to Simplot'
      repeet = .true.
c
c main loop
c
      do while (repeet)
         numdec = numopt - n3
         write (text,100) cipher1, cipher2
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
            if (vector_field) then
c
c save x1, x2, y1, y2
c
                call nx4fil$(jarrow,
     +                       x1, x2, y1, y2)
            elseif (bi_plot) then
c
c save x1, x2, x3, y1, y2, y3, iarrow = arrow_type, ikolor = colour, head = head_size
c
               call getnou (nout)
               call ofiles$(n1, nout,
     +                      fname,
     +                      abort)
               if (abort) then
                  close (unit = nout)
               else
C
C Get title then write header and data to the file
C
                  call gettxt ('Title of data',
     +                         title)
                  write (nout,'(a)') title
                  call i2file (nout, jarrow, n9)
                  do i = n1, jarrow
                     write (nout,'(1p,6e13.5,i4,e13.5,i4)')
     +                      x1(i), x2(i), x3(i), y1(i), y2(i), y3(i),
     +                      iarrow(i), head(i), ikolor(i)
                  enddo
c
c use begin{labels}...end{labels} 
c                  
                  if (labels(1).eq.no_labels) then
                     i = 3
                     call i1file (nout, i)
                     write (nout,'(a)') begin_labels
                     write (nout,'(a)') no_labels
                     write (nout,'(a)') end_labels
                  else   
                     i = jarrow + 2
                     call i1file (nout, i)
                     write (nout,'(a)') begin_labels
                     do i = n1, jarrow
                        write (nout,'(a)') labels(i)
                     enddo
                     write (nout,'(a)') end_labels
                  endif   
                  close (unit = nout)
               endif
            endif
         elseif (numdec.lt.numopt - n2) then
            call gksvf6 (iarrow, ikolor, jarrow, jcolor,
     +                   head, x1, x2, x3, y1, y2, y3,
     +                   labels,
     +                   bi_plot, vector_field)
         elseif (numdec.eq.numopt - n2) then
c
c help
c
            write (text,200)
            numbld(1) = 1
            numbld(8) = 1
            numbld(15) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(8) = 0
            numbld(15) = 0
         elseif (numdec.eq.numopt - n1) then
c
c default graph
c         
            abort = .false.
            repeet = .false.
         elseif (numdec.eq.numopt) then   
c
c Cancel
c
            abort = .true.
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Save As ... ',1x,a
     +/'Advanced editing ... ',1x,a
     +/'Help'
     +/'Return to default graph'
     +/'Cancel')
  200 format (
     + 'Arrow coordinate files'
     +/
     +/'From this procedure you can create an ASCII text file with the'
     +/'coordinates of the arrows previously displayed. This can then'
     +/'be input into the Simfit program Simplot for further advanced'
     +/'editing. Note: there are two types of vector field type files.'
     +/
     +/'Vector field type files (arrow coordinates only)'
     +/'These have the format:'
     +/'x1, x2, y1, y2'
     +/'where arrow heads are at (x1,y1) while tails are at (x2,y2).'
     +/'When such files are input into simplot each arrow will have the'
     +/'same type, colour, and head size.'
     +/
     +/'Biplot type files (also have label coordinates and parameters)'
     +/'These have labels plotted at (x3,y3) and have the format:'
     +/'x1, x2, x3, y1, y2, y3, type, size, colour'
     +/'so that there are additional advantages.'
     +/'1) type  `arrows can have individual arrow types'
     +/'2) size  `arrow head sizes can be adjusted individually'
     +/'3) colour`arrows can have individual colours'
     +/'4) labels`may be appended to the end of the file')
      end
c
c
