C
C GKSVF3
C ======
C
C Plot a vector field with labels
C
      SUBROUTINE GKSVF3 (IARROW, IKOLOR, JARROW, JCOLOR, LCOLOR, M,
     +                   NGKS,
     +                   HEAD, SIZE1, X1, X2, X3, Y1, Y2, Y3,  
     +                   LABEL1, LABEL2,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
C
C ACTION  : Call LOOPD4$ to draw arrows (e.g. a vector field)
C           Arguments are input/unchanged in this version
C
C           IARROW : type
C           IKOLOR : colour
C           JARROW : no. of arrows
C           JCOLOR : colour for text
C           LCOLOR : backgound colour
C           M      : label displacement type (usually 0)  
C           NGKS   : transformation (usually 0)
C           HEAD   : size of arrow head
C           SIZE1  : size of labels and also string displacement factor if M > 0
C           X1     : head
C           X2     : tail          
C           X3     : label
C           Y1     : head
C           Y2     : tail 
C           Y3     : label 
C           LABEL1 : label
C           LABEL2 : plotting key
C           PTITLE : plot title
C           XTITLE : x legend
C           YTITLE : y legend
C           AXES   : unused 
C           GSAVE  : unused 
C
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K.
C           Derived from GKSVF1, 28/08/2006
C           14/09/2006 added BI_PLOT and VECTOR_FIELD in call to GKSVF2
C           14/06/2007 removed defngks.ins and added GETGKS_LGL, etc. 
C           24/12/2007 added NO_LABELS, IWARNU, NWMAX, SIM256, and 'f$rotate.tmp' 
C           11/01/2008 added JKOLOR so label colour = arrow colour if JCOLOR out of (0,71) 
C           30/06/2009 now deletes FNAME 
C           19/08/2009 added call to GKSSIG$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: JARROW
      INTEGER,             INTENT (IN) :: IARROW(JARROW),
     +                                    IKOLOR(JARROW), JCOLOR,
     +                                    LCOLOR, M, NGKS
      DOUBLE PRECISION,    INTENT (IN) :: HEAD(JARROW), SIZE1,
     +                                    X1(JARROW), X2(JARROW),
     +                                    X3(JARROW),
     +                                    Y1(JARROW), Y2(JARROW),
     +                                    Y3(JARROW)
      CHARACTER (LEN = *), INTENT (IN) :: LABEL1(*), LABEL2(*)
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
      LOGICAL,             INTENT (IN) :: AXES, GSAVE
C
C Local allocatable arrays
C
      INTEGER,          ALLOCATABLE :: JKOLOR(:)
      DOUBLE PRECISION, ALLOCATABLE :: XX1(:), XX2(:), YY1(:), YY2(:)
      LOGICAL,          ALLOCATABLE :: PLOTX(:)
C
C Locals
C                 
      INTEGER    NOUT_PS
      INTEGER    K0, K1, K2, K3, K5, NPLOTS
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K5 = 5, 
     +           NPLOTS = 1)
      INTEGER    NCFONT, NTFONT, NXFONT, NYFONT
      PARAMETER (NCFONT = 102, NTFONT = 106, NXFONT = NTFONT,
     +           NYFONT = NTFONT)
      INTEGER    I, IERR, IOS, KTIC, LCTEMP, MXTIC, MYTIC, LN(1), MK(1),
     +           N, NTEMP 
      INTEGER    MTRANS, NIN 
      INTEGER    ISEND, NXFIG, NXSIG, NYFIG, NYSIG
      INTEGER    BLACK, BRIGHT_WHITE
      PARAMETER (BLACK = 1, BRIGHT_WHITE = 16)
      INTEGER    NWMAX
      PARAMETER (NWMAX = 2000)
      DOUBLE PRECISION XTRA, ZERO
      PARAMETER (XTRA = 0.05D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XPC, XPT, XPX, XPY
      PARAMETER (XPC = 1.5D+00, XPT = 2.0D+00, XPX = 1.75D+00,
     +           XPY = 1.75D+00)
      DOUBLE PRECISION ASYMP, A, B, C, D, DELTA, XPC1, Y_SCALE
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      CHARACTER  PTEXT*50, XTEXT*55, YTEXT*41
      CHARACTER  FNAMEX*1024  
      CHARACTER  FNAME*1024, SIM256*1024 
      CHARACTER  BLANK*1, NO_LABELS*11
      PARAMETER (BLANK = ' ', NO_LABELS = '%no_labels%')
      LOGICAL    HARD_COPY, HPGL, PS
      LOGICAL    NATLOG(11), PLOT(NPLOTS)
      LOGICAL    ABORT, ASCII, FIRST, MONO, PCX, VIDEO
      LOGICAL    BOXIT, FRAME, OFFSET, TEXTS, XGRID, XHAIRS, YGRID
      LOGICAL    XTOINT, YTOINT, YVERT
      LOGICAL    BI_PLOT, PLOT_LABELS, VECTOR_FIELD      
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   MAXMIN$, GKSDEC$, GKSMNU$, GKSBOX$, LOOPD4$,
     +           GSELNT$, GKSD2D$, DEFGKS$, PLTLAB$, GKSSIG$ 
      EXTERNAL   GETGKS_LGL, GETGKS_EPS, GETGKS_REL
      EXTERNAL   GKSVF2, GETNOU, DELEET, GETTMP, SIM256
C
C Data (background colour) to avoid UNDEF
C
      SAVE LCTEMP
      DATA LCTEMP  / 15 /
C
C Initialise FNAME
C      
      FNAME = BLANK
C
C Check for plotting labels
C      
      IF (LABEL1(1).EQ.NO_LABELS) THEN
         PLOT_LABELS = .FALSE.
      ELSE
         PLOT_LABELS = .TRUE.
      ENDIF      
C
C Check JARROW to see if only arrows can be plotted
C      
      IF (JARROW.LT.K1) THEN
         RETURN
      ELSEIF (PLOT_LABELS .AND. JARROW.GT.NWMAX) THEN
         PLOT_LABELS = .FALSE.   
      ENDIF   
C
C Initialise DEFNGKS.INS data
C                   
       CALL DEFGKS$ 
       CALL GETGKS_EPS (NOUT_PS,
     +                  PS)
       CALL GETGKS_LGL (K3,
     +                  HPGL) 
       CALL GETGKS_REL (K5,
     +                  Y_SCALE)                     
C
C Initialise then find the minimum and maximum of the X and Y values
C
      N = JARROW
      IF (N.LE.K0) RETURN
      IERR = K0
      IF (ALLOCATED(XX1)) DEALLOCATE(XX1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(XX2)) DEALLOCATE(XX2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY1)) DEALLOCATE(YY1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY2)) DEALLOCATE(YY2, STAT = IERR)
      IF (IERR.NE.K0) RETURN  
      IF (ALLOCATED(PLOTX)) DEALLOCATE (PLOTX, STAT = IERR)
      IF (IERR.NE.K0) RETURN  
      ALLOCATE(XX1(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(XX2(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY1(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY2(JARROW), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE (PLOTX(NWMAX), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (PLOT_LABELS) THEN
         IF (ALLOCATED(JKOLOR)) DEALLOCATE(JKOLOR, STAT = IERR)
         IF (IERR.NE.K0) RETURN
         ALLOCATE (JKOLOR(JARROW), STAT = IERR)
         IF (IERR.NE.K0) RETURN
         IF (JCOLOR.GE.0 .AND. JCOLOR.LE.71) THEN
            DO I = 1, JARROW
               JKOLOR(I) = JCOLOR
            ENDDO
         ELSE
            DO I = 1, JARROW
               JKOLOR(I) = IKOLOR(I)
            ENDDO
         ENDIF                  
      ENDIF    
      LN(1) = 0
      MK(1) = 0
      PLOT(1) = .FALSE.
      CALL MAXMIN$(K0, N,
     +             X1, XMAX, XMIN)
      CALL MAXMIN$(K0, N,
     +             Y1, YMAX, YMIN)
      CALL MAXMIN$(K1, N,
     +             X2, XMAX, XMIN)
      CALL MAXMIN$(K1, N,
     +             Y2, YMAX, YMIN)   
      DELTA = XTRA*(XMAX - XMIN)
      XMIN = XMIN - DELTA
      XMAX = XMAX + DELTA
      DELTA = XTRA*(YMAX - YMIN)
      YMIN = YMIN - DELTA
      YMAX = YMAX + DELTA
      MXTIC = K2
      MYTIC = K2
      ISEND = K1
      NXFIG = K3
      NXSIG = K3
      NYFIG = K3
      NYSIG = K3
      CALL GKSSIG$(ISEND, NXFIG, NXSIG, NYFIG, NYSIG)
C
C Initialise GKSDEC
C                       
      MTRANS = K0
      FIRST = .TRUE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
C
C But re-set MONO = .FALSE.
C
      MONO = .FALSE.
      KTIC = K1
      PTEXT = 'Not yet initialised'
      XTEXT = PTEXT
      YTEXT = XTEXT(1:41)
C
C Initialise plot style parameters
C
      BOXIT = .FALSE.
      FRAME = .FALSE.
      OFFSET = .TRUE.
      TEXTS = .FALSE.
      XGRID = .FALSE.
      XHAIRS = .FALSE.
      XTOINT = .FALSE.
      YGRID = .FALSE.
      YTOINT = .FALSE.
      YVERT = .FALSE.       
      DO I = K1, 11
         NATLOG(I) = .TRUE.
      ENDDO   
C
C Create the labels file
C      
      CALL GETTMP (I,
     +             FNAMEX) 
      CALL GETNOU (NIN) 
      OPEN (UNIT = NIN, FILE = FNAMEX)    
      IF (PLOT_LABELS) THEN
        
C
C******************************************************************
C The next lines must not be translated or altered in any way
C
           
         WRITE (NIN,'(A)',IOSTAT=IOS) '%simfitplotlabelsfile%' 
         WRITE (NIN,'(2I6)',IOSTAT=IOS) JARROW, K2
         DO I = K1, JARROW
            WRITE (NIN,'(1P,2E13.5)',IOSTAT=IOS) X3(I), Y3(I)
            PLOTX(I) = .TRUE.
         ENDDO 
         CLOSE (UNIT = NIN)
         
         FNAME = SIM256('f$rotate.tmp')
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)',IOSTAT=IOS) '%simfitrotatelabelsfile%'
         WRITE (NIN,'(2I6)',IOSTAT=IOS) JARROW, K5
         DO I = K1, JARROW
            WRITE (NIN,'(1P,5E13.5)',IOSTAT=IOS) X3(I), ZERO, Y3(I),
     +                                           ZERO, ZERO
         ENDDO
         
      ELSE
        
         WRITE (NIN,'(A)',IOSTAT=IOS)
     +'%simfitplotlabelsfile%no_labels%'
         CLOSE (UNIT = NIN)
         
         FNAME = SIM256('f$rotate.tmp')
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)',IOSTAT=IOS)
     +'%simfitrotatelabelsfile%no_labels'
        
      ENDIF 
      CLOSE (UNIT = NIN)  
C      
C******************************************************************
C

C
C LABEL 20: Loop to call graph repeatedly
C =========
C
   20 CONTINUE
C
C Enquire if default axes are satisfactory
C                          
      CALL GETGKS_LGL (K2,
     +                 HARD_COPY)       
      IF (.NOT.FIRST .AND. .NOT.PCX .AND. .NOT.HARD_COPY) THEN
          CALL GKSMNU$(KTIC, K1, LN, MK, MXTIC, MYTIC, NPLOTS,
     +                 XMAX, XMIN, YMAX, YMIN,
     +                 PTEXT, XTEXT, YTEXT,
     +                 AXES, BOXIT, FRAME, MONO, OFFSET, PLOT,
     +                 TEXTS, VIDEO, XGRID, XHAIRS, YGRID)
      ENDIF
C
C Call GKSBOX to set up a GKS portrait frame
C        
      MONO = .FALSE.
      IF (TEXTS) THEN
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTEXT, XTEXT, YTEXT,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ELSE
         CALL GKSBOX$(KTIC, K1, K1, MXTIC, MYTIC,
     +                NCFONT, NTFONT, NXFONT, NYFONT,
     +                A, B, C, D,
     +                ZERO, ZERO, ZERO, ZERO, XMAX, XMIN,
     +                XPC, XPT, XPX, XPY, YMAX, YMIN,
     +                PTITLE, XTITLE, YTITLE,
     +                ABORT, BOXIT, FRAME, MONO, OFFSET, VIDEO,
     +                XGRID, XHAIRS, XTOINT, YGRID, YTOINT, YVERT)
      ENDIF
      IF (ABORT) GOTO 60
C
C Set colours then call LOOPD4$ to draw arrows
C
      LCTEMP = 15
      IF (MONO) THEN
         IF (VIDEO) THEN
            LCTEMP = 15
         ELSE
            LCTEMP = 0
         ENDIF
      ELSE
         LCTEMP = LCOLOR
      ENDIF
C
C Transform into standard coordinates before calling arrows
C
      CALL GSELNT$(K1)
C
C Now map into (0,1) type space to agree with NGKS = 0 in GSELNT$(NGKS)
C
      NTEMP = JARROW
      DO I = 1, NTEMP
         CALL GKSD2D$(X1(I), XX1(I), Y1(I), YY1(I))
         CALL GKSD2D$(X2(I), XX2(I), Y2(I), YY2(I))
      ENDDO
C
C Create the vector field
C
      CALL LOOPD4$(IARROW, IKOLOR, NTEMP, LCTEMP, NGKS,
     +             HEAD, XX1, XX2, YY1, YY2,
     +             MONO, VIDEO, BLACK, BRIGHT_WHITE)

C
C Draw labels: SIZE1 scales the font and also displacement to use if  M > 0  
C          
       IF (PLOT_LABELS) THEN            
          CALL GETGKS_EPS (NOUT_PS,
     +                     PS)
          CALL GETGKS_LGL (K3,
     +                     HPGL) 
          CALL GETGKS_REL (K5,
     +                     Y_SCALE)          
         ASYMP = ZERO 
         NTEMP = JARROW 
         CLOSE (UNIT = NIN)   
         XPC1 = SIZE1*XPC
         CALL PLTLAB$(JKOLOR, M, MTRANS, NCFONT, NIN, NTEMP, NOUT_PS,
     +                NTEMP,
     +                ASYMP, SIZE1, XX2, XMAX, XMIN, XPC1, XX1, YY2,
     +                YMAX, YMIN, Y_SCALE, YY1,
     +                FNAMEX, LABEL1, LABEL2, 
     +                HARD_COPY, HPGL, MONO, NATLOG, PLOTX, PS, VIDEO)
         CLOSE (UNIT = NIN)        
      ENDIF   
C
C LABEL 40: decisions
C =========
C
   40 CONTINUE
      FIRST = .FALSE.
      CALL GKSDEC$(ABORT, ASCII, FIRST, GSAVE, MONO, PCX, VIDEO)
      MONO = .FALSE.
      IF (ASCII) THEN  
         BI_PLOT = .TRUE.
         VECTOR_FIELD = .FALSE.
         CALL GKSVF2 (IARROW, IKOLOR, JARROW, JCOLOR,
     +                HEAD, X1, X2, X3, Y1, Y2, Y3,
     +                LABEL1,
     +                ABORT, BI_PLOT, VECTOR_FIELD)
         IF (.NOT.ABORT) GOTO 40
      ENDIF
      IF (.NOT.ABORT) GOTO 20
C
C LABEL 60: Close down plot
C =========
C
   60 CONTINUE
      CALL DELEET (FNAMEX,
     +             ASKIF, THERE)
      CALL DELEET (FNAME,
     +             ASKIF, THERE)
      IF (ALLOCATED(JKOLOR)) DEALLOCATE(JKOLOR, STAT = IERR)   
      DEALLOCATE(XX1, STAT = IERR)
      DEALLOCATE(XX2, STAT = IERR)
      DEALLOCATE(YY1, STAT = IERR)
      DEALLOCATE(YY2, STAT = IERR)
      DEALLOCATE(PLOTX, STAT = IERR)
      END
C
C
