 
c
c
      subroutine gksvf4 (lwork, ncol, nrow, ntype,
     +                   d, work, 
     +                   label1, label2,
     +                   ptitle, xtitle, ytitle)    
c
c action: prepare data for a biplot
c author: w.g.bardsley, university of manchester, u.k., 27/08/2006 
c         20/06/2007 added options for rows or columns only and new arrow types
c         22/12/2007 extensive revision for version 6
c         29/12/2007 added nwmax
c
c  lwork: (input/unchanged) dimension
c   ncol: (input/unchanged) no. of columns
c   nrow: (input/unchanged) no. of rows
c  ntype: (input/unchanged) matrix type, i.e. 1 = data, 2 = residual
c      d: (input/unchanged) singular values
c   work: (input/unchanged) contains U and Vt from SVD
c label1: (input/output) labels...may be edited
c label2: (input/output) keys...may be edited
c ptitle: (input/output) plot title...may be edited     
c xtitle: (input/output) x legend...may be edited
c ytitle: (input/output) y legend...may be edited
c
      implicit   none  
c
c arguments
c      
           
      integer,             intent (in)    :: lwork, ncol, nrow, ntype
      double precision,    intent (in)    :: d(3), work(lwork)
      character (len = *), intent (inout) :: label1(*),
     +                                       label2(*),
     +                                       ptitle, xtitle, ytitle
c
c local allocatable arrays
c      
      integer,          allocatable :: iarrow(:), ikolor(:)        
      double precision, allocatable :: head(:),
     +                                 x1(:), x2(:), x3(:),
     +                                 y1(:), y2(:), y3(:)
c
c locals
c       
      integer    itype, ktype, m, method, ngks, numdec, numopt, numsta,
     +           numtxt, nwmax, nsav
      parameter (itype = 5, m = 0, ngks = 0, nwmax = 2000)
      integer    i, ierr, j, jarrow, k, n, nhigh, nlines, nwide 
      integer    numbld(20)
      integer    iarr_c, iarr_r, ikol_c, ikol_r, jcolor, lcolor
      double precision d1, d2, u1, u2, vt1, vt2, s1, s2, xsize
      double precision alpha, a1, a2, a3, a4, scale_c, scale_r
      double precision head_c, head_r, size1  
      double precision arrow_size, ssq1, ssq2, text_size
      parameter (arrow_size = 0.01d+00, text_size = 0.75d+00)  
      double precision zero, one, fact1, fact2
      parameter (zero = 0.0d+00, one = 1.0d+00, fact1 = 1.05d+00,
     +           fact2 = 1.1d+0)
      character  mtype(4)*45, matrix(2)*20, text(30)*100, word11*11 
      character  atype(0:21)*20, savlab*40, stype(3)*20 
      character  no_labels*11, too_many*80
c
c %no_labels% must NOT be translated as it indicates not to plot labels
c      
      parameter (
     +no_labels = '%no_labels%', 
     +too_many = 'Too many labels requested ... maxmimum = 2000')
      logical    plot_labels, repeet, store
      logical    axes, gsave
      parameter (axes = .true., gsave = .true., store = .true.)
      external   gksvf3, lstbox, getd01, listbx, patch2, edittx, getdm1 
      external   palett$, fsizes$, putfat$
      intrinsic  sqrt, len                                 
      save       ktype, method 
      save       scale_c, scale_r 
      save       iarr_c, iarr_r, ikol_c, ikol_r     
      save       head_c, head_r, size1 
      save       jcolor, lcolor
      save       alpha
      data       alpha / 0.5d+00 /
      data       iarr_c, iarr_r, ikol_c, ikol_r / 
     +               21,     20,      9,     12 /
      data           head_c,     head_r,     size1 /
     +           arrow_size, arrow_size, text_size /  
      data       jcolor, lcolor / -1, 15 /   
      data       ktype, method / 2, 1 /    
      data       scale_c, scale_r / one, one /
      data       matrix / 'Original data      ',
     +                    'Residual matrix    ' / 
      data       mtype / 'Symmetric: U*sqrt(sigma), V^T*sqrt(sigma)   ',
     +                   'Row emphasis: U*sigma, V^T                  ',
     +                   'Column emphasis: U, V^T*sigma               ',
     +                   'User-defined: U*sigma^{t}, V^T*sigma^{1 - t}'/   
      data       stype / 'No-scaling          ',
     +                   'Auto-scaling        ',
     +                   'User-defined scaling' /
      data       numbld / 20*0 / 
      data       atype / 'None                ',
     +                   'Arrow: normal       ', 
     +                   'Arrow: hollow       ',
     +                   'Arrow: solid        ', 
     +                   'Line: solid         ',
     +                   'Line: dashed        ', 
     +                   'Line: dotted        ', 
     +                   'Line: dash-dot      ', 
     +                   '                    ',
     +                   '                    ',
     +                   '                    ', 
     +                   '                    ',
     +                   '                    ',
     +                   '                    ',
     +                   '                    ', 
     +                   '                    ', 
     +                   'Arrow: dashed       ', 
     +                   'Symbol: plus        ',
     +                   'Symbol: times       ', 
     +                   'Symbol: asterisk    ',
     +                   'Arrow: script-solid ', 
     +                   'Arrow: script-dashed' /
c
c initialise
c                 
      if (ntype.eq.1) then
c
c analyse the data matrix
c      
         d1 = d(1)
         d2 = d(2)
      elseif (ntype.eq.2) then
c
c analyse the residual matrix
c      
         d1 = d(2)
         d2 = d(3)
      else  
c
c ntype not valid
c      
         return
      endif
c
c define plot_labels
c       
      if (ncol + nrow.gt.nwmax .or. label1(1).eq.no_labels) then
         plot_labels = .false.
      else
         plot_labels = .true.
      endif      
c
c define s1, s2 depending on d1, d2, i.e. ntype of course 
c      
      s1 = sqrt(d1)
      s2 = sqrt(d2)   
c
c define a1, a2, a3, and a4 
c           
      a1 = d1**alpha
      a2 = d2**alpha
      a3 = d1**(one - alpha)
      a4 = d2**(one - alpha)
c
c allocate
c         
      ierr = 0
      if (allocated(iarrow)) deallocate(iarrow, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(ikolor)) deallocate(ikolor, stat = ierr)
      if (ierr.ne.0) return           
      if (allocated(head)) deallocate(head, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(x2)) deallocate(x2, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(x3)) deallocate(x3, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(y2)) deallocate(y2, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(y3)) deallocate(y3, stat = ierr)
      if (ierr.ne.0) return
      n = ncol + nrow
      allocate (iarrow(n), stat = ierr)
      if (ierr.ne.0) return  
      allocate (ikolor(n), stat = ierr)
      if (ierr.ne.0) return          
      allocate (head(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (x1(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (x2(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (x3(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (y1(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (y2(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (y3(n), stat = ierr)
      if (ierr.ne.0) return  
c
c initialise the arrow parameters
c      
      do i = 1, nrow
         iarrow(i) = iarr_r
         ikolor(i) = ikol_r
         head(i) = head_r
      enddo  
      do i = nrow + 1, n
         iarrow(i) = iarr_c
         ikolor(i) = ikol_c
         head(i) = head_c
      enddo     
      do i = 1, n
         x2(i) = zero
         y2(i) = zero
      enddo            
c
c main loop
c          
      repeet = .true.
      do while (repeet)
         if (method.eq.4) then
            write (word11,'(a5,f6.3)') ', t =', alpha
         else
            word11 = ' '
         endif       
         write (text,100) matrix(ntype), mtype(method), word11,
     +                    stype(ktype)
         numopt = 12
         numsta = 6
         numtxt = numsta + numopt - 1
         numbld(1) = 4 
         numdec = numopt - 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.ge.1 .and. numdec.le.3 .and.
     +       ncol + nrow.gt.nwmax) then
             call putfat$(too_many)
             numdec = 0
         endif             
         if (numdec.ge.1 .and. numdec.le.6) then   
c
c numdec = 1 to 6: create a biplot
c ===============
c         
            if (ntype.eq.1) then  
               j = 0
               k = 4*nrow 
            else
               j = nrow
               k = 4*nrow + ncol 
            endif       
            if (method.eq.1) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  x1(i) = s1*u1
                  y1(i) = s2*u2
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  x1(i) = s1*vt1
                  y1(i) = s2*vt2
               enddo
            elseif (method.eq.2) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  x1(i) = d1*u1
                  y1(i) = d2*u2
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  x1(i) = vt1
                  y1(i) = vt2
               enddo 
             elseif (method.eq.3) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  x1(i) = u1
                  y1(i) = u2
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  x1(i) = d1*vt1
                  y1(i) = d2*vt2
               enddo 
            elseif (method.eq.4) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  x1(i) = a1*u1
                  y1(i) = a2*u2
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  x1(i) = a3*vt1
                  y1(i) = a4*vt2
               enddo              
            endif      
c
c scale the arrow cordinates
c          
             if (ktype.eq.1) then
c
c no scaling but x3, y3 moved to centrifuge out the labels
c               
               do i = 1, n
                  x3(i) = x1(i)
                  y3(i) = y1(i)
                  if (x3(i).ge.zero) then   
                     x3(i) = fact1*x3(i)
                     if (y3(i).ge.zero) then 
                       y3(i) = fact1*y3(i)
                     else
                       y3(i) = fact2*y3(i)
                     endif    
                  elseif (y3(i).ge.zero) then
                     x3(i) = fact1*x3(i)
                     y3(i) = fact1*y3(i)
                  else
                     x3(i) = fact2*x3(i)
                     y3(i) = fact2*y3(i)     
                  endif   
               enddo 
            elseif (ktype.eq.2) then
c
c scaling so largest vector in each set has length = 1
c            
               ssq1 = zero
               ssq2 = zero
               do i = 1, nrow
                  ssq2 = x1(i)**2 + y1(i)**2  
                  if (ssq2.gt.ssq1) ssq1 = ssq2
               enddo
               ssq2 = sqrt(ssq1)
               if (ssq2.gt.zero) then
                  do i = 1, nrow
                     x1(i) = x1(i)/ssq2
                     y1(i) = y1(i)/ssq2
                  enddo
               endif          
               ssq1 = zero
               ssq2 = zero
               do i = nrow + 1, n 
                  ssq2 = x1(i)**2 + y1(i)**2
                  if (ssq2.gt.ssq1) ssq1 = ssq2
               enddo
               ssq2 = sqrt(ssq1)
               if (ssq2.gt.zero) then
                  do i = nrow + 1, n
                     x1(i) = x1(i)/ssq2
                     y1(i) = y1(i)/ssq2
                  enddo
               endif  
               do i = 1, n
                  x3(i) = x1(i)
                  y3(i) = y1(i)
                  if (x3(i).ge.zero) then   
                     x3(i) = fact1*x3(i)
                     if (y3(i).ge.zero) then 
                       y3(i) = fact1*y3(i)
                     else
                       y3(i) = fact2*y3(i)
                     endif    
                  elseif (y3(i).ge.zero) then
                     x3(i) = fact1*x3(i)
                     y3(i) = fact1*y3(i)
                  else
                     x3(i) = fact2*x3(i)
                     y3(i) = fact2*y3(i)     
                  endif   
               enddo              
            elseif (ktype.eq.3) then
c
c user chooses scaling factors
c            
               do i = 1, nrow
                  x1(i) = scale_r*x1(i)
                  y1(i) = scale_r*y1(i)
                  x3(i) = x1(i)
                  y3(i) = y1(i)
               enddo 
               do i = nrow + 1, n 
                  x1(i) = scale_c*x1(i)
                  y1(i) = scale_c*y1(i)
                  x3(i) = x1(i)
                  y3(i) = y1(i)
               enddo 
               do i = 1, n
                  if (x3(i).ge.zero) then   
                     x3(i) = fact1*x3(i)
                     if (y3(i).ge.zero) then 
                       y3(i) = fact1*y3(i)
                     else
                       y3(i) = fact2*y3(i)
                     endif    
                  elseif (y3(i).ge.zero) then
                     x3(i) = fact1*x3(i)
                     y3(i) = fact1*y3(i)
                  else
                     x3(i) = fact2*x3(i)
                     y3(i) = fact2*y3(i)     
                  endif   
               enddo 
            endif
c
c display the biplot
c                    
            if (numdec.ge.4 .and. numdec.le.6) then
               if (numdec.lt.6) then
                  nsav = 1
               else
                  nsav = nrow + 1
               endif    
               savlab = label1(nsav)
               label1(nsav) = no_labels
            endif   
            if (numdec.eq.1 .or. numdec.eq.4) then
c
c numdec = 1 or 4: rows and columns
c ================
c              
               jarrow = n
               call gksvf3 (iarrow, ikolor, jarrow, jcolor, lcolor, m,
     +                      ngks, 
     +                      head, size1, x1, x2, x3, y1, y2, y3,
     +                      label1, label2, ptitle, xtitle, ytitle,
     +                      axes, gsave)
           elseif (numdec.eq.2 .or. numdec.eq.5) then 
c
c numdec = 2 or 5: rows only
c ================
c           
               jarrow = nrow
               call gksvf3 (iarrow, ikolor, jarrow, jcolor, lcolor, m,
     +                      ngks, 
     +                      head, size1, x1, x2, x3, y1, y2, y3,
     +                      label1, label2, ptitle, xtitle, ytitle,
     +                      axes, gsave) 
           elseif (numdec.eq.3 .or. numdec.eq.6) then 
c
c numdec = 3 or 6: columns only
c ================
c           
               jarrow = ncol
               if (plot_labels) then
                  i = nrow + 1
               else
                  i = 1
               endif      
               call gksvf3 (iarrow(i), ikolor(i), jarrow, jcolor,
     +                      lcolor, m, ngks, 
     +                      head(i), size1, x1(i), x2(i), x3(i),
     +                      y1(i), y2(i), y3(i),
     +                      label1(i), label2(i),
     +                      ptitle, xtitle, ytitle,
     +                      axes, gsave) 
           endif 
           if (numdec.ge.4 .and. numdec.le.6) then
              label1(nsav) = savlab
           endif   
        elseif (numdec.eq.7) then  
c             
c numdec = 7: change method
c ===========
c        
           numopt = 4
           call listbx (method, numopt,
     +                  mtype) 
           if (method.eq.4) then
              call getdm1 (zero, alpha, one,
     +                     'exponent t in U*sigma^t,V^T*sigma^{1 - t}')
              a1 = d1**alpha
              a2 = d2**alpha
              a3 = d1**(one - alpha)
              a4 = d2**(one - alpha)
           endif                 
        elseif (numdec.eq.8) then
c
c numdec = 8: change scaling factors
c ===========
c        
           numopt = 3
           call listbx (ktype, numopt,
     +                  stype)
           if (ktype.eq.3) then            
              call getd01 (scale_r, 
     +                     'row scaling factor required')
              call getd01 (scale_c, 
     +                     'column scaling factor required')
           endif 
        elseif (numdec.eq.9) then   
c
c numdec = 9: edit the arrows
c ===========
c        
           write (text,200) atype(iarr_c), atype(iarr_r),
     +                      ikol_c, ikol_r,
     +                      head_c/arrow_size, head_r/arrow_size           
           numopt = 7
           numdec = numopt
           call listbx (numdec, numopt,
     +                  text)
           if (numdec.eq.1) then 
              write (text,300)
              numdec = 1
              numopt = 15
              call listbx (numdec, numopt,
     +                     text)              
              if (numdec.eq.1) then
                 iarr_c = 1
              elseif (numdec.eq.2) then
                 iarr_c = 16
              elseif (numdec.eq.numopt - 1) then
                 iarr_c = 0
              elseif (numdec.lt.numopt - 4) then
                 iarr_c = numdec - 1      
              elseif (numdec.ne.numopt) then
                 iarr_c = numdec + 8   
              endif  
              if (numdec.ne.numopt) then          
                 do i = nrow + 1, n  
                    iarrow(i) = iarr_c
                 enddo
              endif   
           elseif (numdec.eq.2) then
              write (text,300)
              numdec = 1
              numopt = 15
              call listbx (numdec, numopt,
     +                     text)              
              if (numdec.eq.1) then
                 iarr_r = 1
              elseif (numdec.eq.2) then
                 iarr_r = 16
              elseif (numdec.eq.numopt - 1) then
                 iarr_r = 0
              elseif (numdec.lt.numopt - 6) then
                 iarr_r = numdec - 1  
              elseif (numdec.ne.numopt) then
                 iarr_r = numdec + 8   
              endif
              if (numdec.ne.numopt) then            
                 do i = 1, nrow
                    iarrow(i) = iarr_r
                 enddo                           
              endif   
           elseif (numdec.eq.3) then 
              i = 0
              call palett$(ikol_c, i)
              do i = nrow + 1, n
                 ikolor(i) = ikol_c
              enddo 
           elseif (numdec.eq.4) then 
              i = 0
              call palett$(ikol_r, i)
              do i = 1, nrow
                 ikolor(i) = ikol_r
              enddo
           elseif (numdec.eq.5) then 
              head_c = head_c/arrow_size
              call getd01 (head_c,
     +                     'column arrow head size required')
              head_c = head_c*arrow_size
              do i = nrow + 1, n
                 head(i) = head_c
              enddo
           elseif (numdec.eq.6) then
              head_r = head_r/arrow_size
              call getd01 (head_r,
     +                     'row arrow head size required')
              head_r = head_r*arrow_size
              do i = 1, nrow
                 head(i) = head_r
              enddo 
           endif 
        elseif (numdec.eq.10) then
c
c numdec = 10: edit the labels
c ===========
c                                   
           numopt = 6
           numdec = numopt
           write (text,400) size1/text_size
           call listbx (numdec, numopt,
     +                  text)
           if (numdec.eq.1) then
c
c jcolor out of range (0,71) forces label colour = arrow colour
c             
              jcolor = -1
           elseif (numdec.eq.2) then
c
c jcolor in range (0,71) forces fixed label colour
c           
              i = 0
              jcolor = 0
              call palett$(jcolor, i)
           elseif (numdec.eq.3) then    
              xsize = size1/text_size
              call fsizes$(itype, 
     +                     xsize, 
     +                     store)
              size1 = xsize*text_size  
           elseif (numdec.eq.4) then
              if (nrow.gt.nwmax) then
                 call putfat$(too_many)
              else    
                 nhigh = nrow
                 nwide = len(label1(1))
                 call edittx (nhigh, nlines, nwide,
     +                        label1(1)) 
              endif 
           elseif (numdec.eq.5) then
              if (ncol.gt.nwmax) then
                 call putfat$(too_many)
              else   
                 nhigh = ncol
                 nwide = len(label1(1))
                 call edittx (nhigh, nlines, nwide,
     +                     label1(nrow + 1)) 
              endif
           endif                            
        elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c        
           write (text,1000)
           numtxt = 20
           numbld(1) = 1
           call patch2 (numbld, numtxt,
     +                  text)           
        elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================ 
c        
           repeet = .false.
        endif
      enddo
c
c deallocate temporary workspaces
c     
      deallocate(iarrow, stat = ierr)   
      deallocate(ikolor, stat = ierr)  
      deallocate(head, stat = ierr)   
      deallocate(x1, stat = ierr)      
      deallocate(x2, stat = ierr)
      deallocate(x3, stat = ierr)    
      deallocate(y1, stat = ierr)  
      deallocate(y2, stat = ierr)
      deallocate(y3, stat = ierr)    
c
c format statements
c      
  100 format (
     + 'Biplot using',1x,a
     +/
     +/'Method:',1x,a,1x,a
     +/'Scaling:',1x,a
     +/
     +/'Biplot with labels: rows and columns' 
     +/'Biplot with labels: rows only'
     +/'Biplot with labels: columns only'
     +/'Biplot without labels: rows and columns' 
     +/'Biplot without labels: rows only'
     +/'Biplot without labels: columns only'
     +/'Change: method'
     +/'Change: scaling'
     +/'Change: arrows'
     +/'Change: labels'
     +/'Help'
     +/'Cancel')  
  200 format (
     + 'Change arrow type: column ...',1x,a   
     +/'Change arrow type: row ...',1x,a
     +/'Change arrow colour: column (',i3,')'
     +/'Change arrow colour: row (',i3,')'
     +/'Change arrow size: column (',f7.3,')'
     +/'Change arrow size: row (',f7.3,')'
     +/'Cancel ... no changes')                             
  300 format (
     + 'Arrow: normal'
     +/'Arrow: dashed'
     +/'Arrow: hollow'
     +/'Arrow: solid'
     +/'Line: solid'
     +/'Line: dashed'
     +/'Line: dotted'
     +/'Line: dashed-dotted' 
     +/'Symbol: plus'
     +/'Symbol: multiply' 
     +/'Symbol: asterisk'
     +/'Script arrow head: solid shaft'
     +/'Script arrow head: dashed shaft'
     +/'Suppress'
     +/'Cancel ... no changes')
  400 format (             
     + 'Set label colour = arrow colour'       
     +/'Set label colour = fixed colour'
     +/'Change label size (',f7.3,')'  
     +/'Edit row labels'
     +/'Edit column labels'
     +/'Cancel ... no changes')
 1000 format (
     + 'Fine tuning a biplot'
     +/
     +/'The default setting is general emphasis with auto-scaling, and'
     +/'this should suffice for a simple preliminary investigation for'
     +/'parallelism and orthogonality. For final hardcopy you may need'
     +/'to investigate the other methods and scaling options, observing'
     +/'as follows.'
     +/                       
     +/'1)`Please take note whether you are using sigma(1) and sigma(2)'
     +/'  `(i.e. the original data matrix) or sigma(2) and sigma(3)'
     +/'  `(i.e. the the residual matrix).' 
     +/'1)`Change the sign of scaling factors to reflect the arrows'  
     +/'  `if you find it helpful'
     +/'2)`Change the size of scaling factors if one set dominates' 
     +/'  `the plot, obscuring the smaller vectors' 
     +/'3)`Fine tuning can be used to re-position labels for clarity'
     +/'  `if you find labels and arrows overlapping inconveniently.'
     +/'  `This is done using the option to transfer to Simplot.'
     +/'4)`Biplot files save all the details of biplots so that they'
     +/'  `can be reproduced in program Simplot for advanced editing.')     
      end
c
c 


                                    
           
                
                          