c
c
      subroutine gksvf5 (narrow, nin, nmax, nwords,
     +                   xmax, xmin, ymax, ymin, 
     +                   fname,
     +                   abort, bi_plot, vector_field)
c
c action: check if file fname is a valid biplot or vector field file
c author: w.g.bardsley, university of manchester, u.k., 12/09/2006 
c         27/12/2007 allowed arrow types =< 21  
c         31/12/2007 removed check for number of labels
c
c       narrow: (output) number of arrows required
c          nin: (input/unchanged) unconnected unit for data input
c         nmax: (input/unchanged) maximum array size allowed for arrows
c       nwords: (input/unchanged) maximum array size allowed for labels
c       xmax, xmin, ymax, ymin: (output) limits 
c        fname: (input/unchanged) file with data
c        abort: (output) error indicator
c      bi_plot: (output) .true. if fname is a consistent 9 column biplot file
c vector_field: (output) .true. if fname is a consistent 4 column vector field file
c
      implicit none
c
c arguments
c
      integer,             intent (out) :: narrow
      integer,             intent (in)  :: nin, nmax, nwords 
      double precision,    intent (out) :: xmax, xmin, ymax, ymin
      character (len = *), intent (in)  :: fname
      logical,             intent (out) :: abort, bi_plot, vector_field
c
c locals
c
      integer    i, iarrow, ikolor, ios, ncol, nrow
      double precision head, x1, x2, x3, y1, y2, y3
      double precision temp1, temp2 
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      logical    there
      external   putfat$
      external   isitmf
      intrinsic  max, min, nint
c
c initialise
c
      narrow = 0
      abort = .true.
      bi_plot = .false. 
      vector_field = .false.
      if (nmax.lt.1 .or. nwords.lt.1) return
c
c check
c
      inquire (file = fname, exist = there)
      if (.not.there) then
         write (line,100)
         call putfat$(line)
         return
      endif
      call isitmf (ncol, nrow,
     +             fname)
      if (ncol.ne.4 .and. ncol.ne.9) then
         write (line,200)
         call putfat$(line)
         return
      endif           
      if (nrow.lt.1) then
         write (line,300) 
         call putfat$(line)
         return
      endif   
      if (nrow.gt.nmax) then
         write (line,400) nrow, nmax
         call putfat$(line)
         return
      endif   
      if (ncol.eq.4) then
c
c Seems to be a satisfactory 4 column vector field type file
c      
         close (unit = nin)
         open (unit = nin, file = fname)
         read (nin,'(a)') line
         read (nin,*) nrow, ncol
         do i = 1, nrow
            read (nin,*,iostat=ios) x1, x2, y1, y2
            if (ios.ne.0) then
               write (line,500) i
               call putfat$(line)
               close (unit = nin)
               return
            endif    
            if (i.eq.1) then
               xmax = max(x1,x2)
               xmin = min(x1,x2)
               ymax = max(y1,y2)
               ymin = min(y1,y2)
            else       
               if (x1.lt.xmin) xmin = x1 
               if (x2.lt.xmin) xmin = x2
               if (y1.lt.ymin) ymin = y1
               if (y2.lt.ymin) ymin = y2
               if (x1.gt.xmax) xmax = x1
               if (x2.gt.xmax) xmax = x2
               if (y1.gt.ymax) ymax = y1
               if (y2.gt.ymax) ymax = y2
            endif
         enddo
         close (unit = nin)   
         narrow = nrow
         abort = .false.   
         vector_field = .true. 
      elseif (ncol.eq.9) then   
c
c could be a satisfactory 9 column biplot file so check systematically
c      
         close (unit = nin)
         open (unit = nin, file = fname)
         read (nin,'(a)') line
         read (nin,*) nrow, ncol
         do i = 1, nrow
            read (nin,*,iostat=ios) x1, x2, x3, y1, y2, y3, temp1,
     +                              head, temp2
              
            if (ios.ne.0) then
               write (line,500) i
               call putfat$(line)
               close (unit = nin)
               return
            endif

            iarrow = nint(temp1)
            ikolor = nint(temp2)
             
            if (iarrow.lt.0 .or. (iarrow.gt.7 .and. iarrow.lt.16) .or. 
     +          iarrow.gt.21 .or.       
     +          ikolor.lt.0 .or. ikolor.gt.71 .or.
     +          head.lt.zero) then
               write (line,600) i
               call putfat$(line)
               close (unit = nin)
               return
            endif    
            if (i.eq.1) then   
               xmax = max(x1,x2,x3)
               xmin = min(x1,x2,x3)
               ymax = max(y1,y2,y3)
               ymin = min(y1,y2,y3)
            else   
               if (x1.lt.xmin) xmin = x1 
               if (x2.lt.xmin) xmin = x2 
               if (x3.lt.xmin) xmin = x3
               if (y1.lt.ymin) ymin = y1
               if (y2.lt.ymin) ymin = y2  
               if (y3.lt.ymin) ymin = y3
               if (x1.gt.xmax) xmax = x1
               if (x2.gt.xmax) xmax = x2 
               if (x3.gt.xmax) xmax = x3
               if (y1.gt.ymax) ymax = y1
               if (y2.gt.ymax) ymax = y2 
               if (y3.gt.ymax) ymax = y3 
            endif
         enddo   
         narrow = nrow
         abort = .false.
         bi_plot = .true.  
         close (unit = nin)  
      endif   
c
c format statements
c      
  100 format ('File supplied to GKSVF5 cannot be found')
  200 format (
     +'Vector fields require 4 columns and biplots require 9 columns')
  300 format ('Must have number of arrows >= 1')
  400 format ('No. rows =',i8,', max. no. of arrows allowed =',i8) 
  500 format ('Error in file supplied to GKSVF5: cannot read line',i6)
  600 format ('Arrow type, colour or size out of range at line',i6)
      end
c
c
