cc
c
      subroutine gksvf6 (iarrow, ikolor, jarrow, jkolor,
     +                   head, x1, x2, x3, y1, y2, y3,
     +                   labels,
     +                   bi_plot, vector_field)
c
c action: transfer arrows from vector fields or biplots to simplot
c author: w.g.bardsley, university of manchester, u.k., 12/09/2006 
c         05/06/2007 added sim256
c         24/12/2007 added 'f$rotate.tmp'
c         29/12/2007 added no_labels and plot_labels
c         01/01/2008 added nxtra
c         15/01/2008 made sure nmax >= 10000
c         30/06/2009 now deletes fsav(1) and fsav1(1) as they may be renamed
c         26/09/2011 made ifill, ihue, factor dimension nxtra = nwords = nwmax  
c
c arguments are all unchanged by this routine
c
c iarrow: arrow_type
c ikolor: arrow_colour
c jarrow: number of arrows
c   head: arrow head_size
c x1, x2, x3, y1, y2, y3: head(x1,y1), tail(x2,y2), label(x3,y3) coordinates
c labels: labels for arrow heads
c
      implicit   none
c
c arguments
c
      integer,             intent(in) :: jarrow
      integer,             intent(in) :: iarrow(jarrow),
     +                                   ikolor(jarrow), jkolor
      double precision,    intent(in) :: head(jarrow),
     +                                   x1(jarrow), x2(jarrow),
     +                                   x3(jarrow),
     +                                   y1(jarrow), y2(jarrow),
     +                                   y3(jarrow)
      character (len = *), intent(in) :: labels(*)
      logical,            intent (in) :: bi_plot, vector_field
c
c local allocatable arrays
c
      integer, allocatable :: ifill(:), ihue(:), jcolor(:), l(:), m(:),
     +                        nsav(:)
      double precision, allocatable :: factor(:), size1(:), wide1(:)
      character (len = 1024), allocatable :: fsav(:), fsav1(:)
      character (len = 40), allocatable :: label1(:), labvec(:),
     +                                     pline(:), psymb(:),
     +                                     tsav(:), wordx(:), wordy(:)
      logical, allocatable :: barcap(:), lower(:), plotx(:), ploty(:),
     +                        plotz(:), pshow(:), upper(:), yaxis(:)
c
c locals
c
      integer    i, ierr, j, k, kpanel, nfile1, ngrafs, nin, nmax,
     +           nmax1, nwords, nwmax, nxtra, n2
      parameter (kpanel = 1, ngrafs = 300, nin = 3, nmax = 2000, 
     +           nwmax = 2000, nwords = nwmax, nxtra = nwmax, n2 = 2)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  titles(4)*40, filex*1024
      character  labfil*1024, rotate*1024, sim256*1024, vffile*1024                   
c
c The parameters labfil_12, rotate_12, and vffile_12 must not be changed
c                                                     
      character  blank*1, labfil_12*12, rotate_12*12, vffile_12*12
      parameter (blank = ' ', labfil_12 = 'f$labels.tmp',
     +                        rotate_12 = 'f$rotate.tmp', 
     +                        vffile_12 = 'f$vfield.tmp')
      character  no_labels*11
      parameter (no_labels = '%no_labels%')
      logical    barcap_1, bar_chart, lib_file, pie_chart, supply_xy,
     +           two_plots, type_in, vec_field
      logical    plot_labels
      logical    askif, there
      parameter (askif = .false.)
      external   gksgrf$, gettmp, i1file, i2file, deleet, sim256
c
c check then allocate
c
      if (.not.bi_plot .and. .not.vector_field) return
      if (vector_field .or. jarrow.gt.nwmax) then
         plot_labels = .false.
      elseif (labels(1).eq.no_labels) then
         plot_labels = .false.
      else
         plot_labels = .true.
      endif        
      allocate (ifill(nxtra), stat = ierr)
      if (ierr.ne.0) return
      allocate (ihue(nxtra), stat = ierr)
      if (ierr.ne.0) return
      allocate (jcolor(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (l(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (m(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (nsav(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (factor(nxtra), stat = ierr)
      if (ierr.ne.0) return
      allocate (size1(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (wide1(5*ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (fsav(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (fsav1(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (label1(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (labvec(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (pline(kpanel), stat = ierr)
      if (ierr.ne.0) return
      allocate (psymb(kpanel), stat = ierr)
      if (ierr.ne.0) return
      allocate (tsav(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (wordx(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (wordy(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (barcap(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (lower(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (plotx(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (ploty(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (plotz(nwords), stat = ierr)
      if (ierr.ne.0) return
      allocate (pshow(kpanel), stat = ierr)
      if (ierr.ne.0) return
      allocate (upper(ngrafs), stat = ierr)
      if (ierr.ne.0) return
      allocate (yaxis(ngrafs), stat = ierr)
      if (ierr.ne.0) return  
c
c define labfil, rotate, and vffile
c                         
      labfil = sim256(labfil_12)
      rotate = sim256(rotate_12)
      vffile = sim256(vffile_12)
c
c create a temporary file
c
      call gettmp (ierr,
     +             filex)
      open (unit = nin, file = filex)
      write (nin,'(a)') 'temporary file'
      if (vector_field) then
c
c 4 columns for a vector field file
c      
         j = 4
         call i2file (nin, jarrow, j)
         do i = 1, jarrow
            write (nin,100) x1(i), x2(i), y1(i), y2(i)
         enddo
         close (unit = nin)
      else     
c
c but four files for biplots as follows:
c  filex = 9 column biplot file with appended labels
c vffile = 2 column 'f$vfield.tmp' with title %simfitplotlabelsfile%  
c          containing coordinates and appended labels
c labfil = 1 column 'f$labels.tmp' is a simple labels file 
c          i.e. just a list of labels 
c rotate = data for possible moving and rotating
c      
        
         j = 9
         call i2file (nin, jarrow, j)
         do i = 1, jarrow
            write (nin,200) x1(i), x2(i), x3(i),
     +                      y1(i), y2(i), y3(i),
     +                      iarrow(i), head(i), ikolor(i)
         enddo
         if (plot_labels) then
            i = jarrow + 2
            call i1file (nin, i)
            write (nin,'(a)') 'begin{labels}'
            do i = 1, jarrow
               write (nin,'(a)') labels(i)
            enddo
            write (nin,'(a)') 'end{labels}'
            close (unit = nin)           
            
            open (unit = nin, file = labfil)
            do i = 1, jarrow
               write (nin,'(a)') labels(i)
            enddo
            close (unit = nin)
            
            open (unit = nin, file = vffile)
            write (nin,'(a)') '%simfitplotlabelsfile%'
            call i2file (nin, jarrow, n2)
            do i = 1, jarrow
               write (nin,300) x3(i), y3(i)
            enddo 
            close (unit = nin)
            
            open (unit = nin, file = rotate)
            write (nin,'(a)') '%simfitrotatelabelsfile%'
            j = 5
            call i2file (nin, jarrow, j)
            do i = 1, jarrow
               write (nin,400) x3(i), zero, y3(i), zero, zero
            enddo
         else 
            i = 3
            call i1file (nin, i)
            write (nin,'(a)') 'begin{labels}'
            write (nin,'(a)') no_labels
            write (nin,'(a)') 'end{labels}'
            close (unit = nin)           
            
            open (unit = nin, file = labfil)
            write (nin,'(a)') no_labels
            close (unit = nin)
            
            open (unit = nin, file = vffile)
            write (nin,'(a)') '%simfitplotlabelsfile%no_labels%'
            close (unit = nin)
            
            open (unit = nin, file = rotate)
            write (nin,'(a)') '%simfitrotatelabelsfile%no_labels%'
         endif   
         close (unit = nin)  
      endif   
c
c initialise all arrays passed to gksgrf$
c
      do i = 1, nwords 
         label1(i) = blank
         labvec(i) = blank
         wordx(i) = blank
         wordy(i) = blank
         plotx(i) = .true.
         ploty(i) = .false.
         plotz(i) = .false.
c         plotz(i) = .true.
      enddo
      do i = 1, jarrow
         ifill(i) = iarrow(i)
         ihue(i) = ikolor(i)
         factor(i) = head(i)
      enddo  
      if (nxtra.gt.jarrow) then
         do i = jarrow + 1, nxtra
            ifill(i) = 0
            ihue(i) = 0
            factor(i) = zero
         enddo  
      endif   
      k = 0
      do i = 1, ngrafs
         jcolor(i) = 0
         l(i) = 1
         m(i) = 0
         nsav(i) = 0
         size1(i) = one
         do j = 1, 5
            k = k + 1
            wide1(k) = one
         enddo
         fsav(i) = blank
         fsav1(i) = blank
         tsav(i) = blank
         barcap(i) = .false.
         lower(i) = .false.
         upper(i) = .false.
         yaxis(i) = .true.
      enddo
      do i = 1, kpanel
         pline(i) = blank
         psymb(i) = blank
         pshow(i) = .false.
      enddo     
c
c make sure all scalars are initialised properly
c
      nfile1 = 1
      fsav(1) = filex
      barcap_1 = .false.
      bar_chart = .false.
      pie_chart = .false.
      supply_xy = .true.
      two_plots = .false.
      type_in = .false.
      vec_field = .true.
c
c pass data on to gksgrf$
c
      jcolor(1) = jkolor 

      nmax1 = max(jarrow,nmax) 
      
      call gksgrf$(ifill, ihue, jcolor, kpanel, l, m, nfile1, ngrafs,
     +             nin, nmax1, nsav, nwords, nxtra,
     +             factor, size1, wide1,
     +             fsav, fsav1, label1, labvec, pline, psymb, tsav,
     +             titles, wordx, wordy,
     +             barcap, barcap_1, bar_chart, lib_file, lower,
     +             pie_chart, plotx, ploty, plotz, pshow, supply_xy,
     +             two_plots, type_in, upper, vec_field, yaxis)
c
c delete the temporary files then deallocate
c
      call deleet (filex,
     +             askif, there) 
      call deleet (fsav(1),
     +             askif, there) 
      call deleet (fsav1(1),
     +             askif, there) 
      if (bi_plot) then
         call deleet (labfil,
     +                askif, there)
         call deleet (vffile,
     +                askif, there)
      endif
      deallocate (ifill, stat = ierr)
      deallocate (ihue, stat = ierr)
      deallocate (jcolor, stat = ierr)
      deallocate (l, stat = ierr)
      deallocate (m, stat = ierr)
      deallocate (nsav, stat = ierr)
      deallocate (factor, stat = ierr)
      deallocate (size1, stat = ierr)
      deallocate (wide1, stat = ierr)
      deallocate (fsav, stat = ierr)
      deallocate (fsav1, stat = ierr)
      deallocate (label1, stat = ierr)
      deallocate (labvec, stat = ierr)
      deallocate (pline, stat = ierr)
      deallocate (psymb, stat = ierr)
      deallocate (tsav, stat = ierr)
      deallocate (wordx, stat = ierr)
      deallocate (wordy, stat = ierr)
      deallocate (barcap, stat = ierr)
      deallocate (lower, stat = ierr)
      deallocate (plotx, stat = ierr)
      deallocate (ploty, stat = ierr)
      deallocate (plotz, stat = ierr)
      deallocate (pshow, stat = ierr)
      deallocate (upper, stat = ierr)
      deallocate (yaxis, stat = ierr)
c
c format statements
c      
  100 format (1p,4e13.5)
  200 format (1p,6e13.5,i4,e13.5,i4) 
  300 format (1p,2e13.5)
  400 format (1p,5e13.5)
      end
c
c

