c
c
      subroutine gksvf8 (lwork, ncol, nin, nrow, ntype,
     +                   d, work, 
     +                   label1) 
c
c action: prepare data for a 3D biplot
c author: w.g.bardsley, university of manchester, u.k., 
c         10/01/2008 derived from gksvf4 
c
c  lwork: (input/unchanged) dimension
c   ncol: (input/unchanged) no. of columns
c   nrow: (input/unchanged) no. of rows
c  ntype: (input/unchanged) matrix type, i.e. 1 = data, 2 = residual
c      d: (input/unchanged) singular values
c   work: (input/unchanged) contains U and Vt from SVD
c label1: (input/output) labels...may be edited
c label2: (input/output) keys...may be edited
c
      implicit   none  
c
c arguments
c      
           
      integer,             intent (in)    :: lwork, ncol, nin, nrow,
     +                                       ntype
      double precision,    intent (in)    :: d(4), work(lwork)
      character (len = *), intent (inout) :: label1(*)
c
c local allocatable arrays
c      
      double precision, allocatable :: x1(:), y1(:), z1(:)
c
c locals
c       
      integer    ktype, method, nfiles, numdec, numopt,
     +           numsta, numtxt, nwmax, n1, n3
      parameter (nwmax = 2000, n1 = 1, n3 = 3)
      integer    i, ierr, j, k, n, ncol2, nrow2 
      integer    numbld(20)
      double precision d1, d2, d3, u1, u2, u3, vt1, vt2, vt3, 
     +                 s1, s2, s3
      double precision alpha, a1, a2, a2_z, a3, a4, a4_z, 
     +                 scale_c, scale_r
      double precision ssq1, ssq2
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  mtype(4)*45, matrix(2)*20, text(30)*100, word11*11 
      character  savlab*40, stype(3)*20 
      character  no_labels*11, too_many*80
      character  fnames(2)*1024, sim256*1024
c
c %no_labels% must NOT be translated as it indicates not to plot labels
c      
      parameter (
     +no_labels = '%no_labels%', 
     +too_many = 'Too many labels requested ... maxmimum = 2000')
      character  blank*1, begin_labels*13, end_labels*11
      parameter (blank = ' ',
     +    begin_labels = 'begin{labels}',
     +      end_labels = 'end{labels}') 
      logical    repeet
      logical    plot_arrows, plot_labels, plot_lines,
     +           plot_perpendiculars, plot_symbols
      parameter (plot_arrows = .true., plot_lines = .false.,
     +           plot_perpendiculars = .false., plot_symbols = .false.) 
      logical    askif, there
      parameter (askif = .false.)   
      external   lstbox, getd01, listbx, patch2, getdm1, sim256 , space6
      external   putfat$, deleet
      intrinsic  sqrt                                 
      save       ktype, method 
      save       scale_c, scale_r 
      save       alpha
      data       alpha / 0.5d+00 /
      data       ktype, method / 2, 1 /    
      data       scale_c, scale_r / one, one /
      data       matrix / 'Original data      ',
     +                    'Residual matrix    ' / 
      data       mtype / 'Symmetric: U*sqrt(sigma), V^T*sqrt(sigma)   ',
     +                   'Row emphasis: U*sigma, V^T                  ',
     +                   'Column emphasis: U, V^T*sigma               ',
     +                   'User-defined: U*sigma^{t}, V^T*sigma^{1 - t}'/   
      data       stype / 'No-scaling          ',
     +                   'Auto-scaling        ',
     +                   'User-defined scaling' /
      data       numbld / 20*0 / 
c
c initialise
c                 
      fnames(1) = sim256('f$mxrows.tmp')
      fnames(2) = sim256('f$mxcols.tmp')
      if (ntype.eq.1) then
c
c analyse the data matrix
c      
         d1 = d(1)
         d2 = d(2)
         d3 = d(3)
      elseif (ntype.eq.2) then
c
c analyse the residual matrix
c      
         d1 = d(2)
         d2 = d(3)
         d3 = d(4)
      else  
c
c ntype not valid
c      
         return
      endif
c
c define s1, s2, s3 depending on d1, d2, d3, i.e. ntype  
c      
      s1 = sqrt(d1)
      s2 = sqrt(d2)   
      s3 = sqrt(d3)
c
c define a1, a2, a2_z, a3, a4, and a4_z 
c           
      a1 = d1**alpha
      a2 = d2**alpha
      a2_z = d3**alpha
      a3 = d1**(one - alpha)
      a4 = d2**(one - alpha)
      a4_z = d3**(one - alpha)
c
c allocate
c         
      ierr = 0
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return      
      if (allocated(z1)) deallocate(z1, stat = ierr)
      if (ierr.ne.0) return
      n = ncol + nrow
      allocate (x1(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (y1(n), stat = ierr)
      if (ierr.ne.0) return      
      allocate (z1(n), stat = ierr)
      if (ierr.ne.0) return      
c
c main loop
c          
      repeet = .true.
      do while (repeet)
         if (method.eq.4) then
            write (word11,'(a5,f6.3)') ', t =', alpha
         else
            word11 = blank
         endif       
         write (text,100) matrix(ntype), mtype(method), word11,
     +                    stype(ktype)
         numopt = 10
         numsta = 6
         numtxt = numsta + numopt - 1
         numbld(1) = 4 
         numdec = numopt - 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.ge.1 .and. numdec.le.3 .and.
     +       ncol + nrow.gt.nwmax) then
             call putfat$(too_many)
             numdec = 0
         endif
         if (numdec.ge.1 .and. numdec.le.3) then
            plot_labels = .true.
         else
            plot_labels = .false.
         endif                   
         if (numdec.ge.1 .and. numdec.le.6) then   
c
c numdec = 1 to 6: create a biplot
c ===============
c  
            ncol2 = 2*ncol
            nrow2 = 2*nrow        
            if (ntype.eq.1) then  
               j = 0
               k = 4*nrow 
            else
               j = nrow
               k = 4*nrow + ncol
            endif       
            if (method.eq.1) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  u3 = work(nrow2 + j)
                  x1(i) = s1*u1
                  y1(i) = s2*u2
                  z1(i) = s3*u3
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  vt3 = work(ncol2 + k)
                  x1(i) = s1*vt1
                  y1(i) = s2*vt2
                  z1(i) = s3*vt3
               enddo
            elseif (method.eq.2) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  u3 = work(nrow2 + j)
                  x1(i) = d1*u1
                  y1(i) = d2*u2
                  z1(i) = d3*u3
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  vt3 = work(ncol2 + k)
                  x1(i) = vt1
                  y1(i) = vt2
                  z1(i) = vt3
               enddo 
             elseif (method.eq.3) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  u3 = work(nrow2 + j)
                  x1(i) = u1
                  y1(i) = u2
                  z1(i) = u3
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  vt3 = work(ncol2 + k)
                  x1(i) = d1*vt1
                  y1(i) = d2*vt2
                  z1(i) = d3*vt3
               enddo 
            elseif (method.eq.4) then
               do i = 1, nrow
                  j = j + 1
                  u1 = work(j)
                  u2 = work(nrow + j)
                  u3 = work(nrow2 + j)
                  x1(i) = a1*u1
                  y1(i) = a2*u2
                  z1(i) = a2_z*u3
               enddo
               do i = nrow + 1, n
                  k = k + 1
                  vt1 = work(k)
                  vt2 = work(ncol + k)
                  vt3 = work(ncol2 + k)
                  x1(i) = a3*vt1
                  y1(i) = a4*vt2
                  z1(i) = a4_z*vt3
               enddo              
            endif      
c
c scale the arrow cordinates
c          
             if (ktype.eq.1) then
c
c no scaling 
c               
               continue
            elseif (ktype.eq.2) then
c
c scaling so largest vector in each set has length = 1
c            
               ssq1 = zero
               ssq2 = zero
               do i = 1, nrow
                  ssq2 = x1(i)**2 + y1(i)**2  + z1(i)**2
                  if (ssq2.gt.ssq1) ssq1 = ssq2
               enddo
               ssq2 = sqrt(ssq1)
               if (ssq2.gt.zero) then
                  do i = 1, nrow
                     x1(i) = x1(i)/ssq2
                     y1(i) = y1(i)/ssq2
                     z1(i) = z1(i)/ssq2
                  enddo
               endif          
               ssq1 = zero
               ssq2 = zero
               do i = nrow + 1, n 
                  ssq2 = x1(i)**2 + y1(i)**2 + z1(i)**2
                  if (ssq2.gt.ssq1) ssq1 = ssq2
               enddo
               ssq2 = sqrt(ssq1)
               if (ssq2.gt.zero) then
                  do i = nrow + 1, n
                     x1(i) = x1(i)/ssq2
                     y1(i) = y1(i)/ssq2
                     z1(i) = z1(i)/ssq2
                  enddo
               endif  
            elseif (ktype.eq.3) then
c
c user chooses scaling factors
c            
               do i = 1, nrow
                  x1(i) = scale_r*x1(i)
                  y1(i) = scale_r*y1(i)
                  z1(i) = scale_r*z1(i)
               enddo 
               do i = nrow + 1, n 
                  x1(i) = scale_c*x1(i)
                  y1(i) = scale_c*y1(i)
                  z1(i) = scale_c*z1(i)
               enddo 
            endif
c
c display the 3D biplot
c                    
            if (numdec.ge.4 .and. numdec.le.6) then
               savlab = label1(1)
               label1(1) = no_labels
            endif   
            if (numdec.eq.1 .or. numdec.eq.4) then
c
c numdec = 1 or 4: rows and columns
c ================
c              
              nfiles = 2
              close (unit = nin)
              open (unit = nin, file = fnames(1))
              write (nin,'(a)') 'Temporary row file'
              write (nin,'(2i6)') nrow, n3
              do i = 1, nrow
                 write (nin,'(1p,3e12.4)') x1(i), y1(i), z1(i)
              enddo
              if (numdec.eq.1) then
                 write (nin,'(i6)') nrow + 2
                 write (nin,'(a)') begin_labels
                 do i = 1, nrow
                    write (nin,'(a)') label1(i)
                 enddo
                 write (nin,'(a)') end_labels
              else
                 write (nin,'(i6)') n1
                 write (nin,'(a)') no_labels
              endif
              close (unit = nin)
              
              open (unit = nin, file = fnames(2))
              write (nin,'(a)') 'Temporary column file'
              write (nin,'(2i6)') ncol, n3
              do i = 1, ncol
                 write (nin,'(1p,3e12.4)') x1(nrow + i), y1(nrow + i),
     +                                     z1(nrow + i)
              enddo
              if (numdec.eq.1) then
                 write (nin,'(i6)') ncol + 2
                 write (nin,'(a)') begin_labels
                 do i = 1, ncol
                    write (nin,'(a)') label1(nrow + i)
                 enddo
                 write (nin,'(a)') end_labels
              else
                 write (nin,'(i6)') n1
                 write (nin,'(a)') no_labels
              endif
              close (unit = nin) 
                
              call space6 (nfiles,
     +                     fnames(1), 
     +                     plot_arrows,
     +                     plot_labels,
     +                     plot_lines,
     +                     plot_perpendiculars,
     +                     plot_symbols)
               call deleet (fnames(1),
     +                      askif, there)  
               call deleet (fnames(2),
     +                      askif, there)                                                 
           elseif (numdec.eq.2 .or. numdec.eq.5) then 
c
c numdec = 2 or 5: rows only
c ================
c
              nfiles = 1 
              close (unit = nin)
              open (unit = nin, file = fnames(1))
              write (nin,'(a)') 'Temporary row file'
              write (nin,'(2i6)') nrow, n3
              do i = 1, nrow
                 write (nin,'(1p,3e12.4)') x1(i), y1(i), z1(i)
              enddo
              if (numdec.eq.2) then
                 write (nin,'(i6)') nrow + 2
                 write (nin,'(a)') begin_labels
                 do i = 1, nrow
                    write (nin,'(a)') label1(i)
                 enddo
                 write (nin,'(a)') end_labels
              else
                 write (nin,'(i6)') n1
                 write (nin,'(a)') no_labels
              endif
              close (unit = nin)
              
              call space6 (nfiles,
     +                     fnames(1), 
     +                     plot_arrows,
     +                     plot_labels,
     +                     plot_lines,
     +                     plot_perpendiculars,
     +                     plot_symbols)
               call deleet (fnames(1),
     +                      askif, there)  
           elseif (numdec.eq.3 .or. numdec.eq.6) then 
c
c numdec = 3 or 6: columns only
c ================
c           
              nfiles = 1
              open (unit = nin, file = fnames(2))
              write (nin,'(a)') 'Temporary column file'
              write (nin,'(2i6)') ncol, n3
              do i = 1, ncol
                 write (nin,'(1p,3e12.4)') x1(nrow + i), y1(nrow + i),
     +                                     z1(nrow + i)
              enddo
              if (numdec.eq.3) then
                 write (nin,'(i6)') ncol + 2
                 write (nin,'(a)') begin_labels
                 do i = 1, ncol
                    write (nin,'(a)') label1(nrow + i)
                 enddo
                 write (nin,'(a)') end_labels
              else
                 write (nin,'(i6)') n1
                 write (nin,'(a)') no_labels
              endif
              close (unit = nin) 
                
              call space6 (nfiles,
     +                     fnames(2), 
     +                     plot_arrows,
     +                     plot_labels,
     +                     plot_lines,
     +                     plot_perpendiculars,
     +                     plot_symbols)
               call deleet (fnames(2),
     +                      askif, there)                         
           endif 
           if (numdec.ge.4 .and. numdec.le.6) then
              label1(1) = savlab
           endif   
        elseif (numdec.eq.7) then  
c             
c numdec = 7: change method
c ===========
c        
           numopt = 4
           call listbx (method, numopt,
     +                  mtype) 
           if (method.eq.4) then
              call getdm1 (zero, alpha, one,
     +                     'exponent t in U*sigma^t,V^T*sigma^{1 - t}')
              a1 = d1**alpha
              a2 = d2**alpha
              a2_z = d3**alpha
              a3 = d1**(one - alpha)
              a4 = d2**(one - alpha)
              a4_z = d3**(one - alpha)
           endif                 
        elseif (numdec.eq.8) then
c
c numdec = 8: change scaling factors
c ===========
c        
           numopt = 3
           call listbx (ktype, numopt,
     +                  stype)
           if (ktype.eq.3) then            
              call getd01 (scale_r, 
     +                     'row scaling factor required')
              call getd01 (scale_c, 
     +                     'column scaling factor required')
           endif 
        elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c        
           write (text,1000)
           numtxt = 20
           numbld(1) = 1
           call patch2 (numbld, numtxt,
     +                  text)           
        elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================ 
c        
           repeet = .false.
        endif
      enddo
c
c deallocate temporary workspaces
c     
      deallocate(x1, stat = ierr)      
      deallocate(y1, stat = ierr)
      deallocate(z1, stat = ierr)    
c
c format statements
c      
  100 format (
     + '3D biplot using',1x,a
     +/
     +/'Method:',1x,a,1x,a
     +/'Scaling:',1x,a
     +/
     +/'3D biplot with labels: rows and columns' 
     +/'3D biplot with labels: rows only'
     +/'3D biplot with labels: columns only'
     +/'3D biplot without labels: rows and columns' 
     +/'3D biplot without labels: rows only'
     +/'3D biplot without labels: columns only'
     +/'Change: method'
     +/'Change: scaling'
     +/'Help'
     +/'Cancel')  
 1000 format (
     + 'Fine tuning a 3D biplot'
     +/
     +/'The default setting is general emphasis with auto-scaling, and'
     +/'this should suffice for a simple preliminary investigation for'
     +/'parallelism and orthogonality. For final hardcopy you may need'
     +/'to investigate the other methods and scaling options, observing'
     +/'as follows.'
     +/                       
     +/'1)`Please note if you are using sigma(1),sigma(2), and sigma(3)'
     +/'  `(i.e. the original data matrix) or sigma(2), sigma(3), and'
     +/'  `sigma(4) i.e. the the residual matrix).' 
     +/'1)`Change the sign of scaling factors to reflect the arrows'  
     +/'  `if you find it helpful'
     +/'2)`Change the size of scaling factors if one set dominates' 
     +/'  `the plot, obscuring the smaller vectors' 
     +/'3)`Fine tuning can be used to re-position labels for clarity'
     +/'  `if you find labels and arrows overlapping inconveniently.'
     +/'  `This is done from the [Menu] option.'
     +/'4)`Explore the effect of rotating coordinates until you find'
     +/'  `a satisfactory viewpoint.')     
      end
c
c                                      
           
                
                                