C 
C
      SUBROUTINE GKSWGB$(J, K, L, M, N,
     +                   A, B, C, D, SIZE, WIDE, X, XMAX, XMIN, Y)
C
C ACTION : DRAW SYMBOLS AND LINES AS FOLLOWS:-
C          J = COLOUR, K = ARGUMENT TO GSELNT, L(INE), M(ARKER)
C          Markers : M = ?, 1=dot,2=plus,3=cross,4=asterisk,
C          5=circle,6=half-filled circle,7=filled circle
C          8=triangle,9=half-filled triangle,10=filled triangle
C          11=square,12=half-filled square,13=filled square
C          14=diamond,15=half-filled diamond,16=filled diamond
C          17=minus,18=male,19=female
C          ADJUST MUST AGREE WITH ADJUST IN GKSBAR
C
C Note: This routine was necessary with HPGL output which was poor at filled polygons.
C       If this routine is called with M = 0 then it just draws a polyline.
C       Otherwise it breaks the polyline into segments to avoid putting a line
C       through empty symbols.
C       This is no longer necessary as empty and half empty symbols are filled with background.
C


C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 2/2/92
C          08/10/1992 TESTS ON N BEFORE CALL TO GPL
C          12/10/1992 REMOVED MONO
C          28/11/1992 DERIVED FROM GKSPIC
C          04/12/1992 ADDED CODE TO LEAVE SPACES WHEN JOINING MARKERS
C          01/10/1995 Adjusted for stair step lines if L = 5
C          02/23/1997 Edited
C          13/04/2007 Added INTENTS 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: J, K, L, M, N 
      DOUBLE PRECISION, INTENT (IN) :: A, B, C, D, SIZE, WIDE, X(N),
     +                                 XMAX, XMIN, Y(N)
C
C Locals
C      
      INTEGER    I
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION ADJUST, PNT005, ONE, TWO
      PARAMETER (ADJUST = 0.012D+00, PNT005 = 0.005D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION CONST, HEIGHT, RADIUS, SLOPE, XYDIST
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION BIGRAD, BIGX1, BIGX2, BIGY1, BIGY2, XDIFF, XSAV,
     +                 YSAV
      DOUBLE PRECISION XDELTA
      LOGICAL    DRAW
      EXTERNAL   GSELNT$, GSLN$, POLYLINE$, LINE$, GSLWSC$
      INTRINSIC  ABS, SQRT
C
C Check if a line is required 
C      
      IF (N.LT.1 .OR. L.EQ.0) RETURN
C
C No marker if M = 0
C
      IF (M.EQ.0 .AND. L.NE.0 .AND. N.GT.1) THEN
         CALL GSELNT$(K)
         CALL GSLN$(L)
         CALL GSLWSC$(WIDE)
         CALL POLYLINE$(N, X, Y, J)
         RETURN
      ENDIF
C
C No action if L > 0 or L > 9
C
      IF (L.LE.0 .OR. L.GT.9) RETURN
C
C Arrows, stair-steps and filled polygons if L not 1, 2, 3 or 4
C so draw the polyline which may be overwritten by symbols
C
      IF (L.GT.4) THEN
         CALL GSELNT$(K)
         CALL GSLN$(L)
         CALL GSLWSC$(WIDE)
         CALL POLYLINE$(N, X, Y, J)
         RETURN
      ENDIF
C
C Marker is required and also a line of type 1, 2, 3 or 4 so define
C height and radius in C mathematical space and use A, B, C and D
C to map into physical space. Then draw lines falling short of the
C edges of the plotting symbols.
C
      XDELTA = XMAX - XMIN
      RADIUS = ADJUST*SIZE*XDELTA
      HEIGHT = RADIUS*A/C
      BIGRAD = A*RADIUS
      XSAV = X(1)
      YSAV = Y(1)
C
C Main loop, triangles made equilateral using TRIANG
C
      CALL GSELNT$(K)
      CALL GSLN$(L)
      CALL GSLWSC$(WIDE)
      DO I = N1, N
C
C Now attempt to draw the lines cut short at edge of circle marker
C
         IF (I.GT.1) THEN
            XDIFF = ABS(X(I) - XSAV)/XDELTA
C
C Draw vertical line if X points close together and sufficient space
C
            IF (XDIFF.LE.PNT005) THEN
               IF (ABS(YSAV - Y(I)).LE.TWO*HEIGHT) THEN
                  DRAW = .FALSE.
               ELSE
                  DRAW = .TRUE.
                  IF (YSAV.GT.Y(I)) THEN
                     X1 = XSAV
                     Y1 = YSAV - HEIGHT
                     X2 = X(I)
                     Y2 = Y(I) + HEIGHT
                   ELSE
                     X1 = X(I)
                     Y1 = Y(I) - HEIGHT
                     X2 = XSAV
                     Y2 = YSAV + HEIGHT
                   ENDIF
               ENDIF
            ELSE
C
C First define coordinates in physical space and do necessary calculations
C before finally transforming back into mathematical space to draw line
C
               IF (X(I).GT.XSAV) THEN
                  BIGX1 = A*XSAV + B
                  BIGX2 = A*X(I) + B
                  BIGY1 = C*YSAV + D
                  BIGY2 = C*Y(I) + D
               ELSE
                  BIGX1 = A*X(I) + B
                  BIGX2 = A*XSAV + B
                  BIGY1 = C*Y(I) + D
                  BIGY2 = C*YSAV + D
               ENDIF
               XYDIST = SQRT((BIGX2 - BIGX1)**2 + (BIGY2 - BIGY1)**2)
               IF (XYDIST.LE.TWO*BIGRAD) THEN
                  DRAW = .FALSE.
               ELSE
                  DRAW = .TRUE.
                  SLOPE = (BIGY2 - BIGY1)/(BIGX2 - BIGX1)
                  CONST = BIGY1 - SLOPE*BIGX1
                  X1 = BIGX1 + BIGRAD*SQRT(ONE/(ONE + SLOPE**2))
                  Y1 = SLOPE*X1 + CONST
                  X2 = BIGX2 - BIGRAD*SQRT(ONE/(ONE + SLOPE**2))
                  Y2 = SLOPE*X2 + CONST
                  X1 = (X1 - B)/A
                  X2 = (X2 - B)/A
                  Y1 = (Y1 - D)/C
                  Y2 = (Y2 - D)/C
               ENDIF
            ENDIF
            IF (DRAW) CALL LINE$(X1, Y1, X2, Y2, J)
            XSAV = X(I)
            YSAV = Y(I)
         ENDIF
      ENDDO
      END
C
C                                    
