c
c
      subroutine glplot$ (ing, isx, ncol, ng, nig, nrmax, nrow,
     +                    x, 
     +                    labels, legend, title,
     +                    add_centroids, dots_only)
      use module_pcavar
c
c action: plot groups as symbols with associated labels
c author: w.g.bardsley, university of manchester, u.k., 22/08/2010
c         02/11/2010 added sizes and thick to argument list to symbol
c         04/12/2010 increased minimum dimension in call to symbol to 15 (subsequently increased to 20) 
c         16/08/2016 added call to pcavx1 to replace previous code define indices and now
c                    also includes x_factor and y_factor to reflect the X and Y axes
c
c           ing: ing(ii) = group to which observation i belongs
c           isx: isx(i) =< 0 means variable(i) excluded, o/w indicates an included variable
c          ncol: column dimension
c            ng: number of groups (must be >= 1)
c           nig: nig(i) = number in group i (must be 1 =< nig(i) =< ng)
c         nrmax: leading row dimension
c          nrow: row dimension
c             x: data 
c        labels: plot labels
c        legend: legend for x,y axes (typically group or score)
c         title: plot title (typically Groups or Scores)
c add_centroids: plot centroids and spokes if required
c     dots_only: plot dots instead of symbols
c
c Note: By defining isx appropriately on entry the routine can be made to 
c       automatically plot any two of the X columns, which is equivalent
c       to pre-defing nvar1 and nvar2
c
c Advice: this subroutine is derived from grplot$ and lbplot$
c         First the data are prepared exactly as in grplot$ but then all the associated
c         parameters are rolled up 1 level and the labes are insterted at level 1.
c         Success depends on the simplot procedures plotting labels as the first
c         in any series of plotting files.  
c         Note the extra dimension for allocation to accomodate the extra labels file. 
c
      implicit none
c
c arguments   
c      
      integer,             intent (in) :: ncol, nrow
      integer,             intent (in) :: ng, nig(nrow), nrmax 
      integer,             intent (in) :: ing(nrow), isx(ncol)
      double precision,    intent (in) :: x(nrmax,ncol) 
      character (len = *), intent (in) :: legend, title 
      character (len = *), intent (in) :: labels(nrow)
      logical,             intent (in) :: add_centroids, dots_only
c
c allocatable
c
      integer,                allocatable :: j(:), k(:), l(:), m(:),
     +                                       nout(:) 
      double precision,       allocatable :: cmeans(:,:), xlab(:),
     +                                       ylab(:)
      double precision,       allocatable :: sizes(:), thick(:)
      character (len = 1024), allocatable :: files(:)
c
c locals
c       
      integer    i, ierr, itop, nvar 
      integer    icount, nfiles, nfull, nout1, nsym, ntotal
      integer    len200
      integer    ibot, isend, nwords
      parameter (ibot = 1, isend = 1, nwords = 2000)
      double precision delta_x, delta_y, dnig, xmax, xmin, ymax, ymin
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 80) titles(4), title1  
      character (len = 6) word6
      character (len = 1) blank, minus
      parameter (blank = ' ', minus = '-')
c
c--------------------------------------------------------------------------------
c THESE PARAMETERS MUST NOT BE TRANSLATED AS THEY ARE THE LABELS FILE FOR SIMPLOT
c-------------------------------------------------------------------------------- 
      character  filex*1024, fname*1024, line*100, sim256*1024
      character  labfil*12, rotate*12
      parameter (labfil = 'f$labels.tmp',
     +           rotate = 'f$rotate.tmp')
c--------------------------------------------------------------------------------
c      
      logical    askif, there
      parameter (askif = .false.)
      external   symbol, smplot$, gettmp, getnou, putfat$,
     +           deleet, triml1, len200, sim256 
      external   pcavx1  
      intrinsic  max, min
c
c check arguments supplied
c     
      if (ncol.lt.2 .or. nrmax.lt.2 .or.
     +    nrow.lt.2 .or. nrow.gt.nrmax) then
         call putfat$ ('glplot$: dimension error')
         return
      endif

      if (nrow.gt.nwords) then
         write (line,100) nwords
         call putfat$ (line)
         return
      endif   
      
      if (ng.lt.0) then
         call putfat$ ('glplot$: ng must be >= 1')
         return
      endif
       
      icount = 0
      do i = 1, ng
         icount = icount + nig(i)
      enddo
      if (icount.ne.nrow) then
         call putfat$ ('glplot$: sum of nig not equal to nrow') 
         return
      endif

      do i = 1, nrow
         if (ing(i).lt.0 .or. ing(i).gt.ng) then
            write (word6,'(i6)') i
            call triml1 (word6)
            call putfat$ (
     +'glplot$: ing(i) < 0 or ing(i) > ng at i = '//word6)
            return
         endif      
      enddo   
            
      nvar = 0
      do i = 1, ncol
         if (isx(i).gt.0) nvar = nvar + 1
      enddo
      if (nvar.lt.2) then
         call putfat$ ('glplot$: must have >= 2 variables')
         return
      endif
c
c define variables to be plotted
c          
      itop = ncol
      if (nvar1.gt.itop) nvar1 = ibot
      if (nvar2.gt.itop) nvar2 = itop
      call pcavx1 (ibot, isx, itop, ncol, nvar, nvar1, nvar2,
     +             x_factor, y_factor,
     +             legend)   
c
c allocate
c
      ierr = 0
      if (allocated(j)) deallocate(j, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(k)) deallocate(k, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(l)) deallocate(l, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(m)) deallocate(m, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(nout)) deallocate(nout, stat = ierr)
      if (ierr.ne.0) return  
      if (add_centroids) then  
         if (allocated(cmeans)) deallocate(cmeans, stat = ierr)
         if (ierr.ne.0) return
      endif     
      if (allocated(sizes)) deallocate(sizes, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(thick)) deallocate(thick, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xlab)) deallocate(xlab, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(ylab)) deallocate(ylab, stat = ierr)
      if (ierr.ne.0) return    
      if (allocated(files)) deallocate(files, stat = ierr)
      if (ierr.ne.0) return
c
c must have nsym at least 20 in order to call symbol
c      
      if (add_centroids) then
         nfiles = 2*ng + 2
      else
         nfiles = ng + 1
      endif        
      nsym = max(nfiles,20)
      
      allocate (j(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (k(nsym), stat = ierr)
      if (ierr.ne.0) return  
      allocate (l(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (m(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (sizes(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (thick(nsym), stat = ierr)
      if (ierr.ne.0) return  

      ntotal = nrow 
      allocate (xlab(ntotal), stat = ierr)
      if (ierr.ne.0) return  
      allocate (ylab(ntotal), stat = ierr)
      if (ierr.ne.0) return 
      if (add_centroids) then  
         allocate (cmeans(ng,2), stat = ierr)
         if (ierr.ne.0) return             
      endif

      allocate (nout(ng), stat = ierr)
      if (ierr.ne.0) return  
      allocate (files(nfiles), stat = ierr)
      if (ierr.ne.0) return
c
c initialise j, k, l, m 
c        
      do i = 1, nsym
         j(i) = 4
         k(i) = 1
         l(i) = 0
         m(i) = 5
      enddo
      call symbol (isend, j, k, l, m,
     +             sizes, thick) 
      do i = 1, ng
        l(i) = 0
      enddo 
      if (ng.gt.15) then
         do i = 16, min(ng,30)
            icount = i - 15
            j(i) = j(icount)
            m(i) = m(icount)
         enddo   
      endif 
      if (ng.gt.30) then
         do i = 31, min(ng,45)
            icount = i - 15
            j(i) = j(icount)
            m(i) = m(icount)
         enddo   
      endif 
c
c create ng temporary files
c     
      do i = 1, nfiles
         files(i) = blank
      enddo   
      do i = 1, ng
         call gettmp (ierr,
     +                files(i))
         call getnou (nout(i))
         open (unit = nout(i), file = files(i))
         write (nout(i),'(a)') title
         write (nout(i),'(2i6)') nig(i), 2           
      enddo     
c
c write data to the files
c      
      do i = 1, nrow
         xlab(i) = x(i,nvar1)
         ylab(i) = x(i,nvar2)
         write (nout(ing(i)),'(1p,2e13.5)') x_factor*xlab(i),
     +                                      y_factor*ylab(i)
      enddo
      do i = 1, ng
         close (unit = nout(i))
      enddo
c
c if add_centroids then calculate cmeans etc.
c      
      if (add_centroids) then
         do i = 1, ng 
            cmeans(i,1) = zero       
            cmeans(i,2) = zero       
         enddo  
         do i = 1, nrow
            icount = ing(i)
            cmeans(icount,1) = cmeans(icount,1) + x(i,nvar1)
            cmeans(icount,2) = cmeans(icount,2) + x(i,nvar2)
         enddo
         do i = 1, ng
            if (nig(i).gt.0) then
               dnig = dble(nig(i))
               cmeans(i,1) = cmeans(i,1)/dnig
               cmeans(i,2) = cmeans(i,2)/dnig
            endif  
         enddo 
c
c create ng temporary files for the spokes
c      
         do i = 1, ng
            call gettmp (ierr,
     +                   files(ng + i))
            call getnou (nout(i))
            open (unit = nout(i), file = files(ng + i))
            write (nout(i),'(a)') title
            write (nout(i),'(2i6)') 2*nig(i), 2           
         enddo  
c
c write spokes to the temporary files then close them
c      
         do i = 1, nrow
            icount = ing(i)
            write (nout((icount)),'(1p,2e13.5)') 
     +             x_factor*cmeans(icount,1),
     +             y_factor*cmeans(icount,2)
            write (nout((icount)),'(1p,2e13.5)') x_factor*x(i,nvar1),
     +                                           y_factor*x(i,nvar2)
         enddo
         do i = 1, ng
            close (unit = nout(i))
         enddo
      endif   
c
c roll over any empty files
c      
      nfull = 0
      do i = 1, ng
         if (nig(i).gt.0) then
            nfull = nfull + 1  
         else
            do icount = i, ng - 1
               files(icount) = files(icount + 1) 
            enddo
            if (add_centroids) then
               do icount = ng + i, 2*ng - 1
                  files(icount) = files(icount + 1) 
               enddo      
            endif               
         endif         
      enddo
      if (add_centroids) then
         icount = ng - nfull
         if (icount.gt.0) then
            do i = nfull + 1, 2*ng - icount
               files(i) = files(i + icount)
            enddo   
         endif  
c
c assign parameters for the spokes
c      
         do i = 1, nfull
            icount = nfull + i
            j(icount) = j(i)
            l(icount) = 1
            m(icount) = 0
         enddo    
c
c write the centroids to file
c      
         nfull = 2*nfull + 1 
         call gettmp (ierr, 
     +                files(nfull))
         call getnou (nout(1))
         open (unit = nout(1), file = files(nfull))
         write (nout(1),'(a)') title
         write (nout(1),'(2i6)') (nfull - 1)/2, 2
         do i = 1, ng
            if (nig(i).gt.0) write (nout(1),'(1p,2e13.5)')
     +                       x_factor*cmeans(i,1),
     +                       y_factor*cmeans(i,2) 
         enddo
         close (unit = nout(1))      
         j(nfull) = 0
         m(nfull) = 1
         l(nfull) = 0  
      endif      
c
c Open a temporary file and connect to a temporary unit
c
      call gettmp (ierr,
     +             filex)
      call getnou (nout1)
c
c The file title identifies the file type to simplot
c---------------------------------------------------------------------------
c THIS NEXT LINE MUST NOT BE TRANSLATED AS IT INFORMS SIMPLOT TO PLOT LABELS
c---------------------------------------------------------------------------
      write (title1,'(a)') '%simfitplotlabelsfile%'
c---------------------------------------------------------------------------      
      
      open (unit = nout1, file = filex)
      write (nout1,'(a)') title1
      write (nout1,'(i6,i3)') ntotal, 2
      do i = 1, ntotal
         write (nout1,'(1p,e13.5)') x_factor*xlab(i), y_factor*ylab(i)
      enddo
      write (nout1,'(i3)') 1
      write (nout1,'(a)') 'Default Line'
      close (unit = nout1)
c
c Create the actual labels file
c                         
      fname = sim256(labfil)
      call deleet (fname,
     +             askif, there)
      if (there) then 
         write (line,200)
         call putfat$ (line)
      else
         open (unit = nout1, file = fname)
         do i = 1, ntotal
            write (nout1,'(a)') labels(i)
         enddo
         close (unit = nout1)
      endif
c
c Create the move/rotate file
c                         
      fname = sim256(rotate)
      call deleet (fname,
     +             askif, there)
      if (there) then 
         write (line,300)
         call putfat$ (line)
      else
         if (dots_only) then
c
c plot actual (x,y) values as PLTLAB$ will move
c           
            delta_x = zero
            delta_y = zero
         else
c
c displace the labels diagonally upwards
c           
            xmax = xlab(1)
            xmin = xlab(1)
            ymax = ylab(1)
            ymin = ylab(1)
            do i = 2, ntotal
               if (xlab(i).lt.xmin) xmin = xlab(i)
               if (xlab(i).gt.xmax) xmax = xlab(i)
               if (ylab(i).lt.ymin) ymin = ylab(i)
               if (ylab(i).gt.ymax) ymax = ylab(i)
            enddo 
            delta_x = 0.01d+00*(xmax - xmin)
            delta_y = 0.007d+00*(ymax - ymin) 
         endif     
         open (unit = nout1, file = fname)
         write (nout1,'(a)') '%simfitrotatelabelsfile%'
         write (nout1,'(2i6)') ntotal, 5
         do i = 1, ntotal
            write (nout1,'(1p,5e13.5)') x_factor*xlab(i), delta_x,
     +                                  y_factor*ylab(i),
     +                                  delta_y, zero
         enddo
         close (unit = nout1)
      endif
c
c prepare title and legends 
c     
      titles(1) = title
      write (word6,'(i6)') nvar1
      call triml1 (word6)
      i = len200(legend)
      if (x_factor.lt.zero) then
         titles(2) = minus//legend(1:i)//blank//word6
      else   
         titles(2) = legend(1:i)//blank//word6
      endif   
      write (word6,'(i6)') nvar2
      call triml1 (word6)
      if (y_factor.lt.zero) then
         titles(3) = minus//legend(1:i)//blank//word6 
      else   
         titles(3) = legend(1:i)//blank//word6 
      endif   
      titles(4) = blank
c
c insert the labels file
c     
      nfull = nfull + 1 
      do i = nfull, 2, -1
         icount = i - 1
         j(i) = j(icount)
         l(i) = l(icount)
         m(i) = m(icount)
         files(i) = files(icount)
      enddo
      j(1) = 0
      l(1) = 0
      m(1) = 0   
      files(1) = filex
c
c check dots_only
c  
      if (dots_only) then
         do i = 1, nsym
            m(i) = 1
         enddo
      endif          
c
c call smplot$
c      
      call smplot$ (j, l, m, nfull,
     +              files, titles)
c
c delete temporary files
c  
      call deleet (filex, 
     +             askif, there)  
      do i = 1, nfiles
         call deleet (files(i),
     +                askif, there)
      enddo
c
c deallocate
c     
      deallocate(j, stat = ierr)     
      deallocate(k, stat = ierr)     
      deallocate(l, stat = ierr)     
      deallocate(m, stat = ierr)  
      if (allocated(cmeans)) deallocate(cmeans, stat = ierr)   
      deallocate(sizes, stat = ierr)     
      deallocate(thick, stat = ierr)     
      deallocate(xlab, stat = ierr)     
      deallocate(ylab, stat = ierr)     
      deallocate(nout, stat = ierr)     
      deallocate(files, stat = ierr)  
c
c format statements
c     
  100 format ('Too many labels requested: maximum =',i6)
  200 format ('You must attrib -r f$labels.tmp then delete')
  300 format ('You must attrib -r f$rotate.tmp then delete')         
      end
c
c      

      