c
c
      subroutine glplot (ing, isx, ncol, ng, nig, nrmax, nrow,
     +                   x, 
     +                   labels, legend, title,
     +                   add_centroids, dots_only)
c
c action: plot groups as symbols with associated labels
c author: w.g.bardsley, university of manchester, u.k., 13/08/2010
c
c           ing: ing(ii) = group to which observation i belongs
c           isx: isx(i) =< 0 means variable(i) excluded, o/w indicates an included variable
c          ncol: column dimension
c            ng: number of groups (must be >= 1)
c           nig: nig(i) = number in group i (must be 1 =< nig(i) =< ng)
c         nrmax: leading row dimension
c          nrow: row dimension
c             x: data 
c        labels: plot labels
c        legend: legend for x,y axes (typically group or score)
c         title: plot title (typically Groups or Scores)
c     dots_only: plot dots instead of symbols
c add_centroids: display centroids and spokes
c
c Note: By defining isx appropriately on entry the routine can be made to 
c       automatically plot any two of the X columns, which is equivalent
c       to pre-defing nvar1 and nvar2
c
c Advice: this subroutine is derived from grplot$ and lbplot$
c         First the data are prepared exactly as in grplot$ but then all the associated
c         parameters are rolled up 1 level and the labes are insterted at level 1.
c         Success depends on the simplot procedures plotting labels as the first
c         in any series of plotting files.  
c         Note the extra dimension for allocation to accomodate the extra labels file. 
c
      implicit none
c
c arguments   
c      
      integer,             intent (in) :: ncol, nrow
      integer,             intent (in) :: ng, nig(nrow), nrmax 
      integer,             intent (in) :: ing(nrow), isx(ncol)
      double precision,    intent (in) :: x(nrmax,ncol) 
      character (len = *), intent (in) :: legend, title 
      character (len = *), intent (in) :: labels(nrow)
      logical,             intent (in) :: add_centroids, dots_only
c
c locals
c      
       external glplot$ 
       call glplot$ (ing, isx, ncol, ng, nig, nrmax, nrow,
     +               x, 
     +               labels, legend, title,
     +               add_centroids, dots_only)     
       end
c
c
