C
C GRAF10$: Plot colours
C MENU10$: Colours
C
C Subroutines for SIMPLOT
C
C
      SUBROUTINE GRAF10$(NPRESS)
C
C ACTION: Call MENU10$ from i_press_10
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         07/10/2002 increased IJ TO 300
C         12/11/2004 increased IK to 12
C         20/09/2011 now calls X_GRAF10
C
C          NPRESS: (input/output)
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C
      EXTERNAL X_GRAF10
      CALL X_GRAF10 (NPRESS)
      END
C
C

      SUBROUTINE MENU10$(IJ, IK, ISEND, JCOLOR, KCOLOR, LCOLOR, NFILES,
     +                   FSAV,
     +                   MONO, VIDEO)
C
C ACTION : Set colours ... MENU06 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, U.K. 8/11/93
C          26/01/1995 Added MONO and VIDEO
C          14/07/1997 win32 version
C          29/10/2000 extensive re-editing
C          18/11/2000 removed KCOLOR(6) and KCOLOR(7) which referred to
C                     text and arrows as these are now set in PLTOBJ$
C                     KCOLOR(6) and KCOLOR(7) now have no use. However
C                     they are retained for possible future use.
C          01/02/2001 Added FSAV and FSAV1
C          10/04/2001 used KCOLOR(6) = border, KCOLOR(7) = graph paper
C          20/07/2001 added DENDRO_GRAM
C          07/10/2002 increased NMAX TO 300
C          12/11/2004 increased NKCOL1 to 12, KCOLOR(8) = BACKGROUND
C          19/09/2006 added BI_PLOT 
C          20/04/2007 added INTENTS and removed SYMBOLS and SYMLAB$
C          01/02/2008 introduced MODULE_SAVEGKS and call to LVIEW1
C          16/08/2008 added code for outline symbols (30 =< M =< 33)
C          29/11/2010 added KCOLOR(9) = colour for extra title
C          20/09/2011 now calls X_MENU10
C
C          IJ: (input/unchanged) dimension
C          IK: (input/unchanged) dimension
C       ISEND: (input/unchanged) as follows:-
C               ISEND = 1: store
C               ISEND = 2: edit then store
C               ISEND = 3: retrieve
C      JCOLOR: (input/output) line/symbol colours
C      KCOLOR: (input/output) colours for titles etc.
C      LCOLOR: (input/output) background = KCOLOR(8)
C        FSAV: (input/output) file names
C        MONO: (input/output) black on white if .true.
C       VIDEO: (input/output) white on black if .true.
C
C KCOLOR values 
C -------------
C      KCOLOR(1): main title
C      KCOLOR(2): axes
C      KCOLOR(3): labels
C      KCOLOR(4): legends
C      KCOLOR(5): panel keys
C      KCOLOR(6): border
C      KCOLOR(7): graticule
C      KCOLOR(8): background
C      KCOLOR(9): extra title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: IJ, IK, ISEND
      INTEGER,             INTENT (INOUT) :: JCOLOR(IJ), KCOLOR(IK),
     +                                       LCOLOR, NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(IJ)
      LOGICAL,             INTENT (INOUT) :: MONO, VIDEO
C
C Locals
C
      EXTERNAL X_MENU10
      CALL X_MENU10 (IJ, IK, ISEND, JCOLOR, KCOLOR, LCOLOR, NFILES,
     +               FSAV,
     +               MONO, VIDEO)
      END
C
C
