c
c
      module    module_pcavar
      implicit none
      integer  nvar1, nvar2
      double precision x_factor, y_factor
      double precision one
      parameter (one = 1.0d+00)
      data   nvar1, nvar2 / 1, 2 /
      data   x_factor, y_factor / one, one /
      end module module_pcavar
c
c
      subroutine grplot$ (ing, isx, ncol, ng, nig, nrmax, nrow,
     +                    x, 
     +                    legend, title,
     +                    add_centroids)
      use module_pcavar
c
c action: plot groups as symbols plus centroids and spokes if required
c author: w.g.bardsley, university of manchester, u.k.21/08/2010
c         04/12/2010 increased minimum dimension in call to symbol to 15 (subsequently increased to 20)
c         16/08/2016 added call to pcavx1 to replace previous code define indices and now
c                    also includes x_factor and y_factor to reflect the X and Y axes
c
c           ing: ing(i) = group to which observation i belongs
c           isx: isx(i) =< 0 means variable(i) excluded, o/w indicates an included variable
c          ncol: column dimension
c            ng: number of groups (must be >= 1)
c           nig: nig(i) = number in group i (must be 1 =< nig(i) =< ng)
c         nrmax: leading row dimension
c          nrow: row dimension
c             x: data 
c        legend: legend for x,y axes (typically Variable or Score)
c         title: plot title (typically Groups or Scores)
c add_centroids: display centroids and spokes
c
c Note: By defining isx appropriately on entry the routine can be made to 
c       automatically plot any two of the X columns, which is equivalent
c       to pre-defing nvar1 and nvar2. Empty groups and groups out of logical
c       order can be accomodated. 
c
      implicit none
c
c arguments   
c      
      integer,             intent (in) :: ncol, nrow
      integer,             intent (in) :: ng, nig(nrow), nrmax 
      integer,             intent (in) :: ing(nrow), isx(ncol)
      double precision,    intent (in) :: x(nrmax,ncol) 
      character (len = *), intent (in) :: legend, title 
      logical,             intent (in) :: add_centroids 
c
c allocatable
c
      integer,                allocatable :: j(:), k(:), l(:), m(:),
     +                                       nout(:) 
      double precision,       allocatable :: cmeans(:,:)
      double precision,       allocatable :: sizes(:), thick(:)
      character (len = 1024), allocatable :: files(:)
c
c locals
c       
      integer    i, ierr, itop, nvar 
      integer    icount, nfiles, nfull, nsym
      integer    len200
      integer    ibot, isend
      parameter (ibot = 1, isend = 1)
      double precision dnig
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 80) titles(4)  
      character (len = 6) word6
      character (len = 1) blank, minus
      parameter (blank = ' ', minus = '-')
      logical    askif, there
      parameter (askif = .false.)
      external   symbol, smplot$, gettmp, getnou, putfat$,
     +           deleet, triml1, len200 
      external   pcavx1  
      intrinsic  max, dble, min
c
c check arguments supplied
c     
      if (ncol.lt.2 .or. nrmax.lt.2 .or.
     +    nrow.lt.2 .or. nrow.gt.nrmax) then
         call putfat$ ('grplot$: dimension error')
         return
      endif
      
      if (ng.lt.0) then
         call putfat$ ('grplot$: ng must be >= 1')
         return
      endif
       
      icount = 0
      do i = 1, ng
         icount = icount + nig(i)
      enddo
      if (icount.ne.nrow) then
         call putfat$ ('grplot$: sum of nig not equal to nrow') 
         return
      endif

      do i = 1, nrow
         if (ing(i).lt.0 .or. ing(i).gt.ng) then
            write (word6,'(i6)') i
            call triml1 (word6)
            call putfat$ (
     +'grplot$: ing(i) < 0 or ing(i) > ng at i = '//word6)
            return
         endif      
      enddo   
            
      nvar = 0
      do i = 1, ncol
         if (isx(i).gt.0) nvar = nvar + 1
      enddo
      if (nvar.lt.2) then
         call putfat$ ('grplot$: must have >= 2 variables')
         return
      endif
c
c define variables to be plotted
c          
      itop = ncol
      if (nvar1.gt.itop) nvar1 = ibot
      if (nvar2.gt.itop) nvar2 = itop
      call pcavx1 (ibot, isx, itop, ncol, nvar, nvar1, nvar2,
     +             x_factor, y_factor,
     +             legend) 
c
c allocate
c
      ierr = 0
      if (allocated(j)) deallocate(j, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(k)) deallocate(k, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(l)) deallocate(l, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(m)) deallocate(m, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(nout)) deallocate(nout, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(sizes)) deallocate(sizes, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(thick)) deallocate(thick, stat = ierr)
      if (ierr.ne.0) return   
      if (add_centroids) then  
         if (allocated(cmeans)) deallocate(cmeans, stat = ierr)
         if (ierr.ne.0) return     
      endif     
      if (allocated(files)) deallocate(files, stat = ierr)
      if (ierr.ne.0) return
c
c must have nsym at least 20 in order to call symbol
c     
      if (add_centroids) then 
         nfiles = 2*ng + 1  
      else   
         nfiles = ng
      endif
      nsym = max(nfiles,20)
      
      allocate (j(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (k(nsym), stat = ierr)
      if (ierr.ne.0) return  
      allocate (l(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (m(nsym), stat = ierr)
      if (ierr.ne.0) return

      allocate (nout(ng), stat = ierr)
      if (ierr.ne.0) return  
      allocate (sizes(nsym), stat = ierr)
      if (ierr.ne.0) return
      allocate (thick(nsym), stat = ierr)
      if (ierr.ne.0) return    
      if (add_centroids) then  
         allocate (cmeans(ng,2), stat = ierr)
         if (ierr.ne.0) return  
      endif      
      allocate (files(nfiles), stat = ierr)
      if (ierr.ne.0) return
c
c initialise j, k, l, m 
c        
      do i = 1, nsym
         j(i) = 4
         k(i) = 1
         l(i) = 0
         m(i) = 5
      enddo
      call symbol (isend, j, k, l, m,
     +             sizes, thick) 
      do i = 1, ng
        l(i) = 0
      enddo 
      if (ng.gt.15) then
         do i = 16, min(ng,30)
            icount = i - 15
            j(i) = j(icount)
            m(i) = m(icount)
         enddo   
      endif 
      if (ng.gt.30) then
         do i = 31, min(ng,45)
            icount = i - 15
            j(i) = j(icount)
            m(i) = m(icount)
         enddo   
      endif 
c
c initialise the files
c 
      do i = 1, nfiles
         files(i) = blank
      enddo        
c
c create ng temporary files for data and open them
c     
      do i = 1, ng
         call gettmp (ierr,
     +                files(i))
         call getnou (nout(i))
         open (unit = nout(i), file = files(i))
         write (nout(i),'(a)') title
         write (nout(i),'(2i6)') nig(i), 2           
      enddo     
c
c write data to the temporary files then close them
c      
      do i = 1, nrow
         write (nout(ing(i)),'(1p,2e13.5)') x_factor*x(i,nvar1),
     +                                      y_factor*x(i,nvar2)
      enddo
      do i = 1, ng
         close (unit = nout(i))
      enddo 
c
c if add_centroids then calculate cmeans etc.
c      
      if (add_centroids) then
         do i = 1, ng 
            cmeans(i,1) = zero       
            cmeans(i,2) = zero       
         enddo  
         do i = 1, nrow
            icount = ing(i)
            cmeans(icount,1) = cmeans(icount,1) + x(i,nvar1)
            cmeans(icount,2) = cmeans(icount,2) + x(i,nvar2)
         enddo
         do i = 1, ng
            if (nig(i).gt.0) then
               dnig = dble(nig(i))
               cmeans(i,1) = cmeans(i,1)/dnig
               cmeans(i,2) = cmeans(i,2)/dnig
            endif  
         enddo 
c
c create ng temporary files for the spokes
c      
         do i = 1, ng
            call gettmp (ierr,
     +                   files(ng + i))
            call getnou (nout(i))
            open (unit = nout(i), file = files(ng + i))
            write (nout(i),'(a)') title
            write (nout(i),'(2i6)') 2*nig(i), 2           
         enddo  
c
c write spokes to the temporary files then close them
c      
         do i = 1, nrow
            icount = ing(i)
            write (nout((icount)),'(1p,2e13.5)')
     +             x_factor*cmeans(icount,1),
     +             y_factor*cmeans(icount,2)
            write (nout((icount)),'(1p,2e13.5)') x_factor*x(i,nvar1),
     +                                           y_factor*x(i,nvar2)
         enddo
         do i = 1, ng
            close (unit = nout(i))
         enddo
      endif   
c
c calculate nfull and roll over empty groups if any present
c      
      nfull = 0
      do i = 1, ng
         if (nig(i).gt.0) then
            nfull = nfull + 1
         else   
            do icount = i, ng - 1
               files(icount) = files(icount + 1) 
            enddo
            if (add_centroids) then
               do icount = ng + i, 2*ng - 1
                  files(icount) = files(icount + 1) 
               enddo      
            endif   
         endif     
      enddo
      if (add_centroids) then
         icount = ng - nfull
         if (icount.gt.0) then
            do i = nfull + 1, 2*ng - icount
               files(i) = files(i + icount)
            enddo   
         endif  
c
c assign parameters for the spokes
c      
         do i = 1, nfull
            icount = nfull + i
            j(icount) = j(i)
            l(icount) = 1
            m(icount) = 0
         enddo    
c
c write the centroids to file
c      
         nfull = 2*nfull + 1 
         call gettmp (ierr, 
     +                files(nfull))
         call getnou (nout(1))
         open (unit = nout(1), file = files(nfull))
         write (nout(1),'(a)') title
         write (nout(1),'(2i6)') (nfull - 1)/2, 2
         do i = 1, ng
            if (nig(i).gt.0) write (nout(1),'(1p,2e13.5)')
     +                       x_factor*cmeans(i,1),
     +                       y_factor*cmeans(i,2) 
         enddo
         close (unit = nout(1))      
         j(nfull) = 0
         m(nfull) = 1
         l(nfull) = 0  
      endif
c
c prepare title and legends 
c     
      titles(1) = title
      write (word6,'(i6)') nvar1
      call triml1 (word6)
      i = len200(legend)
      if (x_factor.lt.zero) then
         titles(2) = minus//legend(1:i)//blank//word6
      else   
         titles(2) = legend(1:i)//blank//word6
      endif   
      write (word6,'(i6)') nvar2
      call triml1 (word6)
      if (y_factor.lt.zero) then
         titles(3) = minus//legend(1:i)//blank//word6 
      else   
         titles(3) = legend(1:i)//blank//word6 
      endif   
      titles(4) = blank
c
c call smplot$
c      
      call smplot$ (j, l, m, nfull,
     +              files, titles)
c
c delete temporary files
c  
      do i = 1, nfiles
         call deleet (files(i),
     +                askif, there)
      enddo
c
c deallocate
c     
      deallocate(j, stat = ierr)     
      deallocate(k, stat = ierr)     
      deallocate(l, stat = ierr)     
      deallocate(m, stat = ierr)     
      deallocate(sizes, stat = ierr)     
      deallocate(thick, stat = ierr)     
      if (allocated(cmeans)) deallocate(cmeans, stat = ierr)     
      deallocate(nout, stat = ierr)     
      deallocate(files, stat = ierr)     
      end
c
c      
c
c--------------------------------------------------------------------
c
      subroutine pcavx1 (ibot, isx, itop, ncol, nvar, nvar1, nvar2,
     +                   x_factor, y_factor,
     +                   legend)      
c
c action: extra subroutine to select pca/variable multivariate indices
c author: w.g.bardsley, university of manchester, u.k., 16/08/2016
c
      implicit none
c             
c arguments   
c
      integer, intent (in)             :: ibot, itop, ncol, nvar 
      integer, intent (in)             :: isx(ncol)
      integer, intent (inout)          :: nvar1, nvar2
      double precision, intent (inout) :: x_factor, y_factor
      character (len = *), intent (in) :: legend 
c
c locals
c
      integer    ivar1, ivar2 
      character (len = 100) line
      logical    repeet, score
      external   pcavx2 
      external   putfat$
      intrinsic  index
c
c see if scores or variables are being requested
c      
      if (index(legend,'Score').gt.0 .or.
     +    index(legend,'score').gt.0) then
         score = .true.
      else
         score = .false.
      endif
c
c call pcavx2 then make sure sensible values are returned
c       
      repeet = .true.
      do while (repeet)
         ivar1 = nvar1
         ivar2 = nvar2
         call pcavx2 (ibot, itop, ivar1, ivar2,
     +                x_factor, y_factor) 
         repeet = .false.
         if (.not.score .and. nvar.lt.ncol) then
            if (isx(ivar1).le.0) then
               write (line,'(a,i4,a)') 'Variable', ivar1,
     +                                 ' is excluded'
               call putfat$ (line)
               repeet = .true.
            endif  
            if (isx(ivar2).le.0) then
               write (line,'(a,i4,a)') 'Variable', ivar2,
     +                                 ' is excluded'
               call putfat$ (line)
               repeet = .true.
            endif
         endif   
       enddo
       nvar1 = ivar1
       nvar2 = ivar2
       end
c
c------------------------------------------------------------------------
c
      subroutine pcavx2 (nbot, ntop, nx, ny,
     +                   x_factor, y_factor)
c
c action: extra subroutine to manipulate multivariate plotting parameters
c author: w.g.bardsley, university of manchester, u.k., 15/07/2016
c  
c     nbot = minimum index
c     ntop = maximum index
c     nbot =< nx =< ntop ... index to plot as X
c     nbot =< ny =< ntop ... index to plot as Y
c     x_factor = +/-1 ... multiplies X
c     y_factor = +/-1 ... multiplies Y
c   
      integer,          intent (in)    :: nbot, ntop
      integer,          intent (inout) :: nx, ny
      double precision, intent (inout) :: x_factor, y_factor
c
c locals
c       
      integer    icolor, ixl, iyl, lshade, numopt, nstart, ntext
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0, 
     +           numopt = 4, nstart = 15, ntext = nstart + numopt - 1)
      integer    ix_value, iy_value, kvalue(numopt), numbld(ntext),
     +           numpos(numopt) 
      double precision xvalue(numopt)
      double precision one
      parameter (one = 1.0d+00)
      character (len = 100) text(ntext)
      character (len = 12 ) form12, word1, word2
      character (len = 10 ) wordx, wordy
      character (len = 1  ) blank, svalue(numopt)
      parameter (blank = ' ')
      logical    repeet
      logical    tab_bot, tab_mid, tab_top      
      parameter (tab_bot = .false., tab_mid = .false., tab_top = .true.)
      external   get00n, form12, putadv, putwar
      intrinsic  nint
      data numbld / ntext*0 /
      data numpos / 1, 1, 4, 4 /
      data svalue / numopt*blank /
      data xvalue / numopt*0.0d+00 /
c
c check input
c      
      if (nbot.ge.ntop) then
         call putwar ('NBOT >= NTOP in call to PCAVX2')
         return
      elseif (nbot.lt.1) then
         call putwar ('NBOT < 1 in call to PCAVX2')
         return
      elseif (nbot.eq.ntop) then
         call putwar ('NBOT = NTOP in call to PCAVX2')
         return   
      endif   
      ix_value = nint(x_factor)
      iy_value = nint(y_factor)
      if (ix_value.ne.-1 .and. ix_value.ne.1) then
         call putwar ('X_factor must be -1 or 1 in call to PCAVX2')    
         return
      elseif (iy_value.ne.-1 .and. iy_value.ne.1) then
         call putwar ('Y_factor must be -1 or 1 in call to PCAVX2')    
         return
      endif
c
c define starting values
c      
      kvalue(1) = nx
      kvalue(2) = ny
      kvalue(3) = -ix_value
      kvalue(4) = -iy_value
      word1 = form12(nbot)
      word2 = form12(ntop)
c
c loop to make sure all values are declared properly
c
      repeet =.true.
      do while (repeet)
         if (kvalue(3).eq.1) then
            wordx = 'reversed'
         else
            wordx = 'normal'
         endif  
         if (kvalue(4).eq.1) then
            wordy = 'reversed'
         else
            wordy = 'normal'
         endif         
         write (text,100) word1, word2, wordx, wordy 
         numbld(1) = 4
         numbld(10) = 1
         numbld(11) = 1
         numbld(12) = 1
         numbld(13) = 1
         kvalue(1) = nx
         kvalue(2) = ny
         
         CALL GET00N (ICOLOR, IXL, IYL, KVALUE, LSHADE, NUMBLD,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                XVALUE,
     +                SVALUE, TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
     
         repeet = .false.
         if (kvalue(1).lt.nbot .or. kvalue(1).gt.ntop) then
             call putadv ('X index out of range')
             repeet = .true.
         elseif (kvalue(2).lt.nbot .or. kvalue(2).gt.ntop) then 
             call putadv ('Y index out of range')
             repeet = .true. 
         elseif (kvalue(1).eq.kvalue(2)) then  
             call putadv ('X index = Y index')
             repeet = .true.     
         else    
            nx = kvalue(1)
            ny = kvalue(2)
            if (kvalue(3).eq.0) then
               x_factor = one
            else   
               x_factor = -one
            endif 
            if (kvalue(4).eq.0) then
               y_factor = one
            else   
               y_factor = -one
            endif
         endif   
      enddo     
c
c format statement 
c  
  100 format (
     + 'Options for plotting multivariate groups/variables/scores'
     +/ 
     +/'You have to choose which items to plot along the X, Y axes,'
     +/'and the direction of these axes can be reversed by plotting'
     +/'the selected items with opposite signs. This can be useful in'
     +/'order to control the orientation when plotting eigenvectors'
     +/'such as principal component scores, since these are only'
     +/'determined up to an arbitrary scalar factor, e.g., +/- 1.'
     +/
     +/'Minimum index:',1x,a
     +/'Maximum index:',1x,a 
     +/'X-axis orientation:',1x,a
     +/'Y-axis orientation:',1x,a
     +/     
     +/'Index of the item to plot horizontally (i.e. as X)'
     +/'Index of the item to plot vertically (i.e. as Y)'
     +/'Reflect the X-axis (i.e., plot -x instead of x)'
     +/'Reflect the Y-axis (i.e., plot -y instead of y)')
      end
c
c   
      