c
c
      subroutine grplot (ing, isx, ncol, ng, nig, nrmax, nrow,
     +                   x, 
     +                   legend, title,
     +                   add_centroids)
c
c action: plot groups as symbols
c author: w.g.bardsley, university of manchester, u.k., 22/08/2010
c
c           ing: ing(i) = group to which observation i belongs
c           isx: isx(i) =< 0 means variable(i) excluded, o/w indicates an included variable
c          ncol: column dimension
c            ng: number of groups (must be >= 1)
c           nig: nig(i) = number in group i (must be 1 =< nig(i) =< ng)
c         nrmax: leading row dimension
c          nrow: row dimension
c             x: data 
c        legend: legend for x,y axes (typically Group or Score)
c         title: plot title (typically Groups or Scores)
c add_centroids: display centroids and spokes
c
c Note: By defining isx appropriately on entry the routine can be made to 
c       automatically plot any two of the X columns, which is equivalent
c       to pre-defing nvar1 and nvar2
c
      implicit none
c
c arguments   
c      
      integer,             intent (in) :: ncol, nrow
      integer,             intent (in) :: ng, nig(nrow), nrmax  
      integer,             intent (in) :: ing(nrow), isx(ncol)
      double precision,    intent (in) :: x(nrmax,ncol) 
      character (len = *), intent (in) :: legend, title 
      logical,             intent (in) :: add_centroids 
c
c locals
c       
      external grplot$
      call grplot$ (ing, isx, ncol, ng, nig, nrmax, nrow,
     +              x, 
     +              legend, title,
     +              add_centroids)      
      end
c
c      

      