C
C
      SUBROUTINE GSCALE$(MXTIC,
     +                   XMAX, XMIN)
C
C 21/08/2001 Edited by W.G.Bardsley, 21/08/2001 to improve readability, transform
C            to double precision, clean up to stop ftn95 complaining and finally
C            export new values for MXTIC, XMAX AND XMIN
C 20/04/2007 added INTENTS 
C 18/07/2009 edited and corrected output if the range has been expanded too much
C            also altered checks to allow for high significance in axes labels 
C
C     MXTIC: returned as MXTIC supplied, MXTIC + 1, or MXTIC + 2, or MXTIC = 1 if failure
C      XMAX: returned as XMAX supplied or XMAX + something
C      XMIN: returned as XMIN supplied or XMIN - something  
C
C
C*****Original arguments
C*****SUBROUTINE  SCALE(FMN, FMX, N, VALMIN, STEP, VALMAX, IFAULT)
C
C ALGORITHM AS 96  APPL. STATIST. (1976) VOL.25, NO.1
C
C Given extreme values FMN, FMX, and the need for a scale with N
C marks, calculates value for the lowest scale mark (VALMIN) and
C step length (STEP) and highest scale mark (VALMAX).
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (INOUT) :: MXTIC
      DOUBLE PRECISION, INTENT (INOUT) :: XMAX, XMIN
      
C
C Original arguments
C
C*****INTEGER    N, IFAULT
      INTEGER    N
      DOUBLE PRECISION FMN, FMX, VALMIN, STEP, VALMAX
C
C Units for step lengths
C
      DOUBLE PRECISION UNIT(11)
C
C Local variables
C
      INTEGER    NUNIT, I, J     
      DOUBLE PRECISION FRACN
      DOUBLE PRECISION TOL, ZERO, HALF, ONE, TEN, BIAS, FMAX, FMIN,
     +                 RN, X, S, RANGE1, RATIO
      DOUBLE PRECISION EPSI, RMAX, RMIN, SIGFIG
      PARAMETER (EPSI = 1.0D-200, RMIN = 0.999D+00, RMAX = 1.25D+00,
     +           SIGFIG = 1.0D-04)
      INTRINSIC  ABS, DBLE, NINT
C
C Array length unit()
C
      DATA NUNIT / 11 /
C
C Local constant, defining effective equality of values.
C
      DATA TOL / 5.0D-06 /
      DATA ZERO / 0.0D+00 /, HALF / 0.5D+00 /, ONE / 1.0D+00 /,
     +            TEN / 10.0D+00 /
      DATA BIAS / 1.0D-04 /
      DATA UNIT / 1.0D+00, 1.2D+00, 1.6D+00, 2.0D+00, 2.5D+00,
     +            3.0D+00, 4.0D+00, 5.0D+00, 6.0D+00, 8.0D+00,
     +           10.0D+00/
C
C New w.g.b. header: reverse if necessary
C
      IF (XMAX.LT.XMIN) THEN
         FMN = XMAX
         FMX = XMIN
      ELSE
         FMX = XMAX
         FMN = XMIN
      ENDIF
      N = MXTIC + 1
C
C New w.g.b header: evasive action if very small
C
      IF (FMX - FMN.LE.EPSI) THEN
         XMIN = FMN - EPSI
         XMAX = FMX + EPSI
         MXTIC = 1
         RETURN
      ENDIF
C
C.......................................................................
C Start of original code
C Only minor editing by w.g.b in this section
C.......................................................................
C
      FMAX = FMX
      FMIN = FMN
C*****IFAULT = 1
C
C Test for valid parameter values
C
      IF (FMAX .LT. FMIN .OR. N .LE. 1) RETURN
C*****IFAULT = 0
      RN = DBLE(N - 1)
      X = ABS(FMAX)
C*****IF (X .EQ. ZERO) X = ONE
      IF (ABS(X - ZERO).LE.EPSI) X = ONE
      IF ((FMAX - FMIN)/X .GT. TOL) GOTO 20
C
C All values effectively equal
C
      IF (FMAX .LT. ZERO) THEN
        FMAX = ZERO
C*****ELSE IF (FMAX .EQ. ZERO) THEN
      ELSEIF (ABS(FMAX - ZERO).LE.EPSI) THEN
        FMAX = ONE
      ELSE
        FMIN = ZERO
      ENDIF
C
C
C
   20 CONTINUE
      STEP = (FMAX - FMIN)/RN
      S = STEP
C
C Find power of 10
C
   25 CONTINUE
      IF (S .GE. ONE) GOTO 30
      S = S*TEN
      GOTO 25
   30 CONTINUE
      IF (S .LT. TEN) GOTO 35
      S = S/TEN
      GOTO 30
C
C Calculate STEP
C
   35 CONTINUE
      X = S - BIAS
      DO 40 I = 1, NUNIT
        IF (X .LE. UNIT(I)) GOTO 45
   40 CONTINUE
   45 CONTINUE
      STEP = STEP*UNIT(I)/S
      RANGE1 = STEP*RN
C
C Make first estimate of VALMIN
C
      X = HALF*(ONE + (FMIN + FMAX - RANGE1)/STEP)
      J = NINT(X - BIAS)
      IF (X .LT. ZERO) J = J - 1
      VALMIN = STEP*DBLE(J)
C
C Test if VALMIN could be zero
C
      IF (FMIN .GE. ZERO .AND. RANGE1 .GE. FMAX) VALMIN = ZERO
      VALMAX = VALMIN + RANGE1
C
C Test if VALMAX could be zero
C
      IF (FMAX .GT. ZERO .OR. RANGE1 .LT. - FMIN) GOTO 50
      VALMAX = ZERO
      VALMIN = - RANGE1
C
C.......................................................................
C End of original code
C.......................................................................
C

C
C Extra code by w.g.b. to check, expand range if necessary and redefine original arguments
C
   50 CONTINUE
C*****IF (IFAULT.NE.0) RETURN!to silence ftn95
C
C These next checks are sometimes necessary for minor tweaking
C
      IF (VALMIN.GT.FMN) THEN
         VALMIN = VALMIN - STEP
         N = N + 1
      ENDIF
      IF (VALMAX.LT.FMX) THEN
         VALMAX = VALMAX + STEP
         N = N + 1
      ENDIF
C
C But this next check should never be necessary
C
      IF (VALMIN.GT.FMN .OR. VALMAX.LT.FMX) GOTO 50
C
C Check if range too small or too large
C        
      RATIO = (VALMAX - VALMIN)/(FMX - FMN)
      IF (RATIO.LT.RMIN .OR. RATIO.GT.RMAX) THEN
C
C Out of range so just use the original limits
C        
         MXTIC = 1
         XMAX = FMX
         XMIN = FMN
      ELSE   
C
C Check FRACN then define MXTIC, XMAX, XMIN then check for significant figures and exit
C
         FRACN = STEP/(HALF*(ABS(VALMAX) + ABS(VALMIN)) + EPSI)
         IF (FRACN .LE. SIGFIG) THEN 
C
C Steps are too small to register on the labels so just use the original range 
C           
            MXTIC = 1
            XMAX = FMX
            XMIN = FMN
         ELSE
C
C Steps are acceptable
C           
            MXTIC = N - 1
            XMAX = VALMAX
            XMIN = VALMIN    
         ENDIF     
      ENDIF   
      END
C
C
